/******************************************************************************
 * Copyright © 2013-2016 The Nxt Core Developers.                             *
 * Copyright © 2016-2020 Jelurida IP B.V.                                          *
 *                                                                            *
 * See the LICENSE.txt file at the top-level directory of this distribution   *
 * for licensing information.                                                 *
 *                                                                            *
 * Unless otherwise agreed in a custom licensing agreement with Jelurida B.V.,*
 * no part of the Nxt software, including this file, may be copied, modified, *
 * propagated, or distributed except according to the terms contained in the  *
 * LICENSE.txt file.                                                          *
 *                                                                            *
 * Removal or modification of this copyright notice is prohibited.            *
 *                                                                            *
 ******************************************************************************/

QUnit.module("nxt.remotenodes");

// Note the difference in the attachment
var origTransactionsJson = '{"transactions":[{"signature":"91297853b125cc60e37591f6eb5c6e150de83263e8f375fbef51a236219f6d0f6b0f4f10f7cb1ff463cba6b9fe2a5c747821100559bc9fe35fcdfe881cef1256","transactionIndex":0,"type":1,"phased":false,"ecBlockId":"13790759943580110225","signatureHash":"ff5f98e5c27479cb7fcaba6c7e5d540cc5e3b122bb9527dbd47a29210dcfd0ed","attachment":{"version.PrunablePlainMessage":1,"messageIsText":false,"messageHash":"776b2be154d8f5d139f19d46519dc8e3df2d9ea0ce9069cae7b0e4e33eff5a4a","message":"89504e470d0a1a0a0000000d49484452000000960000025808020000000f1e8858000000097048597300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a2109104a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe17ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e42e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb6362e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaecece368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d4280803806883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602fd4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd072b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c243411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c437241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e5066598324155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a681768f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a93ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36aeeda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6ba51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd699359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a558555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbaeb66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563ade9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157add7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df437f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b94115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c2785878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fec56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae5857debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7bbcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9cc6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f29793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c207f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080830000f9ff000080e9000075300000ea6000003a980000176f925fc546000044684944415478daecbd79bc1c559df7ff39a7aaabbbefbe2537fbcd46129620300c6417715040055944858c0a3ae3ee3caf51c799671495f199f9e94f7914051551810041c45111100195c1447685109604b292e526b9fbbdbd57d579fea8eaeeaaeaaaeaaa5eab6ece79f97a49fa7655579dcff9becff77ccf39df433adff951f012e6228e2752bc16425d28af022e212f5c425eb8845c42c26b611a5821e1424e0f907215a7435fc8cd719ab8335cc869e2917215c322a19b52dc1cc362856594e2428605a46564e22a067a684fbcd91b37c7405b211772fa8c0be159485e023aa8205621b93986735cc8b93a1d86f69cabd34142ced550484888879ae75c0dba1512cf4272ae061aa43ecd917335a0e342ced569e1ce70ae4e138f9473757a8c0b3957c3202129af10e76ab0c7851e8d837335c820d5ebb36cb572ae06bc2f2c0ac9b91a6a778673753a78a49cabd36450d14cae72217d0f2a886bcd379eabbc83acc40a9d75e25c0dc3b8d043dbe75c0dc3b8d0439571ae86615cc8b93a1dc6859cab61f748ebc455e2d91c39576be391d69cabe05c6d044809e76ad80715e05c9d06830aced550ba334e4d99b85614e76a80fa4297964e5c3b48ced5607aa49cab21f7483957c31e9de15c0dffa08273358c1ea9e30b72ae86c92375a9aca6739570ae7aec0b5d2aabb95c05e7aa2f778673759a78a49cabe172677c5716e76ad0061584b80ac9b91a0a90bad51ae76a58fac2f2e6c8b91a0a778673356c423ab8339cabe1e12a757c50ced590986321cc4d2a1532ec5c0dbd9096b533e4f8e32ac2ce55db05f99cab6132476a538341e46a59218f5faedab93341e42a3857cb8294b80ac9b91a5c732cdd22cab91a32216d577373ae8689ab4eabb9395743638ee68360093857432724f58035ced54073d5e36a6eced5e09a23750017e76a688474590accb91a0eaeba2f05e65c0d8139520f64e35c0db490d49e6c9cabe1e1aaafa5c09cab413447edd82de2a72a3957832564611da9d38d385783ced5d275a49cab21e36ae93a52ced59071d5691d29e76a68b8ea7c5a4c59ae12ced54070959a11071f5c05e76a20b84a3db5b526729570ae96f933f50a8d6671159cab65fe4c5d11c7b91a02ae3a2c42e45c0d0f57a9db7e14ced530709596542be76ac8b82a020460c5e767c69761a65763e60f8d4232bbcf414098dd15b6bf68f8dcfa084ebf0b808031fd1928051540282801a1f9ca22c5cb1903185406a682a95015a82a54152a83ddafc2feb988dd9b16fee2f0a836e6c8ca7ccbf843c4ed96a2f5b9ad4296d6a9c34b166ab3b45ddb0869fe45e65c832621cdf7a7020401a2082240a079d90c8d567f9e7c6595024355c054a82a1419b20c5986aa967b0ce72655b6ad97b6eff22ac2a1b95b2574a956bb97610e0d43ab23172199c323da98a3d38f02a200518228421074d918cbff4f856a5b174e3020a022042012051894829659c8b2cd3bfa16b256e6e826a458f29c41e5aa204092204a1044109287a10a67e495c1a3ae2b2b3e2d2190244851a8712832723964335095807355b4abd9807155142145119140291883ea646aee0dc8d56e0a7f5215fd9fa2888884580cd92cb219c8b9c072552c6a43bc546b63b91a91108d418c000053a0c84587d6a39b53fc02296f37c51b32bdad8020164734865c1699347299007255f4601fcde0aa1841348e48040c50d512194afd5555ff9582836a558b15db13cb371442c088dd18b1f0ca4c6f3711091109b92cd229c8d9407155f400bac6729552c45b74ff42c79a53c99b0b833e96a014d4e09a12627a6256e8fcd4fc70420514a8da1d8c8336cb2b6b4f9217329b413201a60484aba25dbb691e57a518e271500a45b33c62e7afe6ed92107d5c218820145400350c2a2c3fc44ac6c8052d1505aa0c5981a24065062d2daf9c1752637b3a894c2a085c15f5af5a6bb6e15ca522e22d8844a032288afd2f32a657b11881204214f47185f69dc2d0c2a9ee58c9c7844214f4be5655a0289065c839283254e41b84e59519141984a2b51d1109c9292b2a1ace55d1d5441ac555298a780b08d53d78eb8b53dd5c048a6854d74f7fe0d271856bdd593e2e4a0e903c2755551f1ae67250149dcc05fdf51752a1a890a2104524a790cd36d15f154b58c71acdd5780b6271ddf888c55f257a244c10106b812481521da4c5a8985315b8f8ab765f670053f52f4811481214591f5128b28d900cba39b6752295402ad9ac388068ffd5c67095101d478a02c64a02df0caa0c222016871405154c36e71e07a858485d4b06a8ba632549c866914d4391f5182c54b33932c45b2188989a684a7c55b4ef9c1ac0554ad1da0e41d47b3e8bafa14925c5108d4110a0aaf6dea953d3d15c1553ef58f03969d1f3746bfa040c600a88e6214bc8a491cd80005430739541912145d1d185c9f1fc0d1bc755d1d0046c59e73000b7a2d9275729415b07a8501cad17e7130055812022a68d0b99615ce8ec5d6ba16add9a891efea62204aab7513dac234396a1c8baae056fd6cd88994ef2d6364424a49306733408a9c81044747463724c8f09348aaba2d9c528bdaf2d579d06e6deb84a295a3b418941bf821280aa221a432c0e420cae8a6d149041512067c1182212e2ad88b5e8c1142d202788a0b44814a6425190cb229b41268d740ae924d24964d27a304110ec66e7f27e13032409a2a85f42a8de31175e59554005b47719546c0457453b5fb19e5ca5146d9d2004aa929f702e34640584a2b5155214aa0a45b55900411840a0aac8a6c118627174f6a3bd132ded88b7b8be2c011140054424b4b4153fcfa49198c4d43826c7914a4065902408823d7bb471614b1b0411a9a4ae59a10bd554148c2a3662de4a74c05d7db84a085a3bf2fa1193bfaa281004c4db200a50d4e2cf5967f81832298822ba7ad1d58bce6e7d54577189c6108da1670654051363181bc6d83092097dc0c01cb81a8d4110919c82a240a0a67ad05ea4bd13136386465f47ae8ace33e675e06a6b3b04018a625dfda0a83a090931fdd5f86eba7811cc9c83be7e9325d5a450416f169914868e606810892944e31045f3fbe6cd5114d1d681c424e41c04c1540f8a0241d4557477826bc1550127ad715ca8e2b444c57ec98cedc227c3bf35422a8ad5855755481adc08986adf1b65d25015f4f6636029fafa119150bf2246d0d1859e19100424269149211229795f02a68252fd8d6439df2fe661a3aa884440a935265e877556024e5c63bed6762592d3da27380a69f9301a472c0e45b6193c4424b4b4da85bff29e5e2685f64e0c9c80fe39f515cf5431223abad1d50745c6c4381883583225a079bfd128141572cea022f4b5049204559bebb0e56335429a245c6b77676fe608979d6c86af8b225adb8a6383c29f541591285ada8aa3376286683a05423077210696221a43e34b24829e196869456202a9444903227af83caa85e5cc2a6ad893a290b3606afdd6af6a5668bbeaad465ca504ad1d7987961447814c452462d2cff276c9045adab0e42474f5a2b925de8ade7e64529818852882121b15a528941c64d9e0a3020ca0149128b26907d56ac0d53c482d17d490abf1564444ddc92c7ca8aa1004b4b48120dfff19d45555a492e89d89a527378e9c659d9dde9900c3e810400dfe4b21864cf53961550531acce5519441184209773d6a52a21a9db22f9eab92a46f4aec2f875ad0b89b7e507efc434fba328c8a43177008b963b2fbf6f5299b7184b4f822a2397313f1b81aae83350dad22c6230064541b40562a4dc92fb0ab94aed9657d788ab8420de6218e1e63b48c6106bd1239f96b79265e432183801b3172098a5b71fcb4e85caec55142388b7e657c519a7b454b4b639d76d55e658928f14a8195763310825832a5545340a49b28e2eb43867368d8113d0d78f20978e2eac78131415b9ac554545d16305aa62324455852022d6e25ab7150a493d0cec2ae22aa590e2d6e905ed4da271ebd412215019d249cc5f8cde99087e69ebc0b25320e720e7cc4e0083aa1619430cb6a12888c58bdda463ddfae62ab5bfb27aae4663fa144181ab9a39ea9f335373610ce914e60c60e61c84a574f660e9c9f9b5c28675535a47186b31e034bf7a8352c4e38e0657a939da667faa9aab5440240a55310cf2f2435d5132cd3f68134fe9147a6704b7ff732a3d33307f095249aba3afc52b24730d689d6534661d3b562d24751e1254c1d558de048d5d3aa59062254340826c16b118064e4018cb9c05e8998154c2aa016388c6f5e5e7a661a28058dc79e35c255ca5e5422da54296334742204a79c79a147b41290a413039dc5abc585530b02c70e307ef65f10a8811e4b2e65a66104544a250cd711945811403a135dcc7ea31fb931fae4a5173ebcb0fe42392be84b0f02b84209d42ffbcbcc31dce2246b07019b2196b8c9731c462a0a269ff2263100448311ffb58cb09499dc776957195e84dcf727d24bf7ec9587259b4b461d63c84bdf4ccc08cd948a54c6fadaaa002a2d1e26ae6c2e7d1a87395fae62a751edb116f429a9b8c244210cc1d1e031510895811aaada99dbb30c4083596f98bf3c10a63dc8de9534e0ca63e45100d814397440f9ecc91fa8e99b97355944c7fd24268a2082a581d996c069d3d68efc4f4285214b3e6229d32a5b5632a0431ef19986bb874d2a352ae52cf31330f5c2514a2585c50ab874329c448493f0100e89f8be954fae7211a852a5b2b5b9f3166c51a56558811fbb19c7fae52cf31330f5c1523a0868543da2a396da19fd10409412e83ceeeda2f9e68ba5fd3370b99b4411ba263d31a680404d161d58f6fae52fb9c249571b5b8f02b7fad36d94d49be333010a66706a65f99310b62c41a56a4828d84446369d5795788e9f03b5f731176f7154540b5ea2d88e68d6104720ef13674744f4309a37174f6e88bbe8d8e9b18c92f1d46b1118ba2a77c56e5b84a6d46059571950a3a458d914f412c8e250ad3ba39199dd351bfc20043b52cc964fa3e3ad31649a6d718caa5412ac755ea3c48f7c9557dab9f81ab4c7b4a4b77cb200ad3d304b5d2d98d788b1efb86c1a7d3c75a96309658ae865d1c11ab475a2aa44fae0a024c9e8cf661c9dc8a2c23de5a66e575a80b15d0d18d6cd66c090482680d6369bb946d6a18be3a485a3edae291ab96a7d1e656a8688e4d10c80ada3a30bd4b476749e883e93b69b489d2c2b25e41b053ca1f574bcff2ad94abda1c4a71ab3b40847c60a2f05d064aa7db58a2b4b4762012354513b5d028a5e6f43f0c54a83e413975c84ee893ab349f48abc055c6f27bd59935e0146b99e6124ad1e2ba6763a08a9a3d1ac2f4141d95e45f2d72d59c77c6ba21bb346994c31e1a6290b0d04c4ae7365515f13822956e64515931eaaf6d7223debe2950c77b2a6ad9fd5f6e973b95580b26c711317749a50b85b55ad276be39e6072893cfaa34ef0c73dc74e3949450af4d6a4ac5a2f94a96895f6db6ac8222504c65202b90c4229ad269c42268914cb33902c5440a0044a1f8cd8934daa2889ae77d28c1780a022da390a24256d119b7db0ce42261dc66070cb1f3042985e2319f95bd9062c99633dbec84a5425a367e927c32259882811653068314ad44c2a9ccacaef84de79db4b0339eb767f6873746ffe5f7afe0c80466b6179f6522b5624ed7b7cf5d31b3458f23e71476cfcec16ffd710726d3e86b2b2e69194ffddd89b3bfbc7a49ab24b8fc7222abfc9fa7763ff4d221b4c7fcb19494b40c1b6c10d34237f84a4c569050bf91c306418f5c353e07cbaf5127767bcc2ad80ec880a9f4ff7fe9e9972c352d6efb9bfe8e0b17f5fec3fddb9e78e5303a5bd02a415691556ebf70e5dff69b9cdeb36675bc7da0f753bfddbe73cf10fada101591ced178e4814bcf9068f9a9ae5fbffbf48e3d43998c8ca8e85942499f9c315a1e31f893ac745c0737d4397395968b627bf35789c368c4d264288520566285841c4b644b3f3eb9b7edcf1f5cf37f2e3a0d8ce1c884f69b479299d26f9e37d0fbcac7defc4f7f772212190c4f8152a6b0a3898c278a032ded31f39e82b2d744acf3a6cccee68a4388caf35a0b3865836b14c09bbf2a4afa10d0f815492a090c3274cf80e4739b040122c21ff78f80d28353996dc7265f3c34dedf196f8be8005c3fbfe78a93e66c1f4beedb3304517868702222d03de3a96d47275f1a9c386166bb487497fafc2533d62dea7b6a7062f8f03818bbfff0b824909da3c96d43532f5afe77705415e8acd62880444eb9feb97d998c8c88e0991c0c23c7f43d8845eb61c8e58a86a8f9105abea952c1bc9e174008deff45bb8eda36d750e93e5e56ecbdc568d19dd100128b830a5059319188aa60e10988b756e2cea47398cccfe3a4739dfd1dd7ffdd89d79c6a5ab4f18d27777fe18f3b303c8556495f5e9c9517ceeff9fe852bcf5fd4577457812ffce1d56f6e790d9369b4466dfb1d1c99f8c41567de78ee0a002959997bcb96d191245a3cf7028a8c1ddb20e720145a36852223953004fd19a8a0676db0ad55eb07cc01122b37d88d227daebad0926a592605f5f03c8a99cc342baca43b641029241111019288b66866227ddff3fb5f9dca9eb3a8af45d45bfada79ddef5c3e6bdb78f2e0e0045aa3daffc68e4edeb9edc0948a7317f71562b86f5bd4b76aa077cbb1a9f1e1043a628849900448222411d1085a2528ea05a7ce7bcbbc6e00114affe3a93db9ac1f2b04c3d0513dff57219ca6ed41347292d0fc92703bf279e3aa80951b9c47919e3b482bfa09a0cd561b0f51606040774f25120a14890c72f9dc040c888a50d84bbb8efee4f5a3f3db632b67b46b5f9cd31afdc8690bc41669cb815135a78012c42348e59ed839b879f7b113fbda9774e98185a55d2d1ffddb85c38afaeca1713d10a115594546468b7470327df98a59ed92f8f567f6fc76fb41c4251fcb7c5486e12350153348557d8b1a31f8329a842877f083335709deff459b26ef97abd118a4587ecd41fe8fb1b849572dfdd6c0d24a409acaceeb69fde1db4e5ed8911f5480fd6eeff0e7fff82a9bcc40562e3b63e0bb179e323b5eec650f2532a35319220a3955bd65fba1ef3db10be91c08f9ccbaa5df3aef24a34fb5672c99cc29245fd7a399dce71edbf1e4de6130d6d2d932bb55da75680cb10844c1c7d05096b1631b945cd17d2304b28c54c2e4da5301e924d2292b27fd7095e0fd5f72f8921f212351440b9b60f2e924632da6554fda92b5054bd0daee7b503134f9b3abd75eb1d4ba63e6ddf76ffbf5d37bd0d58263931dbd6d375e70cac693ed77652cf9e9d6dd87c62089189e5ab2a0f7c60b57be7da1e3e6e1fd5399816f3f8a16095919b28a160902f537b4cf66f0da76a846778642cee9ebbe0b4ca202520964d23682317bdd4afec5a86bfcd333572dd311c8e7cc327e5fdba35526d1afe3a062df58b2f4e3e1a93428012598dd3991cafefde6a73ff89b17865236c38f542a0742101130a76bd791f1f36fddfad9dfbfe2941f72cf5812aa0a06c422688b82127ffa21bf4add3260d0d2c211f3cc916d42263f5c151d032e704efa541a0760b04978c94ae2000c9065fffa019df17ffb9f9de3596549675c73e864c61ede3bbc65f710b4be4d65e88c23a7dcbe75d7fdfb473e77d6c2592d51ed9b1945bdede543874712688f82012a436f1b32f2f58fbcfce01b231f3b6d7e474434f6e1c3e9dcd79fda838808a18a05aeb20c452906f9e050930c805a265128ca1ca84370e597ca3baf65b92a08faeed64207c9544851483153e0349dc1ccd99839db778d508a4c0e9369f387045d2de6f03a40091219a472a66f460474c64d01520d33136964ed9a548b84d6a8bfb1bca58c0e61cf0e446386856654eff68c738484606a028ae29cf7b73c57c5f2f14fc7e89c81e95ad60a623047bdd131d3fd2990cb563447a12222a0a7d57ebc617105e312e2928d8b68a901c6d01605a28ed1ed6a4a266d5ac18d7c155163d645a2a7aa2eb00dbece61d1ff4dad08769b20745881a87572ccbcea42db2c69f9492a588f7a98ae259336e536d1d3ecab660212a8aa6166d8dbb98125ab2ca8e380c3e9cc3ba7388065cb84161c816a0a765301d94c858618ae924e5a17cb68672a986a83d825162f776ea05513424b3648789faf2f2195c95f25fa40d0f84d4a91938bdb62a7ad7e2964d2c53e8f180dce922443f5943ecbd55fa5ce33123eb95a38edc8b0dcd0ae95317d783b8d4b724a4fa360629262ed1d0b67a954731e2b293dcbb762aeaa4abe3bcc0f1fb5340f1677431491982c97ec36e465723c8f37c3885051400da762169251bbf9199eb84a1da796fc72551bb69b584f6d582a8848a7909cbe8628e7303966581f4440a8a97248be0b53142ba508a980abd43ef764655cb5929d4065665df3e3d9c9f1692be1f828b269ebe04f564c3b9fb5994253f25c58232a9eb94a1d44ae88ab8a6ce3af6a8f6e4cae13896072dce19497f097b16108e6746b0c5072d66ad10f0e8243564b1f5ca5ae22fbe4aa7616aed15f25048aaca7982bf8ab5440268dc9b169a85f2a81c97144a4a207400954393f7168f66e2c7387b6e6e881abd443e7e987ab8514c7859c165a5adcc26a3692df89383a3c0d251c1ab48e8f4121e7f21bb50d832b63acd83969b317ae52c7804b655c957336ed4896a132d39122110989c9fc0939d3a56433181d46345e0c316a110f59364f7d030c25796a5c8574e52a75f846a55c55142825c379cd7bb62cf713440c1f9956121e3968586991af5e3907c53ceb2450fdd01ac0758d8557ae52d76f54c455396bb30ab6748e2912c1d424c647a64b2f98c4f051446386c131055849349180507d1bb0537e4a9f5ca51ec8eb93ab1afa613644edbc78cb06b688842387ec12c887b01cd8a39f446bf4f6b51310056a5a35aa28a624cfb0b3043f5ca5de6624fc70555b2d29942c52ce65f3ab9b4991a5720e470e855ebf6383981cd3b78b187b413d73b0a1962845366bdaeeeb9ef7d70357a9edd107d572359729aeba280623e43c635971e3a414c3d870b847fa99340eef472c6eae10aa9f5d59dc5842400998aa67cbb7585e155c357a4a0e365b01571990cb59f787128a6c36bf2ecf104d15451cda6f75654354f6be0600d4b0e58a52a80a72253e011590c95a53b239cf2279e42af51439ab80abd90c546672a6b5f488d9ac750f86284155f0c69e50eaf7c62ea4a6108d99367969271469abf12dbd60366d97fe0cd570953a9b6d755c054336034af3cb38a0efd256729073f98338f3cd361a432a81837b43a6dfd1c3183a62dab4ccf22b1372d9bcef96af372d2655f0571d27927c73953a0fd5abe6aa9c852ae75534a421cda6a128661581681ce3a3183c181afd868fe2d03ec4ccebaf04018a8c74dae49a6a6911e41cb2191f30f3cc55ea23045a0157d369f35e51e8591f3229fdbf8d5f8fc6307214470f8740bfd1211cd88d68d4b47d5e9b5c4b278b156bacfc54d2f9a0b2aab84a3d87402be2aaaa229bb10e30a800554126a5afe22d345542108d616810470e06ddfef6ef42246ad8b544f439de74ca10d1ce2f891604a45386550d1ecf0df4ca55ea39045a2957b35928aa355300cd838550739e1382684c675460a36807f6e4cf18359cf646293269e472e6b4160c820059362fb9aff400480fe754947eb5465c4d27f3edd4f82d01d92c72193de10931aa18c7d808f6bd16acb56e8c61ff2e0cbe81682caf13292eaecca691357781c83be4c6fcf9d6aaab0157a9b73dbdd5715555914e150fb72efe9d20a3396fd4b0c700faf6d264127b5f339fa5dabc929cc2eb2f636c18f156c3508115f54ba74c44413e9b456aca3087ea3d39a80faed24aa7967c7255ce2193ce273b2a4c561210824c5a579118f2ef31e821e3837b71f88d92e3631b0ecfdd3b90499b931e315da46c06e9745e3f437e2e2a229d2a8643e1772ec92b574583f1da1d1c0ff391d8856ff8d84993bf792ea3e7592fac19d13666aaf9e5eb920418f6feb0fc59f3a343484ea1af1f9d3d8d166f6a1c470f636a0252d43a0ad2da5c268d74daa041beb24411d90c3269db8d2c3e0f2c678efb66485142735d97cf41c3ca3c909390992448ab21933cd155644036adefa4d102c485f80008622d907338b41f1363e8ee455b6783c8397c14e3a320d0f3363298f403904a21972d6e3c2ebca92040ce2295704b99e5e3c0725b032b0a21daa1afd41c2d425af206391cd94dec76d2a4136869d3e781917f13edbc58ed084ecd59286c432405731491984262122d6de8ec414757bd4e47981cd723efda51dfa60456a4b8f82c9d8452983e63a6e486b28c4402567239e43eb3ad377814524be0e582be3a713595443c0e4128ee1e62f95c7caa8c5412d198eeb29bcc1190a2602a520924263172146d9d68ef344c115457b2194c8c61720cc904c01091747fd2682b5ae797cb229dd4d3fa5a841205e46424a61cea07f5e0aae87c41ddb8ca185229fd903f939f42402954864c0a4a444fa0643c875b33d8481460c8e5303488d121c4e26869432c8e58dc772206454126855402c904520964b3a08235c518294c8e513015a92472d9620a5de38b6ad39fc9c94a521156c155b1fc05f5e02a634825106b4124024536743344df15adc557c5a8be2cdac255adbe344b4d25919804a5102390a2884421491023faf926054757b369458592432e875c16d98c3ea4d1162b8b2262b1d2a706f29910b33964d3501593f1159f4740369b1f027a4c45581bae8af60383c670359d048b2122e99bd099e1f534fbcba6a0c8ba1e05210b77d5be29464022fa06cc6402ea443e49643ec56601308ce9db8bb4bdab94820a10459088c15131d72dcdafaccc6521e700624d7205a36b9ab269e5769b3a6bcb55d13edd65c3b89a49eb2e0c417eef4f214c430106250745862c2212d16392fa8e62c38f16d29b89147a0e50a6bf94f6e5c23094ba678033ecbfb58a87a2f119df489bd62ed095c16bd3af1d5745e76b1ac5550d65d1b87e1c0233b7122ded8926a4064ffd340556b044bb6d52a4b886c51c252b97409602044cd153a3c9b29edf9e940a4df4655de964be4777eabaeacb55b1e41ad604ae2a0a925388c6109140f21b9a2d5cd584d4568b6b420a541f9fb13c271dadca222db38e13f42751a1c890157d1341c105652507136a1699cb2095f20ab0ba71552c415ff3b89a494396f39370aae917597e4287004c4536a357aed69fe9ff418b193b8aaf40500297fc0e484307a96d1e5364a82a54a6f7a3c8a3d838794b09a836af9bd2f7b5302f0da58e5c15ad2da2b95c55642465485144a47cd2ea925652301a5585a200b23edcd6924b5362881d1bd246165e47cd77905a66464d3f2db3032120140273801e8140a1aac8a4f529eb0a870435e6aae866c5cde26a36033987880431e228a4166526792353b41db3c4144a26253fad7b3706f06ae6689ab129a96542f5c7c86690cd18760a7ab0956ab98ab218134bfe8c4070556becb91c22f9111e53cdb963ccb72204100ccd8b012c7f04182b993523e68c0f761da47621cdefd1cd6690cd16f304ba24e8a931576d3b48932825a9835890b8aa2ac828c85188117dd6024c2721609f869c180606a68ab67aa676159dafe5827dab0ab229c8b97c2cb0f4e1cb5771bdb92adaa02f685cd58c2097cd0f2a28049a2721b36b01b6155d1adc2889c2eb5d2983a24296a1e490937583f6755e4063b92afaa8d6e6faab8ce513e812082204aa9f824489d97564aecd19d6c08a71a8a0f9a55a063ca6d83fbc13f49ac755b1847e01e66aa1aee51ce4bc06857145219ce6241831a8a549aef9a2aaaa7b43aa62cf55c75a76e2aa87765f3bae8ace5796b3625f53f67599b72a2438cde58704a4b8a95f0b1c12628ecb303d731d63608a29fc06a7100fb39968ade0409dba71d5e5cca6724fe686be46cd5b996eaee9a19a62d6704e926c63a64ef957e178a04e00b84acb2db9295d6f53bac4df21b19e6da3aee33a2b52b3d578208e41578f75e5afba50e69c6bd7a35ea8bf43627cd5b58fa5fb96eaad6cfd2a7ce707809f3c81551ea863737fcfe75cc36d1d1b2ddf846deb9af869d44eedb7261653797e808a5b899fba826be233786f288e4d9fbada32e76a08b84a7d18cdf1ce55124cae52df0f77fc72b5e6e65e1bae523ff4ab3757c974e32a1ac1555aa695113f4256cb5570ae56c0556af3f25e2fe65c0d0457ed0efc690a5709e76a855ca5e6ebd120ae5635f080e3cd8f4baed2f22f5f0faec23f57dd6cfdf8e1aa4d43a1e5af0f0857e19fab64fa71154ed99f3ce4dd0e2357715c7095fa76d6395703c655eafb7aced580719556789e01e76a60b84a3d3ddff4e42a991e5ca51e9e6fba7215d383abb4a22008e76a80b8ea7dd69e7335a05ca5e52cba765c259cab75e12aad4570193e5a19e76aadb94a2b5de1c3b91a14aed2320d8d7335f05ca5aeb7e05c0d015769b516cdb9da6cae527f0d8d7335785ca57e6ec1b91a44ae520fb7e05c0d34572b3bf0877335405cf573e00fe76a20b94afddf827335585ca5fea7fc39579bc25547156815cfc7b9da48ae3aaa40adcfc7b91a36aed21a5a34e76a53b84a6bf77c9cabcde12af5bd1fec78e12a090b57a9675c1c6f5c4558b84abd5a34e76a50b95a367510e76ad0b94add8e5d6b2857893f7f9a73d5146023b5cb0b5339573d74909cab76dca23e87b79cab81e32af5d4ca385703cc55eae35c52ced5462626f3ac02753d609673b5565c45fdb84addaee75c0d0357a9a7eb395703cc55ea2d3906e76a70b94a5dcd8573b5b23b3794abd4353906e76a351d6483b84add9e8c73350c5ca59ea2419cab01e62a757832ced5d07095dad832e76aa8b84abde5aae15c0d2e5769d9932c385703ce555ade961bc355c2b95a215769b996db28ae8273b542aedaad9de15c0d15575dd7ce70aeda36c18071953a3c13e7aa5f5b6f1a576939fe70ae069dab7ed6ce70ae0692ab1436040d3e5709e7aa6111a2cb7924c1e52a38570b77a66efad79cab8473b5f65ca5652eab2d57c1b95a7bae524f86c2b91a60aeda2e05ae095709e76a63b8eab214b84aae8273b5315ca595180ae76a90b84acbd4ef71c155126aae526f23f1e9cd55849aabd44164ced5d070d5398d1ee76a48b84a1d2b977335245ca56e95cbb95a47aed6eca032dbd5dc9cab0de02a6ac555eacc1cced570709596630ee76a3db85acb0320a9bd8970aed697aba82157a91d17c3cf55721c71953ab4d32073d503f7701c71953ab7d3c072159cabc627a3e5da29e76ad0b94abd9902e76a70b96abb20bf495c259cab957035bf20dfbe3496abe05cad84abd47568ccb91a02ae520f310eced54073d561413ee76a78b84a9ddd7dced57070953a1b41f8b94aeac4551228ae5267c8849faba813571128aed2f275cab91a6cae52bbdae05c0d1357a933ca02c355c2b95a7ed6deb6e202c35570aeba71d5611d69bdb84a38576dee5f1d57a95b85d69eabe05c2dd7417a3377527ae08f0bdf38571bccd5ca0ffcf1628e9cab0de02afc71953ad71ae76a38b8eabc2d8673b5395cadecc01fb8dc9473b5c15cf53df0a06e83f1e6729570ae7ae22a05e066134de42a3857bd1ef843e058ff95719570ae7a4e2b5a03ae525787a232ae8273b54c075953aed272fe3de76ad0b94abdf9f79cabc1e52a75ac47ced59070953a552fe76a58b84a9d9b3ce76a38b84a5d6b8a7335045ca5e5da20e76ad0b94a3d3779ced5807295faa929ced520729502ce5271ae8681ab14ce2a71ae8682abd4f9893957c3c1556abe17385703cf55977409e5cdd15d48ced5c670150e8b107d0b1900aeba80eef8e12a0175e662e0b90a70aeba0e2a385743c255ead6c639576bc6d53a1e00e9ba2d8673b5665c45fdb84a1d27a53857edb94a82c6d5d26d319cab157790cde1aa9f6d316519cdb9da0cae52d73a74374770ae0681abd4dd4e385783cf55e7414553b84a38577d739596616683b90ace55df5ca58e4d9e7335245ca5657c42ced5c0739596f709395783cd55ea7588c6b91a54aed27292858aabe478e42af5265948b88ae391abd4953c9cabcde5aaa703759c279beac755c2b9ea91abf0c2555ac6faeac15570aed692abdec6859cab01e62a850783e25c0d325729caf18e7335e05ca565aa8e7335f05ca565eb967335e05ca5f056b79cab81e52a750dff73ae8680abd42504ceb91a0aae7acc47cab91a5cae961bda73ae069eab1e86f69cabc1e6aae7a13de76a50b9ea2e618db84a3857ebc8d5b212d682abe05cad23573d4ac8b91a5caefa92907335885ca51eec8973d58f900de72a75be9873d52357d15cae9af75454638e9cab4de22af560cb9cab81e62af57c31e76a40b94addaa9873350c5ca565aa987335f05cf51660e35c0d3057a90f3d385783c255b72328eb648ed392aba4795c3575901505d802c4552f42d689ab080857fd4a1834ae8273b53209395703c4d58a25e45cf5cbd57a2528af5242ce55efe6883a1d585e13093957ebda4196e16aad24e45c6d1a576b2b21e76a13b85a0f0939571bcad53a49c8b9da38aed65542ced54670b5011272aed697ab8d919073b58e5c6da4849cab75e16ae325e45cad31579b226183b95ac38d7341e46a13256c185751bb851d41e46ad3250c0957115cae064142ced5aab81a1c0939572be46ad024e45cf5cd55316802ae6dddf1f1be4704a202b86ffc8cede9052f26e7fb1492996a99953547e6f241a7905c143d7662ece0455d7f01a030fafd636fdd3ab5ace4cbc4ed9708c05cbfa09b2373f84afe5a9b7b1082afdc1b10f14e8c1dbcaa7bcb655d4f193fcc3161f3e8dab41a7970e2f47d99be348b78be1fb3fdcff25f0600c4686e20327461e7f36bdb769e143f48cc5ff8c5e8dfde39bce695f45cbb1bb072bfc3ca3c09f3f09ca6561700094f8defbfaa7bcbbb3a9f23ce8faf808e2b2d7f492eda32b5fca189378d2b2df510b253489edfb16d5ddb8e335af6740a290d060ef725bf193bfdcee1b5db52f3edeedf38219b2ce1c9b103d7f4fef1c28ebffaba6a486e1f96dbfe9c58be656af99f13cbfc595849d52c8b1dee1327d7b5ed58d3bab3579cea13277d3dccbf1c78ff6fc64eaf8339ba0b5954b1691212b08b3b9ffdaf399babbccff3a985c372dbe353273e9d58322cb74faa312fe6d82ea47b85c9b35a776d687fe5aded2f55f90c2fa7e66e1a5ef7ebb13358c1e56820579b20a140d477773e7365f7d69362076a7be7c15ce71f264f793eb5f0c1f1d3143b673b46b25f9cfdcba42a9dd7fee2acc8786d7ffde5d4dcbb4656ff6aec4c85d14672b5d1125edef5e4877afe6749f448fd7ee2e9c4928fecff688e097612e67eb5e49b03d250fd7e7d57a6ffd6a1f5f78e9ed530ae0a38e73d150cc12a2817753efb7fe7dd7e69d7d33d62a24e3f2133e19307aeb9e1e8058ac378578670c7c8fa3e716a45ec1025ac1ecfd02326ceed78b9579cda9fed1b535a1b100720f8cacfbd47352aebf3ded5f9dcd53d8fad881daa5ffbc830f1ded1559b46d6efcbf679f9fe8034f4f73d7fbabcfbc92891ebf4483926fc72f4cc1f0f9db33fdb5b57ae1a25acbd8a7322a3df9cbbe9f4f8defa899756a59f8f9d7df7e8daddd919de460ec5b2387af4bbf37eba387ab47e8fa7307af7c8aa9f0cbdf950aebb4e5cb54858332117484357756fb9aa7b8bcbd0aafaf26a7aeea70f5c7d20d763aa17e60f1297773f7565f7d6ba424261f4ce91b5770eaf29b1c81a9823c1977fee1c1eaca42c968e5ed9b3e5b2aea7622457bf4a79393def8e91f5bf1e3f53b5794edf4252b08bbb9eddd8f3a7936207eb098cc89d236bbe39f88eda7295e0cbf738cf0ff856f1da59f75edef554842875f58c3e7f70e3fd1367781ad1fb7459ae9fb7e9828ee7ebfaf0db53f36e3c7ade639327d6ca1c35090d82552ae45bdbb77fa0e7f1b35a5eafebfbdf37fe37778eaedf965ae023bae653c553e3fbafead97251e773757d91a7134b6e1f5ef7fb8993ab17d228217cec3c3694f33b5eb8b27bcbdfb6ecaadf0bab20bf1c3bebeed135dbd3f3fd5f5d8990a7c4dfb861deadb323637515f299c4e2bb46d63c347e6a355cb548e8cf1c2fe878fe433dff736a7c5f5ddf735f76c6a70e5cfd7a665675b7f12d649c66dfdbfde7f7753f51d75000801b8f9e77cfc8d947e58ecaccd156424f423eb2f46bf32223757db7fdd9de3b4637fc7cececb42ad5e27e9598638c66dfd3f5d4c69e3f2d9086ebf7a6536aec81b1d3be72e8d20ab84ac11818737b6156fa390320d56d50ac95ff18bcf4e2ddffb269647d8df44365eb01d2aab46964fdc5bb3effa7a915f57bd9369a7e4bc7cb25b0f314d021b8f667864f892f73bca8f3d90ff43c7e72ada3d5bf9f3ce58ed1f54f264ea8670ba9c42257b5eedcd8b3a5fa990d4b792935eff6e175f78d9d61fb8c65cdd12c215c73d53808f98e8ebf5cd9b3f58cf89eea5fe6a18937dd39baeed9e41234a254a22280335b767d67feed3dc254953f9f52a59f8dacda9e9af7c0f8e96ecf514e48826bef763815c8d99db113f2fc8e172eecf8eb9ad61dad3453c1fb0cc9ed9f3c70cdb6d4001a5d2a11b25b486cecf9d315dd4ffa9d1fd64a428dfe62f4ac9f0cbdf948aed3492ee78f99ad840ecaf8e42a80d991d18ddd5baee87ea28da63dbecfb0dc7ee7e8dabb47d78e2aad685aa94cc8a9f7f5fcf933337ee7cb6db967e4ec3b46d61dce7539ff22f3658e045fbadb20894715cb08393732f2deee27dedfbdb5ac90df3976e13da3ab46943634bf54c8d5f33ab67db0e7f1bf69d95356bccd236b7e36b2eaa016ef2e23990faee62584fb691abeb90a608638f1c19ec7afecde12a7d9d26f3c915876e7e8badf4f9e8260950a857c6bfbf6ab7ab6ac6e7dadf44f7f9a5ab13d357ff3c8ea637287a342159a230046f0a5cd0e7ad480ab00fac4c98ff4fe6191747443db2bda275b13cb6f1fd9f0f8d489086ea94c48b6a1ed95efccbfbd10df7f7c6ac5edc31bf445a75e14aa48c88284b05bd35e1baee63df2d73ed5f7d0cecceceb062f47084a85e6383732fce1bec796450f7fefd8db9e9c3ac1d3af54c755822f6eb6df0a5c6bae86b3542864950b917d9923d5277f9935f862f8b02442631fd061ce2fac7f54ef804e1d4a851b3ca2c6e9b63aefb7a2c5dab71d7c9884845548fb96c26cc372e7b4bdf4e8d2af7dbcefe176cfe38dc009e9a1b4d3f4c7673cf2bb13fe334a94c6ecb712b0e132d72ead365c5ddff6ea0fe7dfd24a3367b7be7e71d7333926be985e103e21cbd9d3553d5bbe356fd3b9ed2fb5d1cc6c69ecd1c9950dd86f2560fda5251ad458c80dedafde3cff47858f5a696643db2b27c60eedcff61d953ba707574f89bf71edecfffe50efe385e0d48ad8a10169e891c9536d5cc59a72356f8536bb528963c6133ffeeabab61d3f58704be91f16478f5ed1fde4a2e8b1fdb9be21b93dbc5c5d113bf4affdbffef759bf2a5d09b73c76d8ac625d12e898415a6b73dcd0f6eacd76fa15cab2e8e17774fc35c5a497d2f359c81c572250f5aa9eadffdf9ccda7c4df70fad2f2d8e145d2b1877515518f03cb056cb8b4c46c6b23e4bab61d372fb8a5bcf346e50d6dafbebbf3990c935e4dcf0d859002d42bba9ffcf6dcdbded1f1d7282de3662f8b0d2e2cda226ace55ad2fb44565555cddd0f6eacd03b778af9476217d4edbcb67b4ecd99e5e301a8890a96359123df2cdb9776cecf953bbe0d5b55e163bbc401a7e7472a5a30e557055c0fa4b1dbbb74acd717ddb8e1f0cfca4026b9a278d5cd9bd754e647477b67fac991317f665a174ecf3337ff31fb3ef9927f95e71b2dc46c5da7055c0fa4b4a94a84ac80d6dafde3cf0e36a687862ece0553d5b55d046cdfd7a2a1fef7be48679b756b356b8a45fb4d3c63f57f3566863529570755ddbce9b17feb8263edfd9adaf9fdff1c2941adb9999d35cf1ded5f9dcb7e6de7141c7f3d5f7d2cb62838ba3c71e9e38b50c2afd7055c0ba4b6dc4f0648e5621d7b7edfc512df42b941e71eabcf617cfeb7871477acea0dcd578f14e8feffdc1825bdedffde71e71aa56f73c213a6847d4cab96a002941797374e6ea86f6576f5ef8937ad4639f38f9aecee7fac4c99d99d9538efbb06b5c6645c6fed7cc07ff7dd62ffbc5f19adfdc3c5e44955cd52474f5393d70756ddb6b372ffc69fd460302514f8defbfb27bebdeecccaad70497292d34f3d9990f7c7dce5da7c7f7d66f5bd6f2d8e1856e2afae0aa514267215dcd717dfbce1f2dfa490346730251cfef786175eb6b0916dd551f21dfdef1c275b37efeb68e6d75dd535718692c891e1d92db0f972ec5f0c355827fbdcd1e8fdeb8baaee3b51fd5879feee585d4c0a70f5c6d58ca506d99214e7c77de4fdf54e7cd05b6e51ff6ffe396a9e5e5bee538012960dd250e782ccfd50ded3b6e5ef4d3a67889b322e317753edb2a64766567a5aa5beedd2b4e7da4f70fff31fb678ba2c79af22e17753ef7626ac13e6d97b27fae12fcebade60fbc05650856b7edfac9e21fa3d9655469bd7b74ed0dc7ceafecf2cfcc78e87ddd5bbb8544d35fe49a7d1f7da27c1a241b7314c100c28ada6813b94521999e9e86142e22daff9fd9ba070128dd42e2e37d0f2f8b1eba73749db72ad0cbead69d57756f796bfbf680840ece6cd9e3edf90dc9fb7447e50bb77a733bade6d82ea4cf6cddfb9d8577d67b4faff7f2cedd5fd895e9f7f2cd25d123f72ffe7a401efba9e4d2db86373c9b5832e96fc8c40a7de1c5aee30747ae6699b83733e381b1375160797c50acbf0be75e7e3d7ee66f274ecf324fe939734cec8f8cd7354582979261e2cfc6d6fcf3c10feccdcec8fa4e2c5a18daaf7bb79dc3526e389fff605c69797c72f9c363a7ac6edfd52d269b55173f1f5bf5ef87df9bd78ff48a530aa3960442dd42a25d4827d5a8d6fe1e9d5cd91f19aff9b62cef65d3c8fa2f1e7edf7de36716f5a82891ae80b5eff6341074e5eaa8d27ad7d0eaa372c77c69b47ec99d9cca3d63abbe7cf83d857fbeabf32f3f5df08387264eb36cd2f8c6dcbbbe32ebdeddd9fec298f28f5327cf8c4c345ec557d3736f3876c10f87cf2b998df1b1ceca30a8587bb18f81a0abbffa726aee03636f9a19995c111f6c58756c1e5dfbd5c397171ef3828ee7bf39f70e9128b78d6c98504d394bdfd1f1d7a5d1c1f33b5ed89ded2f84781e9b3ab9579c5ae93ced5ef3f2c5c3effdeae0e52fb9250df0678ed4e4795a168eb292cdf9d615a40cccb87a914d28f17fddff9e8b76fcd37389850dd16fcd75872f293ced051dcf5f3f7793b9c36786fe4f7fd9ebe7de6ecc4c72dde0659b47d734e0691f9c38fda2dd9fffc5d8d96a797d7c7055b47a38cc387e0040f2a30e98061e26ae32cb55afa5fb3fb4ebc3efe979f61ffb1fab79cec8223f47575d77b83053c62ee878c1ac9ff1bdac3571fddcdbf766671432335f3778b940d8155d4fd4e95107735dd70e5ee17fabb7d6a9b9a724b5d96b6f352cb3391a9708bb5d2533ba79f8ecb7bdf2b907c74ead47a5dc3b7af6970f17f766bcbd63dbf5f336b9fadfd66af8b7fe5f19fff9e5c3efb9776c55cd9f734a8dfdd79177bf6dd7bf57b1559f940b73eb7d616957e73203e5d55f55411f1e3fe589a9a52d347b42ac66d9ea368facfecae1cb0abf7e41c70bffb744bf4d23eb2d7de1f91d2f2c35e4419d1b195d197fc39845ea8f5327f78a9335ec177f3b71dab587af787472a55aed61126e5c15b0f622df01369ffeeae15cd7efc657329025b1632d767b0dfdea67e0276645c6362ffa9e9dcbbe6e424bc14eec2504b0503a7652ecc0830615ff67eaa49aa83898ebfaf01b1fbd7de4cd350cc43bf9abb4849075e12ac06e3a72ee453b3e73c3e079d5f57f6717fd1700c09766ffaa4cfc82b9ed2d3ab7fda59be69b22bdd70d5e7ecfd8ea8a9f70586ebfe1d80597eef96cddf206909245886b2ef246c81a7035ad4acf2616ed4ccf9a2d8d57e0e6dc3b7ad6b5072f37fef88d0b6e3bd72185c8a691f513c5831088ad156a6551892d3e3675f2caf81b0b25df13174f27977e60df27b72456a499843a161357a97908c1ac43088b4760bb870da557992e14a01aaf7a64fce4ab777df8d663ebd2aaf7734370f7c8aa2f1dbcccf8e3df5ff0d373bda68061eebbfcce6d7fe9fbf34dab5ebf7ee4223fc79a20cd229f39f0a10feefb4403d74eea42524bccb41e5c3daff3a5fb977ffb9cf6570b57a555f1eb872e3cffd5cffe7efc244ffddff0eaaf1ebac428c68d03b79ed3fe4a0debe39cb6976f9c5724ea9eeccc8fecffa89788ab961eeafcd7ffb76515c567663cf4c8d2afad6ddd516f2169a5237a1f5711b025b163df5fbce953fdbfef120a71547624d7f1a9bd1bff69ef95afa667bbdadfd9d71dbad8d8426e1af8e9b9ed2f97333ca7c4645efbc5e7928b3fb4ef13e54265733eb8ff13ff79e49223862d5a0ba4e13b06befbf1be87e745463a85bac78d69c9a6ceda73b51016f9e4ac3ffc66f9774e2dfa7b0c600f8f9f72c98e4f6f1e5a25db1d4bb075ea84af1ebcc4f88b370ddcfa16eff6c798af7dd66f6933a9f8d7d4c28dfb3e6dfbcd21b9fd7307375eb2e77396e4a89f9ef1d05d0337147298789c39a9524227496ac75543e98b4cfd6cd90fbe3d70d799ad7b8d3f7dddc18b2eddf9a97d995ee397734cf8af83ef347ee24f3f7b6fd99f8acf25176ddcf769cba917778faef9fb7d9f7ac09c99f8ac96d7bf3df7b64ff43ddc5b514aa82a24ac8290feae3294b777bdb469e98f36f63d114161ba98bd96eebf78c73f5d77e0e25de99900324cbc66f787776566167eeea681dbded25169ffe7c71c3515a3f9dc23cf25175db3ff63192602d895e9bf6ef0f2af0e5ebed7b0d42542941be7fdf8b6819bdedef1021a5e04ac7e57b921bcf310c25b1c60716ce8c26e9bf50d1b3a76bea3fb8571b975675a9f375040b7a7e6fd62e4cc952d07fef3d0bb9e9c5a52f8b91b17de7eae1ffd368dac9b50e2c6a73dbf73db52cfa7d42c928e7508a9c7a74ed4ee7028d7b33d35bf579cfae0be4f3e6f1ef0bdabf3b96fcfbdf5b4967d0e019ad37767fbeb2aa168b224e392196bc89be4ffdf10f2f6b2d0c6b5f52f888e7c63e09e751d3bbfb4ff92fcb435cb30e123bbafce370306909b16deeedbfe983958efbf5cdaf5f48313a73f975ca4dd614b62c5968429ceb9247ae41f7b1fad77166f8fee4c6d3c4fb7ab5ccb45ddcf6f5ef6c3cbba9fa5c5fb143be31b2bd0cffae3ac82e4313192bb65c10ff38e89e90e14ecea9ec7ee5ffcf5a6eb970fb0957a9eacc4f3acd65f2d534e8a1ffada825fdeb7e28685c544d80c603f5874dbb915f67fcc4b80adac8ab72db8c990228f01b8aceba9fb167fe35ffaef43300ab5f73cc13c49e2cf5f2d5f96c48efe72f9f7fe6dcefdda55abda76bfb9a3caa131f3dc8a1c9c05a2de31f03d6d95f78034f4a559bff8daec9fd5f5e4b70afa42c3d42ecaae292db839beaef2d3f069ee03339e382176f491f1933e3be7e1eab5b33e6a45e5d6053ff8c6d177fef3cc07db8297f748cc7b2a068705e64979c6cc1e0a1c842cb9cae21cf929abdb77ad6edf55adfd99a6ebab3aea2e46b3d7cefa6f04b250b3f3c6eac9d5c617df240f63710fb0d52852dae4c2aaf1684221a193e70947cfb3027fb529cad90d2fa6a384a50910ebc4d5c62b6805009bae56c83c1b56855c2568de768b66f7c72d151df95029486d0dab165c159ad3fc5d161234a824d4e86b99d98d0fb0d59eab5bc7177fe2b5f7c98c365c415fd9956b5c5e480d5cb3ff63afa4eb9e34a7648ba84da81a958ee8f5ab2695e81fc74eb878fbc736f63f7dd98cbf4a0ddb8f58ba0ebd2165586efbcae0e586cc32f57d06eae040d69eabbbd3bdd7edbbe092ed1fdd9dee6b9819bacf3fd7bc6499b86964dd557b3ffde8c44a570fb9f6013662df664d711914278f88b965592f749bb7da9deebd68fbc72ee97be1ca99cf9cd832d80815ab0bad792f9b47d7fc78e89c8385e3bd6d6caf2ee62816b529fe447db9aa3072efb1d37e71ecf477f7bdf09f8b7e5d7f6fc6fc767528afa4e7fe78f89c07c64fb76f3dc4a161d5b42f2cb12a94ee5db2332c541e5f6560bf1c3af5b5d48c6b663d7141cf4b75d1b0f84e7534c32f1c7cbf7ef4202995cb5251d68ebab67da19ddb69d3cfb1dafaabdb13b3ff79d765ef7df9c3f70dafacd3f0ded7b4a59f5b93fbc6ce78efee4f178f8e64a8ec3cd69af48546189a1b082b695c5e272e7ccc5b6d4bccd9b6fb929dc9fe2bfb9f99238dd7c71c6bd903fdf7e899778eac7d59df9e585a3fa5ab8aeac855d1e1371acd5580fd7870f5e6a367be67c65faeec7f664174b436a1992a26bc6ccbfe6cef5dc3ab6f1b5e6f5e1256a28c75176d1db92a964caa91922ec4450f8b90d5faab493572db9155f70e9df19d253f5fdbb9abd62a56550e647b360daffdf9e859f97c61a53ea05919bdc688035749adfc55d1bccd1a41e06a42897c64e7556b3a76ffc3ecadab3af654ce4f37b2f92b8f4f2effccbebfcf30d1bc3cd3d252ed6470fc75562bae8a7623874070f5cf138b9e9e5cf8f1398f6f9cf9748798ae48c19246e3bffc7ee2a43b87573f513cc6ceb23cb35ca3af3f57459b6e3f305c9519f9eec1736e3f72f687fa9f7cffcc673bc55423036c2372eb67f66dcca7eeb020d1a1ae9ac155b144f0c071755c8e7de7e05b7e3b72f297173e7046db1bfe406aaa501fe2dd3d7cf65dc3ab86e53657243273d53787aba28d0ccde46ae142eb553b5333ae7ae5ea73ba767e7cce9f4e6d3de843c56280cd9390db92f33fb167e370e118a9b2095b9acd55d141866671d56e2460d817f0d8d8b2c7c6966dec7ffab3f31e8db99fb4e33fc0f6ccd4a23b8756fd6efc143b254a5f36285c154b6e8a807315c01d47ce7a7474c5d5b39ef840ff533509b06599f8d9bd573caa6f3966b6f9574b5e36285c2de90b43c2d5c16cfb7fed7ffb339303ff307bab33575dd0a497b41af9efe1336e39bafe70b6d3f4826e4d2d585c156db40d0f571f1d5df1e8e88a0b7a5efae49cc797c48f9517d25c76a567fcdbbe4b5f4ccef3f25b81e5aa313ac3ec6e1a02aefe76e4e4df8e9c7cedc08357ccf84be17002a205e50d5719b317bf9e9e79cbe0ba5f8f9c56a287d7bcd6c1e1aa68beb95deba80757dd84ac84ab00aedb77e1dd47cfbcaaffe9f7ccf88b6106a578559609da1dbf75e0bc9f1c5dc340cc20a978334993b94af089eb1dceb32839f61065ce6c2a733465e5a989e0796b7123af424d0e2ab3bfdcfed7edeb8a5a074c4eb36bf60bb4ede602e170947ae9d6fb3aaf5f2db771aeb2ab9c163d97bc6ce94264069b1c2170dec7eab808d638536b59906ffd4f6623a4ed01f70cf642dadcd96e9d959b900e179a5eaf32f9ebdc6860f7b270ae2ba7f883fd22d8e2c3539b3fb80be9628eb66b50bd0b69dfca98db0affcaf605d4e52af74458ac7c5dc179bd9ddb7a0046ed46bd9cab61e22a75d8bbc5b91a1aae52bba7e75c0d1357a96ba3e05c0d0157a97d749873353c5ca54e7e0ee76a58b84a5d27dc385743c0555a6efb24e76ad0b94a1deb9a7335245ca5ae75cdb91a02ae520f75cdb91a24ae9608491de2e09cab41e56a4907499d65e25c0d07575db35070ae8681ab1e128970ae069babde72c154c555c6b95a57aefa49e7532157c1b95a57aefacfc8c4b95a97ab58c55cad28a99677ae32ce5563132cab47255cad222f9a27213957bdc85f55a3a93ab51de76ab3b95a8bec849cab4de06ab1f1d52ec124e76a43b95aaccf5ae708e55c6d3857eb90e6f5f8e52a6b0a57eb96a977ba719579e02a9ac2d53a275b9e3e5cad0521595db85aff7cd99cab2edd6a2db8daa894e79cab75e36a53b3d64f63ae56365ca988ab8d95f0f8e1aa5b22dd1a73b5e11272aed69aab4d92707a73953594ab4d9570ba72150de56ab325e45cad9aabc190703a7195359aab4192b0865c65cde32a1acdd58049582baee238e26a2025e45cf5c3d5004bc8b9ea8dabc196b0715c65e1e56a18246c0457115eae864742ce5507ae864a42ce553bae865042ce55f355a195907315e10529e7aa99abe197f0b8e7ea7491f038e6ea3492f078e5eab493f0f8e3ea3495f078e2eaf495b0315c65cde7ea7497b0de5c45f3b97a7c48d844aeb2ba73f5b891b0595c45ddb97a9c49381db97a5c4a38bdb87abc4a388db87a7c4b382db8ca250c3d57b984a1e72a9730f45ce512869eab5cc2d073954b187aae720943cf552e61e8b9ca250c3d57452e4a852a1200c4d51c09ac5fd16a9d98ffd3f0a1e3cd351549feb3fc253c461a18aea21aae720943cf552e6100fd557f1b92b984a1e72a9730f45ce512869eab5cc2d073954b187aaef2a17de8e300dc0a43cf552e61e8b9ca411a7aae722b0c3d57b984a1e72a9730f471002e61a884b433642e6158b80a2773e412869eab5cc2d073954b187aaef2a17de8e300dc0a43cf552e61e8b9ca250cbd397209432f249730f45ce51e69e8fd556e85a117924b18fac2250c7d113be3515e0ba12eff6f006088b5c505c6e8de0000000049454e44ae426082","version.ArbitraryMessage":0},"senderRS":"NXT-XK4R-7VJU-6EQG-7R335","subtype":0,"amountNQT":"0","recipientRS":"NXT-EVHD-5FLM-3NMQ-G46NR","block":"2852309517372377639","blockTimestamp":80517367,"deadline":1440,"timestamp":80517289,"height":762843,"senderPublicKey":"112e0c5748b5ea610a44a09b1ad0d2bddc945a6ef5edc7551b80576249ba585b","feeNQT":"290000000","confirmations":133437,"fullHash":"fe0909e3d36a6d7b8e7003272ca7ac1123edbcf369cf5d57a0fc6850ac4b3d60","version":1,"sender":"5873880488492319831","recipient":"16992224448242675179","ecBlockHeight":762834,"transaction":"8893882297406261758"}]}';
var prunedTransactionsJson = '{"transactions":[{"signature":"91297853b125cc60e37591f6eb5c6e150de83263e8f375fbef51a236219f6d0f6b0f4f10f7cb1ff463cba6b9fe2a5c747821100559bc9fe35fcdfe881cef1256","transactionIndex":0,"type":1,"phased":false,"ecBlockId":"13790759943580110225","signatureHash":"ff5f98e5c27479cb7fcaba6c7e5d540cc5e3b122bb9527dbd47a29210dcfd0ed","attachment":{"version.PrunablePlainMessage":1,"messageHash":"776b2be154d8f5d139f19d46519dc8e3df2d9ea0ce9069cae7b0e4e33eff5a4a","version.ArbitraryMessage":0},"senderRS":"NXT-XK4R-7VJU-6EQG-7R335","subtype":0,"amountNQT":"0","recipientRS":"NXT-EVHD-5FLM-3NMQ-G46NR","block":"2852309517372377639","blockTimestamp":80517367,"deadline":1440,"timestamp":80517289,"height":762843,"senderPublicKey":"112e0c5748b5ea610a44a09b1ad0d2bddc945a6ef5edc7551b80576249ba585b","feeNQT":"290000000","confirmations":133437,"fullHash":"fe0909e3d36a6d7b8e7003272ca7ac1123edbcf369cf5d57a0fc6850ac4b3d60","version":1,"sender":"5873880488492319831","recipient":"16992224448242675179","ecBlockHeight":762834,"transaction":"8893882297406261758"}]}';

var peers1 = {"peers":["176.31.118.228","52.20.125.165","52.42.15.36","192.3.196.10","178.150.207.53","109.230.199.49","178.162.198.109","174.140.168.136","107.170.3.62"]};

var peers2 = {"peers":["109.230.199.49","176.31.118.228","52.20.125.165","178.162.198.109","52.42.15.36","80.150.243.97","192.3.196.10","178.150.207.53","107.170.3.62"]};

QUnit.test("compare.transactions", function (assert) {
    var origTransactions = JSON.parse(origTransactionsJson);
    var prunedTransactions = JSON.parse(prunedTransactionsJson);
    var c1 = NRS.getComparableResponse(origTransactions);
    !assert.notEqual(c1, undefined);
    var c2 = NRS.getComparableResponse(prunedTransactions);
    !assert.notEqual(c2, undefined);
    assert.equal(c1, c2);
});

QUnit.test("peers.list.similar", function (assert) {
    assert.equal(NRS.isPeerListSimilar(peers1, peers1), true);
    assert.equal(NRS.isPeerListSimilar({}, {}), true);
    assert.equal(NRS.isPeerListSimilar(peers1, peers2), true);
    peers1.peers.splice(3);
    peers1.peers.push("garbage");
    peers1.peers.push("garbage");
    peers1.peers.push("garbage");
    assert.equal(NRS.isPeerListSimilar(peers1, peers2), false);
});
