/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import java.lang.reflect.Field;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

public class ExtendedCommands {
    private static ExtendedParameters getExtendedParameters(Object command) {
        ExtendedParameters anno = command.getClass().getAnnotation(ExtendedParameters.class);
        if (anno == null) {
            throw new IllegalStateException("All extended commands should have an ExtendedParameters annotation: " + command.getClass().getCanonicalName());
        }
        return anno;
    }

    public static String commandName(JCommander jc) {
        return ExtendedCommands.getExtendedParameters(jc.getObjects().get(0)).commandName();
    }

    public static String commandName(Object command) {
        return ExtendedCommands.getExtendedParameters(command).commandName();
    }

    public static String[] commandAliases(JCommander jc) {
        return ExtendedCommands.commandAliases(jc.getObjects().get(0));
    }

    public static String[] commandAliases(Object command) {
        return ExtendedCommands.getExtendedParameters(command).commandAliases();
    }

    public static void addExtendedCommand(JCommander jc, Command command) {
        jc.addCommand(ExtendedCommands.commandName(command), command, ExtendedCommands.commandAliases(command));
        command.setupCommand(command.getJCommander());
    }

    public static String[] parameterArgumentNames(ParameterDescription parameterDescription) {
        Parameterized parameterized = parameterDescription.getParameterized();
        Field field = null;
        for (Class<?> cls = parameterDescription.getObject().getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(parameterized.getName());
                break;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        assert (field != null);
        ExtendedParameter extendedParameter = field.getAnnotation(ExtendedParameter.class);
        if (extendedParameter != null) {
            return extendedParameter.argumentNames();
        }
        return new String[0];
    }

    public static JCommander getSubcommand(JCommander jc, String commandName) {
        if (jc.getCommands().containsKey(commandName)) {
            return jc.getCommands().get(commandName);
        }
        for (JCommander command : jc.getCommands().values()) {
            for (String alias : ExtendedCommands.commandAliases(command)) {
                if (!commandName.equals(alias)) continue;
                return command;
            }
        }
        return null;
    }

    public static String getCommandDescription(JCommander jc) {
        Parameters parameters = jc.getObjects().get(0).getClass().getAnnotation(Parameters.class);
        if (parameters == null) {
            return null;
        }
        return parameters.commandDescription();
    }
}

