/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.zip.GZIPInputStream;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Parser;

public class CSP2XML {
    private static int debug = 0;
    private String cspFileName;
    private String xmlFileName;
    private boolean prolog;
    private List<Expression> expressions;

    public CSP2XML(String string, String string2, boolean bl) {
        this.cspFileName = string;
        this.xmlFileName = string2;
        this.prolog = bl;
    }

    private void convert() {
    }

    private void load() throws IOException {
        Logger.fine("Parsing " + this.cspFileName);
        InputStream inputStream = this.cspFileName.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(this.cspFileName)) : new FileInputStream(this.cspFileName);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        Parser parser = new Parser(bufferedReader, this.prolog);
        this.expressions = parser.parse();
        Logger.info("parsed " + this.expressions.size() + " expressions");
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-v") || stringArray[n2].equals("-verbose")) {
                ++Logger.verboseLevel;
                continue;
            }
            if (stringArray[n2].equals("-prolog")) {
                bl = true;
                continue;
            }
            if (stringArray[n2].equals("-debug") && n2 + 1 < stringArray.length) {
                debug = Integer.parseInt(stringArray[n2 + 1]);
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-option") && n2 + 1 < stringArray.length) {
                ++n2;
                continue;
            }
            if (!stringArray[n2].startsWith("-")) break;
        }
        if ((n = stringArray.length - n2) != 2) {
            System.out.println("Usage : java CSP2XML [-v] cspFileName xmlFileName");
            System.exit(1);
        }
        String string = stringArray[n2];
        String string2 = stringArray[n2 + 1];
        try {
            CSP2XML cSP2XML = new CSP2XML(string, string2, bl);
            cSP2XML.load();
            cSP2XML.convert();
        }
        catch (IOException iOException) {
            System.out.println("c ERROR Exception " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

