/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import jp.kobe_u.sugar.OutputInterface;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.HoldLiteral;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearEqLiteral;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearNeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.csp.PowerLiteral;
import jp.kobe_u.sugar.csp.ProductLiteral;
import jp.kobe_u.sugar.csp.Relation;
import jp.kobe_u.sugar.csp.RelationLiteral;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class OutputSMT
implements OutputInterface {
    private CSP csp;
    private Format format;
    private Formatter formatter;
    private PrintWriter out;

    @Override
    public void setCSP(CSP cSP) {
        this.csp = cSP;
    }

    @Override
    public void setOut(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(System.out);
        }
        this.out = printWriter;
    }

    public void setFormat(Format format) {
        if (format == null) {
            format = Format.SMT;
        }
        this.format = format;
        this.formatter = new Formatter(format);
    }

    @Override
    public void setFormat(String string) throws SugarException {
        if (string != null && !string.equals("smt")) {
            throw new SugarException("Unknown output format: " + string);
        }
        this.setFormat(Format.SMT);
    }

    private void format(Expression expression) throws SugarException {
        if (expression.isAtom()) {
            this.formatter.add(expression.toString());
            return;
        }
        Sequence sequence = (Sequence)expression;
        int n = 0;
        Expression expression2 = sequence.get(0);
        if (expression2.isString() && (Expression.isOperator(expression2) || this.csp.getRelation(expression2.stringValue()) != null)) {
            this.formatter.begin(expression2.stringValue());
            ++n;
        } else {
            this.formatter.begin();
        }
        while (n < sequence.length()) {
            this.format(sequence.get(n));
            ++n;
        }
        this.formatter.end();
    }

    private void outputIntegerVariable(IntegerVariable integerVariable) throws SugarException {
        String string = integerVariable.getName();
        IntegerDomain integerDomain = integerVariable.getDomain();
        String string2 = integerVariable.getComment();
        this.formatter.reset();
        if (string2 != null) {
            this.out.println(this.formatter.comment(string2));
        }
        this.formatter.begin("declare-fun").add(string).add("()").add("Int").end();
        this.out.println(this.formatter.finish());
        this.formatter.begin("assert");
        this.formatter.begin("or");
        Iterator<int[]> iterator = integerDomain.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            this.formatter.begin("and");
            this.formatter.begin("<=").add(nArray[0]).add(string).end();
            this.formatter.begin("<=").add(string).add(nArray[1]).end();
            this.formatter.end();
        }
        this.formatter.end();
        this.formatter.end();
        this.out.println(this.formatter.finish());
    }

    private void outputBooleanVariable(BooleanVariable booleanVariable) throws SugarException {
        String string = booleanVariable.getName();
        String string2 = booleanVariable.getComment();
        this.formatter.reset();
        if (string2 != null) {
            this.out.println(this.formatter.comment(string2));
        }
        this.formatter.begin("declare-fun").add(string).add("()").add("Bool").end();
        this.out.println(this.formatter.finish());
    }

    private void outputRelationDefinition(Relation relation) throws SugarException {
        throw new SugarException("Relation is not supported");
    }

    private void formatLinearLiteral(LinearLiteral linearLiteral, String string) throws SugarException {
        LinearSum linearSum = linearLiteral.getLinearExpression();
        String string2 = null;
        if (string.equals("eq")) {
            string2 = "=";
        } else if (string.equals("ne")) {
            string2 = "distinct";
        } else if (string.equals("lt")) {
            string2 = "<";
        } else if (string.equals("le")) {
            string2 = "<=";
        } else if (string.equals("gt")) {
            string2 = ">";
        } else if (string.equals("ge")) {
            string2 = ">=";
        }
        this.formatter.begin(string2);
        if (linearSum.size() == 1) {
            for (IntegerVariable integerVariable : linearSum.getVariables()) {
                this.formatter.begin("*").add(linearSum.getA(integerVariable)).add(integerVariable.getName()).end();
            }
        } else {
            this.formatter.begin("+");
            for (IntegerVariable integerVariable : linearSum.getVariables()) {
                this.formatter.begin("*").add(linearSum.getA(integerVariable)).add(integerVariable.getName()).end();
            }
            this.formatter.end();
        }
        this.formatter.add(-linearSum.getB());
        this.formatter.end();
    }

    private void formatLiteral(Literal literal) throws SugarException {
        if (literal instanceof HoldLiteral) {
            Expression expression;
            HoldLiteral holdLiteral = (HoldLiteral)literal;
            if (holdLiteral.isNegative()) {
                this.formatter.begin("not");
            }
            if ((expression = holdLiteral.getExpression()).isSequence(Expression.ALLDIFFERENT)) {
                this.formatter.begin("distinct");
                Sequence sequence = (Sequence)((Sequence)expression).get(1);
                for (int i = 0; i < sequence.length(); ++i) {
                    if (!sequence.get(i).isAtom()) {
                        throw new SugarException("Invalid argument in alldifferent: " + sequence.get(i));
                    }
                    this.formatter.add(sequence.get(i).toString());
                }
                this.formatter.end();
            } else {
                this.format(expression);
            }
            if (holdLiteral.isNegative()) {
                this.formatter.end();
            }
        } else if (literal instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)literal;
            if (booleanLiteral.getNegative()) {
                this.formatter.begin("not");
            }
            this.formatter.add(booleanLiteral.getBooleanVariable().getName());
            if (booleanLiteral.getNegative()) {
                this.formatter.end();
            }
        } else if (literal instanceof LinearEqLiteral) {
            this.formatLinearLiteral((LinearLiteral)literal, "eq");
        } else if (literal instanceof LinearNeLiteral) {
            this.formatLinearLiteral((LinearLiteral)literal, "ne");
        } else if (literal instanceof LinearGeLiteral) {
            this.formatLinearLiteral((LinearLiteral)literal, "ge");
        } else if (literal instanceof LinearLeLiteral) {
            this.formatLinearLiteral((LinearLiteral)literal, "le");
        } else if (literal instanceof RelationLiteral) {
            RelationLiteral relationLiteral = (RelationLiteral)literal;
            if (relationLiteral.negative) {
                this.formatter.begin("not");
            }
            this.formatter.begin(relationLiteral.name);
            for (IntegerVariable integerVariable : relationLiteral.vs) {
                this.formatter.add(integerVariable.getName());
            }
            this.formatter.end();
            if (relationLiteral.negative) {
                this.formatter.end();
            }
        } else {
            if (literal instanceof ProductLiteral) {
                throw new SugarException("Unsupported literal: " + literal);
            }
            if (literal instanceof PowerLiteral) {
                throw new SugarException("Unsupported literal: " + literal);
            }
            throw new SugarException("Unknown literal: " + literal);
        }
    }

    private void outputClause(Clause clause) throws SugarException {
        List<Literal> list = clause.getLiterals();
        String string = clause.getComment();
        this.formatter.reset();
        if (string != null) {
            this.out.println(this.formatter.comment(string));
        }
        this.formatter.begin("assert");
        if (list.size() == 1) {
            this.formatLiteral(list.get(0));
        } else {
            this.formatter.begin("or");
            for (Literal literal : list) {
                this.formatLiteral(literal);
            }
            this.formatter.end();
        }
        this.formatter.end();
        this.out.println(this.formatter.finish());
    }

    private void outputObjective(CSP.Objective objective, List<IntegerVariable> list) throws SugarException {
        this.formatter.reset();
        this.formatter.begin("objective");
        if (objective == CSP.Objective.MINIMIZE) {
            this.formatter.add("minimize");
        } else if (objective == CSP.Objective.MAXIMIZE) {
            this.formatter.add("maximize");
        } else {
            throw new SugarException("Unknown objective: " + (Object)((Object)objective));
        }
        for (IntegerVariable integerVariable : list) {
            this.formatter.add(integerVariable.getName());
        }
        this.formatter.end();
        this.out.println(this.formatter.finish());
    }

    public void outputBody() throws SugarException {
        this.formatter.reset();
        this.out.println(this.formatter.comment("File generated by sugar.Output"));
        this.formatter.begin("set-option").add(":produce-models").add("true").end();
        this.out.println(this.formatter.finish());
        this.formatter.begin("set-logic").add("QF_LIA").end();
        this.out.println(this.formatter.finish());
        if (this.csp.isUnsatisfiable()) {
            this.formatter.add("false");
            this.out.println(this.formatter.finish());
            return;
        }
        for (IntegerVariable iterator : this.csp.getIntegerVariables()) {
            this.outputIntegerVariable(iterator);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            this.outputBooleanVariable(booleanVariable);
        }
        for (Relation relation : this.csp.getRelations()) {
            this.outputRelationDefinition(relation);
        }
        List<IntegerVariable> list = this.csp.getObjectiveVariables();
        if (list != null) {
            throw new SugarException("Optimization is not supported");
        }
        for (Clause clause : this.csp.getClauses()) {
            this.outputClause(clause);
        }
    }

    public void outputPost() throws SugarException {
        this.formatter.begin("check-sat").end();
        this.out.println(this.formatter.finish());
        this.formatter.begin("get-value").begin();
        for (IntegerVariable comparable : this.csp.getIntegerVariables()) {
            if (comparable.isAux()) continue;
            this.formatter.add(comparable.getName());
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (booleanVariable.isAux()) continue;
            this.formatter.add(booleanVariable.getName());
        }
        this.formatter.end().end();
        this.out.println(this.formatter.finish());
        this.formatter.begin("exit").end();
        this.out.println(this.formatter.finish());
    }

    @Override
    public void output() throws SugarException {
        this.outputBody();
        this.outputPost();
    }

    class Formatter {
        private StringBuilder sb = new StringBuilder();
        private boolean escape;
        private String quote;
        private String comment;
        private String prefix;
        private String lparen;
        private String rparen;
        private String delimiter;
        private String period;
        private int depth = 0;
        private boolean first = true;

        Formatter(Format format) {
            switch (format) {
                case CSP: 
                case SMT: {
                    this.prefix = null;
                    this.escape = false;
                    this.quote = "";
                    this.comment = "; ";
                    this.lparen = "(";
                    this.rparen = ")";
                    this.delimiter = " ";
                    this.period = "";
                    break;
                }
                case Prolog: {
                    this.prefix = null;
                    this.escape = true;
                    this.quote = "'";
                    this.comment = "% ";
                    this.lparen = "[";
                    this.rparen = "]";
                    this.delimiter = ",";
                    this.period = ".";
                    break;
                }
                case ASP: {
                    this.prefix = "list";
                    this.escape = true;
                    this.quote = "'";
                    this.comment = "% ";
                    this.lparen = "(";
                    this.rparen = ")";
                    this.delimiter = ",";
                    this.period = ".";
                }
            }
        }

        String escape(String string) throws SugarException {
            if (this.escape) {
                if (string.contains(this.quote)) {
                    throw new SugarException("String contains quotation mark: " + string);
                }
                if (!string.matches("(-?\\d+|[a-z]\\w*)")) {
                    string = this.quote + string + this.quote;
                }
            }
            return string;
        }

        Formatter reset() {
            this.sb = new StringBuilder();
            this.depth = 0;
            this.first = true;
            return this;
        }

        Formatter comment(String string) {
            this.sb.append(this.comment);
            this.sb.append(string);
            return this;
        }

        Formatter begin(String string) throws SugarException {
            if (!this.first) {
                this.sb.append(this.delimiter);
            }
            this.first = true;
            if (this.prefix == null) {
                this.sb.append(this.lparen);
                if (string != null) {
                    this.sb.append(this.escape(string));
                    this.first = false;
                }
            } else {
                if (string == null) {
                    this.sb.append(this.prefix);
                } else {
                    this.sb.append(this.escape(string));
                }
                this.sb.append(this.lparen);
            }
            ++this.depth;
            return this;
        }

        Formatter begin() throws SugarException {
            return this.begin(null);
        }

        Formatter addStr(String string) {
            if (!this.first) {
                this.sb.append(this.delimiter);
            }
            this.sb.append(string);
            this.first = false;
            return this;
        }

        Formatter add(String string) throws SugarException {
            return this.addStr(this.escape(string));
        }

        Formatter add(int n) throws SugarException {
            if (n < 0) {
                this.begin();
                this.addStr("-");
                this.addStr(Integer.toString(-n));
                this.end();
            } else {
                this.addStr(Integer.toString(n));
            }
            return this;
        }

        Formatter end() throws SugarException {
            this.sb.append(this.rparen);
            --this.depth;
            if (this.depth < 0) {
                throw new SugarException("Too many end()");
            }
            this.first = false;
            return this;
        }

        String finish() throws SugarException {
            if (this.depth != 0) {
                throw new SugarException("Too short end()");
            }
            this.sb.append(this.period);
            return this.toString();
        }

        public String toString() {
            String string = this.sb.toString();
            this.reset();
            return string;
        }
    }

    public static enum Format {
        CSP,
        ASP,
        Prolog,
        SMT;

    }
}

