/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.Output;
import jp.kobe_u.sugar.OutputInterface;
import jp.kobe_u.sugar.OutputSMT;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.converter.Simplifier;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerDomainDiet;
import jp.kobe_u.sugar.csp.IntegerDomainIntevals;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.encoder.Encoder;
import jp.kobe_u.sugar.encoder.Encoding;
import jp.kobe_u.sugar.encoder.Problem;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Parser;
import jp.kobe_u.sugar.expression.Sequence;
import jp.kobe_u.sugar.hook.ConverterHook;
import jp.kobe_u.sugar.hybrid.HybridConverter;
import jp.kobe_u.sugar.hybrid.HybridEncoder;
import jp.kobe_u.sugar.pb.PBEncoder;
import jp.kobe_u.sugar.pb.PBFileProblem;

public class SugarMain {
    CSP csp = null;
    static boolean prolog = false;
    static boolean maxCSP = false;
    static boolean weightedCSP = false;
    static boolean competition = false;
    static boolean incremental = false;
    static boolean propagation = true;
    static boolean simplify_clauses = true;
    static boolean pb = false;
    static PBEncoder.Encoding pbEncoding = null;
    static boolean hybrid = false;
    public static int debug = 0;

    private List<Expression> toMaxCSP(List<Expression> list) throws SugarException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        arrayList2.add(Expression.ADD);
        int n = 0;
        for (Expression expression : list) {
            if (expression.isSequence(Expression.DOMAIN_DEFINITION) || expression.isSequence(Expression.INT_DEFINITION) || expression.isSequence(Expression.BOOL_DEFINITION) || expression.isSequence(Expression.PREDICATE_DEFINITION) || expression.isSequence(Expression.RELATION_DEFINITION)) {
                arrayList.add(expression);
                continue;
            }
            if (expression.isSequence(Expression.OBJECTIVE_DEFINITION)) {
                throw new SugarException("Illegal " + expression);
            }
            Expression expression2 = Expression.create("_C" + n);
            arrayList.add(Expression.create(Expression.INT_DEFINITION, expression2, Expression.ZERO, Expression.ONE));
            expression = expression2.ge(Expression.ONE).or(expression);
            arrayList.add(expression);
            arrayList2.add(expression2);
            ++n;
        }
        Expression expression = Expression.create("_COST");
        arrayList.add(Expression.create(Expression.INT_DEFINITION, expression, Expression.ZERO, Expression.create(n)));
        arrayList.add(expression.ge(Expression.create(arrayList2)));
        arrayList.add(Expression.create(Expression.OBJECTIVE_DEFINITION, Expression.MINIMIZE, expression));
        Logger.info("MAX CSP: " + n + " constraints");
        return arrayList;
    }

    private List<Expression> toWeightedCSP(List<Expression> list) throws SugarException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        arrayList2.add(Expression.ADD);
        int n = 0;
        int n2 = 0;
        for (Expression expression : list) {
            if (expression.isSequence(Expression.OBJECTIVE_DEFINITION)) {
                throw new SugarException("Illegal " + expression);
            }
            if (expression.isSequence(Expression.WEIGHTED)) {
                Sequence sequence = (Sequence)expression;
                if (!sequence.matches("WI.")) {
                    throw new SugarException("Bad definition " + sequence);
                }
                int n3 = sequence.get(1).integerValue();
                expression = sequence.get(2);
                Expression expression2 = Expression.create("_C" + n);
                arrayList.add(Expression.create(Expression.INT_DEFINITION, expression2, Expression.ZERO, Expression.ONE));
                expression = expression2.ge(Expression.ONE).or(expression);
                arrayList.add(expression);
                arrayList2.add(expression2.mul(n3));
                n2 += n3;
                ++n;
                continue;
            }
            arrayList.add(expression);
        }
        Expression expression = Expression.create("_COST");
        arrayList.add(Expression.create(Expression.INT_DEFINITION, expression, Expression.ZERO, Expression.create(n2)));
        arrayList.add(expression.ge(Expression.create(arrayList2)));
        arrayList.add(Expression.create(Expression.OBJECTIVE_DEFINITION, Expression.MINIMIZE, expression));
        Logger.info("Weighted CSP: " + n + " constraints");
        return arrayList;
    }

    private List<Expression> toGCNF(List<Expression> list) throws SugarException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        int n2 = 0;
        for (Expression expression : list) {
            if (expression.isSequence(Expression.DOMAIN_DEFINITION) || expression.isSequence(Expression.INT_DEFINITION) || expression.isSequence(Expression.BOOL_DEFINITION) || expression.isSequence(Expression.PREDICATE_DEFINITION) || expression.isSequence(Expression.RELATION_DEFINITION)) {
                arrayList.add(expression);
                continue;
            }
            if (expression.isSequence(Expression.OBJECTIVE_DEFINITION)) {
                throw new SugarException("Illegal " + expression);
            }
            expression = Expression.create(Expression.LABEL, Expression.create(++n2)).or(expression);
            arrayList.add(expression);
            ++n;
        }
        int n3 = n2;
        arrayList.add(Expression.create(Expression.GROUPS_DEFINITION, Expression.create(n2), Expression.create(n3)));
        Logger.info("Group CSP: " + n + " constraints");
        return arrayList;
    }

    public List<Expression> parse(String string) throws SugarException, IOException {
        Logger.fine("Parsing " + string);
        InputStream inputStream = string.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(string)) : new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        Parser parser = new Parser(bufferedReader, prolog);
        List<Expression> list = parser.parse();
        bufferedReader.close();
        bufferedReader = null;
        inputStream.close();
        inputStream = null;
        parser = null;
        Runtime.getRuntime().gc();
        Logger.info("parsed " + list.size() + " expressions");
        if (debug > 0) {
            for (Expression expression : list) {
                System.out.println("c " + expression);
            }
        }
        Logger.status();
        if (Problem.GCNF || Problem.GWCNF) {
            list = this.toGCNF(list);
        } else if (maxCSP) {
            list = this.toMaxCSP(list);
        } else if (weightedCSP) {
            list = this.toWeightedCSP(list);
        }
        return list;
    }

    public void translate(String string) throws SugarException, IOException {
        List<Expression> list = this.parse(string);
        Logger.fine("Converting to clausal form CSP");
        this.csp = new CSP();
        Converter converter = new Converter(this.csp);
        Converter.INCREMENTAL_PROPAGATION = propagation;
        converter.convert(list);
        converter = null;
        list = null;
        Expression.clear();
        Runtime.getRuntime().gc();
        Logger.fine("CSP : " + this.csp.summary());
        Logger.status();
        if (propagation) {
            Logger.fine("Propagation in CSP");
            this.csp.propagate();
            Logger.fine("CSP : " + this.csp.summary());
            if (debug > 0) {
                this.csp.output(System.out, "c ");
            }
            Logger.status();
        }
        if (this.csp.isUnsatisfiable()) {
            Logger.info("CSP is unsatisfiable after propagation");
            Logger.println("s UNSATISFIABLE");
            return;
        }
        if (simplify_clauses) {
            Logger.fine("Simplifing CSP clauses by introducing new Boolean variables");
            Simplifier simplifier = new Simplifier(this.csp);
            simplifier.simplify();
            Logger.info("CSP : " + this.csp.summary());
            if (debug > 0) {
                this.csp.output(System.out, "c ");
            }
            Logger.status();
        }
        Runtime.getRuntime().gc();
    }

    public void encode(String string, String string2, String string3) throws SugarException, IOException {
        this.translate(string);
        if (this.csp.isUnsatisfiable()) {
            return;
        }
        Logger.fine("Encoding CSP to SAT : " + string2);
        Encoder encoder = new Encoder(this.csp);
        encoder.encode(string2);
        Logger.fine("Writing map file : " + string3);
        encoder.outputMap(string3);
        Logger.status();
        Logger.info("SAT : " + encoder.summary());
    }

    /*
     * WARNING - void declaration
     */
    public void decode(String string, String string2) throws SugarException, IOException {
        Object object;
        Object object2;
        Object object3;
        Logger.fine("Decoding " + string);
        CSP cSP = new CSP();
        ArrayList<Object> arrayList = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
        while ((object3 = bufferedReader.readLine()) != null) {
            int n;
            object2 = ((String)object3).split("\\s+");
            if (object2[0].equals("objective")) {
                void object5;
                if (object2[1].equals("minimize")) {
                    cSP.setObjective(CSP.Objective.MINIMIZE);
                } else if (((String)object2[1]).equals("maximize")) {
                    cSP.setObjective(CSP.Objective.MAXIMIZE);
                }
                arrayList = new ArrayList<Object>();
                int i = 2;
                while (object5 < ((Object)object2).length) {
                    arrayList.add(object2[object5]);
                    ++object5;
                }
                continue;
            }
            if (object2[0].equals("int")) {
                Object n4;
                int n2;
                int n3;
                Object object6 = object2[1];
                n = Integer.parseInt((String)object2[2]);
                object = null;
                if (((Object)object2).length == 4) {
                    int n5;
                    n3 = ((String)object2[3]).indexOf("..");
                    if (n3 < 0) {
                        n5 = n2 = Integer.parseInt((String)object2[3]);
                    } else {
                        n5 = Integer.parseInt(((String)object2[3]).substring(0, n3));
                        n2 = Integer.parseInt(((String)object2[3]).substring(n3 + 2));
                    }
                    object = IntegerDomain.create(n5, n2);
                } else {
                    n4 = new TreeSet<Integer>();
                    for (n2 = 3; n2 < ((Object)object2).length; ++n2) {
                        int n6;
                        int n7 = ((String)object2[n2]).indexOf("..");
                        if (n7 < 0) {
                            n3 = n6 = Integer.parseInt((String)object2[n2]);
                        } else {
                            n3 = Integer.parseInt(((String)object2[n2]).substring(0, n7));
                            n6 = Integer.parseInt(((String)object2[n2]).substring(n7 + 2));
                        }
                        for (int i = n3; i <= n6; ++i) {
                            n4.add(i);
                        }
                    }
                    object = IntegerDomain.create(n4);
                }
                n4 = new IntegerVariable((String)object6, (IntegerDomain)object);
                ((IntegerVariable)n4).setCode(n);
                cSP.add((IntegerVariable)n4);
                continue;
            }
            if (!((String)object2[0]).equals("bool")) continue;
            Object string3 = object2[1];
            n = Integer.parseInt((String)object2[2]);
            object = new BooleanVariable((String)string3);
            ((BooleanVariable)object).setCode(n);
            cSP.add((BooleanVariable)object);
        }
        bufferedReader.close();
        if (arrayList != null) {
            object3 = new ArrayList();
            for (String string3 : arrayList) {
                IntegerVariable integerVariable = cSP.getIntegerVariable(string3);
                if (integerVariable == null) {
                    throw new SugarException("Unknown objective variable " + string3);
                }
                object3.add(integerVariable);
            }
            cSP.setObjectiveVariables((List<IntegerVariable>)object3);
        }
        if (((Encoder)(object3 = new Encoder(cSP))).decode(string)) {
            if (cSP.getObjectiveVariables() == null) {
                Logger.println("s SATISFIABLE");
            } else {
                object2 = "o";
                for (IntegerVariable integerVariable : cSP.getObjectiveVariables()) {
                    object = integerVariable.getName();
                    int n = integerVariable.getValue();
                    Logger.println("c OBJECTIVE " + (String)object + " " + n);
                    object2 = (String)object2 + " " + n;
                }
                Logger.println((String)object2);
            }
            if (competition) {
                Logger.print("v");
                for (IntegerVariable integerVariable : cSP.getIntegerVariables()) {
                    if (integerVariable.isAux() || integerVariable.getName().startsWith("_")) continue;
                    Logger.print(" " + integerVariable.getValue());
                }
                Logger.println("");
            } else {
                for (IntegerVariable booleanVariable : cSP.getIntegerVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                for (BooleanVariable booleanVariable : cSP.getBooleanVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                Logger.println("a");
            }
        } else {
            Logger.println("s UNSATISFIABLE");
        }
    }

    public void encodeHybrid(String string, String string2, String string3) throws SugarException, IOException {
        this.translate(string);
        if (this.csp.isUnsatisfiable()) {
            return;
        }
        Logger.fine("Hybrid Encoding CSP to PB : " + string2);
        HybridConverter hybridConverter = new HybridConverter(this.csp);
        hybridConverter.convert();
        PBFileProblem pBFileProblem = new PBFileProblem(string2);
        HybridEncoder hybridEncoder = new HybridEncoder(this.csp, pBFileProblem);
        hybridEncoder.encode();
        Logger.fine("Writing map file : " + string3);
        hybridEncoder.outputMap(string3);
        Logger.status();
        Logger.info("PB : " + pBFileProblem.summary());
    }

    /*
     * WARNING - void declaration
     */
    public void decodeHybrid(String string, String string2) throws SugarException, IOException {
        Object object;
        Object object2;
        Object object3;
        Logger.fine("Decoding " + string);
        CSP cSP = new CSP();
        ArrayList<Object> arrayList = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
        while ((object3 = bufferedReader.readLine()) != null) {
            object2 = ((String)object3).split("\\s+");
            if (object2[0].equals("objective")) {
                void object5;
                if (object2[1].equals("minimize")) {
                    cSP.setObjective(CSP.Objective.MINIMIZE);
                } else if (((String)object2[1]).equals("maximize")) {
                    cSP.setObjective(CSP.Objective.MAXIMIZE);
                }
                arrayList = new ArrayList<Object>();
                int i = 2;
                while (object5 < ((Object)object2).length) {
                    arrayList.add(object2[object5]);
                    ++object5;
                }
                continue;
            }
            if (object2[0].equals("int")) {
                Object n4;
                int n;
                int n2;
                Object object6 = object2[1];
                int n3 = Integer.parseInt((String)object2[2]);
                object = null;
                if (((Object)object2).length == 4) {
                    n2 = ((String)object2[3]).indexOf("..");
                    if (n2 < 0) {
                        n = n = Integer.parseInt((String)object2[3]);
                    } else {
                        n = Integer.parseInt(((String)object2[3]).substring(0, n2));
                        n = Integer.parseInt(((String)object2[3]).substring(n2 + 2));
                    }
                    object = IntegerDomain.create(n, n);
                } else {
                    n4 = new TreeSet<Integer>();
                    for (n = 3; n < ((Object)object2).length; ++n) {
                        int n5;
                        int n6 = ((String)object2[n]).indexOf("..");
                        if (n6 < 0) {
                            n2 = n5 = Integer.parseInt((String)object2[n]);
                        } else {
                            n2 = Integer.parseInt(((String)object2[n]).substring(0, n6));
                            n5 = Integer.parseInt(((String)object2[n]).substring(n6 + 2));
                        }
                        for (int i = n2; i <= n5; ++i) {
                            n4.add(i);
                        }
                    }
                    object = IntegerDomain.create(n4);
                }
                n4 = new IntegerVariable((String)object6, (IntegerDomain)object);
                ((IntegerVariable)n4).setCode(n3);
                cSP.add((IntegerVariable)n4);
                continue;
            }
            if (((String)object2[0]).equals("bool")) {
                Object object7 = object2[1];
                int object8 = Integer.parseInt((String)object2[2]);
                object = new BooleanVariable((String)object7);
                ((BooleanVariable)object).setCode(object8);
                cSP.add((BooleanVariable)object);
                continue;
            }
            if (!((String)object2[0]).equals("encoding")) continue;
            Object string3 = object2[1];
            Object integerVariable = object2[2];
            if (((String)integerVariable).equals("order")) {
                cSP.getIntegerVariable((String)string3).setEncoding(Encoding.ORDER);
                continue;
            }
            if (((String)integerVariable).equals("log")) {
                cSP.getIntegerVariable((String)string3).setEncoding(Encoding.LOG);
                continue;
            }
            throw new SugarException("Unknown encoding " + (String)integerVariable);
        }
        bufferedReader.close();
        if (arrayList != null) {
            object3 = new ArrayList();
            for (String string3 : arrayList) {
                IntegerVariable integerVariable = cSP.getIntegerVariable(string3);
                if (integerVariable == null) {
                    throw new SugarException("Unknown objective variable " + string3);
                }
                object3.add(integerVariable);
            }
            cSP.setObjectiveVariables((List<IntegerVariable>)object3);
        }
        if (((HybridEncoder)(object3 = new HybridEncoder(cSP, null))).decode(string)) {
            if (cSP.getObjectiveVariables() == null) {
                Logger.println("s SATISFIABLE");
            } else {
                object2 = "o";
                for (IntegerVariable integerVariable : cSP.getObjectiveVariables()) {
                    object = integerVariable.getName();
                    int n = integerVariable.getValue();
                    Logger.println("c OBJECTIVE " + (String)object + " " + n);
                    object2 = (String)object2 + " " + n;
                }
                Logger.println((String)object2);
            }
            if (competition) {
                Logger.print("v");
                for (IntegerVariable integerVariable : cSP.getIntegerVariables()) {
                    if (integerVariable.isAux() || integerVariable.getName().startsWith("_")) continue;
                    Logger.print(" " + integerVariable.getValue());
                }
                Logger.println("");
            } else {
                for (IntegerVariable booleanVariable : cSP.getIntegerVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                for (BooleanVariable booleanVariable : cSP.getBooleanVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                Logger.println("a");
            }
        } else {
            Logger.println("s UNSATISFIABLE");
        }
    }

    public void encodePB(String string, String string2, String string3) throws SugarException, IOException {
        this.translate(string);
        if (this.csp.isUnsatisfiable()) {
            return;
        }
        Logger.fine("Encoding CSP to PB : " + string2);
        PBFileProblem pBFileProblem = new PBFileProblem(string2);
        PBEncoder pBEncoder = new PBEncoder(this.csp, pBFileProblem, pbEncoding);
        pBEncoder.encode();
        Logger.fine("Writing map file : " + string3);
        pBEncoder.outputMap(string3);
        Logger.status();
        Logger.info("PB : " + pBFileProblem.summary());
    }

    /*
     * WARNING - void declaration
     */
    public void decodePB(String string, String string2) throws SugarException, IOException {
        Object object;
        Object object2;
        Object object3;
        Logger.fine("Decoding " + string);
        CSP cSP = new CSP();
        ArrayList<Object> arrayList = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
        while ((object3 = bufferedReader.readLine()) != null) {
            int n;
            object2 = ((String)object3).split("\\s+");
            if (object2[0].equals("objective")) {
                void object5;
                if (object2[1].equals("minimize")) {
                    cSP.setObjective(CSP.Objective.MINIMIZE);
                } else if (((String)object2[1]).equals("maximize")) {
                    cSP.setObjective(CSP.Objective.MAXIMIZE);
                }
                arrayList = new ArrayList<Object>();
                int i = 2;
                while (object5 < ((Object)object2).length) {
                    arrayList.add(object2[object5]);
                    ++object5;
                }
                continue;
            }
            if (object2[0].equals("int")) {
                Object n4;
                int n2;
                int n3;
                Object object6 = object2[1];
                n = Integer.parseInt((String)object2[2]);
                object = null;
                if (((Object)object2).length == 4) {
                    int n5;
                    n3 = ((String)object2[3]).indexOf("..");
                    if (n3 < 0) {
                        n5 = n2 = Integer.parseInt((String)object2[3]);
                    } else {
                        n5 = Integer.parseInt(((String)object2[3]).substring(0, n3));
                        n2 = Integer.parseInt(((String)object2[3]).substring(n3 + 2));
                    }
                    object = IntegerDomain.create(n5, n2);
                } else {
                    n4 = new TreeSet<Integer>();
                    for (n2 = 3; n2 < ((Object)object2).length; ++n2) {
                        int n6;
                        int n7 = ((String)object2[n2]).indexOf("..");
                        if (n7 < 0) {
                            n3 = n6 = Integer.parseInt((String)object2[n2]);
                        } else {
                            n3 = Integer.parseInt(((String)object2[n2]).substring(0, n7));
                            n6 = Integer.parseInt(((String)object2[n2]).substring(n7 + 2));
                        }
                        for (int i = n3; i <= n6; ++i) {
                            n4.add(i);
                        }
                    }
                    object = IntegerDomain.create(n4);
                }
                n4 = new IntegerVariable((String)object6, (IntegerDomain)object);
                ((IntegerVariable)n4).setCode(n);
                cSP.add((IntegerVariable)n4);
                continue;
            }
            if (!((String)object2[0]).equals("bool")) continue;
            Object string3 = object2[1];
            n = Integer.parseInt((String)object2[2]);
            object = new BooleanVariable((String)string3);
            ((BooleanVariable)object).setCode(n);
            cSP.add((BooleanVariable)object);
        }
        bufferedReader.close();
        if (arrayList != null) {
            object3 = new ArrayList();
            for (String string3 : arrayList) {
                IntegerVariable integerVariable = cSP.getIntegerVariable(string3);
                if (integerVariable == null) {
                    throw new SugarException("Unknown objective variable " + string3);
                }
                object3.add(integerVariable);
            }
            cSP.setObjectiveVariables((List<IntegerVariable>)object3);
        }
        if (((PBEncoder)(object3 = new PBEncoder(cSP, null, pbEncoding))).decode(string)) {
            if (cSP.getObjectiveVariables() == null) {
                Logger.println("s SATISFIABLE");
            } else {
                object2 = "o";
                for (IntegerVariable integerVariable : cSP.getObjectiveVariables()) {
                    object = integerVariable.getName();
                    int n = integerVariable.getValue();
                    Logger.println("c OBJECTIVE " + (String)object + " " + n);
                    object2 = (String)object2 + " " + n;
                }
                Logger.println((String)object2);
            }
            if (competition) {
                Logger.print("v");
                for (IntegerVariable integerVariable : cSP.getIntegerVariables()) {
                    if (integerVariable.isAux() || integerVariable.getName().startsWith("_")) continue;
                    Logger.print(" " + integerVariable.getValue());
                }
                Logger.println("");
            } else {
                for (IntegerVariable booleanVariable : cSP.getIntegerVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                for (BooleanVariable booleanVariable : cSP.getBooleanVariables()) {
                    if (booleanVariable.isAux() || booleanVariable.getName().startsWith("_")) continue;
                    Logger.println("a " + booleanVariable.getName() + "\t" + booleanVariable.getValue());
                }
                Logger.println("a");
            }
        } else {
            Logger.println("s UNSATISFIABLE");
        }
    }

    public void outputCSP(String string, String string2, String string3, String string4) throws SugarException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        OutputInterface outputInterface;
        Logger.info("Translate CSP to " + string3);
        this.translate(string);
        PrintWriter printWriter = null;
        if (string2 != null) {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
        }
        if (string4 == null) {
            outputInterface = string3.equals("smt") ? new OutputSMT() : new Output();
        } else {
            Class<?> clazz = Class.forName(string4);
            outputInterface = (OutputInterface)clazz.newInstance();
        }
        outputInterface.setCSP(this.csp);
        outputInterface.setOut(printWriter);
        outputInterface.setFormat(string3);
        outputInterface.output();
        printWriter.close();
        Logger.status();
    }

    private static boolean setOption(String string) {
        String[] stringArray = string.split("=", 2);
        if (string.matches("(no_)?peep(hole)?")) {
            Converter.OPT_PEEPHOLE = !string.startsWith("no_");
        } else if (string.matches("(no_)?linear(ize)?")) {
            Converter.LINEARIZE = !string.startsWith("no_");
        } else if (string.matches("(no_)?norm(alize_linearsum)?")) {
            Converter.NORMALIZE_LINEARSUM = !string.startsWith("no_");
        } else if (string.matches("(no_)?prop(agation)?")) {
            propagation = !string.startsWith("no_");
        } else if (string.matches("(no_)?simp(lify(_clauses)?)?")) {
            simplify_clauses = !string.startsWith("no_");
        } else if (string.matches("(no_)?reduce(_arity)?") || string.matches("(no_)?new_variable")) {
            Converter.REDUCE_ARITY = !string.startsWith("no_");
        } else if (string.matches("arity=(\\d+)")) {
            Converter.MAX_ARITY = Integer.parseInt(stringArray[1]);
        } else if (string.matches("(no_)?decomp(ose)?")) {
            Converter.setDecomposeAll(!string.startsWith("no_"));
        } else if (string.matches("(no_)?decomp(ose)?_rel(ation)?")) {
            Converter.DECOMPOSE_RELATION = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_alldiff(erent)?")) {
            Converter.DECOMPOSE_ALLDIFFERENT = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_(weightedsum|wsum)")) {
            Converter.DECOMPOSE_WEIGHTEDSUM = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_cumul(ative)?")) {
            Converter.DECOMPOSE_CUMULATIVE = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_elem(ent)?")) {
            Converter.DECOMPOSE_ELEMENT = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_disj(unctive)?")) {
            Converter.DECOMPOSE_DISJUNCTIVE = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_lex_less")) {
            Converter.DECOMPOSE_LEX_LESS = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_lex_lesseq")) {
            Converter.DECOMPOSE_LEX_LESSEQ = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_nvalue")) {
            Converter.DECOMPOSE_NVALUE = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_count")) {
            Converter.DECOMPOSE_COUNT = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_(global_cardinality|gc)")) {
            Converter.DECOMPOSE_GLOBAL_CARDINALITY = !string.startsWith("no_");
        } else if (string.matches("(no_)?decomp(ose)?_(global_cardinality_with_costs|gcc)")) {
            Converter.DECOMPOSE_GLOBAL_CARDINALITY_WITH_COSTS = !string.startsWith("no_");
        } else if (string.matches("(no_)?hints")) {
            Converter.HINT_ALLDIFF_PIGEON = !string.startsWith("no_");
        } else if (string.matches("(no_)?hint_alldiff_pigeon") || string.matches("(no_)?pigeon")) {
            Converter.HINT_ALLDIFF_PIGEON = !string.startsWith("no_");
        } else if (string.matches("(no_)?replace(_arguments|_args)?")) {
            Converter.REPLACE_ARGUMENTS = !string.startsWith("no_");
        } else if (string.matches("equiv=(\\d+)")) {
            Converter.MAX_EQUIVMAP_SIZE = Integer.parseInt(stringArray[1]);
        } else if (string.matches("linearsum=(\\d+)")) {
            Converter.MAX_LINEARSUM_SIZE = Long.parseLong(stringArray[1]);
        } else if (string.matches("split=(\\d+)")) {
            Converter.SPLITS = Integer.parseInt(stringArray[1]);
        } else if (string.matches("(no_)?use_eq")) {
            Converter.USE_EQ = !string.startsWith("no_");
        } else if (string.matches("(no_)?equiv(_translation)?")) {
            Converter.EQUIV_TRANSLATION = !string.startsWith("no_");
        } else if (string.matches("(no_)?hold")) {
            Converter.HOLD_CONSTRAINTS = !string.startsWith("no_");
        } else if (string.matches("(no_)?diet")) {
            IntegerDomain.USE_DIET_DOMAIN = !string.startsWith("no_");
        } else if (string.matches("domain=(\\d+)")) {
            int n;
            IntegerDomainIntevals.MAX_SET_SIZE = n = Integer.parseInt(stringArray[1]);
            IntegerDomainDiet.MAX_SET_SIZE = n;
        } else if (string.startsWith("pb_")) {
            pb = true;
            if (string.equals("pb_b")) {
                pbEncoding = PBEncoder.Encoding.COMPACT_ORDER_ENCODING;
                PBEncoder.BASE = 2;
            } else if (string.equals("pb_d")) {
                pbEncoding = PBEncoder.Encoding.DIRECT_ENCODING;
            } else if (string.equals("pb_o")) {
                pbEncoding = PBEncoder.Encoding.ORDER_ENCODING;
                PBEncoder.ENCODING_OPTION = 1;
            } else if (string.matches("pb_o=\\d+")) {
                pbEncoding = PBEncoder.Encoding.ORDER_ENCODING;
                PBEncoder.ENCODING_OPTION = Integer.parseInt(stringArray[1]);
            } else if (string.matches("pb_c=\\d+")) {
                pbEncoding = PBEncoder.Encoding.COMPACT_ORDER_ENCODING;
                PBEncoder.BASE = Integer.parseInt(stringArray[1]);
            } else if (string.matches("pb_m=\\d+")) {
                pbEncoding = PBEncoder.Encoding.MIXED_ENCODING;
                PBEncoder.MIXED_BASE = Integer.parseInt(stringArray[1]);
            }
        } else if (string.startsWith("hy")) {
            hybrid = true;
            HybridConverter.HYBRID_OPTION = Integer.parseInt(stringArray[0].substring(2));
            if (stringArray.length > 1) {
                HybridConverter.HYBRID_PARAM = Integer.parseInt(stringArray[1]);
            }
        } else if (string.matches("(no_)?pmin")) {
            HybridConverter.USE_PMINIMAL = !string.startsWith("no_");
        } else if (string.matches("(no_)?gcnf")) {
            Problem.GCNF = !string.startsWith("no_");
        } else if (string.matches("(no_)?gwcnf")) {
            Problem.GWCNF = !string.startsWith("no_");
        } else if (string.matches("simp_cache=(\\d+)")) {
            int n = Integer.parseInt(stringArray[1]);
            if (n <= 0) {
                Simplifier.USE_SIMPLIFYCACHE = false;
            } else {
                Simplifier.USE_SIMPLIFYCACHE = true;
                Simplifier.MAX_SIMPLIFYCACHE_SIZE = n;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void setDefaultOptions() {
        Converter.OPT_PEEPHOLE = true;
        Converter.LINEARIZE = true;
        Converter.NORMALIZE_LINEARSUM = true;
        propagation = true;
        simplify_clauses = true;
        Converter.REDUCE_ARITY = true;
        Converter.setDecomposeAll(true);
        Converter.DECOMPOSE_RELATION = false;
        Converter.HINT_ALLDIFF_PIGEON = true;
        Converter.REPLACE_ARGUMENTS = false;
        Converter.USE_EQ = false;
        Converter.EQUIV_TRANSLATION = false;
        Converter.HOLD_CONSTRAINTS = false;
        IntegerDomain.USE_DIET_DOMAIN = false;
        Problem.GCNF = false;
        Problem.GWCNF = false;
        Simplifier.USE_SIMPLIFYCACHE = true;
        Simplifier.MAX_SIMPLIFYCACHE_SIZE = 1000;
        PBEncoder.BASE = 0;
        PBEncoder.ENCODING_OPTION = 1;
        HybridConverter.HYBRID_OPTION = 0;
        HybridConverter.USE_PMINIMAL = false;
    }

    public static void init() {
        SugarMain.setDefaultOptions();
        Converter.hooks = null;
    }

    public static void main(String[] stringArray) {
        try {
            String string42;
            String[] stringArray2;
            int n;
            SugarMain.setDefaultOptions();
            String string2 = null;
            String string3 = "";
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-prolog")) {
                    prolog = true;
                    continue;
                }
                if (stringArray[n].equals("-max")) {
                    maxCSP = true;
                    continue;
                }
                if (stringArray[n].equals("-weighted")) {
                    weightedCSP = true;
                    continue;
                }
                if (stringArray[n].equals("-competition")) {
                    competition = true;
                    continue;
                }
                if (stringArray[n].equals("-incremental")) {
                    incremental = true;
                    continue;
                }
                if (stringArray[n].equals("-pb")) {
                    pb = true;
                    simplify_clauses = false;
                    Converter.REDUCE_ARITY = false;
                    if (pbEncoding != null) continue;
                    pbEncoding = PBEncoder.Encoding.ORDER_ENCODING;
                    continue;
                }
                if (stringArray[n].equals("-hybrid")) {
                    hybrid = true;
                    simplify_clauses = false;
                    Converter.REDUCE_ARITY = false;
                    Converter.USE_EQ = true;
                    continue;
                }
                if (stringArray[n].equals("-option") && n + 1 < stringArray.length) {
                    for (String string42 : stringArray2 = stringArray[n + 1].split(",")) {
                        if (SugarMain.setOption(string42)) continue;
                        throw new SugarException("Unknown option " + string42);
                    }
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-debug") && n + 1 < stringArray.length) {
                    debug = Integer.parseInt(stringArray[n + 1]);
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-conversionHooks") && n + 1 < stringArray.length) {
                    for (String string42 : stringArray2 = stringArray[n + 1].split(",")) {
                        Class<?> clazz = Class.forName(string42);
                        ConverterHook object = (ConverterHook)clazz.newInstance();
                        Converter.addHook(object);
                    }
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-outputHook") && n + 1 < stringArray.length) {
                    string2 = stringArray[n + 1];
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-v") || stringArray[n].equals("-verbose")) {
                    ++Logger.verboseLevel;
                    continue;
                }
                if (!stringArray[n].startsWith("-")) continue;
                string3 = stringArray[n];
                break;
            }
            stringArray2 = new SugarMain();
            int n2 = stringArray.length - n;
            if (string3.equals("-to") && n2 == 4) {
                String string5 = stringArray[n + 1];
                String string6 = stringArray[n + 2];
                string42 = stringArray[n + 3];
                if (string6.equals("-")) {
                    string6 = null;
                }
                stringArray2.outputCSP(string42, string6, string5, string2);
            } else if (string3.equals("-encode") && n2 == 4) {
                String string7 = stringArray[n + 1];
                String string8 = stringArray[n + 2];
                string42 = stringArray[n + 3];
                if (hybrid) {
                    stringArray2.encodeHybrid(string7, string8, string42);
                } else if (pb || pbEncoding != null) {
                    stringArray2.encodePB(string7, string8, string42);
                } else {
                    stringArray2.encode(string7, string8, string42);
                }
            } else if (string3.equals("-decode") && n2 == 3) {
                String string9 = stringArray[n + 1];
                String string10 = stringArray[n + 2];
                if (hybrid) {
                    stringArray2.decodeHybrid(string9, string10);
                } else if (pb || pbEncoding != null) {
                    stringArray2.decodePB(string9, string10);
                } else {
                    stringArray2.decode(string9, string10);
                }
            } else {
                String string11 = "";
                for (String string : stringArray) {
                    string11 = string11 + " " + string;
                }
                throw new SugarException("Invalid arguments " + string11);
            }
            Logger.status();
        }
        catch (Exception exception) {
            Logger.println("c ERROR Exception " + exception.getMessage());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                Logger.info(stackTraceElement.toString());
            }
            Logger.println("s UNKNOWN");
            System.exit(1);
        }
        catch (Error error) {
            Logger.println("c ERROR Exception " + error.getMessage());
            for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                Logger.info(stackTraceElement.toString());
            }
            Logger.println("s UNKNOWN");
            System.exit(1);
        }
    }
}

