/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar;

import java.util.ArrayList;
import java.util.List;
import jp.kobe_u.sugar.SugarException;

public class XCSP {
    public List<Domain> domains = new ArrayList<Domain>();
    public List<Variable> variables = new ArrayList<Variable>();
    public List<Relation> relations = new ArrayList<Relation>();
    public List<Predicate> predicates = new ArrayList<Predicate>();
    public List<Constraint> constraints = new ArrayList<Constraint>();
    private int countConstraint = 0;

    public void add(Domain domain) throws SugarException {
        if (this.domains.contains(domain)) {
            throw new SugarException("Duplicate domain " + domain);
        }
    }

    public class Constraint {
        String name;
        int arity;
        String scope;
        String reference;
        String parameters;

        public Constraint(String string, int n, String string2, String string3, String string4) {
            if (string == null) {
                string = "C" + XCSP.this.countConstraint;
                XCSP.this.countConstraint++;
            }
            this.name = string;
            this.arity = n;
            this.scope = string2;
            this.reference = string3;
            this.parameters = string4;
        }
    }

    public class Predicate {
        String name;
        String parameters;
        String expression;

        public Predicate(String string, String string2, String string3) {
            this.name = string;
            this.parameters = string2;
            this.expression = string3;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Predicate predicate = (Predicate)object;
            if (!this.getOuterType().equals(predicate.getOuterType())) {
                return false;
            }
            return !(this.name == null ? predicate.name != null : !this.name.equals(predicate.name));
        }

        private XCSP getOuterType() {
            return XCSP.this;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Relation {
        String name;
        int arity;
        int nbTuples;
        String semantics;
        String tuples;

        public Relation(String string, int n, int n2, String string2, String string3) {
            this.name = string;
            this.arity = n;
            this.nbTuples = n2;
            this.semantics = string2;
            this.tuples = string3;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Relation relation = (Relation)object;
            if (!this.getOuterType().equals(relation.getOuterType())) {
                return false;
            }
            return !(this.name == null ? relation.name != null : !this.name.equals(relation.name));
        }

        private XCSP getOuterType() {
            return XCSP.this;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Variable {
        String name;
        String domain;

        public Variable(String string, String string2) {
            this.name = string;
            this.domain = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Variable variable = (Variable)object;
            if (!this.getOuterType().equals(variable.getOuterType())) {
                return false;
            }
            return !(this.name == null ? variable.name != null : !this.name.equals(variable.name));
        }

        private XCSP getOuterType() {
            return XCSP.this;
        }

        public String toString() {
            return this.name;
        }
    }

    public class Domain {
        String name;
        int nbValues;
        String domain;

        public Domain(String string, int n, String string2) {
            this.name = string;
            this.nbValues = n;
            this.domain = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Domain domain = (Domain)object;
            if (!this.getOuterType().equals(domain.getOuterType())) {
                return false;
            }
            return !(this.name == null ? domain.name != null : !this.name.equals(domain.name));
        }

        private XCSP getOuterType() {
            return XCSP.this;
        }

        public String toString() {
            return this.name;
        }
    }
}

