/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.kobe_u.sugar.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML2CSP {
    private static int debug = 0;
    private String xmlFileName;
    private String cspFileName;
    private Document document;
    private BufferedWriter cspFile;
    private int nbDomains = 0;
    private int nbVariables = 0;
    private int nbPredicates = 0;
    private int nbRelations = 0;
    private int nbConstraints = 0;
    private static final String NAME = "name";
    private static final String DOMAINS = "domains";
    private static final String NB_DOMAINS = "nbDomains";
    private static final String DOMAIN = "domain";
    private static final String VARIABLES = "variables";
    private static final String NB_VARIABLES = "nbVariables";
    private static final String VARIABLE = "variable";
    private static final String RELATIONS = "relations";
    private static final String NB_RELATIONS = "nbRelations";
    private static final String RELATION = "relation";
    private static final String ARITY = "arity";
    private static final String SEMANTICS = "semantics";
    private static final String PREDICATES = "predicates";
    private static final String NB_PREDICATES = "nbPredicates";
    private static final String PREDICATE = "predicate";
    private static final String FUNCTIONAL = "functional";
    private static final String PARAMETERS = "parameters";
    private static final String CONSTRAINTS = "constraints";
    private static final String NB_CONSTRAINTS = "nbConstraints";
    private static final String CONSTRAINT = "constraint";
    private static final String SCOPE = "scope";
    private static final String REFERENCE = "reference";
    private static HashSet<String> supportedGlobalConstraints = new HashSet();

    public XML2CSP(String string, String string2) {
        this.xmlFileName = string;
        this.cspFileName = string2;
    }

    private Element getFirstElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    private String getTextContext(Element element) {
        return element.getTextContent().replaceAll("\\s+", " ").trim();
    }

    private void output(String string) throws IOException {
        this.cspFile.write(string);
        this.cspFile.write(10);
    }

    private void convertDomains(Element element) throws IOException {
        this.nbDomains = Integer.parseInt(element.getAttribute(NB_DOMAINS));
        this.output("; nbDomains=" + this.nbDomains);
        NodeList nodeList = element.getElementsByTagName(DOMAIN);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(NAME);
            String string2 = this.getTextContext(element2);
            if (string2.matches("(-?\\d+)")) {
                this.output("(domain " + string + " " + string2 + " " + string2 + ")");
                continue;
            }
            if (string2.matches("(-?\\d+)\\s*\\.\\.\\s*(-?\\d+)")) {
                String[] stringArray = string2.split("\\s*\\.\\.\\s*");
                this.output("(domain " + string + " " + stringArray[0] + " " + stringArray[1] + ")");
                continue;
            }
            string2 = string2.replaceAll("(-?\\d+)\\s*\\.\\.\\s*(-?\\d+)", "($1 $2)");
            this.output("(domain " + string + " (" + string2 + "))");
        }
    }

    private void convertVariables(Element element) throws IOException {
        this.nbVariables = Integer.parseInt(element.getAttribute(NB_VARIABLES));
        this.output("; nbVariables=" + this.nbVariables);
        NodeList nodeList = element.getElementsByTagName(VARIABLE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(NAME);
            String string2 = element2.getAttribute(DOMAIN);
            this.output("(int " + string + " " + string2 + ")");
        }
    }

    private void convertPredicates(Element element) throws IOException {
        if (element == null) {
            return;
        }
        this.nbPredicates = Integer.parseInt(element.getAttribute(NB_PREDICATES));
        this.output("; nbPredicates=" + this.nbPredicates);
        NodeList nodeList = element.getElementsByTagName(PREDICATE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(NAME);
            Element element3 = this.getFirstElement(element2, PARAMETERS);
            Element element4 = this.getFirstElement(element2, FUNCTIONAL);
            String string2 = this.getTextContext(element3);
            string2 = string2.replaceAll("int\\s+", "");
            String string3 = this.getTextContext(element4);
            string3 = string3.replaceAll("(\\w+)\\(", "($1 ");
            string3 = string3.replaceAll("\\s*,\\s*", " ");
            this.output("(predicate (" + string + " " + string2 + ") " + string3 + ")");
        }
    }

    private void convertRelations(Element element) throws IOException {
        if (element == null) {
            return;
        }
        this.nbRelations = Integer.parseInt(element.getAttribute(NB_RELATIONS));
        this.output("; nbRelations=" + this.nbRelations);
        NodeList nodeList = element.getElementsByTagName(RELATION);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(NAME);
            int n = Integer.parseInt(element2.getAttribute(ARITY));
            String string2 = element2.getAttribute(SEMANTICS);
            String string3 = this.getTextContext(element2);
            if (!(string3 = string3.replaceAll("\\s*\\|\\s*", ") (")).matches("\\s*")) {
                string3 = "(" + string3 + ")";
            }
            this.output("(relation " + string + " " + n + " (" + string2 + " " + string3 + "))");
        }
    }

    private void convertConstraints(Element element) throws IOException {
        this.nbConstraints = Integer.parseInt(element.getAttribute(NB_CONSTRAINTS));
        this.output("; nbConstraints=" + this.nbConstraints);
        NodeList nodeList = element.getElementsByTagName(CONSTRAINT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(NAME);
            String string2 = element2.getAttribute(SCOPE);
            String string3 = element2.getAttribute(REFERENCE);
            Element element3 = this.getFirstElement(element2, PARAMETERS);
            String string4 = "";
            if (string3.startsWith("global:")) {
                if (!supportedGlobalConstraints.contains(string3 = string3.replaceFirst("global:", "").toLowerCase())) {
                    System.out.println("s UNSUPPORTED");
                    throw new IOException("global:" + string3 + " is not supported");
                }
                if (element3 == null) {
                    string4 = string2;
                } else {
                    NodeList nodeList2 = element3.getChildNodes();
                    String string5 = "";
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        string4 = nodeList2.item(j).getNodeType() == 1 ? string4 + string5 + nodeList2.item(j).getNodeName() : string4 + string5 + nodeList2.item(j).getTextContent();
                        string5 = " ";
                    }
                    string4 = string4.replaceAll("[\\[\\{]", "(");
                    string4 = string4.replaceAll("[\\]\\}]", ")");
                }
                this.output("(" + string3 + " " + string4 + ") ; " + string);
                continue;
            }
            string4 = element3 == null ? string2 : this.getTextContext(element3);
            this.output("(" + string3 + " " + string4 + ") ; " + string);
        }
    }

    public void convert() throws IOException {
        this.cspFile = new BufferedWriter(new FileWriter(this.cspFileName));
        this.output("; BEGIN " + this.xmlFileName);
        Element element = this.document.getDocumentElement();
        this.convertDomains(this.getFirstElement(element, DOMAINS));
        this.convertVariables(this.getFirstElement(element, VARIABLES));
        this.convertPredicates(this.getFirstElement(element, PREDICATES));
        this.convertRelations(this.getFirstElement(element, RELATIONS));
        this.convertConstraints(this.getFirstElement(element, CONSTRAINTS));
        this.output("; END " + this.xmlFileName);
        this.cspFile.close();
        System.out.println("c " + this.nbDomains + " domains, " + this.nbVariables + " variables, " + this.nbPredicates + " predicates, " + this.nbRelations + " relations, " + this.nbConstraints + " constraints");
    }

    public void load() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = new FileInputStream(this.xmlFileName);
        if (this.xmlFileName.endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.document = documentBuilder.parse(inputStream);
        inputStream.close();
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals("-v") || stringArray[n2].equals("-verbose")) {
                ++Logger.verboseLevel;
                continue;
            }
            if (stringArray[n2].equals("-debug") && n2 + 1 < stringArray.length) {
                debug = Integer.parseInt(stringArray[n2 + 1]);
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-option") && n2 + 1 < stringArray.length) {
                ++n2;
                continue;
            }
            if (!stringArray[n2].startsWith("-")) break;
        }
        if ((n = stringArray.length - n2) != 2) {
            System.out.println("Usage : java XML2CSP [-v] xmlFileName cspFileName");
            System.exit(1);
        }
        String string = stringArray[n2];
        String string2 = stringArray[n2 + 1];
        try {
            XML2CSP xML2CSP = new XML2CSP(string, string2);
            xML2CSP.load();
            xML2CSP.convert();
        }
        catch (IOException iOException) {
            System.out.println("c ERROR Exception " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("c ERROR Exception " + parserConfigurationException.getMessage());
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.println("c ERROR Exception " + sAXException.getMessage());
            sAXException.printStackTrace();
        }
    }

    static {
        supportedGlobalConstraints.add("alldifferent");
        supportedGlobalConstraints.add("weightedsum");
        supportedGlobalConstraints.add("cumulative");
        supportedGlobalConstraints.add("element");
        supportedGlobalConstraints.add("disjunctive");
        supportedGlobalConstraints.add("lex_less");
        supportedGlobalConstraints.add("lex_lesseq");
        supportedGlobalConstraints.add("nvalue");
        supportedGlobalConstraints.add("count");
        supportedGlobalConstraints.add("global_cardinality");
        supportedGlobalConstraints.add("global_cardinality_with_costs");
    }
}

