/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearEqLiteral;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearNeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.expression.Atom;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;
import jp.kobe_u.sugar.hook.ConverterHook;

public class ComparisonConverter {
    private Converter converter;
    private CSP csp;

    public ComparisonConverter(Converter converter) {
        this.converter = converter;
        this.csp = converter.csp;
    }

    private void convertConstraint(Expression expression) throws SugarException {
        this.converter.convertConstraint(expression);
    }

    private IntegerVariable newIntegerVariable(IntegerDomain integerDomain, Expression expression) throws SugarException {
        return this.converter.newIntegerVariable(integerDomain, expression);
    }

    private IntegerVariable toIntegerVariable(LinearSum linearSum, Expression expression) throws SugarException {
        IntegerVariable integerVariable;
        if (linearSum.isIntegerVariable()) {
            integerVariable = linearSum.getCoef().firstKey();
        } else {
            integerVariable = this.newIntegerVariable(linearSum.getDomain(), expression);
            Expression expression2 = Expression.create(integerVariable.getName()).eq(expression);
            expression2.setComment(integerVariable.getName() + " == " + expression);
            this.convertConstraint(expression2);
            this.converter.addEquivalence(integerVariable, expression);
        }
        return integerVariable;
    }

    private LinearSum convertInteger(Atom atom) throws SugarException {
        return new LinearSum(atom.integerValue());
    }

    private LinearSum convertString(Atom atom) throws SugarException {
        String string = atom.stringValue();
        if (this.csp.getIntegerVariable(string) == null) {
            this.converter.syntaxError(atom);
        }
        IntegerVariable integerVariable = this.csp.getIntegerVariable(string);
        return new LinearSum(integerVariable);
    }

    private LinearSum convertADD(Sequence sequence) throws SugarException {
        LinearSum linearSum = new LinearSum(0);
        for (int i = 1; i < sequence.length(); ++i) {
            LinearSum linearSum2 = this.convertFormula(sequence.get(i));
            linearSum.add(linearSum2);
        }
        return linearSum;
    }

    private LinearSum convertSUB(Sequence sequence) throws SugarException {
        LinearSum linearSum = null;
        if (sequence.length() == 1) {
            this.converter.syntaxError(sequence);
        } else if (sequence.length() == 2) {
            linearSum = this.convertFormula(sequence.get(1));
            linearSum.multiply(-1);
        } else {
            linearSum = this.convertFormula(sequence.get(1));
            for (int i = 2; i < sequence.length(); ++i) {
                LinearSum linearSum2 = this.convertFormula(sequence.get(i));
                linearSum.subtract(linearSum2);
            }
        }
        return linearSum;
    }

    private LinearSum convertABS(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 1);
        Expression expression = sequence.get(1);
        LinearSum linearSum = this.convertFormula(expression);
        IntegerDomain integerDomain = linearSum.getDomain();
        if (integerDomain.getLowerBound() >= 0) {
            return linearSum;
        }
        if (integerDomain.getUpperBound() <= 0) {
            linearSum.multiply(-1);
            return linearSum;
        }
        IntegerDomain integerDomain2 = integerDomain.abs();
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain2, sequence);
        Expression expression2 = Expression.create(integerVariable.getName());
        Expression expression3 = expression2.ge(expression).and(expression2.ge(expression.neg())).and(expression2.le(expression).or(expression2.le(expression.neg())));
        expression3.setComment(integerVariable.getName() + " == " + sequence);
        this.convertConstraint(expression3);
        this.converter.addEquivalence(integerVariable, sequence);
        return new LinearSum(integerVariable);
    }

    private LinearSum convertMUL(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        LinearSum linearSum = this.convertFormula(expression);
        LinearSum linearSum2 = this.convertFormula(expression2);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        if (integerDomain.size() == 1) {
            linearSum2.multiply(integerDomain.getLowerBound());
            return linearSum2;
        }
        if (integerDomain2.size() == 1) {
            linearSum.multiply(integerDomain2.getLowerBound());
            return linearSum;
        }
        if (integerDomain.size() > integerDomain2.size()) {
            return this.convertMUL((Sequence)expression2.mul(expression));
        }
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain.mul(integerDomain2), sequence);
        Expression expression3 = Expression.create(integerVariable.getName());
        Iterator<Integer> iterator = integerDomain.values();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.converter.addExtra(expression.eq(n).imp(expression3.eq(expression2.mul(n))));
        }
        return new LinearSum(integerVariable);
    }

    private LinearSum convertDIV(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        LinearSum linearSum = this.convertFormula(expression);
        LinearSum linearSum2 = this.convertFormula(expression2);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        IntegerDomain integerDomain3 = integerDomain.div(integerDomain2);
        IntegerDomain integerDomain4 = integerDomain.mod(integerDomain2);
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain3, sequence);
        IntegerVariable integerVariable2 = this.newIntegerVariable(integerDomain4, expression.mod(expression2));
        Expression expression3 = Expression.create(integerVariable.getName());
        Expression expression4 = Expression.create(integerVariable2.getName());
        Expression expression5 = expression2.mul(expression3);
        if (integerDomain2.size() == 1) {
            int n = integerDomain2.getLowerBound();
            if (n == 1) {
                return linearSum;
            }
            if (n == -1) {
                linearSum.multiply(-1);
                return linearSum;
            }
            if (n <= 0) {
                throw new SugarException("Unsupported " + sequence);
            }
            Expression expression6 = expression.eq(expression5.add(expression4)).and(expression4.ge(Expression.ZERO).and(expression2.abs().gt(expression4)));
            expression6.setComment(integerVariable.getName() + " == " + sequence);
            this.convertConstraint(expression6);
            this.converter.addEquivalence(integerVariable, sequence);
            return new LinearSum(integerVariable);
        }
        throw new SugarException("Unsupported " + sequence);
    }

    private LinearSum convertMOD(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        LinearSum linearSum = this.convertFormula(expression);
        LinearSum linearSum2 = this.convertFormula(expression2);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        IntegerDomain integerDomain3 = integerDomain.div(integerDomain2);
        IntegerDomain integerDomain4 = integerDomain.mod(integerDomain2);
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain3, sequence);
        IntegerVariable integerVariable2 = this.newIntegerVariable(integerDomain4, expression.mod(expression2));
        Expression expression3 = Expression.create(integerVariable.getName());
        Expression expression4 = Expression.create(integerVariable2.getName());
        Expression expression5 = expression2.mul(expression3);
        if (integerDomain2.size() == 1) {
            int n = integerDomain2.getLowerBound();
            if (n <= 0) {
                throw new SugarException("Unsupported " + sequence);
            }
            Expression expression6 = expression.eq(expression5.add(expression4)).and(expression4.ge(Expression.ZERO).and(expression2.abs().gt(expression4)));
            expression6.setComment(integerVariable.getName() + " == " + sequence);
            this.convertConstraint(expression6);
            this.converter.addEquivalence(integerVariable2, sequence);
            return new LinearSum(integerVariable2);
        }
        throw new SugarException("Unsupported " + sequence);
    }

    private LinearSum convertPOW(Sequence sequence) throws SugarException {
        throw new SugarException("Unsupported " + sequence);
    }

    private LinearSum convertMIN(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        LinearSum linearSum = this.convertFormula(expression);
        LinearSum linearSum2 = this.convertFormula(expression2);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        if (integerDomain.getUpperBound() <= integerDomain2.getLowerBound()) {
            return linearSum;
        }
        if (integerDomain2.getUpperBound() <= integerDomain.getLowerBound()) {
            return linearSum2;
        }
        IntegerDomain integerDomain3 = integerDomain.min(integerDomain2);
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain3, sequence);
        Expression expression3 = Expression.create(integerVariable.getName());
        Expression expression4 = expression3.le(expression).and(expression3.le(expression2)).and(expression3.ge(expression).or(expression3.ge(expression2)));
        expression4.setComment(integerVariable.getName() + " == " + sequence);
        this.convertConstraint(expression4);
        this.converter.addEquivalence(integerVariable, sequence);
        return new LinearSum(integerVariable);
    }

    private LinearSum convertMAX(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        LinearSum linearSum = this.convertFormula(expression);
        LinearSum linearSum2 = this.convertFormula(expression2);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        if (integerDomain.getUpperBound() <= integerDomain2.getLowerBound()) {
            return linearSum2;
        }
        if (integerDomain2.getUpperBound() <= integerDomain.getLowerBound()) {
            return linearSum;
        }
        IntegerDomain integerDomain3 = integerDomain.max(integerDomain2);
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain3, sequence);
        Expression expression3 = Expression.create(integerVariable.getName());
        Expression expression4 = expression3.ge(expression).and(expression3.ge(expression2)).and(expression3.le(expression).or(expression3.le(expression2)));
        expression4.setComment(integerVariable.getName() + " == " + sequence);
        this.convertConstraint(expression4);
        this.converter.addEquivalence(integerVariable, sequence);
        return new LinearSum(integerVariable);
    }

    private LinearSum convertIF(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 3);
        Expression expression = sequence.get(1);
        Expression expression2 = sequence.get(2);
        Expression expression3 = sequence.get(3);
        LinearSum linearSum = this.convertFormula(expression2);
        LinearSum linearSum2 = this.convertFormula(expression3);
        IntegerDomain integerDomain = linearSum.getDomain();
        IntegerDomain integerDomain2 = linearSum2.getDomain();
        IntegerDomain integerDomain3 = integerDomain.cup(integerDomain2);
        IntegerVariable integerVariable = this.newIntegerVariable(integerDomain3, sequence);
        Expression expression4 = Expression.create(integerVariable.getName());
        Expression expression5 = expression.not().or(expression4.eq(expression2)).and(expression.or(expression4.eq(expression3)));
        expression5.setComment(integerVariable.getName() + " == " + sequence);
        this.convertConstraint(expression5);
        this.converter.addEquivalence(integerVariable, sequence);
        return new LinearSum(integerVariable);
    }

    protected LinearSum convertFormula(Expression expression) throws SugarException {
        Object object;
        if (Converter.hooks != null) {
            do {
                object = expression;
                for (ConverterHook converterHook : Converter.hooks) {
                    expression = converterHook.convertFunction(this.converter, expression);
                }
            } while (!object.equals(expression));
        }
        object = null;
        IntegerVariable integerVariable = this.converter.getEquivalence(expression);
        if (integerVariable != null) {
            object = new LinearSum(integerVariable);
        } else if (expression.isAtom()) {
            object = expression.isInteger() ? this.convertInteger((Atom)expression) : this.convertString((Atom)expression);
        } else if (expression.isSequence(Expression.ADD)) {
            object = this.convertADD((Sequence)expression);
        } else if (expression.isSequence(Expression.NEG) || expression.isSequence(Expression.SUB)) {
            object = this.convertSUB((Sequence)expression);
        } else if (expression.isSequence(Expression.ABS)) {
            object = this.convertABS((Sequence)expression);
        } else if (expression.isSequence(Expression.MUL)) {
            object = this.convertMUL((Sequence)expression);
        } else if (expression.isSequence(Expression.DIV)) {
            object = this.convertDIV((Sequence)expression);
        } else if (expression.isSequence(Expression.MOD)) {
            object = this.convertMOD((Sequence)expression);
        } else if (expression.isSequence(Expression.POW)) {
            object = this.convertPOW((Sequence)expression);
        } else if (expression.isSequence(Expression.MIN)) {
            object = this.convertMIN((Sequence)expression);
        } else if (expression.isSequence(Expression.MAX)) {
            object = this.convertMAX((Sequence)expression);
        } else if (expression.isSequence(Expression.IF)) {
            object = this.convertIF((Sequence)expression);
        } else {
            this.converter.syntaxError(expression);
        }
        return object;
    }

    private LinearSum simplifyLinearLe(LinearSum linearSum) throws SugarException {
        int n;
        if (linearSum.size() <= 3) {
            return linearSum;
        }
        IntegerVariable integerVariable = linearSum.getLargestDomainVariable();
        if (!linearSum.isDomainLargerThanExcept(Converter.MAX_LINEARSUM_SIZE, integerVariable)) {
            return linearSum;
        }
        IntegerVariable[] integerVariableArray = linearSum.getVariablesSorted();
        LinearSum linearSum2 = new LinearSum(0);
        for (n = 2; n < integerVariableArray.length; ++n) {
            linearSum2.setA(linearSum.getA(integerVariableArray[n]), integerVariableArray[n]);
        }
        n = linearSum2.factor();
        if (n > 1) {
            linearSum2.divide(n);
        }
        IntegerVariable integerVariable2 = new IntegerVariable(linearSum2.getDomain());
        integerVariable2.setComment(integerVariable2.getName() + " : " + linearSum2);
        this.csp.add(integerVariable2);
        Expression expression = Expression.create(integerVariable2.getName());
        Expression expression2 = linearSum2.toExpression();
        Expression expression3 = expression.eq(expression2);
        this.converter.addExtra(expression3);
        LinearSum linearSum3 = new LinearSum(linearSum.getB());
        linearSum3.setA(linearSum.getA(integerVariableArray[0]), integerVariableArray[0]);
        linearSum3.setA(linearSum.getA(integerVariableArray[1]), integerVariableArray[1]);
        linearSum3.setA(n, integerVariable2);
        return linearSum3;
    }

    private LinearSum simplifyLinearExpression(LinearSum linearSum, String string, boolean bl) throws SugarException {
        if (Converter.ESTIMATE_SATSIZE ? linearSum.satSizeLE(Converter.MAX_LINEARSUM_SIZE) : linearSum.size() <= 1 || !linearSum.isDomainLargerThan(Converter.MAX_LINEARSUM_SIZE)) {
            return linearSum;
        }
        int n = linearSum.getB();
        LinearSum[] linearSumArray = linearSum.split(bl ? 3 : Converter.SPLITS);
        linearSum = new LinearSum(n);
        for (int i = 0; i < linearSumArray.length; ++i) {
            LinearSum linearSum2 = linearSumArray[i];
            int n2 = linearSum2.factor();
            if (n2 > 1) {
                linearSum2.divide(n2);
            }
            if ((linearSum2 = this.simplifyLinearExpression(linearSum2, "eq", false)).size() > 1) {
                Expression expression;
                IntegerVariable integerVariable = new IntegerVariable(linearSum2.getDomain());
                integerVariable.setComment(integerVariable.getName() + " : " + linearSum2);
                this.csp.add(integerVariable);
                Expression expression2 = Expression.create(integerVariable.getName());
                Expression expression3 = linearSum2.toExpression();
                if (!Converter.USE_EQ && !Converter.EQUIV_TRANSLATION && string.equals("ge")) {
                    expression = expression2.le(expression3);
                    expression.setComment(integerVariable.getName() + " <= " + expression3);
                } else if (!Converter.USE_EQ && !Converter.EQUIV_TRANSLATION && string.equals("le")) {
                    expression = expression2.ge(expression3);
                    expression.setComment(integerVariable.getName() + " >= " + expression3);
                } else {
                    expression = expression2.eq(expression3);
                    expression.setComment(integerVariable.getName() + " == " + expression3);
                }
                this.convertConstraint(expression);
                linearSum2 = new LinearSum(integerVariable);
            }
            if (n2 > 1) {
                linearSum2.multiply(n2);
            }
            linearSum.add(linearSum2);
        }
        return linearSum;
    }

    private LinearSum reduceLinearExpression(LinearSum linearSum, String string) throws SugarException {
        if (linearSum.size() <= Converter.MAX_ARITY) {
            return linearSum;
        }
        int n = linearSum.getB();
        LinearSum[] linearSumArray = linearSum.split(Converter.MAX_ARITY);
        linearSum = new LinearSum(n);
        for (int i = 0; i < linearSumArray.length; ++i) {
            LinearSum linearSum2 = linearSumArray[i];
            int n2 = linearSum2.factor();
            if (n2 > 1) {
                linearSum2.divide(n2);
            }
            if ((linearSum2 = this.reduceLinearExpression(linearSum2, "eq")).size() > 1) {
                Expression expression;
                IntegerVariable integerVariable = new IntegerVariable(linearSum2.getDomain());
                integerVariable.setComment(integerVariable.getName() + " : " + linearSum2);
                this.csp.add(integerVariable);
                Expression expression2 = Expression.create(integerVariable.getName());
                Expression expression3 = linearSum2.toExpression();
                if (!Converter.USE_EQ && string.equals("ge")) {
                    expression = expression2.le(expression3);
                    expression.setComment(integerVariable.getName() + " <= " + expression3);
                } else if (!Converter.USE_EQ && string.equals("le")) {
                    expression = expression2.ge(expression3);
                    expression.setComment(integerVariable.getName() + " >= " + expression3);
                } else {
                    expression = expression2.eq(expression3);
                    expression.setComment(integerVariable.getName() + " == " + expression3);
                }
                this.convertConstraint(expression);
                linearSum2 = new LinearSum(integerVariable);
            }
            if (n2 > 1) {
                linearSum2.multiply(n2);
            }
            linearSum.add(linearSum2);
        }
        return linearSum;
    }

    private LinearSum reduceArity(LinearSum linearSum, String string) throws SugarException {
        LinearSum[] linearSumArray = linearSum.splitPbPart();
        linearSum = linearSumArray[0];
        if (Converter.REDUCE_ARITY) {
            if (Converter.MAX_ARITY > 0) {
                linearSum = this.reduceLinearExpression(linearSum, string);
            } else if (linearSum.size() > 3 && linearSum.isDomainLargerThanExcept(Converter.MAX_LINEARSUM_SIZE)) {
                linearSum = this.simplifyLinearExpression(linearSum, string, true);
            }
        }
        if (linearSumArray.length >= 2) {
            linearSum.add(linearSumArray[1]);
        }
        return linearSum;
    }

    public LinearLiteral reduceArity(LinearLiteral linearLiteral) throws SugarException {
        LinearSum linearSum = linearLiteral.getLinearExpression();
        String string = linearLiteral.getCmp();
        if ((linearSum = this.reduceArity(linearSum, string)) == linearLiteral.getLinearExpression()) {
            return linearLiteral;
        }
        if (string.equals("eq")) {
            return new LinearEqLiteral(linearSum);
        }
        if (string.equals("ne")) {
            return new LinearNeLiteral(linearSum);
        }
        if (string.equals("ge")) {
            return new LinearGeLiteral(linearSum);
        }
        if (string.equals("le")) {
            return new LinearLeLiteral(linearSum);
        }
        throw new SugarException("Unknown cmp " + string);
    }

    public List<Clause> convertComp(Expression expression, Expression expression2, String string) throws SugarException {
        LinearSum linearSum = this.convertFormula(expression.sub(expression2));
        linearSum.factorize();
        linearSum = this.reduceArity(linearSum, string);
        LinearLiteral linearLiteral = null;
        if (string.equals("eq")) {
            linearLiteral = new LinearEqLiteral(linearSum);
        } else if (string.equals("ne")) {
            linearLiteral = new LinearNeLiteral(linearSum);
        } else if (string.equals("ge")) {
            linearLiteral = new LinearGeLiteral(linearSum);
        } else if (string.equals("le")) {
            linearLiteral = new LinearLeLiteral(linearSum);
        } else {
            throw new SugarException("Unknown comparison operator in convertComp: " + string);
        }
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        if (!linearLiteral.isValid()) {
            if (linearLiteral.isUnsatisfiable()) {
                arrayList.add(new Clause());
            } else {
                arrayList.add(new Clause(linearLiteral));
            }
        }
        return arrayList;
    }
}

