/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.converter.ComparisonConverter;
import jp.kobe_u.sugar.converter.DefinitionConverter;
import jp.kobe_u.sugar.converter.ExpressionOptimizer;
import jp.kobe_u.sugar.converter.GlobalConverter;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.HoldLiteral;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LabelLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.csp.RelationLiteral;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;
import jp.kobe_u.sugar.hook.ConverterHook;

public class Converter {
    public static int MAX_EQUIVMAP_SIZE = 1000;
    public static long MAX_LINEARSUM_SIZE = 1024L;
    public static boolean OPT_PEEPHOLE = true;
    public static boolean OPT_PEEPHOLE_ABS = true;
    public static boolean HINT_ALLDIFF_PIGEON = true;
    public static boolean INCREMENTAL_PROPAGATION = true;
    public static boolean LINEARIZE = true;
    public static boolean NORMALIZE_LINEARSUM = true;
    public static boolean DECOMPOSE_RELATION = false;
    public static boolean DECOMPOSE_ALLDIFFERENT = true;
    public static boolean DECOMPOSE_WEIGHTEDSUM = true;
    public static boolean DECOMPOSE_CUMULATIVE = true;
    public static boolean DECOMPOSE_ELEMENT = true;
    public static boolean DECOMPOSE_DISJUNCTIVE = true;
    public static boolean DECOMPOSE_LEX_LESS = true;
    public static boolean DECOMPOSE_LEX_LESSEQ = true;
    public static boolean DECOMPOSE_NVALUE = true;
    public static boolean DECOMPOSE_COUNT = true;
    public static boolean DECOMPOSE_GLOBAL_CARDINALITY = true;
    public static boolean DECOMPOSE_GLOBAL_CARDINALITY_WITH_COSTS = true;
    public static boolean REPLACE_ARGUMENTS = false;
    public static boolean REDUCE_ARITY = true;
    public static int MAX_ARITY = 0;
    public static int SPLITS = 2;
    public static boolean USE_EQ = false;
    public static boolean EQUIV_TRANSLATION = false;
    public static boolean ESTIMATE_SATSIZE = false;
    public static boolean ADD_GROUP_ID = false;
    public static boolean HOLD_CONSTRAINTS = false;
    public static List<ConverterHook> hooks = null;
    public CSP csp;
    public DefinitionConverter definitionConverter;
    public ComparisonConverter comparisonConverter;
    public GlobalConverter globalConverter;
    public ExpressionOptimizer expressionOptimizer;
    private List<Expression> extra;
    private Map<Expression, IntegerVariable> equivMap;

    public static void setDecomposeAll(boolean bl) {
        DECOMPOSE_ALLDIFFERENT = bl;
        DECOMPOSE_WEIGHTEDSUM = bl;
        DECOMPOSE_CUMULATIVE = bl;
        DECOMPOSE_ELEMENT = bl;
        DECOMPOSE_DISJUNCTIVE = bl;
        DECOMPOSE_LEX_LESS = bl;
        DECOMPOSE_LEX_LESSEQ = bl;
        DECOMPOSE_NVALUE = bl;
        DECOMPOSE_COUNT = bl;
        DECOMPOSE_GLOBAL_CARDINALITY = bl;
        DECOMPOSE_GLOBAL_CARDINALITY_WITH_COSTS = bl;
    }

    public static void addHook(ConverterHook converterHook) {
        if (hooks == null) {
            hooks = new ArrayList<ConverterHook>();
        }
        hooks.add(converterHook);
    }

    public Converter(CSP cSP) {
        this.csp = cSP;
        this.definitionConverter = new DefinitionConverter(this);
        this.globalConverter = new GlobalConverter(this);
        this.comparisonConverter = new ComparisonConverter(this);
        this.expressionOptimizer = new ExpressionOptimizer(this);
        this.extra = new ArrayList<Expression>();
        this.equivMap = new EquivMap();
    }

    protected void addExtra(Expression expression) {
        this.extra.add(expression);
    }

    protected IntegerVariable getEquivalence(Expression expression) {
        return this.equivMap.get(expression);
    }

    protected void addEquivalence(IntegerVariable integerVariable, Expression expression) {
        this.equivMap.put(expression, integerVariable);
    }

    public void syntaxError(String string) throws SugarException {
        throw new SugarException("Syntax error " + string);
    }

    public void syntaxError(Expression expression) throws SugarException {
        this.syntaxError(expression.toString());
    }

    public void checkArity(Expression expression, int n) throws SugarException {
        if (!expression.isSequence(n)) {
            this.syntaxError(expression);
        }
    }

    public LinearSum convertFormula(Expression expression) throws SugarException {
        return this.comparisonConverter.convertFormula(expression);
    }

    public IntegerVariable newIntegerVariable(IntegerDomain integerDomain, Expression expression) throws SugarException {
        IntegerVariable integerVariable = new IntegerVariable(integerDomain);
        this.csp.add(integerVariable);
        integerVariable.setComment(integerVariable.getName() + " : " + expression.toString());
        return integerVariable;
    }

    public IntegerVariable toIntegerVariable(Expression expression) throws SugarException {
        IntegerVariable integerVariable;
        LinearSum linearSum = this.comparisonConverter.convertFormula(expression);
        if (linearSum.isIntegerVariable()) {
            integerVariable = linearSum.getCoef().firstKey();
        } else {
            integerVariable = this.newIntegerVariable(linearSum.getDomain(), expression);
            Expression expression2 = Expression.create(integerVariable.getName()).eq(expression);
            expression2.setComment(integerVariable.getName() + " == " + expression);
            this.convertConstraint(expression2);
            this.addEquivalence(integerVariable, expression);
        }
        return integerVariable;
    }

    private List<Clause> convertDisj(Sequence sequence, boolean bl) throws SugarException {
        ArrayList<Clause> arrayList = null;
        if (sequence.length() == 1) {
            arrayList = new ArrayList<Clause>();
            arrayList.add(new Clause());
        } else if (sequence.length() == 2) {
            arrayList = this.convertConstraint(sequence.get(1), bl);
        } else {
            arrayList = new ArrayList();
            Clause clause = new Clause();
            arrayList.add(clause);
            for (int i = 1; i < sequence.length(); ++i) {
                List<Clause> list = this.convertConstraint(sequence.get(i), bl);
                if (list.size() == 0) {
                    return list;
                }
                if (list.size() == 1) {
                    clause.addAll(list.get(0).getLiterals());
                    continue;
                }
                BooleanVariable booleanVariable = new BooleanVariable();
                this.csp.add(booleanVariable);
                BooleanLiteral booleanLiteral = new BooleanLiteral(booleanVariable, false);
                BooleanLiteral booleanLiteral2 = new BooleanLiteral(booleanVariable, true);
                clause.add(booleanLiteral);
                if (EQUIV_TRANSLATION) {
                    for (Clause clause2 : list) {
                        for (Literal literal : clause2.getLiterals()) {
                            Clause clause3 = new Clause(booleanLiteral);
                            clause3.add(literal.neg());
                            arrayList.add(clause3);
                        }
                        clause2.add(booleanLiteral2);
                        arrayList.add(clause2);
                    }
                    continue;
                }
                for (Clause clause2 : list) {
                    clause2.add(booleanLiteral2);
                }
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public void convertAtom(Expression expression, boolean bl, List<Clause> list) throws SugarException {
        if (expression.isInteger()) {
            expression = expression.integerValue() > 0 ? Expression.TRUE : Expression.FALSE;
        }
        if (expression.equals(Expression.FALSE) && !bl || expression.equals(Expression.TRUE) && bl) {
            list.add(new Clause());
        } else if (!(expression.equals(Expression.FALSE) && bl || expression.equals(Expression.TRUE) && !bl)) {
            BooleanVariable booleanVariable = this.definitionConverter.toBool(expression.stringValue());
            if (booleanVariable == null) {
                this.syntaxError(expression);
            }
            Clause clause = new Clause(new BooleanLiteral(booleanVariable, bl));
            list.add(clause);
        }
    }

    public Expression convertLogical(Sequence sequence, boolean bl, List<Clause> list) throws SugarException {
        Expression expression = null;
        if (sequence.isSequence(Expression.IMP)) {
            this.checkArity(sequence, 2);
            expression = sequence.get(1).not().or(sequence.get(2));
        } else if (sequence.isSequence(Expression.XOR)) {
            this.checkArity(sequence, 2);
            expression = sequence.get(1).or(sequence.get(2)).and(sequence.get(1).not().or(sequence.get(2).not()));
        } else if (sequence.isSequence(Expression.IFF)) {
            this.checkArity(sequence, 2);
            expression = sequence.get(1).not().or(sequence.get(2)).and(sequence.get(1).or(sequence.get(2).not()));
        } else if (sequence.isSequence(Expression.AND) && !bl || sequence.isSequence(Expression.OR) && bl) {
            for (int i = 1; i < sequence.length(); ++i) {
                List<Clause> list2 = this.convertConstraint(sequence.get(i), bl);
                list.addAll(list2);
            }
        } else if (sequence.isSequence(Expression.OR) && !bl || sequence.isSequence(Expression.AND) && bl) {
            list.addAll(this.convertDisj(sequence, bl));
        } else {
            this.syntaxError(sequence);
        }
        return expression;
    }

    public Expression convertComparison(Sequence sequence, boolean bl, List<Clause> list) throws SugarException {
        if (NORMALIZE_LINEARSUM) {
            if (sequence.isSequence(Expression.EQ)) {
                return sequence.get(1).le(sequence.get(2)).and(sequence.get(1).ge(sequence.get(2)));
            }
            if (sequence.isSequence(Expression.NE)) {
                return sequence.get(1).lt(sequence.get(2)).or(sequence.get(1).gt(sequence.get(2)));
            }
        }
        if (sequence.isSequence(Expression.EQ) && !bl || sequence.isSequence(Expression.NE) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1), sequence.get(2), "eq"));
        } else if (sequence.isSequence(Expression.NE) && !bl || sequence.isSequence(Expression.EQ) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1), sequence.get(2), "ne"));
        } else if (sequence.isSequence(Expression.LE) && !bl || sequence.isSequence(Expression.GT) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1), sequence.get(2), "le"));
        } else if (sequence.isSequence(Expression.LT) && !bl || sequence.isSequence(Expression.GE) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1).add(1), sequence.get(2), "le"));
        } else if (sequence.isSequence(Expression.GE) && !bl || sequence.isSequence(Expression.LT) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1), sequence.get(2), "ge"));
        } else if (sequence.isSequence(Expression.GT) && !bl || sequence.isSequence(Expression.LE) && bl) {
            this.checkArity(sequence, 2);
            list.addAll(this.comparisonConverter.convertComp(sequence.get(1), sequence.get(2).add(1), "ge"));
        } else {
            this.syntaxError(sequence);
        }
        return null;
    }

    public Expression convertGlobal(Sequence sequence, boolean bl, List<Clause> list) throws SugarException {
        Expression expression = null;
        if (sequence.isSequence(Expression.ALLDIFFERENT)) {
            expression = this.globalConverter.convertAllDifferent(sequence);
        } else if (sequence.isSequence(Expression.WEIGHTEDSUM)) {
            expression = this.globalConverter.convertWeightedSum(sequence);
        } else if (sequence.isSequence(Expression.CUMULATIVE)) {
            expression = this.globalConverter.convertCumulative(sequence);
        } else if (sequence.isSequence(Expression.ELEMENT)) {
            expression = this.globalConverter.convertElement(sequence);
        } else if (sequence.isSequence(Expression.DISJUNCTIVE)) {
            expression = this.globalConverter.convertDisjunctive(sequence);
        } else if (sequence.isSequence(Expression.LEX_LESS)) {
            expression = this.globalConverter.convertLex_less(sequence);
        } else if (sequence.isSequence(Expression.LEX_LESSEQ)) {
            expression = this.globalConverter.convertLex_lesseq(sequence);
        } else if (sequence.isSequence(Expression.NVALUE)) {
            expression = this.globalConverter.convertNvalue(sequence);
        } else if (sequence.isSequence(Expression.COUNT)) {
            expression = this.globalConverter.convertCount(sequence);
        } else if (sequence.isSequence(Expression.GLOBAL_CARDINALITY)) {
            expression = this.globalConverter.convertGlobal_cardinality(sequence);
        } else if (sequence.isSequence(Expression.GLOBAL_CARDINALITY_WITH_COSTS)) {
            expression = this.globalConverter.convertGlobal_cardinality_with_costs(sequence);
        } else {
            this.syntaxError(sequence);
        }
        return expression;
    }

    private List<Clause> convertConstraint(Expression object, boolean bl) throws SugarException {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        while (true) {
            Object object2;
            Object object3;
            Expression expression;
            if (hooks != null) {
                expression = null;
                object3 = hooks.iterator();
                while (object3.hasNext() && (expression = (object2 = object3.next()).convertConstraint(this, (Expression)object, bl, arrayList)) != null) {
                    object = expression;
                }
                if (expression == null) break;
            }
            if (((Expression)object).isAtom()) {
                this.convertAtom((Expression)object, bl, arrayList);
                break;
            }
            expression = (Sequence)object;
            if (OPT_PEEPHOLE && (object3 = this.expressionOptimizer.peephole((Sequence)expression, bl)) != null) {
                object = object3;
                bl = false;
                continue;
            }
            if (((Sequence)expression).isSequence(Expression.HOLD)) {
                object3 = new Clause(new HoldLiteral(((Sequence)expression).get(1), bl));
                arrayList.add((Clause)object3);
                break;
            }
            if (this.definitionConverter.isPredicate((Sequence)expression)) {
                object = this.definitionConverter.convertPredicate((Sequence)expression);
                continue;
            }
            if (this.definitionConverter.isRelation((Sequence)expression)) {
                if (DECOMPOSE_RELATION) {
                    object3 = (RelationLiteral)this.definitionConverter.convertRelation((Sequence)expression, bl);
                    object2 = new ArrayList();
                    object2.add(Expression.AND);
                    List<RelationLiteral.Brick> list = ((RelationLiteral)object3).getConflictBricks();
                    for (RelationLiteral.Brick brick : list) {
                        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                        arrayList2.add(Expression.AND);
                        for (int i = 0; i < ((RelationLiteral)object3).arity; ++i) {
                            Expression expression2 = Expression.create(((RelationLiteral)object3).vs[i].getName());
                            arrayList2.add(expression2.ge(brick.lb[i]));
                            arrayList2.add(expression2.le(brick.ub[i]));
                        }
                        object2.add(Expression.create(arrayList2).not());
                    }
                    object = Expression.create((List<Expression>)object2);
                    continue;
                }
                object3 = this.definitionConverter.convertRelation((Sequence)expression, bl);
                arrayList.add(new Clause((Literal)object3));
                break;
            }
            if (Expression.isLogical(expression)) {
                if (((Sequence)expression).isSequence(Expression.NOT)) {
                    this.checkArity(expression, 1);
                    object = ((Sequence)expression).get(1);
                    bl = !bl;
                    continue;
                }
                object = this.convertLogical((Sequence)expression, bl, arrayList);
                if (object != null) continue;
                break;
            }
            if (Expression.isComparison(expression)) {
                if (!LINEARIZE) {
                    object = expression.hold();
                    continue;
                }
                object = this.convertComparison((Sequence)expression, bl, arrayList);
                if (object != null) continue;
                break;
            }
            if (Expression.isGlobalConstraint(expression)) {
                object = this.convertGlobal((Sequence)expression, bl, arrayList);
                if (object != null) continue;
                break;
            }
            if (((Sequence)expression).isSequence(Expression.LABEL) && ((Sequence)expression).matches("WI")) {
                int n = ((Sequence)expression).get(1).integerValue();
                object2 = new LabelLiteral(n);
                arrayList.add(new Clause((Literal)object2));
                break;
            }
            this.syntaxError((Expression)object);
        }
        return arrayList;
    }

    protected void convertConstraint(Expression expression) throws SugarException {
        List<Clause> list = this.convertConstraint(expression, false);
        if (list.size() > 0) {
            if (expression.getComment() == null) {
                list.get(0).setComment(expression.toString());
            } else {
                list.get(0).setComment(expression.getComment());
            }
        }
        for (Clause clause : list) {
            this.csp.add(clause);
            if (!INCREMENTAL_PROPAGATION) continue;
            clause.propagate();
        }
    }

    public Expression convertHold(Expression expression) throws SugarException {
        while (!expression.isAtom()) {
            Sequence sequence = (Sequence)expression;
            if (this.definitionConverter.isPredicate(sequence)) {
                expression = this.definitionConverter.convertPredicate(sequence);
                continue;
            }
            Expression[] expressionArray = new Expression[sequence.length()];
            boolean bl = false;
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = this.convertHold(sequence.get(i));
                bl = bl || expressionArray[i].equals(sequence.get(i));
            }
            if (!bl) break;
            expression = Expression.create(expressionArray);
            break;
        }
        return expression;
    }

    public void convertExpression(Expression expression) throws SugarException {
        if (SugarMain.debug >= 2) {
            System.out.println("Converting " + expression);
        }
        if (expression.isSequence(Expression.DOMAIN_DEFINITION)) {
            this.definitionConverter.convertDomainDefinition((Sequence)expression);
        } else if (expression.isSequence(Expression.INT_DEFINITION)) {
            this.definitionConverter.convertIntDefinition((Sequence)expression, false);
        } else if (expression.isSequence(Expression.DINT_DEFINITION)) {
            this.definitionConverter.convertIntDefinition((Sequence)expression, true);
        } else if (expression.isSequence(Expression.BOOL_DEFINITION)) {
            this.definitionConverter.convertBoolDefinition((Sequence)expression, false);
        } else if (expression.isSequence(Expression.DBOOL_DEFINITION)) {
            this.definitionConverter.convertBoolDefinition((Sequence)expression, true);
        } else if (expression.isSequence(Expression.PREDICATE_DEFINITION)) {
            this.definitionConverter.convertPredicateDefinition((Sequence)expression);
        } else if (expression.isSequence(Expression.RELATION_DEFINITION)) {
            this.definitionConverter.convertRelationDefinition((Sequence)expression);
        } else if (expression.isSequence(Expression.OBJECTIVE_DEFINITION)) {
            this.definitionConverter.convertObjectiveDefinition((Sequence)expression);
        } else if (expression.isSequence(Expression.GROUPS_DEFINITION)) {
            this.definitionConverter.convertGroupsDefinition((Sequence)expression);
        } else if (HOLD_CONSTRAINTS) {
            expression = this.convertHold(expression);
            this.convertConstraint(Expression.create(Expression.HOLD, expression));
        } else {
            this.convertConstraint(expression);
        }
    }

    public void convert(Expression expression) throws SugarException {
        this.convertExpression(expression);
        while (this.extra.size() > 0) {
            Expression expression2 = this.extra.remove(0);
            this.convertExpression(expression2);
        }
    }

    public void convert(List<Expression> list) throws SugarException {
        int n = list.size();
        int n2 = 10;
        int n3 = 0;
        for (Expression expression : list) {
            this.convertExpression(expression);
            if (100 * ++n3 / n < n2) continue;
            Logger.fine("converted " + n3 + " (" + n2 + "%) expressions");
            n2 += 10;
        }
        while (this.extra.size() > 0) {
            Expression expression = this.extra.remove(0);
            this.convertExpression(expression);
            if (++n3 % 1000 != 0) continue;
            Logger.fine("converted " + n3 + " extra expressions, remaining " + this.extra.size());
        }
    }

    public Clause reduce(Clause clause) throws SugarException {
        Clause clause2 = new Clause();
        for (Literal literal : clause.getLiterals()) {
            if (literal instanceof LinearLiteral) {
                literal = this.comparisonConverter.reduceArity((LinearLiteral)literal);
            }
            clause2.add(literal);
        }
        return clause2;
    }

    public void reduceAll() throws SugarException {
        List<Clause> list = this.csp.getClauses();
        this.csp.setClauses(new ArrayList<Clause>());
        for (Clause clause : list) {
            Clause clause2 = this.reduce(clause);
            this.csp.add(clause2);
        }
        while (this.extra.size() > 0) {
            Expression expression = this.extra.remove(0);
            this.convertExpression(expression);
        }
    }

    private class EquivMap
    extends LinkedHashMap<Expression, IntegerVariable> {
        private static final long serialVersionUID = -4882267868872050198L;

        EquivMap() {
            super(100, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Expression, IntegerVariable> entry) {
            return this.size() > MAX_EQUIVMAP_SIZE;
        }
    }
}

