/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.csp.Predicate;
import jp.kobe_u.sugar.csp.Relation;
import jp.kobe_u.sugar.csp.RelationLiteral;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class DefinitionConverter {
    private Converter converter;
    private CSP csp;
    private Map<String, IntegerDomain> domainMap;
    private Map<String, IntegerVariable> intMap;
    private Map<String, BooleanVariable> boolMap;
    private Map<String, Predicate> predicateMap;
    private Map<String, Relation> relationMap;

    public DefinitionConverter(Converter converter) {
        this.converter = converter;
        this.csp = converter.csp;
        this.domainMap = new HashMap<String, IntegerDomain>();
        this.intMap = new HashMap<String, IntegerVariable>();
        this.boolMap = new HashMap<String, BooleanVariable>();
        this.predicateMap = new HashMap<String, Predicate>();
        this.relationMap = new HashMap<String, Relation>();
    }

    private IntegerDomain convertRanges(Sequence sequence) throws SugarException {
        int[][] nArray = new int[sequence.length()][2];
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.get(i).isInteger()) {
                int n = sequence.get(i).integerValue();
                nArray[i] = new int[]{n, n};
                continue;
            }
            if (sequence.get(i).isSequence()) {
                Sequence sequence2 = (Sequence)sequence.get(i);
                if (sequence2.matches("II")) {
                    int n;
                    int n2 = ((Sequence)sequence.get(i)).get(0).integerValue();
                    if (n2 > (n = ((Sequence)sequence.get(i)).get(1).integerValue().intValue())) {
                        throw new SugarException("Bad domain definition " + sequence);
                    }
                    nArray[i] = new int[]{n2, n};
                    continue;
                }
                throw new SugarException("Bad domain definition " + sequence);
            }
            throw new SugarException("Bad domain definition " + sequence);
        }
        if (nArray.length == 0) {
            throw new SugarException("Bad definition " + sequence);
        }
        if (nArray.length == 1) {
            return IntegerDomain.create(nArray[0][0], nArray[0][1]);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int[] nArray2 : nArray) {
            for (int i = nArray2[0]; i <= nArray2[1]; ++i) {
                treeSet.add(i);
            }
        }
        return IntegerDomain.create(treeSet);
    }

    protected void convertDomainDefinition(Sequence sequence) throws SugarException {
        String string = null;
        IntegerDomain integerDomain = null;
        if (sequence.matches("WWII")) {
            string = sequence.get(1).stringValue();
            int n = sequence.get(2).integerValue();
            int n2 = sequence.get(3).integerValue();
            integerDomain = IntegerDomain.create(n, n2);
        } else if (sequence.matches("WWI")) {
            string = sequence.get(1).stringValue();
            int n = sequence.get(2).integerValue();
            integerDomain = IntegerDomain.create(n, n);
        } else if (sequence.matches("WWS")) {
            string = sequence.get(1).stringValue();
            integerDomain = this.convertRanges((Sequence)sequence.get(2));
        } else {
            throw new SugarException("Bad definition " + sequence);
        }
        if (this.domainMap.containsKey(string)) {
            throw new SugarException("Duplicated definition " + sequence);
        }
        this.domainMap.put(string, integerDomain);
    }

    protected void convertIntDefinition(Sequence sequence, boolean bl) throws SugarException {
        Object object;
        String string = null;
        IntegerDomain integerDomain = null;
        if (sequence.matches("WWW")) {
            string = sequence.get(1).stringValue();
            object = sequence.get(2).stringValue();
            integerDomain = this.domainMap.get(object);
        } else if (sequence.matches("WWII")) {
            string = sequence.get(1).stringValue();
            int n = sequence.get(2).integerValue();
            int n2 = sequence.get(3).integerValue();
            integerDomain = IntegerDomain.create(n, n2);
        } else if (sequence.matches("WWI")) {
            string = sequence.get(1).stringValue();
            int n = sequence.get(2).integerValue();
            integerDomain = IntegerDomain.create(n, n);
        } else if (sequence.matches("WWS")) {
            string = sequence.get(1).stringValue();
            integerDomain = this.convertRanges((Sequence)sequence.get(2));
        } else {
            throw new SugarException("Bad definition " + sequence);
        }
        if (integerDomain == null) {
            throw new SugarException("Unknown domain " + sequence);
        }
        object = new IntegerVariable(string, integerDomain);
        ((IntegerVariable)object).setDominant(bl);
        this.csp.add((IntegerVariable)object);
        this.intMap.put(string, (IntegerVariable)object);
    }

    protected BooleanVariable toBool(String string) {
        return this.boolMap.get(string);
    }

    protected void convertBoolDefinition(Sequence sequence, boolean bl) throws SugarException {
        String string = null;
        if (!sequence.matches("WW")) {
            throw new SugarException("Bad definition " + sequence);
        }
        string = sequence.get(1).stringValue();
        BooleanVariable booleanVariable = new BooleanVariable(string);
        booleanVariable.setDominant(bl);
        this.csp.add(booleanVariable);
        this.boolMap.put(string, booleanVariable);
    }

    protected void convertPredicateDefinition(Sequence sequence) throws SugarException {
        if (!sequence.matches("WSS")) {
            this.converter.syntaxError(sequence);
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        String string = sequence2.get(0).stringValue();
        Sequence sequence3 = (Sequence)sequence.get(2);
        Predicate predicate = new Predicate(sequence2, sequence3);
        this.predicateMap.put(string, predicate);
    }

    protected void convertRelationDefinition(Sequence sequence) throws SugarException {
        if (!sequence.matches("WWIS")) {
            this.converter.syntaxError(sequence);
        }
        String string = sequence.get(1).stringValue();
        int n = sequence.get(2).integerValue();
        Sequence sequence2 = (Sequence)sequence.get(3);
        Relation relation = new Relation(string, n, sequence2);
        this.relationMap.put(string, relation);
        this.csp.addRelation(relation);
    }

    protected boolean isPredicate(Sequence sequence) {
        return sequence.length() > 0 && sequence.get(0).isString() && this.predicateMap.containsKey(sequence.get(0).stringValue());
    }

    protected Expression convertPredicate(Sequence sequence) throws SugarException {
        String string = sequence.get(0).stringValue();
        Predicate predicate = this.predicateMap.get(string);
        if (predicate == null) {
            throw new SugarException("Undefined predicate " + string + " in " + sequence);
        }
        Expression[] expressionArray = new Expression[sequence.length() - 1];
        for (int i = 1; i < sequence.length(); ++i) {
            expressionArray[i - 1] = sequence.get(i);
        }
        Expression expression = predicate.apply(expressionArray);
        return expression;
    }

    protected boolean isRelation(Sequence sequence) {
        return sequence.length() > 0 && this.relationMap.containsKey(sequence.get(0).stringValue());
    }

    protected Literal convertRelation(Sequence sequence, boolean bl) throws SugarException {
        String string = sequence.get(0).stringValue();
        Relation relation = this.relationMap.get(string);
        if (relation == null) {
            throw new SugarException("Undefined relation " + string + " in " + sequence);
        }
        IntegerVariable[] integerVariableArray = new IntegerVariable[sequence.length() - 1];
        for (int i = 1; i < sequence.length(); ++i) {
            IntegerVariable integerVariable = this.intMap.get(sequence.get(i).stringValue());
            if (integerVariable == null) {
                this.converter.syntaxError(sequence);
            }
            integerVariableArray[i - 1] = integerVariable;
        }
        return new RelationLiteral(relation.name, relation.arity, bl, relation.conflicts, relation.tuples, integerVariableArray);
    }

    protected void convertObjectiveDefinition(Sequence sequence) throws SugarException {
        CSP.Objective objective = null;
        if (sequence.matches("WWW*")) {
            if (sequence.get(1).equals(Expression.MINIMIZE)) {
                objective = CSP.Objective.MINIMIZE;
            } else if (sequence.get(1).equals(Expression.MAXIMIZE)) {
                objective = CSP.Objective.MAXIMIZE;
            }
        }
        if (objective == null) {
            throw new SugarException("Bad definition " + sequence);
        }
        ArrayList<IntegerVariable> arrayList = new ArrayList<IntegerVariable>();
        for (int i = 2; i < sequence.length(); ++i) {
            String string = sequence.get(i).stringValue();
            if (string == null) {
                throw new SugarException("Bad definition " + sequence);
            }
            IntegerVariable integerVariable = this.intMap.get(string);
            if (integerVariable == null) {
                throw new SugarException("Unknown objective variable " + string);
            }
            arrayList.add(integerVariable);
        }
        this.csp.setObjectiveVariables(arrayList);
        this.csp.setObjective(objective);
    }

    protected void convertGroupsDefinition(Sequence sequence) throws SugarException {
        Object var2_2 = null;
        if (!sequence.matches("WII")) {
            throw new SugarException("Bad definition " + sequence);
        }
        int n = sequence.get(1).integerValue();
        int n2 = sequence.get(2).integerValue();
        this.csp.setGroups(n);
        this.csp.setTopWeight(n2);
    }
}

