/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class ExpressionOptimizer {
    private static Expression ZERO = Expression.ZERO;
    private static Expression ANY = Expression.ANY;
    private static Expression leMulZero = ANY.mul(ANY).le(ZERO);
    private static Expression gtMulZero = ANY.mul(ANY).gt(ZERO);
    private Converter converter;

    public ExpressionOptimizer(Converter converter) {
        this.converter = converter;
    }

    private boolean isEq(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.EQ) || bl && sequence.isSequence(Expression.NE);
    }

    private boolean isNe(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.NE) || bl && sequence.isSequence(Expression.EQ);
    }

    private boolean isLe(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.LE) || bl && sequence.isSequence(Expression.GT);
    }

    private boolean isLt(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.LT) || bl && sequence.isSequence(Expression.GE);
    }

    private boolean isGe(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.GE) || bl && sequence.isSequence(Expression.LT);
    }

    private boolean isGt(Sequence sequence, boolean bl) {
        return !bl && sequence.isSequence(Expression.GT) || bl && sequence.isSequence(Expression.LE);
    }

    private Expression peepholeMulZero(Sequence sequence, boolean bl) throws SugarException {
        if (this.isEq(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression2 = ((Sequence)sequence.get(1)).get(2);
                Expression expression3 = expression.eq(ZERO).or(expression2.eq(ZERO));
                return expression3;
            }
            if (sequence.get(2).isSequence(Expression.MUL) && sequence.get(1).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression4 = ((Sequence)sequence.get(2)).get(2);
                Expression expression5 = expression.eq(ZERO).or(expression4.eq(ZERO));
                return expression5;
            }
        } else if (this.isNe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression6 = ((Sequence)sequence.get(1)).get(2);
                Expression expression7 = expression.ne(ZERO).and(expression6.ne(ZERO));
                return expression7;
            }
            if (sequence.get(2).isSequence(Expression.MUL) && sequence.get(1).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression8 = ((Sequence)sequence.get(2)).get(2);
                Expression expression9 = expression.ne(ZERO).and(expression8.ne(ZERO));
                return expression9;
            }
        } else if (this.isLe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression10 = ((Sequence)sequence.get(1)).get(2);
                Expression expression11 = expression.lt(ZERO).and(expression10.gt(ZERO)).or(expression.gt(ZERO).and(expression10.lt(ZERO))).or(expression.eq(ZERO)).or(expression10.eq(ZERO));
                return expression11;
            }
            if (sequence.get(2).isSequence(Expression.MUL) && sequence.get(1).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression12 = ((Sequence)sequence.get(2)).get(2);
                Expression expression13 = expression.lt(ZERO).and(expression12.lt(ZERO)).or(expression.gt(ZERO).and(expression12.gt(ZERO))).or(expression.eq(ZERO)).or(expression12.eq(ZERO));
                return expression13;
            }
        } else if (this.isLt(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression14 = ((Sequence)sequence.get(1)).get(2);
                Expression expression15 = expression.lt(ZERO).and(expression14.gt(ZERO)).or(expression.gt(ZERO).and(expression14.lt(ZERO)));
                return expression15;
            }
            if (sequence.get(2).isSequence(Expression.MUL) && sequence.get(1).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression16 = ((Sequence)sequence.get(1)).get(2);
                Expression expression17 = expression.lt(ZERO).and(expression16.lt(ZERO)).or(expression.gt(ZERO).and(expression16.gt(ZERO)));
                return expression17;
            }
        } else if (this.isGe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression18 = ((Sequence)sequence.get(1)).get(2);
                Expression expression19 = expression.lt(ZERO).and(expression18.lt(ZERO)).or(expression.gt(ZERO).and(expression18.gt(ZERO))).or(expression.eq(ZERO)).or(expression18.eq(ZERO));
                return expression19;
            }
            if (sequence.get(2).isSequence(Expression.MUL) && sequence.get(1).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression20 = ((Sequence)sequence.get(2)).get(2);
                Expression expression21 = expression.lt(ZERO).and(expression20.gt(ZERO)).or(expression.gt(ZERO).and(expression20.lt(ZERO))).or(expression.eq(ZERO)).or(expression20.eq(ZERO));
                return expression21;
            }
        } else if (this.isGt(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.MUL) && sequence.get(2).equals(ZERO)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression22 = ((Sequence)sequence.get(1)).get(2);
                Expression expression23 = expression.lt(ZERO).and(expression22.lt(ZERO)).or(expression.gt(ZERO).and(expression22.gt(ZERO)));
                return expression23;
            }
            if (sequence.get(1).equals(ZERO) && sequence.get(2).isSequence(Expression.MUL)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression24 = ((Sequence)sequence.get(2)).get(2);
                Expression expression25 = expression.lt(ZERO).and(expression24.gt(ZERO)).or(expression.gt(ZERO).and(expression24.lt(ZERO)));
                return expression25;
            }
        }
        return null;
    }

    private Expression peepholeAbs(Sequence sequence, boolean bl) throws SugarException {
        if (this.isEq(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression2 = sequence.get(2);
                Expression expression3 = expression.le(expression2).and(expression.ge(expression2.neg())).and(expression.ge(expression2).or(expression.le(expression2.neg())));
                return expression3;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression4 = sequence.get(1);
                Expression expression5 = expression.le(expression4).and(expression.ge(expression4.neg())).and(expression.ge(expression4).or(expression.le(expression4.neg())));
                return expression5;
            }
        } else if (this.isNe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression6 = sequence.get(2);
                Expression expression7 = expression.lt(expression6).and(expression.gt(expression6.neg())).or(expression.gt(expression6).or(expression.lt(expression6.neg())));
                return expression7;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression8 = sequence.get(1);
                Expression expression9 = expression.lt(expression8).and(expression.gt(expression8.neg())).or(expression.gt(expression8).or(expression.lt(expression8.neg())));
                return expression9;
            }
        } else if (this.isLe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression10 = sequence.get(2);
                Expression expression11 = expression.le(expression10).and(expression.ge(expression10.neg()));
                return expression11;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression12 = sequence.get(1);
                Expression expression13 = expression.ge(expression12).or(expression.le(expression12.neg()));
                return expression13;
            }
        } else if (this.isLt(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression14 = sequence.get(2);
                Expression expression15 = expression.lt(expression14).and(expression.gt(expression14.neg()));
                return expression15;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression16 = sequence.get(1);
                Expression expression17 = expression.gt(expression16).or(expression.lt(expression16.neg()));
                return expression17;
            }
        } else if (this.isGe(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression18 = sequence.get(2);
                Expression expression19 = expression.ge(expression18).or(expression.le(expression18.neg()));
                return expression19;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression20 = sequence.get(1);
                Expression expression21 = expression.le(expression20).and(expression.ge(expression20.neg()));
                return expression21;
            }
        } else if (this.isGt(sequence, bl)) {
            this.converter.checkArity(sequence, 2);
            if (sequence.get(1).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(1)).get(1);
                Expression expression22 = sequence.get(2);
                Expression expression23 = expression.gt(expression22).or(expression.lt(expression22.neg()));
                return expression23;
            }
            if (sequence.get(2).isSequence(Expression.ABS)) {
                Expression expression = ((Sequence)sequence.get(2)).get(1);
                Expression expression24 = sequence.get(1);
                Expression expression25 = expression.lt(expression24).and(expression.gt(expression24.neg()));
                return expression25;
            }
        }
        return null;
    }

    protected Expression peephole(Sequence sequence, boolean bl) throws SugarException {
        Expression expression = null;
        expression = this.peepholeMulZero(sequence, bl);
        if (expression != null) {
            return expression;
        }
        if (Converter.OPT_PEEPHOLE_ABS && (expression = this.peepholeAbs(sequence, bl)) != null) {
            return expression;
        }
        return null;
    }
}

