/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class GlobalConverter {
    private Converter converter;

    public GlobalConverter(Converter converter) {
        this.converter = converter;
    }

    private LinearSum convertFormula(Expression expression) throws SugarException {
        return this.converter.comparisonConverter.convertFormula(expression);
    }

    private IntegerVariable toIntegerVariable(Expression expression) throws SugarException {
        return this.converter.toIntegerVariable(expression);
    }

    protected Expression convertAllDifferent(Sequence sequence) throws SugarException {
        int n;
        Object object;
        int n2;
        Object object2;
        if (sequence.length() != 2 || !sequence.get(1).isSequence()) {
            object2 = new ArrayList();
            for (n2 = 1; n2 < sequence.length(); ++n2) {
                object2.add(sequence.get(n2));
            }
            sequence = (Sequence)Expression.alldifferent(new Sequence((Collection<Expression>)object2));
        }
        object2 = (Sequence)sequence.get(1);
        n2 = ((Sequence)object2).length();
        if (Converter.REPLACE_ARGUMENTS) {
            object = new ArrayList();
            for (Expression expression : ((Sequence)object2).getExpressions()) {
                if (expression.isAtom()) {
                    object.add(expression);
                    continue;
                }
                IntegerVariable integerVariable = this.toIntegerVariable(expression);
                object.add(Expression.create(integerVariable.getName()));
            }
            object2 = (Sequence)Expression.create((List<Expression>)object);
            sequence = (Sequence)Expression.create(Expression.ALLDIFFERENT, (Expression)object2);
        }
        if (!Converter.DECOMPOSE_ALLDIFFERENT) {
            object = sequence.hold();
        } else {
            Expression[] expressionArray = new ArrayList();
            expressionArray.add(Expression.AND);
            for (n = 0; n < n2; ++n) {
                for (int i = n + 1; i < n2; ++i) {
                    expressionArray.add(((Sequence)object2).get(n).ne(((Sequence)object2).get(i)));
                }
            }
            object = Expression.create((List<Expression>)expressionArray);
        }
        if (Converter.HINT_ALLDIFF_PIGEON) {
            int n3 = Integer.MAX_VALUE;
            n = Integer.MIN_VALUE;
            for (Expression expression : ((Sequence)object2).getExpressions()) {
                IntegerDomain integerDomain = this.convertFormula(expression).getDomain();
                n3 = Math.min(n3, integerDomain.getLowerBound());
                n = Math.max(n, integerDomain.getUpperBound());
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(Expression.AND);
            ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
            arrayList2.add(Expression.AND);
            for (Expression expression : ((Sequence)object2).getExpressions()) {
                arrayList.add(expression.lt(Expression.create(n3 + n2 - 1)));
                arrayList2.add(expression.gt(Expression.create(n - n2 + 1)));
            }
            object = ((Expression)object).and(Expression.create(arrayList).not()).and(Expression.create(arrayList2).not());
        }
        return object;
    }

    protected Expression convertWeightedSum(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 3);
        if (!sequence.get(1).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_WEIGHTEDSUM) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Expression expression = sequence.get(2);
        Expression expression2 = sequence.get(3);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.ADD);
        for (Expression expression3 : sequence2.getExpressions()) {
            if (!expression3.isSequence()) {
                this.converter.syntaxError(sequence);
            }
            Sequence sequence3 = (Sequence)expression3;
            this.converter.checkArity(sequence3, 1);
            int n = sequence3.get(0).integerValue();
            if (n == 1) {
                arrayList.add(sequence3.get(1));
                continue;
            }
            if (n == -1) {
                arrayList.add(sequence3.get(1).neg());
                continue;
            }
            arrayList.add(sequence3.get(0).mul(sequence3.get(1)));
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(expression);
        arrayList2.add(Expression.create(arrayList));
        arrayList2.add(expression2);
        Expression expression4 = Expression.create(arrayList2);
        return expression4;
    }

    protected Expression convertCumulative(Sequence sequence) throws SugarException {
        Object object;
        Object object2;
        Expression expression;
        Object object3;
        Expression expression2;
        int n;
        this.converter.checkArity(sequence, 2);
        if (!sequence.get(1).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_CUMULATIVE) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Expression expression3 = sequence.get(2);
        int n2 = sequence2.length();
        Expression[] expressionArray = new Expression[n2];
        Expression[] expressionArray2 = new Expression[n2];
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.AND);
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (n = 0; n < n2; ++n) {
            if (!sequence2.get(n).isSequence(3)) {
                this.converter.syntaxError(sequence);
            }
            expression2 = (Sequence)sequence2.get(n);
            object3 = ((Sequence)expression2).get(0);
            Expression expression4 = ((Sequence)expression2).get(1);
            expression = ((Sequence)expression2).get(2);
            if (object3.equals(Expression.NIL)) {
                expressionArray[n] = expression.sub(expression4);
                expressionArray2[n] = expression;
            } else if (expression4.equals(Expression.NIL)) {
                expressionArray[n] = object3;
                expressionArray2[n] = expression;
            } else if (expression.equals(Expression.NIL)) {
                expressionArray[n] = object3;
                expressionArray2[n] = ((Expression)object3).add(expression4);
            } else {
                arrayList.add(((Expression)object3).add(expression4).eq(expression));
                expressionArray[n] = object3;
                expressionArray2[n] = expression;
            }
            object2 = this.convertFormula(expressionArray[n]).getDomain();
            object = this.convertFormula(expressionArray2[n]).getDomain();
            n3 = Math.min(n3, ((IntegerDomain)object2).getLowerBound());
            n4 = Math.max(n4, ((IntegerDomain)object).getUpperBound() - 1);
        }
        for (n = n3; n <= n4; ++n) {
            expression2 = Expression.create(n);
            object3 = new ArrayList<Expression>();
            object3.add(Expression.ADD);
            for (int i = 0; i < n2; ++i) {
                expression = (Sequence)sequence2.get(i);
                object2 = ((Sequence)expression).get(3);
                object = Expression.create(Expression.IF, expressionArray[i].le(expression2).and(expressionArray2[i].gt(expression2)), Expression.ONE, Expression.ZERO);
                object3.add(((Expression)object2).mul((Expression)object));
            }
            arrayList.add(Expression.create((List<Expression>)object3).le(expression3));
        }
        Expression expression5 = Expression.create(arrayList);
        return expression5;
    }

    protected Expression convertElement(Sequence sequence) throws SugarException {
        Expression expression;
        if (!sequence.isSequence(3) && !sequence.isSequence(4)) {
            this.converter.syntaxError(sequence);
        }
        if (!sequence.get(2).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_ELEMENT) {
            return sequence.hold();
        }
        Expression expression2 = sequence.get(1);
        Sequence sequence2 = (Sequence)sequence.get(2);
        Expression expression3 = Expression.EQ;
        if (sequence.isSequence(3)) {
            expression = sequence.get(3);
        } else {
            expression3 = sequence.get(3);
            expression = sequence.get(4);
        }
        int n = sequence2.length();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.AND);
        arrayList.add(expression2.gt(Expression.ZERO));
        arrayList.add(expression2.le(Expression.create(n)));
        for (int i = 0; i < n; ++i) {
            Expression expression4 = Expression.create(expression3, sequence2.get(i), expression);
            arrayList.add(expression2.eq(Expression.create(i + 1)).imp(expression4));
        }
        Expression expression5 = Expression.create(arrayList);
        return expression5;
    }

    protected Expression convertDisjunctive(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 1);
        if (!sequence.get(1).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_DISJUNCTIVE) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        int n = sequence2.length();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.AND);
        for (int i = 0; i < n; ++i) {
            if (!sequence2.get(i).isSequence(1)) {
                this.converter.syntaxError(sequence);
            }
            Sequence sequence3 = (Sequence)sequence2.get(i);
            Expression expression = sequence3.get(0);
            Expression expression2 = sequence3.get(1);
            for (int j = i + 1; j < n; ++j) {
                Sequence sequence4 = (Sequence)sequence2.get(j);
                Expression expression3 = sequence4.get(0);
                Expression expression4 = sequence4.get(1);
                Expression expression5 = expression.add(expression2).le(expression3);
                Expression expression6 = expression3.add(expression4).le(expression);
                arrayList.add(expression2.eq(0).or(expression4.eq(0)).or(expression5).or(expression6));
            }
        }
        Expression expression = Expression.create(arrayList);
        return expression;
    }

    protected Expression convertLex_less(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        if (!sequence.get(1).isSequence() || !sequence.get(2).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_LEX_LESS) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Sequence sequence3 = (Sequence)sequence.get(2);
        int n = sequence2.length();
        if (n == 0 || n != sequence3.length()) {
            this.converter.syntaxError(sequence);
        }
        Expression expression = sequence2.get(n - 1).lt(sequence3.get(n - 1));
        for (int i = n - 2; i >= 0; --i) {
            Expression expression2 = sequence2.get(i);
            Expression expression3 = sequence3.get(i);
            expression = expression2.le(expression3).and(expression2.eq(expression3).imp(expression));
        }
        return expression;
    }

    protected Expression convertLex_lesseq(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        if (!sequence.get(1).isSequence() || !sequence.get(2).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_LEX_LESSEQ) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Sequence sequence3 = (Sequence)sequence.get(2);
        int n = sequence2.length();
        if (n == 0 || n != sequence3.length()) {
            this.converter.syntaxError(sequence);
        }
        Expression expression = sequence2.get(n - 1).le(sequence3.get(n - 1));
        for (int i = n - 2; i >= 0; --i) {
            Expression expression2 = sequence2.get(i);
            Expression expression3 = sequence3.get(i);
            expression = expression2.le(expression3).and(expression2.eq(expression3).imp(expression));
        }
        return expression;
    }

    protected Expression convertNvalue(Sequence sequence) throws SugarException {
        Expression expression;
        this.converter.checkArity(sequence, 2);
        if (!sequence.get(2).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_NVALUE) {
            return sequence.hold();
        }
        Expression expression2 = sequence.get(1);
        Sequence sequence2 = (Sequence)sequence.get(2);
        int n = sequence2.length();
        if (n == 0) {
            expression = expression2.eq(0);
        } else {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(Expression.ADD);
            for (int i = 0; i < n; ++i) {
                ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                arrayList2.add(Expression.OR);
                for (int j = i + 1; j < n; ++j) {
                    arrayList2.add(sequence2.get(i).eq(sequence2.get(j)));
                }
                if (i < n - 1) {
                    arrayList.add(Expression.create(arrayList2).ifThenElse(Expression.ZERO, Expression.ONE));
                    continue;
                }
                arrayList.add(Expression.ONE);
            }
            Expression expression3 = Expression.create(arrayList);
            expression = expression2.ge(1).and(expression2.le(n)).and(expression2.eq(expression3));
        }
        return expression;
    }

    protected Expression convertCount(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 4);
        if (!Converter.DECOMPOSE_COUNT) {
            return sequence.hold();
        }
        Expression expression = sequence.get(1);
        Sequence sequence2 = (Sequence)sequence.get(2);
        Expression expression2 = sequence.get(3);
        Expression expression3 = sequence.get(4);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.ADD);
        int n = sequence2.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(sequence2.get(i).eq(expression).ifThenElse(Expression.ONE, Expression.ZERO));
        }
        Expression expression4 = Expression.create(expression2, Expression.create(arrayList), expression3);
        return expression4;
    }

    protected Expression convertGlobal_cardinality(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 2);
        if (!sequence.get(1).isSequence() || !sequence.get(2).isSequence()) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_GLOBAL_CARDINALITY) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Sequence sequence3 = (Sequence)sequence.get(2);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.AND);
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        arrayList2.add(Expression.ADD);
        for (int i = 0; i < sequence3.length(); ++i) {
            if (!sequence3.get(i).isSequence(1)) {
                this.converter.syntaxError(sequence);
            }
            Sequence sequence4 = (Sequence)sequence3.get(i);
            Expression expression = sequence4.get(0);
            Expression expression2 = sequence4.get(1);
            arrayList.add(Expression.count(expression, sequence2, Expression.EQ, expression2));
            arrayList2.add(expression2);
        }
        arrayList.add(Expression.create(arrayList2).le(sequence2.length()));
        Expression expression = Expression.create(arrayList);
        return expression;
    }

    protected Expression convertGlobal_cardinality_with_costs(Sequence sequence) throws SugarException {
        this.converter.checkArity(sequence, 4);
        if (!(sequence.get(1).isSequence() && sequence.get(2).isSequence() && sequence.get(3).isSequence())) {
            this.converter.syntaxError(sequence);
        }
        if (!Converter.DECOMPOSE_GLOBAL_CARDINALITY_WITH_COSTS) {
            return sequence.hold();
        }
        Sequence sequence2 = (Sequence)sequence.get(1);
        Sequence sequence3 = (Sequence)sequence.get(2);
        Sequence sequence4 = (Sequence)sequence.get(3);
        Expression expression = sequence.get(4);
        Expression expression2 = Expression.global_cardinality(sequence2, sequence3);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(Expression.ADD);
        for (int i = 0; i < sequence4.length(); ++i) {
            Sequence sequence5;
            if (!sequence4.get(i).isSequence(2)) {
                this.converter.syntaxError(sequence);
            }
            if (!(sequence5 = (Sequence)sequence4.get(i)).get(0).isInteger() || !sequence5.get(1).isInteger()) {
                this.converter.syntaxError(sequence);
            }
            int n = sequence5.get(0).integerValue();
            int n2 = sequence5.get(1).integerValue();
            Expression expression3 = sequence5.get(2);
            if (n < 1 || n > sequence2.length() || n2 < 1 || n2 > sequence3.length()) {
                this.converter.syntaxError(sequence);
            }
            Expression expression4 = sequence2.get(n - 1);
            Expression expression5 = ((Sequence)sequence3.get(n2 - 1)).get(0);
            arrayList.add(expression4.eq(expression5).ifThenElse(expression3, Expression.ZERO));
        }
        Expression expression6 = expression2.and(expression.eq(Expression.create(arrayList)));
        return expression6;
    }
}

