/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.Literal;

public class Simplifier {
    public static boolean USE_SIMPLIFYCACHE = true;
    public static int MAX_SIMPLIFYCACHE_SIZE = 1000;
    private static boolean SIMPLIFY_ALL = true;
    private CSP csp;
    private Map<Literal, BooleanLiteral> simplifyCache;

    public Simplifier(CSP cSP) {
        this.csp = cSP;
        this.simplifyCache = new SimplifyMap();
    }

    private List<Clause> simplify(Clause clause) throws SugarException {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        if (clause.isSimple()) {
            arrayList.add(clause);
        } else {
            List<Literal> list = clause.getLiterals();
            clause = new Clause();
            int n = 0;
            for (Literal literal : list) {
                Clause clause2;
                Object object;
                if (literal.isSimple()) {
                    clause.add(literal);
                    continue;
                }
                if (!SIMPLIFY_ALL && ++n == 1) {
                    clause.add(literal);
                    continue;
                }
                if (USE_SIMPLIFYCACHE && this.simplifyCache.containsKey(literal)) {
                    object = this.simplifyCache.get(literal);
                    clause.add((Literal)object);
                    continue;
                }
                object = new BooleanVariable();
                this.csp.add((BooleanVariable)object);
                BooleanLiteral booleanLiteral = new BooleanLiteral((BooleanVariable)object, false);
                BooleanLiteral booleanLiteral2 = new BooleanLiteral((BooleanVariable)object, true);
                if (Converter.EQUIV_TRANSLATION) {
                    clause2 = new Clause();
                    clause2.add(booleanLiteral2);
                    clause2.add(literal);
                    arrayList.add(clause2);
                    clause2 = new Clause();
                    clause2.add(booleanLiteral);
                    clause2.add(literal.neg());
                    arrayList.add(clause2);
                } else {
                    clause2 = new Clause();
                    clause2.add(booleanLiteral2);
                    clause2.add(literal);
                    arrayList.add(clause2);
                }
                clause.add(booleanLiteral);
                if (!USE_SIMPLIFYCACHE) continue;
                this.simplifyCache.put(literal, booleanLiteral);
            }
            arrayList.add(clause);
        }
        return arrayList;
    }

    public void simplify() throws SugarException {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        for (Clause clause : this.csp.getClauses()) {
            List<Clause> list = this.simplify(clause);
            arrayList.addAll(list);
        }
        this.csp.setClauses(arrayList);
    }

    private class SimplifyMap
    extends LinkedHashMap<Literal, BooleanLiteral> {
        SimplifyMap() {
            super(100, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Literal, BooleanLiteral> entry) {
            return this.size() > MAX_SIMPLIFYCACHE_SIZE;
        }
    }
}

