/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.Literal;

public class BooleanLiteral
extends Literal {
    private BooleanVariable v;
    private boolean negative;

    public BooleanLiteral(BooleanVariable booleanVariable, boolean bl) {
        this.v = booleanVariable;
        this.negative = bl;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public BooleanVariable getBooleanVariable() {
        return this.v;
    }

    public boolean getNegative() {
        return this.negative;
    }

    @Override
    public boolean isValid() throws SugarException {
        return false;
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        return false;
    }

    @Override
    public int propagate() {
        return 0;
    }

    @Override
    public boolean isSatisfied() {
        return this.v.getValue() ^ this.negative;
    }

    @Override
    public Literal neg() throws SugarException {
        return new BooleanLiteral(this.v, !this.negative);
    }

    @Override
    public int getCode() {
        int n = this.v.getCode();
        return this.negative ? -n : n;
    }

    public String toString() {
        String string = this.getBooleanVariable().getName();
        if (this.negative) {
            string = "(not " + string + ")";
        }
        return string;
    }
}

