/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.BitSet;
import jp.kobe_u.sugar.SugarException;

public class BooleanVariable
implements Comparable<BooleanVariable> {
    private static String AUX_NAME_PREFIX = "$B";
    private static int auxBooleanVariablesCount = 0;
    private String name;
    private boolean aux;
    private String comment = null;
    private int code;
    private boolean dominant;
    private boolean value;

    public BooleanVariable(String string) throws SugarException {
        this.name = string;
        this.aux = false;
        if (string.startsWith(AUX_NAME_PREFIX)) {
            int n = Integer.parseInt(string.substring(AUX_NAME_PREFIX.length()));
            if (n > auxBooleanVariablesCount) {
                auxBooleanVariablesCount = n;
            }
            this.aux = true;
        }
    }

    public BooleanVariable() throws SugarException {
        this.name = AUX_NAME_PREFIX + ++auxBooleanVariablesCount;
        this.aux = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAux() {
        return this.aux;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void setDominant(boolean bl) {
        this.dominant = bl;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public int getSatVariablesSize() {
        return 1;
    }

    public void decode(BitSet bitSet) {
        this.setValue(bitSet.get(this.getCode()));
    }

    @Override
    public int compareTo(BooleanVariable booleanVariable) {
        if (this == booleanVariable) {
            return 0;
        }
        if (booleanVariable == null) {
            return 1;
        }
        return this.name.compareTo(booleanVariable.name);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BooleanVariable booleanVariable = (BooleanVariable)object;
        return !(this.name == null ? booleanVariable.name != null : !this.name.equals(booleanVariable.name));
    }

    public String toString() {
        return "(bool " + this.name + ")";
    }
}

