/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.Relation;

public class CSP {
    private List<IntegerVariable> integerVariables;
    private List<BooleanVariable> booleanVariables;
    private List<Relation> relations;
    private List<Clause> clauses;
    private int currentGroupID;
    private HashMap<String, IntegerVariable> integerVariableMap;
    private HashMap<String, BooleanVariable> booleanVariableMap;
    private HashMap<String, Relation> relationMap;
    private List<IntegerVariable> objectiveVariables = null;
    private Objective objective = Objective.NONE;
    private int groups = 0;
    private int topWeight = 0;
    private int integerVariablesSizeSave = 0;
    private int booleanVariablesSizeSave = 0;
    private int clausesSizeSave = 0;

    public CSP() {
        this.integerVariables = new ArrayList<IntegerVariable>();
        this.booleanVariables = new ArrayList<BooleanVariable>();
        this.relations = new ArrayList<Relation>();
        this.clauses = new ArrayList<Clause>();
        this.objective = Objective.NONE;
        this.integerVariableMap = new HashMap();
        this.booleanVariableMap = new HashMap();
        this.relationMap = new HashMap();
    }

    public void commit() {
        this.integerVariablesSizeSave = this.integerVariables.size();
        this.booleanVariablesSizeSave = this.booleanVariables.size();
        this.clausesSizeSave = this.clauses.size();
    }

    public void cancel() {
        int n = this.integerVariablesSizeSave;
        while (this.integerVariablesSizeSave < this.integerVariables.size()) {
            this.integerVariableMap.remove(this.integerVariables.get(n).getName());
            this.integerVariables.remove(n);
        }
        n = this.booleanVariablesSizeSave;
        while (this.booleanVariablesSizeSave < this.booleanVariables.size()) {
            this.booleanVariableMap.remove(this.booleanVariables.get(n).getName());
            this.booleanVariables.remove(n);
        }
        n = this.clausesSizeSave;
        while (this.clausesSizeSave < this.clauses.size()) {
            this.clauses.remove(n);
        }
    }

    public List<IntegerVariable> getObjectiveVariables() {
        return this.objectiveVariables;
    }

    public void setObjectiveVariables(List<IntegerVariable> list) {
        this.objectiveVariables = list;
    }

    public Objective getObjective() {
        return this.objective;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public boolean isMaximize() {
        return this.objective == Objective.MAXIMIZE;
    }

    public boolean isMinimize() {
        return this.objective == Objective.MINIMIZE;
    }

    public int getGroups() {
        return this.groups;
    }

    public void setGroups(int n) {
        this.groups = n;
    }

    public int getTopWeight() {
        return this.topWeight;
    }

    public void setTopWeight(int n) {
        this.topWeight = n;
    }

    public List<IntegerVariable> getIntegerVariables() {
        return this.integerVariables;
    }

    public List<IntegerVariable> getIntegerVariablesDelta() {
        return this.integerVariables.subList(this.integerVariablesSizeSave, this.integerVariables.size());
    }

    public IntegerVariable getIntegerVariable(String string) {
        return this.integerVariableMap.get(string);
    }

    public void add(IntegerVariable integerVariable) throws SugarException {
        String string = integerVariable.getName();
        if (this.integerVariableMap.containsKey(string)) {
            throw new SugarException("Duplicated integer variable " + string);
        }
        this.integerVariableMap.put(integerVariable.getName(), integerVariable);
        this.integerVariables.add(integerVariable);
    }

    public List<BooleanVariable> getBooleanVariables() {
        return this.booleanVariables;
    }

    public List<BooleanVariable> getBooleanVariablesDelta() {
        return this.booleanVariables.subList(this.booleanVariablesSizeSave, this.booleanVariables.size());
    }

    public void add(BooleanVariable booleanVariable) throws SugarException {
        String string = booleanVariable.getName();
        if (this.booleanVariableMap.containsKey(string)) {
            throw new SugarException("Duplicated boolean variable " + string);
        }
        this.booleanVariableMap.put(booleanVariable.getName(), booleanVariable);
        this.booleanVariables.add(booleanVariable);
    }

    public BooleanVariable getBooleanVariable(String string) {
        return this.booleanVariableMap.get(string);
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public Relation getRelation(String string) {
        return this.relationMap.get(string);
    }

    public List<Clause> getClauses() {
        return this.clauses;
    }

    public List<Clause> getClausesDelta() {
        return this.clauses.subList(this.clausesSizeSave, this.clauses.size());
    }

    public void setClauses(List<Clause> list) {
        this.clauses = list;
    }

    public void addRelation(Relation relation) {
        this.relations.add(relation);
        this.relationMap.put(relation.name, relation);
    }

    public void add(Clause clause) {
        this.clauses.add(clause);
    }

    public boolean isUnsatisfiable() throws SugarException {
        for (IntegerVariable object : this.integerVariables) {
            if (!object.isUnsatisfiable()) continue;
            Logger.fine("Unsatisfiable integer variable " + object);
            return true;
        }
        for (Clause clause : this.clauses) {
            if (!clause.isUnsatisfiable()) continue;
            Logger.fine("Unsatisfiable constraint " + clause.toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int propagate() throws SugarException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            void n4;
            ArrayList<Clause> arrayList = new ArrayList<Clause>();
            for (Clause object : this.clauses) {
                if (!object.isModified()) continue;
                arrayList.add(object);
            }
            for (IntegerVariable integerVariable : this.integerVariables) {
                integerVariable.setModified(false);
            }
            n = 0;
            boolean bl = false;
            for (Clause clause : arrayList) {
                n += clause.propagate();
                n4 += clause.removeFalsefood();
            }
            if (n == 0 && n4 == false) break;
            n2 += n;
            n3 += n4;
        }
        int n5 = 0;
        n = 0;
        while (n < this.clauses.size()) {
            if (this.clauses.get(n).isValid()) {
                this.clauses.remove(n);
                ++n5;
                continue;
            }
            ++n;
        }
        Logger.fine(n2 + " values, " + n3 + " unsatisfiable literals, and " + n5 + " valid clauses are removed");
        return n2 + n3 + n5;
    }

    public void compact() throws SugarException {
        throw new SugarException("Unimplemented method compact()");
    }

    public boolean isSatisfied() {
        for (IntegerVariable object : this.integerVariables) {
            if (object.isSatisfied()) continue;
            return false;
        }
        for (Clause clause : this.clauses) {
            if (clause.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    public void outputValues(PrintStream printStream) {
        for (IntegerVariable comparable : this.integerVariables) {
            if (comparable.isAux()) {
                printStream.println(comparable.getName() + " = " + comparable.getValue());
                continue;
            }
            printStream.println(comparable.getName() + " = " + comparable.getValue());
        }
        for (BooleanVariable booleanVariable : this.booleanVariables) {
            if (!booleanVariable.isAux()) {
                printStream.println(booleanVariable.getName() + " = " + booleanVariable.getValue());
                continue;
            }
            printStream.println(booleanVariable.getName() + " = " + booleanVariable.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void output(PrintStream printStream, String string) {
        for (IntegerVariable object : this.integerVariables) {
            if (object.getComment() != null) {
                printStream.print(string + "; ");
                printStream.println(object.getComment());
            }
            printStream.println(string + object.toString());
        }
        for (BooleanVariable booleanVariable : this.booleanVariables) {
            if (booleanVariable.getComment() != null) {
                printStream.print(string + "; ");
                printStream.println(booleanVariable.getComment());
            }
            printStream.println(string + booleanVariable.toString());
        }
        for (Clause clause : this.clauses) {
            if (clause.getComment() != null) {
                printStream.print(string + "; ");
                printStream.println(clause.getComment());
            }
            printStream.println(string + clause.toString());
        }
        List<IntegerVariable> list = this.getObjectiveVariables();
        if (list != null) {
            void var4_12;
            String string2 = "none";
            if (this.objective == Objective.MINIMIZE) {
                String string3 = "minimize";
            } else if (this.objective == Objective.MAXIMIZE) {
                String string4 = "maximize";
            }
            printStream.print(string + "(objective " + (String)var4_12);
            for (IntegerVariable integerVariable : list) {
                printStream.print(" " + integerVariable.getName() + ")");
            }
            printStream.println();
        }
    }

    public String summary() {
        int n = 0;
        for (IntegerVariable integerVariable : this.integerVariables) {
            n = Math.max(n, integerVariable.getDomain().size());
        }
        return this.getIntegerVariables().size() + " integers, " + this.getBooleanVariables().size() + " booleans, " + this.getClauses().size() + " clauses, largest domain size " + n;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.output(printStream, "");
        return byteArrayOutputStream.toString();
    }

    public static enum Objective {
        NONE,
        MAXIMIZE,
        MINIMIZE;

    }
}

