/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.Literal;

public class Clause {
    private List<Literal> literals;
    private Set<IntegerVariable> commonVariables = null;
    private String comment = null;

    public Clause(List<Literal> list) {
        this.literals = list;
    }

    public Clause() {
        this.literals = new ArrayList<Literal>();
    }

    public Clause(Literal literal) {
        this();
        this.literals.add(literal);
    }

    public List<Literal> getLiterals() {
        return this.literals;
    }

    public void addAll(List<Literal> list) {
        this.literals.addAll(list);
    }

    public void add(Literal literal) {
        this.literals.add(literal);
    }

    public int size() {
        return this.literals.size();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean isModified() {
        for (Literal literal : this.literals) {
            Set<IntegerVariable> set = literal.getVariables();
            if (set == null) continue;
            for (IntegerVariable integerVariable : set) {
                if (!integerVariable.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public Set<IntegerVariable> getCommonVariables() {
        if (this.commonVariables == null && this.size() > 0) {
            for (Literal literal : this.literals) {
                Set<IntegerVariable> set = literal.getVariables();
                if (set == null) {
                    this.commonVariables = null;
                    break;
                }
                if (this.commonVariables == null) {
                    this.commonVariables = set;
                    continue;
                }
                TreeSet<IntegerVariable> treeSet = new TreeSet<IntegerVariable>();
                for (IntegerVariable integerVariable : this.commonVariables) {
                    if (!set.contains(integerVariable)) continue;
                    treeSet.add(integerVariable);
                }
                this.commonVariables = treeSet;
            }
            if (this.commonVariables == null) {
                this.commonVariables = new TreeSet<IntegerVariable>();
            }
        }
        return this.commonVariables;
    }

    public int simpleSize() {
        int n = 0;
        for (Literal literal : this.literals) {
            if (!literal.isSimple()) continue;
            ++n;
        }
        return n;
    }

    public boolean isSimple() {
        return this.size() - this.simpleSize() <= 1;
    }

    public boolean isValid() throws SugarException {
        for (Literal literal : this.literals) {
            if (!literal.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnsatisfiable() throws SugarException {
        for (Literal literal : this.literals) {
            if (literal.isUnsatisfiable()) continue;
            return false;
        }
        return true;
    }

    public int propagate() throws SugarException {
        if (this.size() == 0) {
            return 0;
        }
        int n = 0;
        for (IntegerVariable integerVariable : this.getCommonVariables()) {
            int n2;
            int n3;
            int[] nArray = null;
            for (Literal literal : this.literals) {
                int[] nArray2 = literal.getBound(integerVariable);
                if (nArray2 == null) {
                    nArray = null;
                    break;
                }
                if (nArray == null) {
                    nArray = nArray2;
                    continue;
                }
                nArray[0] = Math.min(nArray[0], nArray2[0]);
                nArray[1] = Math.max(nArray[1], nArray2[1]);
            }
            if (nArray == null || (n3 = Math.max(integerVariable.getDomain().getLowerBound(), (int)nArray[0])) > (n2 = Math.min(integerVariable.getDomain().getUpperBound(), nArray[1]))) continue;
            n += integerVariable.bound(nArray[0], nArray[1]);
        }
        return n;
    }

    public int removeFalsefood() throws SugarException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.literals.size()) {
            if (this.literals.get(n2).isUnsatisfiable()) {
                this.literals.remove(n2);
                ++n;
                continue;
            }
            ++n2;
        }
        return n;
    }

    public boolean isSatisfied() {
        for (Literal literal : this.literals) {
            if (!literal.isSatisfied()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.literals.size() == 1) {
            stringBuilder.append(this.literals.get(0).toString());
        } else {
            stringBuilder.append("(or");
            for (Literal literal : this.literals) {
                stringBuilder.append(" ");
                stringBuilder.append(literal.toString());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

