/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.Set;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.expression.Expression;

public class HoldLiteral
extends Literal {
    private Expression expr;
    private boolean negative;

    public HoldLiteral(Expression expression, boolean bl) {
        this.expr = expression;
        this.negative = bl;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public Set<IntegerVariable> getVariables() {
        return null;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isValid() throws SugarException {
        return false;
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        return false;
    }

    @Override
    public int propagate() {
        return 0;
    }

    @Override
    public boolean isSatisfied() {
        return false;
    }

    @Override
    public Literal neg() throws SugarException {
        return new HoldLiteral(this.expr, !this.negative);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.expr == null ? 0 : this.expr.hashCode());
        n = 31 * n + (this.negative ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HoldLiteral holdLiteral = (HoldLiteral)object;
        if (this.expr == null ? holdLiteral.expr != null : !this.expr.equals(holdLiteral.expr)) {
            return false;
        }
        return this.negative == holdLiteral.negative;
    }

    public String toString() {
        if (this.negative) {
            return "(not " + this.expr.toString() + ")";
        }
        return this.expr.toString();
    }
}

