/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.Iterator;
import java.util.SortedSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomainDiet;
import jp.kobe_u.sugar.csp.IntegerDomainIntevals;

public abstract class IntegerDomain {
    public static boolean USE_DIET_DOMAIN = false;

    public static IntegerDomain create(int n, int n2) throws SugarException {
        if (USE_DIET_DOMAIN) {
            return new IntegerDomainDiet(n, n2);
        }
        return new IntegerDomainIntevals(n, n2);
    }

    public static IntegerDomain create(SortedSet<Integer> sortedSet) {
        if (USE_DIET_DOMAIN) {
            return new IntegerDomainDiet(sortedSet);
        }
        return new IntegerDomainIntevals(sortedSet);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract int size();

    public abstract int sizeLE(int var1);

    public abstract boolean contains(int var1);

    public abstract int getLowerBound();

    public abstract int getUpperBound();

    public abstract Iterator<int[]> intervals();

    public abstract Iterator<Integer> values(int var1, int var2) throws SugarException;

    public abstract Iterator<Integer> values() throws SugarException;

    public abstract IntegerDomain bound(int var1, int var2) throws SugarException;

    public abstract IntegerDomain cap(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain cup(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain neg() throws SugarException;

    public abstract IntegerDomain abs() throws SugarException;

    public abstract IntegerDomain add(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain sub(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain mul(int var1) throws SugarException;

    public abstract IntegerDomain mul(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain div(int var1) throws SugarException;

    public abstract IntegerDomain div(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain mod(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain min(IntegerDomain var1) throws SugarException;

    public abstract IntegerDomain max(IntegerDomain var1) throws SugarException;

    private String rangeValues(int n, int n2, boolean bl) {
        if (bl) {
            return n + ".." + n2;
        }
        return "(" + n + " " + n2 + ")";
    }

    public void appendValues(StringBuilder stringBuilder, boolean bl) {
        Iterator<int[]> iterator = this.intervals();
        String string = "";
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            stringBuilder.append(string);
            if (nArray[0] == nArray[1]) {
                stringBuilder.append(nArray[0]);
            } else {
                stringBuilder.append(this.rangeValues(nArray[0], nArray[1], bl));
            }
            string = " ";
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        this.appendValues(stringBuilder, false);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

