/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;

public class IntegerDomainDiet
extends IntegerDomain {
    public static int MAX_SET_SIZE = 128;
    private static Comparator DIET_COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            if (nArray[1] != nArray2[1]) {
                return nArray[1] < nArray2[1] ? -1 : 1;
            }
            if (nArray[0] != nArray2[0]) {
                return nArray[0] < nArray2[0] ? -1 : 1;
            }
            return 0;
        }
    };
    private static IntegerDomainDiet EMPTY = new IntegerDomainDiet();
    private static IntegerDomainDiet ZERO = new IntegerDomainDiet(0, 0);
    private TreeSet<int[]> treeSet = new TreeSet(DIET_COMPARATOR);
    private int size = -1;

    public IntegerDomainDiet() {
    }

    public IntegerDomainDiet(int n, int n2) {
        this();
        this.treeSet.add(new int[]{n, n2});
    }

    public IntegerDomainDiet(SortedSet<Integer> sortedSet) {
        this();
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            if (n == Integer.MIN_VALUE) {
                n = n2 = n3;
                continue;
            }
            if (n2 + 1 == n3) {
                n2 = n3;
                continue;
            }
            if (n == n2) {
                this.treeSet.add(new int[]{n, n});
            } else {
                this.treeSet.add(new int[]{n, n2});
            }
            n = n2 = n3;
        }
        if (n != Integer.MIN_VALUE) {
            if (n == n2) {
                this.treeSet.add(new int[]{n, n});
            } else {
                this.treeSet.add(new int[]{n, n2});
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.treeSet.isEmpty();
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.size = 0;
            for (int[] nArray : this.treeSet) {
                this.size += nArray[1] - nArray[0] + 1;
            }
        }
        return this.size;
    }

    @Override
    public int sizeLE(int n) {
        if (this.getUpperBound() <= n) {
            return this.size();
        }
        int n2 = 0;
        for (int[] nArray : this.treeSet) {
            if (nArray[0] > n) continue;
            n2 += Math.min(nArray[1], n) - nArray[0] + 1;
        }
        return n2;
    }

    @Override
    public boolean contains(int n) {
        int[] nArray = this.treeSet.higher(new int[]{Integer.MIN_VALUE, n});
        return nArray != null && nArray[0] <= n;
    }

    @Override
    public int getLowerBound() {
        return this.treeSet.first()[0];
    }

    @Override
    public int getUpperBound() {
        return this.treeSet.last()[1];
    }

    @Override
    public Iterator<int[]> intervals() {
        return this.treeSet.iterator();
    }

    @Override
    public Iterator<Integer> values() {
        return new IteratorValues();
    }

    @Override
    public Iterator<Integer> values(int n, int n2) throws SugarException {
        return this.bound(n, n2).values();
    }

    @Override
    public IntegerDomain bound(int n, int n2) throws SugarException {
        if (n <= this.getLowerBound() && this.getUpperBound() <= n2) {
            return this;
        }
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        int[] nArray = new int[]{Integer.MIN_VALUE, n};
        for (int[] nArray2 : this.treeSet.tailSet(nArray)) {
            if (nArray2[1] < n) continue;
            if (nArray2[0] < n) {
                integerDomainDiet.treeSet.add(new int[]{n, nArray2[1]});
                continue;
            }
            if (nArray2[0] > n2) break;
            if (nArray2[1] > n2) {
                integerDomainDiet.treeSet.add(new int[]{nArray2[0], n2});
                continue;
            }
            integerDomainDiet.treeSet.add(nArray2);
        }
        return integerDomainDiet;
    }

    public IntegerDomainDiet complement() throws SugarException {
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        if (this.isEmpty()) {
            integerDomainDiet.treeSet.add(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE});
        } else {
            int n = Integer.MAX_VALUE;
            for (int[] nArray : this.treeSet) {
                if (nArray[0] > Integer.MIN_VALUE) {
                    integerDomainDiet.treeSet.add(new int[]{n + 1, nArray[0] - 1});
                }
                n = nArray[1];
            }
            if (n < Integer.MAX_VALUE) {
                integerDomainDiet.treeSet.add(new int[]{n + 1, Integer.MAX_VALUE});
            }
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain cap(IntegerDomain integerDomain) throws SugarException {
        if (this.isEmpty() || integerDomain.isEmpty()) {
            return EMPTY;
        }
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        Iterator<int[]> iterator = this.intervals();
        Iterator<int[]> iterator2 = integerDomain.intervals();
        int[] nArray = iterator.next();
        int[] nArray2 = iterator2.next();
        while (nArray != null && nArray2 != null) {
            if (nArray[1] < nArray2[0]) {
                nArray = null;
            } else if (nArray2[1] < nArray[0]) {
                nArray2 = null;
            } else if (nArray[1] < nArray2[1]) {
                integerDomainDiet.treeSet.add(new int[]{Math.max(nArray[0], nArray2[0]), nArray[1]});
                nArray = null;
            } else {
                integerDomainDiet.treeSet.add(new int[]{Math.max(nArray[0], nArray2[0]), nArray2[1]});
                nArray2 = null;
            }
            if (nArray == null && iterator.hasNext()) {
                nArray = iterator.next();
            }
            if (nArray2 != null || !iterator2.hasNext()) continue;
            nArray2 = iterator2.next();
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain cup(IntegerDomain integerDomain) throws SugarException {
        if (this.isEmpty()) {
            return integerDomain;
        }
        if (integerDomain.isEmpty()) {
            return this;
        }
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        Iterator<int[]> iterator = this.intervals();
        Iterator<int[]> iterator2 = integerDomain.intervals();
        int[] nArray = null;
        int[] nArray2 = null;
        while (true) {
            if (nArray == null && iterator.hasNext()) {
                nArray = iterator.next();
            }
            if (nArray2 == null && iterator2.hasNext()) {
                nArray2 = iterator2.next();
            }
            if (nArray == null || nArray2 == null) break;
            if (nArray[1] + 1 < nArray2[0]) {
                integerDomainDiet.treeSet.add(nArray);
                nArray = null;
                continue;
            }
            if (nArray2[1] + 1 < nArray[0]) {
                integerDomainDiet.treeSet.add(nArray2);
                nArray2 = null;
                continue;
            }
            if (nArray[1] < nArray2[1]) {
                nArray2 = new int[]{Math.min(nArray[0], nArray2[0]), nArray2[1]};
                nArray = null;
                continue;
            }
            nArray = new int[]{Math.min(nArray[0], nArray2[0]), nArray[1]};
            nArray2 = null;
        }
        if (nArray != null) {
            integerDomainDiet.treeSet.add(nArray);
        }
        if (nArray2 != null) {
            integerDomainDiet.treeSet.add(nArray2);
        }
        while (iterator.hasNext()) {
            integerDomainDiet.treeSet.add(iterator.next());
        }
        while (iterator2.hasNext()) {
            integerDomainDiet.treeSet.add(iterator2.next());
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain neg() throws SugarException {
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        for (int[] nArray : this.treeSet) {
            integerDomainDiet.treeSet.add(new int[]{-nArray[1], -nArray[0]});
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain abs() throws SugarException {
        IntegerDomain integerDomain = this.bound(0, Integer.MAX_VALUE);
        IntegerDomain integerDomain2 = this.bound(Integer.MIN_VALUE, -1).neg();
        return integerDomain.cup(integerDomain2);
    }

    private IntegerDomainDiet add(int n) {
        if (this.isEmpty() || n == 0) {
            return this;
        }
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        Iterator<int[]> iterator = this.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            integerDomainDiet.treeSet.add(new int[]{nArray[0] + n, nArray[1] + n});
        }
        return integerDomainDiet;
    }

    private IntegerDomainDiet add(int n, int n2) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (n == n2) {
            return this.add(n);
        }
        IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        Iterator<int[]> iterator = this.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            if (nArray[0] + n <= n4 + 1) {
                n4 = nArray[1] + n2;
                continue;
            }
            if (n4 > Integer.MIN_VALUE) {
                integerDomainDiet.treeSet.add(new int[]{n3, n4});
            }
            n3 = nArray[0] + n;
            n4 = nArray[1] + n2;
        }
        if (n4 > Integer.MIN_VALUE) {
            integerDomainDiet.treeSet.add(new int[]{n3, n4});
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain add(IntegerDomain integerDomain) throws SugarException {
        if (this.isEmpty() || integerDomain.isEmpty()) {
            return EMPTY;
        }
        if (integerDomain.size() < this.size()) {
            return integerDomain.add(this);
        }
        IntegerDomain integerDomain2 = new IntegerDomainDiet();
        Iterator<int[]> iterator = integerDomain.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            integerDomain2 = ((IntegerDomain)integerDomain2).cup(this.add(nArray[0], nArray[1]));
        }
        return integerDomain2;
    }

    @Override
    public IntegerDomain sub(IntegerDomain integerDomain) throws SugarException {
        return this.add(integerDomain.neg());
    }

    @Override
    public IntegerDomain mul(int n) throws SugarException {
        IntegerDomainDiet integerDomainDiet;
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return this;
        }
        if (n < 0) {
            return this.neg().mul(-n);
        }
        if (this.size() <= MAX_SET_SIZE) {
            integerDomainDiet = new IntegerDomainDiet();
            Iterator<Integer> iterator = this.values();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                integerDomainDiet.treeSet.add(new int[]{n2 * n, n2 * n});
            }
        } else {
            integerDomainDiet = new IntegerDomainDiet(this.getLowerBound() * n, this.getUpperBound() * n);
        }
        return integerDomainDiet;
    }

    @Override
    public IntegerDomain mul(IntegerDomain integerDomain) throws SugarException {
        IntegerDomain integerDomain2;
        if (this.isEmpty() || integerDomain.isEmpty()) {
            return EMPTY;
        }
        if (this.size() < integerDomain.size()) {
            return integerDomain.mul(this);
        }
        if (integerDomain.size() <= MAX_SET_SIZE) {
            integerDomain2 = new IntegerDomainDiet();
            Iterator<Integer> iterator = integerDomain.values();
            while (iterator.hasNext()) {
                int n = iterator.next();
                integerDomain2 = ((IntegerDomain)integerDomain2).cup(this.mul(n));
            }
        } else {
            throw new SugarException("Too large IntegerDomainDiet for mul");
        }
        return integerDomain2;
    }

    @Override
    public IntegerDomain div(int n) throws SugarException {
        throw new SugarException("Div is not supported in IntegerDomainDiet");
    }

    @Override
    public IntegerDomain div(IntegerDomain integerDomain) throws SugarException {
        throw new SugarException("Div is not supported in IntegerDomainDiet");
    }

    @Override
    public IntegerDomain mod(IntegerDomain integerDomain) throws SugarException {
        throw new SugarException("Mod is not supported in IntegerDomainDiet");
    }

    @Override
    public IntegerDomain min(IntegerDomain integerDomain) throws SugarException {
        int n;
        int n2 = this.getUpperBound();
        if (n2 == (n = integerDomain.getUpperBound())) {
            return this.cup(integerDomain);
        }
        if (n2 < n) {
            return this.cup(integerDomain.bound(Integer.MIN_VALUE, n2));
        }
        return this.bound(Integer.MIN_VALUE, n).cup(integerDomain);
    }

    @Override
    public IntegerDomain max(IntegerDomain integerDomain) throws SugarException {
        int n;
        int n2 = this.getLowerBound();
        if (n2 == (n = integerDomain.getLowerBound())) {
            return this.cup(integerDomain);
        }
        if (n2 > n) {
            return this.cup(integerDomain.bound(n2, Integer.MAX_VALUE));
        }
        return this.bound(n, Integer.MAX_VALUE).cup(integerDomain);
    }

    public static void main(String[] stringArray) {
        try {
            IntegerDomainDiet integerDomainDiet = new IntegerDomainDiet();
            integerDomainDiet.treeSet.add(new int[]{1, 3});
            integerDomainDiet.treeSet.add(new int[]{20, 21});
            System.out.println(integerDomainDiet);
            IntegerDomainDiet integerDomainDiet2 = new IntegerDomainDiet();
            integerDomainDiet2.treeSet.add(new int[]{2, 5});
            integerDomainDiet2.treeSet.add(new int[]{8, 8});
            System.out.println(integerDomainDiet2);
            System.out.println("complement = " + integerDomainDiet.complement());
            System.out.println("complement^2 = " + integerDomainDiet.complement().complement());
            System.out.println("cap = " + integerDomainDiet.cap(integerDomainDiet2));
            System.out.println("cup = " + integerDomainDiet.cup(integerDomainDiet2));
            System.out.println("add = " + integerDomainDiet.add(integerDomainDiet2));
            System.out.println("sub = " + integerDomainDiet.sub(integerDomainDiet2));
            System.out.println("mul = " + integerDomainDiet.mul(integerDomainDiet2));
            System.out.println("min = " + integerDomainDiet.min(integerDomainDiet2));
            System.out.println("max = " + integerDomainDiet.max(integerDomainDiet2));
            IntegerDomainDiet integerDomainDiet3 = new IntegerDomainDiet();
            integerDomainDiet3.treeSet.add(new int[]{-5, -2});
            integerDomainDiet3.treeSet.add(new int[]{4, 6});
            System.out.println(integerDomainDiet3);
            System.out.println("abs = " + integerDomainDiet3.abs());
        }
        catch (SugarException sugarException) {
            sugarException.printStackTrace();
        }
    }

    private class IteratorValues
    implements Iterator<Integer> {
        Iterator<int[]> iter = null;
        int[] r;
        int value;

        public IteratorValues() {
            if (IntegerDomainDiet.this.size() > 0) {
                this.iter = IntegerDomainDiet.this.intervals();
                this.r = this.iter.next();
                this.value = this.r[0];
            }
        }

        @Override
        public boolean hasNext() {
            return this.iter != null && (this.value <= this.r[1] || this.iter.hasNext());
        }

        @Override
        public Integer next() {
            if (this.value > this.r[1]) {
                this.r = this.iter.next();
                this.value = this.r[0];
            }
            return this.value++;
        }

        @Override
        public void remove() {
        }
    }
}

