/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;

public class IntegerDomainIntevals
extends IntegerDomain {
    public static int MAX_SET_SIZE = 128;
    private int lb;
    private int ub;
    private SortedSet<Integer> domain;

    private static IntegerDomainIntevals _create(SortedSet<Integer> sortedSet) throws SugarException {
        int n = sortedSet.first();
        int n2 = sortedSet.last();
        if (sortedSet.size() <= MAX_SET_SIZE) {
            boolean bl = false;
            for (int i = n; i <= n2; ++i) {
                if (sortedSet.contains(i)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                sortedSet = null;
            }
        } else {
            sortedSet = null;
        }
        if (sortedSet == null) {
            return new IntegerDomainIntevals(n, n2);
        }
        return new IntegerDomainIntevals(sortedSet);
    }

    public IntegerDomainIntevals(int n, int n2) throws SugarException {
        if (n > n2) {
            throw new SugarException("Illegal domain instantiation " + n + " " + n2);
        }
        this.lb = n;
        this.ub = n2;
        this.domain = null;
    }

    public IntegerDomainIntevals(SortedSet<Integer> sortedSet) {
        this.lb = sortedSet.first();
        this.ub = sortedSet.last();
        this.domain = sortedSet;
    }

    public IntegerDomainIntevals(IntegerDomainIntevals integerDomainIntevals) {
        this.lb = integerDomainIntevals.lb;
        this.ub = integerDomainIntevals.ub;
        this.domain = null;
        if (integerDomainIntevals.domain != null) {
            this.domain = new TreeSet<Integer>(integerDomainIntevals.domain);
        }
    }

    @Override
    public int size() {
        if (this.domain == null) {
            return this.lb <= this.ub ? this.ub - this.lb + 1 : 0;
        }
        return this.domain.size();
    }

    private boolean isContiguous() {
        return this.domain == null;
    }

    @Override
    public int getLowerBound() {
        if (this.domain == null) {
            return this.lb;
        }
        return this.domain.first();
    }

    @Override
    public int getUpperBound() {
        if (this.domain == null) {
            return this.ub;
        }
        return this.domain.last();
    }

    private SortedSet<Integer> getSet() {
        return this.domain;
    }

    @Override
    public boolean contains(int n) {
        if (this.domain == null) {
            return this.lb <= n && n <= this.ub;
        }
        return this.domain.contains(n);
    }

    @Override
    public int sizeLE(int n) {
        if (n < this.lb) {
            return 0;
        }
        if (n >= this.ub) {
            return this.size();
        }
        if (this.domain == null) {
            return n - this.lb + 1;
        }
        return this.domain.headSet(n + 1).size();
    }

    @Override
    public IntegerDomain bound(int n, int n2) throws SugarException {
        int n3 = this.getLowerBound();
        int n4 = this.getUpperBound();
        if (n <= n3 && n4 <= n2) {
            return this;
        }
        n = Math.max(n3, n);
        n2 = Math.min(n4, n2);
        if (this.domain == null) {
            return new IntegerDomainIntevals(n, n2);
        }
        return new IntegerDomainIntevals(this.domain.subSet(n, n2 + 1));
    }

    @Override
    public Iterator<Integer> values(int n, int n2) {
        if (n > n2) {
            return new Iter(n, n2);
        }
        if (this.domain == null) {
            n = Math.max(n, this.lb);
            n2 = Math.min(n2, this.ub);
            return new Iter(n, n2);
        }
        return this.domain.subSet(n, n2 + 1).iterator();
    }

    @Override
    public Iterator<Integer> values() {
        return this.values(this.lb, this.ub);
    }

    @Override
    public Iterator<int[]> intervals() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (this.isContiguous()) {
            arrayList.add(new int[]{this.getLowerBound(), this.getUpperBound()});
        } else {
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            Iterator iterator = this.getSet().iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (n == Integer.MIN_VALUE) {
                    n = n2 = n3;
                    continue;
                }
                if (n2 + 1 == n3) {
                    n2 = n3;
                    continue;
                }
                arrayList.add(new int[]{n, n2});
                n = n2 = n3;
            }
            if (n != Integer.MIN_VALUE) {
                arrayList.add(new int[]{n, n2});
            }
        }
        return arrayList.iterator();
    }

    public IntegerDomain cap(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (integerDomainIntevals.domain == null) {
            return this.bound(integerDomainIntevals.lb, integerDomainIntevals.ub);
        }
        if (this.domain == null) {
            return integerDomainIntevals.bound(this.lb, this.ub);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!integerDomainIntevals.contains(n)) continue;
            treeSet.add(n);
        }
        return new IntegerDomainIntevals(treeSet);
    }

    public IntegerDomain cup(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (this.domain == null || integerDomainIntevals.domain == null) {
            if (this.size() == 1 && integerDomainIntevals.size() == 1) {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add(this.lb);
                treeSet.add(integerDomainIntevals.lb);
                return IntegerDomainIntevals._create(treeSet);
            }
            int n = Math.min(this.lb, integerDomainIntevals.lb);
            int n2 = Math.max(this.ub, integerDomainIntevals.ub);
            return new IntegerDomainIntevals(n, n2);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.domain);
        treeSet.addAll(integerDomainIntevals.domain);
        return IntegerDomainIntevals._create(treeSet);
    }

    @Override
    public IntegerDomain neg() throws SugarException {
        if (this.domain == null) {
            return new IntegerDomainIntevals(-this.ub, -this.lb);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            treeSet.add(-n);
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    @Override
    public IntegerDomain abs() throws SugarException {
        if (this.domain == null) {
            int n = Math.min(Math.abs(this.lb), Math.abs(this.ub));
            int n2 = Math.max(Math.abs(this.lb), Math.abs(this.ub));
            if (this.lb <= 0 && 0 <= this.ub) {
                return new IntegerDomainIntevals(0, n2);
            }
            return new IntegerDomainIntevals(n, n2);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            treeSet.add(Math.abs(n));
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    private IntegerDomain add(int n) throws SugarException {
        if (this.domain == null) {
            return new IntegerDomainIntevals(this.lb + n, this.ub + n);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            treeSet.add(n2 + n);
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain add(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (integerDomainIntevals.size() == 1) {
            return this.add(integerDomainIntevals.lb);
        }
        if (this.size() == 1) {
            return integerDomainIntevals.add(this.lb);
        }
        if (this.domain == null || integerDomainIntevals.domain == null) {
            int n = this.lb + integerDomainIntevals.lb;
            int n2 = this.ub + integerDomainIntevals.ub;
            return new IntegerDomainIntevals(n, n2);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = integerDomainIntevals.domain.iterator();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                treeSet.add(n + n3);
            }
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    private IntegerDomain sub(int n) throws SugarException {
        return this.add(-n);
    }

    public IntegerDomain sub(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        return this.add(integerDomainIntevals.neg());
    }

    @Override
    public IntegerDomain mul(int n) throws SugarException {
        if (this.domain == null) {
            if (n < 0) {
                return new IntegerDomainIntevals(this.ub * n, this.lb * n);
            }
            return new IntegerDomainIntevals(this.lb * n, this.ub * n);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            treeSet.add(n2 * n);
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain mul(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (integerDomainIntevals.size() == 1) {
            return this.mul(integerDomainIntevals.lb);
        }
        if (this.size() == 1) {
            return integerDomainIntevals.mul(this.lb);
        }
        if (this.domain == null || integerDomainIntevals.domain == null || this.size() * integerDomainIntevals.size() > MAX_SET_SIZE) {
            int n = this.lb * integerDomainIntevals.lb;
            int n2 = this.lb * integerDomainIntevals.ub;
            int n3 = this.ub * integerDomainIntevals.lb;
            int n4 = this.ub * integerDomainIntevals.ub;
            int n5 = Math.min(Math.min(n, n2), Math.min(n3, n4));
            int n6 = Math.max(Math.max(n, n2), Math.max(n3, n4));
            return new IntegerDomainIntevals(n5, n6);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = integerDomainIntevals.domain.iterator();
            while (iterator2.hasNext()) {
                int n7 = (Integer)iterator2.next();
                treeSet.add(n * n7);
            }
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    private int div(int n, int n2) {
        if (n < 0 && n % n2 != 0) {
            return n / n2 - 1;
        }
        return n / n2;
    }

    @Override
    public IntegerDomain div(int n) throws SugarException {
        if (this.domain == null) {
            if (n < 0) {
                return new IntegerDomainIntevals(this.div(this.ub, n), this.div(this.lb, n));
            }
            return new IntegerDomainIntevals(this.div(this.lb, n), this.div(this.ub, n));
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            treeSet.add(this.div(n2, n));
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain div(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (integerDomainIntevals.size() == 1) {
            return this.div(integerDomainIntevals.lb);
        }
        if (this.domain == null || integerDomainIntevals.domain == null || this.size() * integerDomainIntevals.size() > MAX_SET_SIZE) {
            int n = this.div(this.lb, integerDomainIntevals.lb);
            int n2 = this.div(this.lb, integerDomainIntevals.ub);
            int n3 = this.div(this.ub, integerDomainIntevals.lb);
            int n4 = this.div(this.ub, integerDomainIntevals.ub);
            int n5 = Math.min(Math.min(n, n2), Math.min(n3, n4));
            int n6 = Math.max(Math.max(n, n2), Math.max(n3, n4));
            if (integerDomainIntevals.lb <= 1 && 1 <= integerDomainIntevals.ub) {
                n5 = Math.min(n5, Math.min(this.lb, this.ub));
                n6 = Math.max(n6, Math.max(this.lb, this.ub));
            }
            if (integerDomainIntevals.lb <= -1 && -1 <= integerDomainIntevals.ub) {
                n5 = Math.min(n5, Math.min(-this.lb, -this.ub));
                n6 = Math.max(n6, Math.max(-this.lb, -this.ub));
            }
            return new IntegerDomainIntevals(n5, n6);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = integerDomainIntevals.domain.iterator();
            while (iterator2.hasNext()) {
                int n7 = (Integer)iterator2.next();
                treeSet.add(this.div(n, n7));
            }
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain mod(int n) throws SugarException {
        n = Math.abs(n);
        if (this.domain == null) {
            return new IntegerDomainIntevals(0, n - 1);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            treeSet.add(n2 % n);
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain mod(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        if (integerDomainIntevals.size() == 1) {
            return this.mod(integerDomainIntevals.lb);
        }
        if (this.domain == null || integerDomainIntevals.domain == null) {
            int n = 0;
            int n2 = Math.max(Math.abs(integerDomainIntevals.lb), Math.abs(integerDomainIntevals.ub)) - 1;
            return new IntegerDomainIntevals(n, n2);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = integerDomainIntevals.domain.iterator();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                treeSet.add(n % n3);
            }
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain pow(int n) throws SugarException {
        if (this.domain == null) {
            int n2 = (int)Math.round(Math.pow(this.lb, n));
            int n3 = (int)Math.round(Math.pow(this.ub, n));
            int n4 = Math.min(n2, n3);
            int n5 = Math.max(n2, n3);
            if (n % 2 == 0 && this.lb <= 0 && 0 <= this.ub) {
                return new IntegerDomainIntevals(0, n5);
            }
            return new IntegerDomainIntevals(n4, n5);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.domain.iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            treeSet.add((int)Math.round(Math.pow(n6, n)));
        }
        return IntegerDomainIntevals._create(treeSet);
    }

    public IntegerDomain min(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        int n = Math.min(this.lb, integerDomainIntevals.lb);
        int n2 = Math.min(this.ub, integerDomainIntevals.ub);
        if (this.ub <= integerDomainIntevals.lb) {
            return this;
        }
        if (integerDomainIntevals.ub <= this.lb) {
            return integerDomainIntevals;
        }
        if (this.domain == null) {
            if (integerDomainIntevals.domain == null) {
                return new IntegerDomainIntevals(n, n2);
            }
            return integerDomainIntevals.min(this);
        }
        if (integerDomainIntevals.domain == null) {
            return IntegerDomainIntevals._create(this.domain.subSet(n, n2 + 1));
        }
        SortedSet<Integer> sortedSet = new TreeSet<Integer>(this.domain);
        sortedSet.addAll(integerDomainIntevals.domain);
        sortedSet = sortedSet.subSet(n, n2 + 1);
        return IntegerDomainIntevals._create(sortedSet);
    }

    public IntegerDomain max(IntegerDomainIntevals integerDomainIntevals) throws SugarException {
        int n = Math.max(this.lb, integerDomainIntevals.lb);
        int n2 = Math.max(this.ub, integerDomainIntevals.ub);
        if (this.lb >= integerDomainIntevals.ub) {
            return this;
        }
        if (integerDomainIntevals.lb >= this.ub) {
            return integerDomainIntevals;
        }
        if (this.domain == null) {
            if (integerDomainIntevals.domain == null) {
                return new IntegerDomainIntevals(n, n2);
            }
            return integerDomainIntevals.max(this);
        }
        if (integerDomainIntevals.domain == null) {
            return IntegerDomainIntevals._create(this.domain.subSet(n, n2 + 1));
        }
        SortedSet<Integer> sortedSet = new TreeSet<Integer>(this.domain);
        sortedSet.addAll(integerDomainIntevals.domain);
        sortedSet = sortedSet.subSet(n, n2 + 1);
        return IntegerDomainIntevals._create(sortedSet);
    }

    private void checkDomain(IntegerDomain integerDomain) throws SugarException {
        if (!(integerDomain instanceof IntegerDomainIntevals)) {
            throw new SugarException("Incompatible domain " + this + ", " + integerDomain);
        }
    }

    @Override
    public IntegerDomain cup(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.cup((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain cap(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.cap((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain add(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.add((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain sub(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.sub((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain mul(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.mul((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain div(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.div((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain mod(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.mod((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain min(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.min((IntegerDomainIntevals)integerDomain);
    }

    @Override
    public IntegerDomain max(IntegerDomain integerDomain) throws SugarException {
        this.checkDomain(integerDomain);
        return this.max((IntegerDomainIntevals)integerDomain);
    }

    private class Iter
    implements Iterator<Integer> {
        int value;
        int ub;

        public Iter(int n, int n2) {
            this.value = n;
            this.ub = n2;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.ub;
        }

        @Override
        public Integer next() {
            return this.value++;
        }

        @Override
        public void remove() {
        }
    }
}

