/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.encoder.Encoding;

public class IntegerVariable
implements Comparable<IntegerVariable> {
    private static String AUX_NAME_PREFIX = "$I";
    private static int auxIntegerVariablesCount = 0;
    private String name;
    private IntegerDomain domain;
    private boolean aux;
    private String comment = null;
    private boolean modified = true;
    private int code;
    private boolean dominant;
    private int value;
    private Encoding encoding = Encoding.ORDER;

    public IntegerVariable(String string, IntegerDomain integerDomain) throws SugarException {
        this.name = string;
        this.domain = integerDomain;
        if (integerDomain.isEmpty()) {
            throw new SugarException("Integer variable domain error " + string);
        }
        this.value = integerDomain.getLowerBound();
        this.aux = false;
        if (string.startsWith(AUX_NAME_PREFIX)) {
            int n = Integer.parseInt(string.substring(AUX_NAME_PREFIX.length()));
            if (n > auxIntegerVariablesCount) {
                auxIntegerVariablesCount = n;
            }
            this.aux = true;
        }
    }

    public IntegerVariable(IntegerDomain integerDomain) throws SugarException {
        this.name = AUX_NAME_PREFIX + ++auxIntegerVariablesCount;
        this.domain = integerDomain;
        if (integerDomain.isEmpty()) {
            throw new SugarException("Integer variable domain error " + this.name);
        }
        this.value = integerDomain.getLowerBound();
        this.aux = true;
    }

    public String getName() {
        return this.name;
    }

    public IntegerDomain getDomain() {
        return this.domain;
    }

    public boolean isAux() {
        return this.aux;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public int bound(int n, int n2) throws SugarException {
        IntegerDomain integerDomain = this.domain;
        if (Math.max(this.domain.getLowerBound(), n) > Math.min(this.domain.getUpperBound(), n2)) {
            throw new SugarException("Internal error: " + this + " " + n + " " + n2);
        }
        this.domain = this.domain.bound(n, n2);
        if (!this.domain.equals(integerDomain)) {
            this.modified = true;
        }
        return integerDomain.size() - this.domain.size();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void setDominant(boolean bl) {
        this.dominant = bl;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public boolean isPbEncoding() {
        return this.encoding == Encoding.LOG;
    }

    public boolean isBoolean() {
        int n = this.domain.getLowerBound();
        int n2 = this.domain.getUpperBound();
        return 0 <= n && n <= 1 && 0 <= n2 && n2 <= 1;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public boolean isUnsatisfiable() {
        return this.domain.isEmpty();
    }

    public boolean isSatisfied() {
        return this.domain.contains(this.value);
    }

    public int getSatVariablesSize() {
        return this.domain.size() - 1;
    }

    public List<Clause> getDomainClauses() {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        int n = 0;
        Iterator<int[]> iterator = this.domain.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            if (this.domain.getLowerBound() < nArray[0]) {
                Clause clause = new Clause();
                clause.add(new LinearLeLiteral(new LinearSum(1, this, -n)));
                clause.add(new LinearGeLiteral(new LinearSum(1, this, -nArray[0])));
                arrayList.add(clause);
            }
            n = nArray[1];
        }
        return arrayList;
    }

    public void decode(BitSet bitSet) {
        int n = this.domain.getLowerBound();
        int n2 = this.domain.getUpperBound();
        int n3 = this.getCode();
        this.value = n2;
        for (int i = n; i < n2; ++i) {
            if (!this.domain.contains(i)) continue;
            if (bitSet.get(n3)) {
                this.value = i;
                break;
            }
            ++n3;
        }
    }

    @Override
    public int compareTo(IntegerVariable integerVariable) {
        if (this == integerVariable) {
            return 0;
        }
        if (integerVariable == null) {
            return 1;
        }
        return this.name.compareTo(integerVariable.name);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntegerVariable integerVariable = (IntegerVariable)object;
        return !(this.name == null ? integerVariable.name != null : !this.name.equals(integerVariable.name));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(int ");
        stringBuilder.append(this.name);
        stringBuilder.append(" ");
        stringBuilder.append(this.domain.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

