/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearNeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;

public class LinearEqLiteral
extends LinearLiteral {
    public LinearEqLiteral(LinearSum linearSum) {
        super(linearSum, "eq");
    }

    @Override
    public int[] getBound(IntegerVariable integerVariable) throws SugarException {
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = integerDomain.getLowerBound();
        int n2 = integerDomain.getUpperBound();
        int n3 = n;
        int n4 = n2;
        int n5 = this.linearSum.getA(integerVariable);
        if (n5 > 0) {
            integerDomain = this.linearSum.getDomainExcept(integerVariable).neg();
            n3 = this.ceilDiv(integerDomain.getLowerBound(), n5);
            n4 = this.floorDiv(integerDomain.getUpperBound(), n5);
        } else if (n5 < 0) {
            integerDomain = this.linearSum.getDomainExcept(integerVariable);
            n3 = this.ceilDiv(integerDomain.getLowerBound(), -n5);
            n4 = this.floorDiv(integerDomain.getUpperBound(), -n5);
        }
        if (n3 > n4) {
            return null;
        }
        return new int[]{n3, n4};
    }

    @Override
    public boolean isSimple() {
        if (!this.linearSum.isSimple()) {
            return false;
        }
        if (this.linearSum.size() == 0) {
            return true;
        }
        Encoding encoding = this.linearSum.getCoef().firstKey().getEncoding();
        switch (encoding) {
            case XXX_DIRECT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() throws SugarException {
        IntegerDomain integerDomain = this.linearSum.getDomain();
        return integerDomain.size() == 1 && integerDomain.contains(0);
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        IntegerDomain integerDomain = this.linearSum.getDomain();
        return !integerDomain.contains(0);
    }

    @Override
    public int propagate() throws SugarException {
        if (this.linearSum.size() == 0) {
            return 0;
        }
        int n = 0;
        for (IntegerVariable integerVariable : this.linearSum.getCoef().keySet()) {
            int n2;
            int n3;
            IntegerDomain integerDomain;
            IntegerDomain integerDomain2 = integerVariable.getDomain();
            int n4 = this.linearSum.getA(integerVariable);
            if (n4 > 0) {
                integerDomain = this.linearSum.getDomainExcept(integerVariable).neg().div(n4);
                n3 = integerDomain.getLowerBound();
                n2 = integerDomain.getUpperBound();
                n += integerVariable.bound(n3, n2);
                continue;
            }
            if (n4 >= 0) continue;
            integerDomain = this.linearSum.getDomainExcept(integerVariable).div(-n4);
            n3 = integerDomain.getLowerBound();
            n2 = integerDomain.getUpperBound();
            n += integerVariable.bound(n3, n2);
        }
        return n;
    }

    @Override
    public Literal neg() throws SugarException {
        return new LinearNeLiteral(this.linearSum);
    }

    @Override
    public int getCode() throws SugarException {
        throw new SugarException("Internal error " + this.toString());
    }

    @Override
    public boolean isSatisfied() {
        return this.linearSum.getValue() == 0;
    }
}

