/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;

public class LinearGeLiteral
extends LinearLiteral {
    public LinearGeLiteral(LinearSum linearSum) {
        super(linearSum, "ge");
    }

    @Override
    public int[] getBound(IntegerVariable integerVariable) throws SugarException {
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = integerDomain.getLowerBound();
        int n2 = integerDomain.getUpperBound();
        int n3 = n;
        int n4 = n2;
        int n5 = this.linearSum.getA(integerVariable);
        if (n5 > 0) {
            integerDomain = this.linearSum.getDomainExcept(integerVariable).neg();
            n3 = this.ceilDiv(integerDomain.getLowerBound(), n5);
        } else if (n5 < 0) {
            integerDomain = this.linearSum.getDomainExcept(integerVariable);
            n4 = this.floorDiv(integerDomain.getUpperBound(), -n5);
        }
        if (n3 > n4) {
            return null;
        }
        return new int[]{n3, n4};
    }

    @Override
    public boolean isSimple() {
        if (!this.linearSum.isSimple()) {
            return false;
        }
        if (this.linearSum.size() == 0) {
            return true;
        }
        Encoding encoding = this.linearSum.getCoef().firstKey().getEncoding();
        switch (encoding) {
            case ORDER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() throws SugarException {
        return this.linearSum.getDomain().getLowerBound() >= 0;
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        return this.linearSum.getDomain().getUpperBound() < 0;
    }

    @Override
    public int propagate() throws SugarException {
        if (this.linearSum.size() == 0) {
            return 0;
        }
        int n = 0;
        for (IntegerVariable integerVariable : this.linearSum.getCoef().keySet()) {
            IntegerDomain integerDomain;
            IntegerDomain integerDomain2 = integerVariable.getDomain();
            int n2 = integerDomain2.getLowerBound();
            int n3 = integerDomain2.getUpperBound();
            int n4 = this.linearSum.getA(integerVariable);
            if (n4 > 0) {
                integerDomain = this.linearSum.getDomainExcept(integerVariable).neg().div(n4);
                n2 = integerDomain.getLowerBound();
                n += integerVariable.bound(n2, n3);
                continue;
            }
            if (n4 >= 0) continue;
            integerDomain = this.linearSum.getDomainExcept(integerVariable).div(-n4);
            n3 = integerDomain.getUpperBound();
            n += integerVariable.bound(n2, n3);
        }
        return n;
    }

    @Override
    public boolean isSatisfied() {
        return this.linearSum.getValue() == 0;
    }

    @Override
    public Literal neg() throws SugarException {
        LinearSum linearSum = new LinearSum(this.linearSum);
        linearSum.add(LinearSum.ONE);
        return new LinearLeLiteral(linearSum);
    }
}

