/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;

public class LinearLeLiteral
extends LinearLiteral {
    public LinearLeLiteral(LinearSum linearSum) {
        super(linearSum, "le");
    }

    @Override
    public int[] getBound(IntegerVariable integerVariable) throws SugarException {
        int n = this.linearSum.getA(integerVariable);
        int n2 = integerVariable.getDomain().getLowerBound();
        int n3 = integerVariable.getDomain().getUpperBound();
        if (n != 0) {
            IntegerDomain integerDomain = this.linearSum.getDomainExcept(integerVariable);
            integerDomain = integerDomain.neg();
            int n4 = integerDomain.getUpperBound();
            if (n >= 0) {
                n3 = n4 >= 0 ? n4 / n : (n4 - n + 1) / n;
            } else {
                n2 = n4 >= 0 ? n4 / n : (n4 + n + 1) / n;
            }
        }
        if (n2 > n3) {
            return null;
        }
        return new int[]{n2, n3};
    }

    @Override
    public boolean isSimple() {
        if (!this.linearSum.isSimple()) {
            return false;
        }
        if (this.linearSum.size() == 0) {
            return true;
        }
        Encoding encoding = this.linearSum.getCoef().firstKey().getEncoding();
        switch (encoding) {
            case ORDER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public LinearSum getLinearExpression() {
        return this.linearSum;
    }

    @Override
    public boolean isValid() throws SugarException {
        return this.linearSum.getDomain().getUpperBound() <= 0;
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        return this.linearSum.getDomain().getLowerBound() > 0;
    }

    @Override
    public int propagate() throws SugarException {
        if (this.linearSum.size() == 0) {
            return 0;
        }
        int n = 0;
        for (IntegerVariable integerVariable : this.linearSum.getCoef().keySet()) {
            int n2;
            IntegerDomain integerDomain = this.linearSum.getDomainExcept(integerVariable);
            integerDomain = integerDomain.neg();
            int n3 = this.linearSum.getA(integerVariable);
            int n4 = integerVariable.getDomain().getLowerBound();
            int n5 = integerVariable.getDomain().getUpperBound();
            if (n3 >= 0) {
                n2 = integerDomain.getUpperBound();
                n5 = n2 >= 0 ? n2 / n3 : (n2 - n3 + 1) / n3;
            } else {
                n2 = integerDomain.getUpperBound();
                n4 = n2 >= 0 ? n2 / n3 : (n2 + n3 + 1) / n3;
            }
            if (n4 > n5) {
                System.out.println(this.linearSum);
                for (IntegerVariable integerVariable2 : this.linearSum.getCoef().keySet()) {
                    System.out.println(integerVariable2.toString());
                }
                System.out.println(this.linearSum.getDomainExcept(integerVariable).toString());
                System.out.println(integerVariable.getName() + " " + n4 + " " + n5);
                System.out.println("==>");
                n += integerVariable.bound(n4, n5);
                System.out.println(integerVariable.toString());
                System.out.println();
                continue;
            }
            n += integerVariable.bound(n4, n5);
        }
        return n;
    }

    @Override
    public boolean isSatisfied() {
        return this.linearSum.getValue() <= 0;
    }

    @Override
    public Literal neg() throws SugarException {
        LinearSum linearSum = new LinearSum(this.linearSum);
        linearSum.subtract(LinearSum.ONE);
        return new LinearGeLiteral(linearSum);
    }
}

