/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.Set;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;

public abstract class LinearLiteral
extends Literal {
    protected LinearSum linearSum;
    protected String cmp;

    public LinearLiteral(LinearSum linearSum, String string) {
        int n = linearSum.coefGCD();
        if (n > 1) {
            int n2 = linearSum.getB();
            linearSum.divide(n);
            if (string.equals("eq")) {
                if (n2 % n != 0) {
                    linearSum = LinearSum.ONE;
                    string = "le";
                }
            } else if (string.equals("ne")) {
                if (n2 % n != 0) {
                    linearSum = LinearSum.ONE;
                    string = "ge";
                }
            } else if (string.equals("le")) {
                linearSum.setB(-((int)Math.floor(-((double)n2) / (double)n)));
            } else if (string.equals("ge")) {
                linearSum.setB(-((int)Math.ceil(-((double)n2) / (double)n)));
            }
        }
        this.linearSum = linearSum;
        this.cmp = string;
    }

    @Override
    public Set<IntegerVariable> getVariables() {
        return this.linearSum.getVariables();
    }

    public int floorDiv(int n, int n2) {
        if (n2 < 0) {
            n2 = -n2;
            n = -n;
        }
        if (n >= 0) {
            return n / n2;
        }
        return (n - n2 + 1) / n2;
    }

    public int ceilDiv(int n, int n2) {
        if (n2 < 0) {
            n2 = -n2;
            n = -n;
        }
        if (n >= 0) {
            return (n + n2 - 1) / n2;
        }
        return n / n2;
    }

    public LinearSum getLinearExpression() {
        return this.linearSum;
    }

    public String getCmp() {
        return this.cmp;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.cmp == null ? 0 : this.cmp.hashCode());
        n = 31 * n + (this.linearSum == null ? 0 : this.linearSum.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LinearLiteral linearLiteral = (LinearLiteral)object;
        if (this.cmp == null ? linearLiteral.cmp != null : !this.cmp.equals(linearLiteral.cmp)) {
            return false;
        }
        return !(this.linearSum == null ? linearLiteral.linearSum != null : !this.linearSum.equals(linearLiteral.linearSum));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(wsum (");
        String string = "";
        for (IntegerVariable integerVariable : this.linearSum.getVariables()) {
            stringBuilder.append(string);
            stringBuilder.append("(" + this.linearSum.getA(integerVariable) + " " + integerVariable.getName() + ")");
            string = " ";
        }
        stringBuilder.append(") " + this.cmp + " ");
        stringBuilder.append(-this.linearSum.getB());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

