/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearEqLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;

public class LinearNeLiteral
extends LinearLiteral {
    public LinearNeLiteral(LinearSum linearSum) {
        super(linearSum, "ne");
    }

    @Override
    public int[] getBound(IntegerVariable integerVariable) throws SugarException {
        int n;
        int n2 = integerVariable.getDomain().getLowerBound();
        if (n2 > (n = integerVariable.getDomain().getUpperBound())) {
            return null;
        }
        return new int[]{n2, n};
    }

    @Override
    public boolean isSimple() {
        if (!this.linearSum.isSimple()) {
            return false;
        }
        if (this.linearSum.size() == 0) {
            return true;
        }
        Encoding encoding = this.linearSum.getCoef().firstKey().getEncoding();
        switch (encoding) {
            case XXX_DIRECT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() throws SugarException {
        IntegerDomain integerDomain = this.linearSum.getDomain();
        return !integerDomain.contains(0);
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        IntegerDomain integerDomain = this.linearSum.getDomain();
        return integerDomain.size() == 1 && integerDomain.contains(0);
    }

    @Override
    public int propagate() throws SugarException {
        if (this.linearSum.size() == 0) {
            return 0;
        }
        int n = 0;
        for (IntegerVariable integerVariable : this.linearSum.getCoef().keySet()) {
            int n2;
            IntegerDomain integerDomain;
            int n3 = integerVariable.getDomain().getLowerBound();
            int n4 = integerVariable.getDomain().getUpperBound();
            int n5 = this.linearSum.getA(integerVariable);
            if (n5 > 0) {
                integerDomain = this.linearSum.getDomainExcept(integerVariable).neg().div(n5);
                n2 = integerDomain.getLowerBound();
                if (integerDomain.size() == 1 && n2 == n3) {
                    n += integerVariable.bound(n3 + 1, n4);
                    continue;
                }
                if (integerDomain.size() != 1 || n2 != n4) continue;
                n += integerVariable.bound(n3, n4 - 1);
                continue;
            }
            if (n5 >= 0) continue;
            integerDomain = this.linearSum.getDomainExcept(integerVariable).div(-n5);
            n2 = integerDomain.getLowerBound();
            if (integerDomain.size() == 1 && n2 == n3) {
                n += integerVariable.bound(n3 + 1, n4);
                continue;
            }
            if (integerDomain.size() != 1 || n2 != n4) continue;
            n += integerVariable.bound(n3, n4 - 1);
        }
        return n;
    }

    @Override
    public boolean isSatisfied() {
        return this.linearSum.getValue() != 0;
    }

    @Override
    public Literal neg() throws SugarException {
        return new LinearEqLiteral(this.linearSum);
    }
}

