/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.expression.Expression;

public class LinearSum {
    public static LinearSum ONE = new LinearSum(1);
    private int b;
    private SortedMap<IntegerVariable, Integer> coef = new TreeMap<IntegerVariable, Integer>();
    private IntegerDomain domain = null;

    public LinearSum(int n) {
        this.coef = new TreeMap<IntegerVariable, Integer>();
        this.b = n;
    }

    public LinearSum(int n, IntegerVariable integerVariable, int n2) {
        this(n2);
        this.coef.put(integerVariable, n);
    }

    public LinearSum(IntegerVariable integerVariable) {
        this(1, integerVariable, 0);
    }

    public LinearSum(LinearSum linearSum) {
        this.b = linearSum.b;
        this.coef = new TreeMap<IntegerVariable, Integer>(linearSum.coef);
        this.domain = null;
    }

    public int size() {
        return this.coef.size();
    }

    public int getB() {
        return this.b;
    }

    public void setB(int n) {
        this.b = n;
    }

    public SortedMap<IntegerVariable, Integer> getCoef() {
        return this.coef;
    }

    public Set<IntegerVariable> getVariables() {
        return this.coef.keySet();
    }

    public boolean isIntegerVariable() {
        return this.b == 0 && this.size() == 1 && this.getA(this.coef.firstKey()) == 1;
    }

    public boolean isSimple() {
        return this.coef.size() <= 1;
    }

    public Integer getA(IntegerVariable integerVariable) {
        Integer n = (Integer)this.coef.get(integerVariable);
        if (n == null) {
            n = 0;
        }
        return n;
    }

    public void setA(int n, IntegerVariable integerVariable) {
        if (n == 0) {
            this.coef.remove(integerVariable);
        } else {
            this.coef.put(integerVariable, n);
        }
        this.domain = null;
    }

    public boolean isDomainLargerThan(long l) {
        long l2 = 1L;
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            if ((l2 *= (long)integerVariable.getDomain().size()) <= l) continue;
            return true;
        }
        return false;
    }

    public boolean isDomainLargerThanExcept(long l, IntegerVariable integerVariable) {
        long l2 = 1L;
        for (IntegerVariable integerVariable2 : this.coef.keySet()) {
            if (integerVariable2.equals(integerVariable) || (l2 *= (long)integerVariable2.getDomain().size()) <= l) continue;
            return true;
        }
        return false;
    }

    public boolean isDomainLargerThanExcept(long l) {
        IntegerVariable integerVariable = this.getLargestDomainVariable();
        return this.isDomainLargerThanExcept(l, integerVariable);
    }

    public boolean isModified() {
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            if (!integerVariable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void add(LinearSum linearSum) {
        this.b += linearSum.b;
        for (IntegerVariable integerVariable : linearSum.coef.keySet()) {
            int n = this.getA(integerVariable) + linearSum.getA(integerVariable);
            this.setA(n, integerVariable);
        }
        this.domain = null;
    }

    public void subtract(LinearSum linearSum) {
        this.b -= linearSum.b;
        for (IntegerVariable integerVariable : linearSum.coef.keySet()) {
            int n = this.getA(integerVariable) - linearSum.getA(integerVariable);
            this.setA(n, integerVariable);
        }
        this.domain = null;
    }

    public void multiply(int n) {
        this.b *= n;
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            int n2 = n * this.getA(integerVariable);
            this.setA(n2, integerVariable);
        }
        this.domain = null;
    }

    public void divide(int n) {
        this.b /= n;
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            int n2 = this.getA(integerVariable) / n;
            this.setA(n2, integerVariable);
        }
        this.domain = null;
    }

    private int gcd(int n, int n2) {
        int n3;
        while ((n3 = n % n2) != 0) {
            n = n2;
            n2 = n3;
        }
        return n2;
    }

    public int factor() {
        IntegerVariable integerVariable;
        if (this.size() == 0) {
            return this.b == 0 ? 1 : Math.abs(this.b);
        }
        int n = Math.abs(this.getA(this.coef.firstKey()));
        Iterator<IntegerVariable> iterator = this.coef.keySet().iterator();
        while (iterator.hasNext() && (n = this.gcd(n, Math.abs(this.getA(integerVariable = iterator.next())))) != 1) {
        }
        if (this.b != 0) {
            n = this.gcd(n, Math.abs(this.b));
        }
        return n;
    }

    public void factorize() {
        int n = this.factor();
        if (n > 1) {
            this.divide(n);
        }
    }

    public int coefGCD() {
        IntegerVariable integerVariable;
        if (this.size() == 0) {
            return 1;
        }
        int n = Math.abs(this.getA(this.coef.firstKey()));
        Iterator<IntegerVariable> iterator = this.coef.keySet().iterator();
        while (iterator.hasNext() && (n = this.gcd(n, Math.abs(this.getA(integerVariable = iterator.next())))) != 1) {
        }
        return n;
    }

    public IntegerDomain getDomain() throws SugarException {
        if (this.domain == null || this.isModified()) {
            this.domain = IntegerDomain.create(this.b, this.b);
            for (IntegerVariable integerVariable : this.coef.keySet()) {
                int n = this.getA(integerVariable);
                this.domain = this.domain.add(integerVariable.getDomain().mul(n));
            }
        }
        return this.domain;
    }

    public IntegerDomain getDomainExcept(IntegerVariable integerVariable) throws SugarException {
        IntegerDomain integerDomain = IntegerDomain.create(this.b, this.b);
        for (IntegerVariable integerVariable2 : this.coef.keySet()) {
            if (integerVariable2.equals(integerVariable)) continue;
            int n = this.getA(integerVariable2);
            integerDomain = integerDomain.add(integerVariable2.getDomain().mul(n));
        }
        return integerDomain;
    }

    public LinearSum[] split(int n) {
        LinearSum[] linearSumArray = new LinearSum[n];
        for (int i = 0; i < n; ++i) {
            linearSumArray[i] = new LinearSum(0);
        }
        IntegerVariable[] integerVariableArray = this.getVariablesSorted();
        for (int i = 0; i < integerVariableArray.length; ++i) {
            IntegerVariable integerVariable = integerVariableArray[i];
            linearSumArray[i % n].setA(this.getA(integerVariable), integerVariable);
        }
        return linearSumArray;
    }

    public boolean containsPbPart() {
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            if (!integerVariable.isPbEncoding()) continue;
            return true;
        }
        return false;
    }

    public LinearSum[] splitPbPart() {
        if (!this.containsPbPart()) {
            return new LinearSum[]{this};
        }
        LinearSum linearSum = new LinearSum(0);
        LinearSum linearSum2 = new LinearSum(this.b);
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            if (integerVariable.isPbEncoding()) {
                linearSum2.setA((Integer)this.coef.get(integerVariable), integerVariable);
                continue;
            }
            linearSum.setA((Integer)this.coef.get(integerVariable), integerVariable);
        }
        return new LinearSum[]{linearSum, linearSum2};
    }

    public IntegerVariable getLargestDomainVariable() {
        IntegerVariable integerVariable = null;
        for (IntegerVariable integerVariable2 : this.coef.keySet()) {
            if (integerVariable != null && integerVariable.getDomain().size() >= integerVariable2.getDomain().size()) continue;
            integerVariable = integerVariable2;
        }
        return integerVariable;
    }

    public IntegerVariable[] getVariablesSorted() {
        int n = this.coef.size();
        IntegerVariable[] integerVariableArray = new IntegerVariable[n];
        integerVariableArray = this.coef.keySet().toArray(integerVariableArray);
        Arrays.sort(integerVariableArray, new Comparator<IntegerVariable>(){

            @Override
            public int compare(IntegerVariable integerVariable, IntegerVariable integerVariable2) {
                int n;
                int n2 = integerVariable.getDomain().size();
                if (n2 != (n = integerVariable2.getDomain().size())) {
                    return n2 < n ? -1 : 1;
                }
                n2 = Math.abs(LinearSum.this.getA(integerVariable));
                if (n2 != (n = Math.abs(LinearSum.this.getA(integerVariable2)))) {
                    return n2 > n ? -1 : 1;
                }
                return integerVariable.compareTo(integerVariable2);
            }
        });
        return integerVariableArray;
    }

    private long calcSatSize(long l, IntegerVariable[] integerVariableArray, int n, int n2) throws SugarException {
        long l2 = 0L;
        if (n >= integerVariableArray.length - 1) {
            l2 = 1L;
        } else {
            int n3;
            int n4 = n2;
            int n5 = n2;
            for (n3 = n + 1; n3 < integerVariableArray.length; ++n3) {
                int n6 = this.getA(integerVariableArray[n3]);
                if (n6 > 0) {
                    n4 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
                    n5 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                    continue;
                }
                n4 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                n5 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
            }
            n3 = this.getA(integerVariableArray[n]);
            IntegerDomain integerDomain = integerVariableArray[n].getDomain();
            int n7 = integerDomain.getLowerBound();
            int n8 = integerDomain.getUpperBound();
            if (n3 >= 0) {
                n8 = -n4 >= 0 ? Math.min(n8, -n4 / n3) : Math.min(n8, (-n4 - n3 + 1) / n3);
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n9 = iterator.next();
                    if ((l2 += this.calcSatSize(l, integerVariableArray, n + 1, n2 + n3 * n9)) <= l) continue;
                    return l2;
                }
                if ((l2 += this.calcSatSize(l, integerVariableArray, n + 1, n2 + n3 * (n8 + 1))) > l) {
                    return l2;
                }
            } else {
                n7 = -n4 >= 0 ? Math.max(n7, -n4 / n3) : Math.max(n7, (-n4 + n3 + 1) / n3);
                if ((l2 += this.calcSatSize(l, integerVariableArray, n + 1, n2 + n3 * (n7 - 1))) > l) {
                    return l2;
                }
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n10 = iterator.next();
                    if ((l2 += this.calcSatSize(l, integerVariableArray, n + 1, n2 + n3 * n10)) <= l) continue;
                    return l2;
                }
            }
        }
        return l2;
    }

    public boolean satSizeLE(long l) throws SugarException {
        if (this.isSimple()) {
            return 1L <= l;
        }
        IntegerVariable[] integerVariableArray = this.getVariablesSorted();
        long l2 = this.calcSatSize(l, integerVariableArray, 0, this.getB());
        return l2 <= l;
    }

    public Expression toExpression() {
        Expression expression = Expression.create(this.b);
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            Expression expression2 = Expression.create(this.getA(integerVariable));
            Expression expression3 = Expression.create(integerVariable.getName());
            expression = expression.add(expression2.mul(expression3));
        }
        return expression;
    }

    public int getValue() {
        int n = this.b;
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            n += this.getA(integerVariable) * integerVariable.getValue();
        }
        return n;
    }

    public boolean equals(LinearSum linearSum) {
        if (linearSum == null) {
            return false;
        }
        if (this == linearSum) {
            return true;
        }
        return this.b == linearSum.b && this.coef.equals(linearSum.coef);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.equals((LinearSum)object);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.coef == null ? 0 : this.coef.hashCode());
        n = 31 * n + this.b;
        return n;
    }

    public String toString0() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append("add");
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            stringBuilder.append(" (");
            stringBuilder.append("mul");
            stringBuilder.append(" ");
            stringBuilder.append(this.coef.get(integerVariable));
            stringBuilder.append(" ");
            stringBuilder.append(integerVariable.getName());
            stringBuilder.append(")");
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.b);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IntegerVariable integerVariable : this.coef.keySet()) {
            int n = this.getA(integerVariable);
            if (n == 0) continue;
            if (n > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("+");
                }
                if (n != 1) {
                    stringBuilder.append(n);
                    stringBuilder.append("*");
                }
                stringBuilder.append(integerVariable.getName());
                continue;
            }
            if (n == -1) {
                stringBuilder.append("-");
            } else {
                stringBuilder.append(n);
                stringBuilder.append("*");
            }
            stringBuilder.append(integerVariable.getName());
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.b);
        } else {
            if (this.b >= 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append(this.b);
        }
        return stringBuilder.toString();
    }
}

