/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.HashMap;
import java.util.Map;
import jp.kobe_u.sugar.expression.Atom;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class Predicate {
    public String name;
    public int arity;
    public Atom[] params;
    public Map<Atom, Integer> paramsMap;
    public Expression body;
    private Expression[] args;

    public Predicate(Sequence sequence, Expression expression) {
        this.name = sequence.get(0).stringValue();
        this.arity = sequence.length() - 1;
        this.params = new Atom[this.arity];
        this.paramsMap = new HashMap<Atom, Integer>();
        for (int i = 1; i < sequence.length(); ++i) {
            this.params[i - 1] = (Atom)sequence.get(i);
            this.paramsMap.put(this.params[i - 1], i - 1);
        }
        this.body = expression;
    }

    private boolean paramsOccurred(Expression expression) {
        if (expression.isAtom()) {
            Atom atom = (Atom)expression;
            return this.paramsMap.containsKey(atom);
        }
        Sequence sequence = (Sequence)expression;
        for (int i = 0; i < sequence.length(); ++i) {
            if (!this.paramsOccurred(sequence.get(i))) continue;
            return true;
        }
        return false;
    }

    private Expression substitute(Expression expression) {
        if (!this.paramsOccurred(expression)) {
            return expression;
        }
        if (expression.isAtom()) {
            int n = this.paramsMap.get((Atom)expression);
            return this.args[n];
        }
        Sequence sequence = (Sequence)expression;
        Expression[] expressionArray = new Expression[sequence.length()];
        for (int i = 0; i < sequence.length(); ++i) {
            expressionArray[i] = this.substitute(sequence.get(i));
        }
        expression = Expression.create(expressionArray);
        return expression;
    }

    public Expression apply(Expression[] expressionArray) {
        this.args = expressionArray;
        return this.substitute(this.body);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(predicate ");
        stringBuilder.append("(" + this.name);
        for (Atom atom : this.params) {
            stringBuilder.append(" " + atom.stringValue());
        }
        stringBuilder.append(") ");
        stringBuilder.append(this.body.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

