/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class Relation {
    public String name;
    public int arity;
    public boolean conflicts;
    public int[][] tuples;

    public Relation(String string, int n, Sequence sequence) throws SugarException {
        this.name = string;
        this.arity = n;
        if (sequence.isSequence(Expression.SUPPORTS)) {
            this.conflicts = false;
        } else if (sequence.isSequence(Expression.CONFLICTS)) {
            this.conflicts = true;
        } else {
            throw new SugarException("Syntax error " + sequence);
        }
        int n2 = sequence.length() - 1;
        this.tuples = new int[n2][];
        for (int i = 1; i <= n2; ++i) {
            if (!sequence.get(i).isSequence()) {
                throw new SugarException("Syntax error " + sequence);
            }
            Sequence sequence2 = (Sequence)sequence.get(i);
            int[] nArray = new int[n];
            for (int j = 0; j < n; ++j) {
                nArray[j] = sequence2.get(j).integerValue();
            }
            this.tuples[i - 1] = nArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(" + Expression.RELATION_DEFINITION + " ");
        stringBuilder.append(this.name + " " + this.arity + " (");
        stringBuilder.append(this.conflicts ? Expression.CONFLICTS : Expression.SUPPORTS);
        for (int[] nArray : this.tuples) {
            stringBuilder.append(" (");
            String string = "";
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append(string + nArray[i]);
                string = " ";
            }
            stringBuilder.append(")");
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }
}

