/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.csp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.expression.Expression;

public class RelationLiteral
extends Literal {
    public String name;
    public int arity;
    public boolean negative;
    public boolean conflicts;
    public IntegerVariable[] vs;
    public int[][] tuples;
    private HashSet<Tuple> tupleSet;
    private static final int UNDEF = Integer.MIN_VALUE;

    public RelationLiteral(String string, int n, boolean bl, boolean bl2, int[][] nArray, IntegerVariable[] integerVariableArray) {
        this.name = string;
        this.arity = n;
        this.negative = bl;
        this.conflicts = bl2;
        this.vs = integerVariableArray;
        this.tuples = nArray;
        this.tupleSet = new HashSet();
        for (int[] nArray2 : nArray) {
            this.tupleSet.add(new Tuple((int[])nArray2.clone()));
            int[] nArray3 = (int[])nArray2.clone();
            for (int i = nArray2.length - 1; i >= 1; --i) {
                nArray3[i] = Integer.MIN_VALUE;
                this.tupleSet.add(new Tuple((int[])nArray3.clone()));
            }
        }
    }

    private boolean conflicts(Tuple tuple) {
        return this.negative ^ this.conflicts && this.tupleSet.contains(tuple) || !(this.negative ^ this.conflicts) && !this.tupleSet.contains(tuple);
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isValid() throws SugarException {
        return false;
    }

    @Override
    public boolean isUnsatisfiable() throws SugarException {
        return false;
    }

    @Override
    public int propagate() throws SugarException {
        int n = 0;
        return n;
    }

    private boolean contactInside(Brick brick, Brick brick2, int n) {
        int n2 = brick.lb.length;
        for (int i = 0; i < n2; ++i) {
            if (i == n || brick2.lb[i] <= brick.lb[i] && brick.ub[i] <= brick2.ub[i]) continue;
            return false;
        }
        return true;
    }

    private List<Brick> combineBricks2(List<Brick> list, List<Brick> list2, int n, int n2, int n3) {
        Object object;
        ArrayList<Brick> arrayList = new ArrayList<Brick>();
        int n4 = 0;
        while (n4 < list.size()) {
            object = list.get(n4);
            if (((Brick)object).ub[n] == n2) {
                ++n4;
                continue;
            }
            arrayList.add((Brick)object);
            list.remove(n4);
        }
        n4 = 0;
        while (n4 < list2.size()) {
            object = list2.get(n4);
            if (((Brick)object).lb[n] == n3) {
                ++n4;
                continue;
            }
            arrayList.add((Brick)object);
            list2.remove(n4);
        }
        block2: for (Brick brick : list) {
            for (int i = 0; i < list2.size(); ++i) {
                int[] nArray;
                Brick brick2 = list2.get(i);
                if (this.contactInside(brick, brick2, n)) {
                    nArray = (int[])brick.ub.clone();
                    nArray[n] = brick2.ub[n];
                    brick.ub = nArray;
                    if (!this.contactInside(brick2, brick, n)) {
                        arrayList.add(brick2);
                    }
                    list2.remove(i);
                    continue block2;
                }
                if (!this.contactInside(brick2, brick, n)) continue;
                nArray = (int[])brick2.lb.clone();
                nArray[n] = brick.lb[n];
                brick2.lb = nArray;
                arrayList.add(brick2);
                list2.remove(i);
                continue block2;
            }
        }
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private List<Brick> combineBricks(int n, List<Integer> list, Tuple tuple) throws SugarException {
        List<Brick> list2 = null;
        if (n == this.vs.length - 1) {
            list2 = new ArrayList<Brick>();
            Iterator<Integer> iterator = this.vs[n].getDomain().values();
            int[] nArray = null;
            int[] nArray2 = null;
            while (iterator.hasNext()) {
                int n2;
                tuple.values[n] = n2 = iterator.next().intValue();
                if (this.conflicts(tuple)) {
                    int[] nArray3 = (int[])tuple.values.clone();
                    if (nArray == null) {
                        nArray2 = nArray3;
                        nArray = nArray3;
                        continue;
                    }
                    nArray2 = nArray3;
                    continue;
                }
                if (nArray != null) {
                    list2.add(new Brick(nArray, nArray2));
                }
                nArray2 = null;
                nArray = null;
            }
            if (nArray != null) {
                list2.add(new Brick(nArray, nArray2));
            }
        } else {
            int n3;
            int n4;
            if (list == null) {
                list = new ArrayList<Integer>();
                Iterator<Integer> iterator = this.vs[n].getDomain().values();
                while (iterator.hasNext()) {
                    n4 = iterator.next();
                    list.add(n4);
                }
            }
            if ((n3 = list.size()) == 1) {
                tuple.values[n] = list.get(0);
                for (n4 = n + 1; n4 < tuple.values.length; ++n4) {
                    tuple.values[n4] = Integer.MIN_VALUE;
                }
                if (this.negative ^ this.conflicts) {
                    list2 = this.tupleSet.contains(tuple) ? this.combineBricks(n + 1, null, tuple) : new ArrayList();
                } else if (this.tupleSet.contains(tuple)) {
                    list2 = this.combineBricks(n + 1, null, tuple);
                } else {
                    list2 = new ArrayList();
                    int[] nArray = (int[])tuple.values.clone();
                    int[] nArray4 = (int[])tuple.values.clone();
                    for (int i = n + 1; i < this.vs.length; ++i) {
                        nArray[i] = this.vs[i].getDomain().getLowerBound();
                        nArray4[i] = this.vs[i].getDomain().getUpperBound();
                    }
                    list2.add(new Brick(nArray, nArray4));
                }
            } else {
                n4 = n3 / 2;
                List<Brick> list3 = this.combineBricks(n, list.subList(0, n4), tuple);
                List<Brick> list4 = this.combineBricks(n, list.subList(n4, n3), tuple);
                int n5 = list.get(n4 - 1);
                int n6 = list.get(n4);
                list2 = this.combineBricks2(list3, list4, n, n5, n6);
            }
        }
        return list2;
    }

    public List<Brick> getConflictBricks() throws SugarException {
        Tuple tuple = new Tuple(new int[this.vs.length]);
        List<Brick> list = this.combineBricks(0, null, tuple);
        return list;
    }

    @Override
    public boolean isSatisfied() {
        int[] nArray = new int[this.vs.length];
        for (int i = 0; i < this.vs.length; ++i) {
            nArray[i] = this.vs[i].getValue();
        }
        return this.conflicts(new Tuple(nArray));
    }

    @Override
    public Literal neg() throws SugarException {
        return new RelationLiteral(this.name, this.arity, !this.negative, this.conflicts, this.tuples, this.vs);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.arity;
        n = 31 * n + (this.conflicts ? 1231 : 1237);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.negative ? 1231 : 1237);
        n = 31 * n + (this.tupleSet == null ? 0 : this.tupleSet.hashCode());
        n = 31 * n + Arrays.hashCode(this.vs);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationLiteral relationLiteral = (RelationLiteral)object;
        if (this.arity != relationLiteral.arity) {
            return false;
        }
        if (this.conflicts != relationLiteral.conflicts) {
            return false;
        }
        if (this.name == null ? relationLiteral.name != null : !this.name.equals(relationLiteral.name)) {
            return false;
        }
        if (this.negative != relationLiteral.negative) {
            return false;
        }
        if (this.tupleSet == null ? relationLiteral.tupleSet != null : !this.tupleSet.equals(relationLiteral.tupleSet)) {
            return false;
        }
        return Arrays.equals(this.vs, relationLiteral.vs);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.negative) {
            stringBuilder.append("(" + Expression.NOT + " ");
            stringBuilder.append("(" + this.name + " ");
            Expression.appendString(stringBuilder, this.vs);
            stringBuilder.append("))");
        } else {
            stringBuilder.append("(" + this.name + " ");
            Expression.appendString(stringBuilder, this.vs);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public class Brick {
        public int[] lb;
        public int[] ub;

        public Brick(int[] nArray, int[] nArray2) {
            this.lb = nArray;
            this.ub = nArray2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            Expression.appendString(stringBuilder, this.lb);
            stringBuilder.append(")-(");
            Expression.appendString(stringBuilder, this.ub);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private class Tuple {
        public int[] values;

        public Tuple(int[] nArray) {
            this.values = nArray;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + Arrays.hashCode(this.values);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)object;
            return Arrays.equals(this.values, tuple.values);
        }
    }
}

