/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.encoder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.util.BitSet;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.encoder.Problem;

public abstract class AbstractEncoder {
    public CSP csp;
    public Problem problem;

    public AbstractEncoder(CSP cSP, Problem problem) {
        this.csp = cSP;
        this.problem = problem;
    }

    public int negateCode(int n) {
        n = n == 0 ? Integer.MIN_VALUE : (n == Integer.MIN_VALUE ? 0 : -n);
        return n;
    }

    public abstract void encodeIntegerVariable(IntegerVariable var1) throws SugarException;

    public abstract void encodeClause(Clause var1) throws SugarException;

    public void encode() throws SugarException {
        int n;
        int n2;
        this.problem.clear();
        int n22 = 0;
        for (IntegerVariable comparable : this.csp.getIntegerVariables()) {
            comparable.setCode(n22 + 1);
            n2 = comparable.getSatVariablesSize();
            n22 += n2;
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            booleanVariable.setCode(n22 + 1);
            n2 = booleanVariable.getSatVariablesSize();
            n22 += n2;
        }
        this.problem.addVariables(n22 - this.problem.variablesCount);
        int n3 = 0;
        int n4 = this.csp.getIntegerVariables().size();
        n2 = 10;
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            this.encodeIntegerVariable(integerVariable);
            if (100 * ++n3 / n4 < n2) continue;
            Logger.fine(n3 + " (" + n2 + "%) CSP integer variables are encoded (" + this.problem.summary() + ")");
            n2 += 10;
        }
        n3 = 0;
        int n5 = this.csp.getClauses().size();
        n2 = 10;
        for (Clause clause : this.csp.getClauses()) {
            if (clause.isValid()) continue;
            int n6 = this.problem.clausesCount;
            this.encodeClause(clause);
            ++n3;
            if (SugarMain.debug >= 1) {
                int n7 = this.problem.clausesCount - n6;
                Logger.fine(n7 + " SAT clauses for " + clause);
            }
            if (100 * n3 / n5 < n2) continue;
            Logger.fine(n3 + " (" + n2 + "%) CSP clauses are encoded (" + this.problem.summary() + ")");
            n2 += 10;
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            int n8;
            int n9;
            if (!integerVariable.isDominant() || (n9 = integerVariable.getCode()) >= (n8 = n9 + integerVariable.getSatVariablesSize() - 1)) continue;
            this.problem.addPragmaDominant(n9, n8);
        }
        int n10 = 0;
        int n11 = 0;
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (!booleanVariable.isDominant()) continue;
            int n12 = booleanVariable.getCode();
            if (n11 == 0) {
                n11 = n = n12;
                continue;
            }
            if (n + true == n12) {
                n = n12;
                continue;
            }
            this.problem.addPragmaDominant(n11, n);
            n11 = n = n12;
        }
        if (n11 != 0) {
            this.problem.addPragmaDominant(n11, n);
        }
        this.problem.done();
        Logger.fine(n3 + " CSP clauses encoded");
    }

    public void encodeDelta() throws IOException, SugarException {
        int n;
        int n2 = this.problem.variablesCount;
        for (IntegerVariable object : this.csp.getIntegerVariablesDelta()) {
            object.setCode(n2 + 1);
            n = object.getSatVariablesSize();
            n2 += n;
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariablesDelta()) {
            booleanVariable.setCode(n2 + 1);
            n = booleanVariable.getSatVariablesSize();
            n2 += n;
        }
        this.problem.addVariables(n2 - this.problem.variablesCount);
        for (IntegerVariable integerVariable : this.csp.getIntegerVariablesDelta()) {
            this.encodeIntegerVariable(integerVariable);
        }
        for (Clause clause : this.csp.getClausesDelta()) {
            if (clause.isValid()) continue;
            this.encodeClause(clause);
        }
        this.problem.done();
    }

    public void outputMap(String string) throws SugarException, IOException {
        CharSequence charSequence;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        if (this.csp.getObjectiveVariables() != null) {
            Object object = "objective ";
            if (this.csp.getObjective().equals((Object)CSP.Objective.MINIMIZE)) {
                object = (String)object + "minimize";
            } else if (this.csp.getObjective().equals((Object)CSP.Objective.MAXIMIZE)) {
                object = (String)object + "maximize";
            }
            for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                object = (String)object + " " + integerVariable.getName();
            }
            bufferedWriter.write((String)object);
            bufferedWriter.write(10);
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            if (integerVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = integerVariable.getCode();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("int " + integerVariable.getName() + " " + n + " ");
            integerVariable.getDomain().appendValues((StringBuilder)charSequence, true);
            bufferedWriter.write(((StringBuilder)charSequence).toString());
            bufferedWriter.write(10);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (booleanVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = booleanVariable.getCode();
            charSequence = "bool " + booleanVariable.getName() + " " + n;
            bufferedWriter.write((String)charSequence);
            bufferedWriter.write(10);
        }
        bufferedWriter.close();
    }

    public boolean decode(String string) throws SugarException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        String string2 = null;
        boolean bl = false;
        BitSet bitSet = new BitSet();
        block5: while (true) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -1) break;
            switch (streamTokenizer.ttype) {
                case 10: {
                    continue block5;
                }
                case -3: {
                    int n;
                    int n2;
                    if (streamTokenizer.sval.equals("s")) {
                        streamTokenizer.nextToken();
                        string2 = streamTokenizer.sval;
                        continue block5;
                    }
                    if (streamTokenizer.sval.equals("c")) {
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block5;
                    }
                    if (streamTokenizer.sval.equals("v")) {
                        do {
                            streamTokenizer.nextToken();
                            n2 = (int)streamTokenizer.nval;
                            n = Math.abs(n2);
                            if (n <= 0) continue;
                            bitSet.set(n, n2 > 0);
                        } while (streamTokenizer.ttype != 10);
                        continue block5;
                    }
                    string2 = streamTokenizer.sval;
                    continue block5;
                }
                case -2: {
                    int n2 = (int)streamTokenizer.nval;
                    int n = Math.abs(n2);
                    if (n <= 0) continue block5;
                    bitSet.set(n, n2 > 0);
                    continue block5;
                }
            }
        }
        bufferedReader.close();
        if (string2.startsWith("SAT")) {
            bl = true;
            for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
                integerVariable.decode(bitSet);
            }
            for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
                booleanVariable.decode(bitSet);
            }
        } else if (string2.startsWith("UNSAT")) {
            bl = false;
        } else {
            throw new SugarException("Unknown output result " + string2);
        }
        return bl;
    }
}

