/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.encoder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.util.BitSet;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.encoder.FileProblem;
import jp.kobe_u.sugar.encoder.OrderEncoder;
import jp.kobe_u.sugar.encoder.Problem;

public class Encoder
extends OrderEncoder {
    public Encoder(CSP cSP) {
        super(cSP, null);
    }

    public void commit() throws SugarException {
        this.problem.commit();
    }

    public void cancel() throws SugarException {
        this.problem.cancel();
    }

    public int getSatVariablesCount() {
        return this.problem.variablesCount;
    }

    public int getSatClausesCount() {
        return this.problem.clausesCount;
    }

    public long getSatFileSize() {
        return this.problem.fileSize;
    }

    public void encode(Problem problem) throws SugarException {
        this.problem = problem;
        if (this.csp.getGroups() > 0) {
            problem.setGroups(this.csp.getGroups(), this.csp.getTopWeight());
        }
        this.encode();
    }

    public void encode(String string) throws SugarException {
        this.encode(new FileProblem(string));
    }

    public void encode(String string, boolean bl) throws SugarException {
        if (bl) {
            throw new SugarException("incremental is not supported");
        }
        this.encode(string);
    }

    @Override
    public void outputMap(String string) throws IOException {
        CharSequence charSequence;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        if (this.csp.getObjectiveVariables() != null) {
            Object object = "objective ";
            if (this.csp.getObjective().equals((Object)CSP.Objective.MINIMIZE)) {
                object = (String)object + "minimize";
            } else if (this.csp.getObjective().equals((Object)CSP.Objective.MAXIMIZE)) {
                object = (String)object + "maximize";
            }
            for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                object = (String)object + " " + integerVariable.getName();
            }
            bufferedWriter.write((String)object);
            bufferedWriter.write(10);
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            if (integerVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = integerVariable.getCode();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("int " + integerVariable.getName() + " " + n + " ");
            integerVariable.getDomain().appendValues((StringBuilder)charSequence, true);
            bufferedWriter.write(((StringBuilder)charSequence).toString());
            bufferedWriter.write(10);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (booleanVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = booleanVariable.getCode();
            charSequence = "bool " + booleanVariable.getName() + " " + n;
            bufferedWriter.write((String)charSequence);
            bufferedWriter.write(10);
        }
        bufferedWriter.close();
    }

    @Override
    public boolean decode(String string) throws SugarException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        String string2 = null;
        boolean bl = false;
        BitSet bitSet = new BitSet();
        block5: while (true) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -1) break;
            switch (streamTokenizer.ttype) {
                case 10: {
                    continue block5;
                }
                case -3: {
                    int n;
                    int n2;
                    if (streamTokenizer.sval.equals("s")) {
                        streamTokenizer.nextToken();
                        string2 = streamTokenizer.sval;
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block5;
                    }
                    if (streamTokenizer.sval.equals("c")) {
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block5;
                    }
                    if (streamTokenizer.sval.equals("v")) {
                        do {
                            streamTokenizer.nextToken();
                            n2 = (int)streamTokenizer.nval;
                            n = Math.abs(n2);
                            if (n <= 0) continue;
                            bitSet.set(n, n2 > 0);
                        } while (streamTokenizer.ttype != 10);
                        continue block5;
                    }
                    string2 = streamTokenizer.sval;
                    continue block5;
                }
                case -2: {
                    string2 = "SAT";
                    int n2 = (int)streamTokenizer.nval;
                    int n = Math.abs(n2);
                    if (n <= 0) continue block5;
                    bitSet.set(n, n2 > 0);
                    continue block5;
                }
            }
        }
        bufferedReader.close();
        if (string2.startsWith("SAT") || string2.startsWith("OPT")) {
            bl = true;
            for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
                integerVariable.decode(bitSet);
            }
            for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
                booleanVariable.decode(bitSet);
            }
        } else if (string2.startsWith("UNSAT")) {
            bl = false;
        } else {
            throw new SugarException("Unknown output result " + string2);
        }
        return bl;
    }

    public String summary() {
        return this.problem.summary();
    }
}

