/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.encoder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.encoder.Problem;

public class FileProblem
extends Problem {
    public static boolean USE_NEWIO = true;
    public static int SAT_BUFFER_SIZE = 4096;
    public static long MAX_SAT_SIZE = 0xC0000000L;
    public static String PRAGMA_DOMINANT = "d";
    private String satFileName;
    private FileChannel satFileChannel = null;
    private ByteBuffer satByteBuffer = null;

    public FileProblem(String string) throws SugarException {
        this.satFileName = string;
        this.clear();
    }

    public void open() throws SugarException {
        if (this.satFileChannel != null) {
            throw new SugarException("Internal error: re-opening file " + this.satFileName);
        }
        try {
            if (this.fileSize == 0L) {
                this.satFileChannel = new FileOutputStream(this.satFileName).getChannel();
            } else {
                this.satFileChannel = new RandomAccessFile(this.satFileName, "rw").getChannel();
                this.satFileChannel.position(this.fileSize);
            }
            this.satByteBuffer = ByteBuffer.allocateDirect(SAT_BUFFER_SIZE);
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    public void write(byte[] byArray) throws SugarException {
        if (this.satFileChannel == null) {
            this.open();
        }
        int n = byArray.length;
        if (this.satByteBuffer.position() + n > SAT_BUFFER_SIZE) {
            this.flush();
        }
        int n2 = 0;
        while (n > SAT_BUFFER_SIZE) {
            this.satByteBuffer.put(byArray, n2, SAT_BUFFER_SIZE);
            this.flush();
            n2 += SAT_BUFFER_SIZE;
            n -= SAT_BUFFER_SIZE;
        }
        this.satByteBuffer.put(byArray, n2, n);
        this.fileSize += (long)byArray.length;
        if (this.fileSize >= MAX_SAT_SIZE) {
            new File(this.satFileName).delete();
            throw new SugarException("Encoding is interrupted because file size becomes too large (" + this.fileSize + " bytes)");
        }
    }

    public void write(String string) throws SugarException {
        this.write(string.getBytes());
    }

    public void flush() throws SugarException {
        if (this.satFileChannel == null) {
            return;
        }
        try {
            this.satByteBuffer.flip();
            this.satFileChannel.write(this.satByteBuffer);
            this.satByteBuffer.clear();
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    public void close() throws SugarException {
        if (this.satFileChannel == null) {
            return;
        }
        try {
            this.flush();
            this.satFileChannel.close();
            this.satFileChannel = null;
            this.satByteBuffer = null;
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update() throws SugarException {
        int n = 64;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.groups > 0) {
            if (GCNF) {
                stringBuilder.append("p gcnf ");
                stringBuilder.append(Integer.toString(this.variablesCount));
                stringBuilder.append(" ");
                stringBuilder.append(Integer.toString(this.clausesCount));
                stringBuilder.append(" ");
                stringBuilder.append(Integer.toString(this.groups));
            } else {
                if (!GWCNF) throw new SugarException("GCNF or GWCNF format should be used");
                stringBuilder.append("p gwcnf ");
                stringBuilder.append(Integer.toString(this.variablesCount));
                stringBuilder.append(" ");
                stringBuilder.append(Integer.toString(this.clausesCount));
                stringBuilder.append(" ");
                stringBuilder.append(Integer.toString(this.topWeight));
            }
        } else {
            stringBuilder.append("p cnf ");
            stringBuilder.append(Integer.toString(this.variablesCount));
            stringBuilder.append(" ");
            stringBuilder.append(Integer.toString(this.clausesCount));
        }
        while (stringBuilder.length() < n - 1) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        String string = stringBuilder.toString();
        if (this.satFileChannel != null) {
            throw new SugarException("Internal error: updating opening file " + this.satFileName);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.satFileName, "rw");
            randomAccessFile.seek(0L);
            randomAccessFile.write(string.getBytes());
            if (this.fileSize == 0L) {
                this.fileSize = string.length();
            }
            randomAccessFile.setLength(this.fileSize);
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void clear() throws SugarException {
        super.clear();
        this.update();
    }

    @Override
    public void commit() throws SugarException {
        super.commit();
    }

    @Override
    public void cancel() throws SugarException {
        this.done();
        super.cancel();
        this.update();
    }

    @Override
    public void done() throws SugarException {
        if (this.clausesCount == 0) {
            if (this.variablesCount == 0) {
                ++this.variablesCount;
            }
            this.addNormalizedClause(new int[]{1, -1});
            ++this.clausesCount;
        }
        this.flush();
        this.close();
        this.update();
    }

    @Override
    public void addComment(String string) throws SugarException {
        if (SugarMain.debug >= 1) {
            this.write("c " + string + "\n");
        }
    }

    @Override
    public void addPragmaDominant(int n, int n2) throws SugarException {
        this.write("c PRAGMA " + PRAGMA_DOMINANT + " " + n + " " + n2 + "\n");
    }

    @Override
    public void addNormalizedClause(int[] nArray) throws SugarException {
        if (GCNF) {
            if (this.groupsString == null) {
                this.write("{0} ");
            } else {
                this.write("{" + this.groupsString + "} ");
            }
        } else if (GWCNF) {
            if (this.groupsString == null) {
                this.write("0 " + this.topWeight + " ");
            } else {
                this.write(this.groupsString + " " + this.weightString + " ");
            }
        }
        for (int n : nArray) {
            this.write(Integer.toString(n) + " ");
        }
        this.write("0\n");
    }
}

