/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.encoder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.HoldLiteral;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LabelLiteral;
import jp.kobe_u.sugar.csp.LinearEqLiteral;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearNeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.csp.PowerLiteral;
import jp.kobe_u.sugar.csp.ProductLiteral;
import jp.kobe_u.sugar.csp.RelationLiteral;
import jp.kobe_u.sugar.encoder.AbstractEncoder;
import jp.kobe_u.sugar.encoder.Problem;

public class OrderEncoder
extends AbstractEncoder {
    public OrderEncoder(CSP cSP, Problem problem) {
        super(cSP, problem);
    }

    private int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i + n] = nArray[i];
        }
        return nArray2;
    }

    private int getCodeLE(IntegerVariable integerVariable, int n) {
        if (n < integerVariable.getDomain().getLowerBound()) {
            return 0;
        }
        if (n >= integerVariable.getDomain().getUpperBound()) {
            return Integer.MIN_VALUE;
        }
        return integerVariable.getCode() + integerVariable.getDomain().sizeLE(n) - 1;
    }

    private int getCodeLE(IntegerVariable integerVariable, int n, int n2) {
        int n3;
        if (n >= 0) {
            int n4 = n2 >= 0 ? n2 / n : (n2 - n + 1) / n;
            n3 = this.getCodeLE(integerVariable, n4);
        } else {
            int n5 = n2 >= 0 ? n2 / n - 1 : (n2 + n + 1) / n - 1;
            n3 = this.negateCode(this.getCodeLE(integerVariable, n5));
        }
        return n3;
    }

    private int getCode(LinearGeLiteral linearGeLiteral) throws SugarException {
        int n;
        if (!linearGeLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearGeLiteral.toString());
        }
        LinearSum linearSum = linearGeLiteral.getLinearExpression();
        int n2 = linearSum.getB();
        if (linearSum.size() == 0) {
            n = n2 >= 0 ? Integer.MIN_VALUE : 0;
        } else {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            int n3 = linearSum.getA(integerVariable);
            n = this.getCodeLE(integerVariable, -n3, n2);
        }
        return n;
    }

    private int getCode(LinearLeLiteral linearLeLiteral) throws SugarException {
        int n;
        if (!linearLeLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearLeLiteral.toString());
        }
        LinearSum linearSum = linearLeLiteral.getLinearExpression();
        int n2 = linearSum.getB();
        if (linearSum.size() == 0) {
            n = n2 <= 0 ? Integer.MIN_VALUE : 0;
        } else {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            int n3 = linearSum.getA(integerVariable);
            n = this.getCodeLE(integerVariable, n3, -n2);
        }
        return n;
    }

    @Override
    public void encodeIntegerVariable(IntegerVariable integerVariable) throws SugarException {
        this.problem.addComment(integerVariable.toString());
        IntegerDomain integerDomain = integerVariable.getDomain();
        int[] nArray = new int[2];
        int n = integerDomain.getLowerBound();
        for (int i = n + 1; i <= integerDomain.getUpperBound(); ++i) {
            if (!integerDomain.contains(i)) continue;
            nArray[0] = this.negateCode(this.getCodeLE(integerVariable, n));
            nArray[1] = this.getCodeLE(integerVariable, i);
            this.problem.addClause(nArray);
            n = i;
        }
    }

    private void encodeLinearLe(int[] nArray, IntegerVariable[] integerVariableArray, int n, int n2, int[] nArray2) throws SugarException {
        if (n >= integerVariableArray.length - 1) {
            nArray2[n] = this.getCodeLE(integerVariableArray[n], nArray[n], -n2);
            if (nArray2[n] != Integer.MIN_VALUE) {
                this.problem.addClause(nArray2);
            }
        } else {
            int n3;
            int n4 = n2;
            int n5 = n2;
            for (n3 = n + 1; n3 < integerVariableArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n6 > 0) {
                    n4 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
                    n5 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                    continue;
                }
                n4 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                n5 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
            }
            n3 = nArray[n];
            IntegerDomain integerDomain = integerVariableArray[n].getDomain();
            int n7 = integerDomain.getLowerBound();
            int n8 = integerDomain.getUpperBound();
            if (n3 >= 0) {
                n8 = -n4 >= 0 ? Math.min(n8, -n4 / n3) : Math.min(n8, (-n4 - n3 + 1) / n3);
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n9 = iterator.next();
                    nArray2[n] = this.getCodeLE(integerVariableArray[n], n9 - 1);
                    if (nArray2[n] == Integer.MIN_VALUE) continue;
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * n9, nArray2);
                }
                nArray2[n] = this.getCodeLE(integerVariableArray[n], n8);
                if (nArray2[n] != Integer.MIN_VALUE) {
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * (n8 + 1), nArray2);
                }
            } else {
                n7 = -n4 >= 0 ? Math.max(n7, -n4 / n3) : Math.max(n7, (-n4 + n3 + 1) / n3);
                nArray2[n] = this.negateCode(this.getCodeLE(integerVariableArray[n], n7 - 1));
                if (nArray2[n] != Integer.MIN_VALUE) {
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * (n7 - 1), nArray2);
                }
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n10 = iterator.next();
                    nArray2[n] = this.negateCode(this.getCodeLE(integerVariableArray[n], n10));
                    if (nArray2[n] == Integer.MIN_VALUE) continue;
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * n10, nArray2);
                }
            }
        }
    }

    private void encodeLinearLeLiteral(LinearLeLiteral linearLeLiteral, int[] nArray) throws SugarException {
        if (!linearLeLiteral.isValid()) {
            if (linearLeLiteral.isSimple()) {
                nArray = this.expand(nArray, 1);
                nArray[0] = this.getCode(linearLeLiteral);
                this.problem.addClause(nArray);
            } else {
                LinearSum linearSum = linearLeLiteral.getLinearExpression();
                int n = linearSum.size();
                IntegerVariable[] integerVariableArray = linearSum.getVariablesSorted();
                int[] nArray2 = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = linearSum.getA(integerVariableArray[i]);
                }
                nArray = this.expand(nArray, n);
                this.encodeLinearLe(nArray2, integerVariableArray, 0, linearSum.getB(), nArray);
            }
        }
    }

    private void encodeLinearNe(int[] nArray, IntegerVariable[] integerVariableArray, int n, int n2, int[] nArray2) throws SugarException {
        int n3 = n * 2;
        if (n >= integerVariableArray.length - 1) {
            nArray2[n3] = this.getCodeLE(integerVariableArray[n], nArray[n], -n2 - 1);
            nArray2[n3 + 1] = this.getCodeLE(integerVariableArray[n], -nArray[n], n2 - 1);
            if (nArray2[n3] != Integer.MIN_VALUE && nArray2[n3 + 1] != Integer.MIN_VALUE) {
                this.problem.addClause(nArray2);
            }
        } else {
            int n4 = nArray[n];
            IntegerDomain integerDomain = integerVariableArray[n].getDomain();
            Iterator<Integer> iterator = integerDomain.values();
            while (iterator.hasNext()) {
                int n5 = iterator.next();
                nArray2[n3] = this.getCodeLE(integerVariableArray[n], 1, n5 - 1);
                nArray2[n3 + 1] = this.getCodeLE(integerVariableArray[n], -1, -n5 - 1);
                if (nArray2[n3] == Integer.MIN_VALUE || nArray2[n3 + 1] == Integer.MIN_VALUE) continue;
                this.encodeLinearNe(nArray, integerVariableArray, n + 1, n2 + n4 * n5, nArray2);
            }
        }
    }

    private void encodeLinearNeLiteral(LinearNeLiteral linearNeLiteral, int[] nArray) throws SugarException {
        if (!linearNeLiteral.isValid()) {
            LinearSum linearSum = linearNeLiteral.getLinearExpression();
            int n = linearSum.size();
            IntegerVariable[] integerVariableArray = linearSum.getVariablesSorted();
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = linearSum.getA(integerVariableArray[i]);
            }
            nArray = this.expand(nArray, 2 * n);
            this.encodeLinearNe(nArray2, integerVariableArray, 0, linearSum.getB(), nArray);
        }
    }

    private void encodeRelationLiteral(RelationLiteral relationLiteral, int[] nArray) throws SugarException {
        int n = relationLiteral.arity;
        int[] nArray2 = new int[2 * n + nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[2 * n + i] = nArray[i];
        }
        List<RelationLiteral.Brick> list = relationLiteral.getConflictBricks();
        for (RelationLiteral.Brick brick : list) {
            for (int i = 0; i < n; ++i) {
                IntegerVariable integerVariable = relationLiteral.vs[i];
                nArray2[2 * i + 0] = this.getCodeLE(integerVariable, brick.lb[i] - 1);
                nArray2[2 * i + 1] = this.negateCode(this.getCodeLE(integerVariable, brick.ub[i]));
            }
            this.problem.addClause(nArray2);
        }
    }

    private void encodeLiteral(Literal literal, int[] nArray) throws SugarException {
        if (literal instanceof BooleanLiteral) {
            nArray = this.expand(nArray, 1);
            nArray[0] = ((BooleanLiteral)literal).getCode();
            this.problem.addClause(nArray);
        } else if (literal instanceof RelationLiteral) {
            this.encodeRelationLiteral((RelationLiteral)literal, nArray);
        } else if (literal instanceof LinearLeLiteral) {
            this.encodeLinearLeLiteral((LinearLeLiteral)literal, nArray);
        } else if (literal instanceof LinearGeLiteral) {
            LinearSum linearSum = new LinearSum(0);
            linearSum.subtract(((LinearGeLiteral)literal).getLinearExpression());
            this.encodeLinearLeLiteral(new LinearLeLiteral(linearSum), nArray);
        } else if (literal instanceof LinearEqLiteral) {
            LinearLeLiteral linearLeLiteral = new LinearLeLiteral(((LinearEqLiteral)literal).getLinearExpression());
            this.encodeLiteral(linearLeLiteral, nArray);
            LinearGeLiteral linearGeLiteral = new LinearGeLiteral(((LinearEqLiteral)literal).getLinearExpression());
            this.encodeLiteral(linearGeLiteral, nArray);
        } else if (literal instanceof LinearNeLiteral) {
            this.encodeLinearNeLiteral((LinearNeLiteral)literal, nArray);
        } else {
            if (literal instanceof ProductLiteral) {
                throw new SugarException("Cannot encode " + literal.toString());
            }
            if (literal instanceof PowerLiteral) {
                throw new SugarException("Cannot encode " + literal.toString());
            }
            if (literal instanceof HoldLiteral) {
                throw new SugarException("Cannot encode " + literal.toString());
            }
            throw new SugarException("Cannot encode " + literal.toString());
        }
    }

    @Override
    public void encodeClause(Clause clause) throws SugarException {
        if (clause.isValid()) {
            return;
        }
        if (!clause.isSimple()) {
            throw new SugarException("Cannot encode non-simple clause " + clause.toString());
        }
        this.problem.addComment(clause.toString());
        try {
            int[] nArray = new int[clause.simpleSize()];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 1;
            Literal literal = null;
            int n2 = 0;
            for (Literal literal2 : clause.getLiterals()) {
                if (literal2.isSimple()) {
                    int n3;
                    if (literal2 instanceof LabelLiteral) {
                        arrayList.add(((LabelLiteral)literal2).getLabel());
                        continue;
                    }
                    if (literal2 instanceof BooleanLiteral) {
                        n3 = ((BooleanLiteral)literal2).getCode();
                    } else if (literal2 instanceof LinearLeLiteral) {
                        n3 = this.getCode((LinearLeLiteral)literal2);
                    } else if (literal2 instanceof LinearGeLiteral) {
                        n3 = this.getCode((LinearGeLiteral)literal2);
                    } else {
                        throw new SugarException("Cannot encode literal " + literal2.toString());
                    }
                    if (n3 == Integer.MIN_VALUE) {
                        return;
                    }
                    nArray[n2++] = n3;
                    continue;
                }
                literal = literal2;
            }
            this.problem.beginGroups(arrayList, n);
            if (literal == null) {
                this.problem.addClause(nArray);
            } else {
                this.encodeLiteral(literal, nArray);
            }
            this.problem.endGroups();
        }
        catch (SugarException sugarException) {
            throw new SugarException(sugarException.getMessage() + " in " + clause);
        }
    }
}

