/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.encoder;

import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;

public abstract class Problem {
    public static boolean GCNF = false;
    public static boolean GWCNF = false;
    public static final int FALSE_CODE = 0;
    public static final int TRUE_CODE = Integer.MIN_VALUE;
    public int groups;
    public int topWeight;
    public int variablesCount = 0;
    public int clausesCount = 0;
    public long fileSize = 0L;
    private int variablesCountSave = 0;
    private int clausesCountSave = 0;
    private long fileSizeSave = 0L;
    protected String groupsString = null;
    protected String weightString = null;

    public void clear() throws SugarException {
        this.variablesCount = 0;
        this.clausesCount = 0;
        this.fileSize = 0L;
        this.commit();
    }

    public void commit() throws SugarException {
        this.variablesCountSave = this.variablesCount;
        this.clausesCountSave = this.clausesCount;
        this.fileSizeSave = this.fileSize;
    }

    public void cancel() throws SugarException {
        this.variablesCount = this.variablesCountSave;
        this.clausesCount = this.clausesCountSave;
        this.fileSize = this.fileSizeSave;
    }

    public abstract void done() throws SugarException;

    public void addVariables(int n) throws SugarException {
        this.variablesCount += n;
    }

    public boolean isValid(int[] nArray) {
        for (int n : nArray) {
            if (n != Integer.MIN_VALUE) continue;
            return true;
        }
        return false;
    }

    public int[] normalizeClause(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 != 0) continue;
            ++n;
        }
        if (n == nArray.length) {
            nArray = null;
        } else if (n > 0) {
            int[] nArray2 = new int[nArray.length - n];
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                nArray2[n3++] = nArray[i];
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public void addComment(String string) throws SugarException {
    }

    public void addPragmaDominant(int n, int n2) throws SugarException {
    }

    public void setGroups(int n, int n2) {
        this.groups = n;
        this.topWeight = n2;
    }

    public abstract void addNormalizedClause(int[] var1) throws SugarException;

    public void addClause(int[] nArray) throws SugarException {
        if ((nArray = this.normalizeClause(nArray)) == null) {
            if (this.variablesCount == 0) {
                this.addVariables(1);
            }
            this.addNormalizedClause(new int[]{1});
            ++this.clausesCount;
            this.addNormalizedClause(new int[]{-1});
            ++this.clausesCount;
            return;
        }
        if (this.isValid(nArray)) {
            if (SugarMain.debug > 0) {
                System.out.print("True clause found:");
                for (int n : nArray) {
                    System.out.print(" " + n);
                }
                System.out.println();
            }
            return;
        }
        this.addNormalizedClause(nArray);
        ++this.clausesCount;
    }

    public void beginGroups(List<Integer> list, int n) {
        if (list == null || list.size() == 0) {
            this.groupsString = null;
            this.weightString = null;
        } else {
            this.groupsString = "";
            String string = "";
            for (int n2 : list) {
                this.groupsString = this.groupsString + string + n2;
                string = ",";
            }
            this.weightString = Integer.toString(n);
        }
    }

    public void endGroups() {
        this.groupsString = null;
        this.weightString = null;
    }

    public String summary() {
        return this.variablesCount + " SAT variables, " + this.clausesCount + " SAT clauses, " + this.fileSize + " bytes";
    }
}

