/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.expression;

import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;

public class Atom
extends Expression {
    private Comparable atom;

    public Atom(Comparable comparable) {
        this.atom = comparable;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isString() {
        return this.atom instanceof String;
    }

    @Override
    public boolean isString(String string) {
        return this.isString() && this.atom.equals(string);
    }

    @Override
    public boolean isInteger() {
        return this.atom instanceof Integer;
    }

    @Override
    public String stringValue() {
        return (String)((Object)this.atom);
    }

    @Override
    public Integer integerValue() {
        return (Integer)this.atom;
    }

    @Override
    public int compareTo(Expression expression) {
        if (expression == null) {
            return 1;
        }
        if (expression instanceof Sequence) {
            return -1;
        }
        if (this.equals(expression)) {
            return 0;
        }
        Atom atom = (Atom)expression;
        return this.atom.compareTo(atom.atom);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.atom == null ? 0 : this.atom.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Atom atom = (Atom)object;
        return !(this.atom == null ? atom.atom != null : !this.atom.equals(atom.atom));
    }

    public String toString() {
        return this.atom.toString();
    }
}

