/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.expression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.expression.Atom;
import jp.kobe_u.sugar.expression.Sequence;

public abstract class Expression
implements Comparable<Expression> {
    public static boolean intern = false;
    public static final int MAX_MAP_SIZE = 10000;
    private static HashMap<Expression, Expression> map = new HashMap();
    public static final Expression DOMAIN_DEFINITION = Expression.create("domain");
    public static final Expression INT_DEFINITION = Expression.create("int");
    public static final Expression DINT_DEFINITION = Expression.create("dint");
    public static final Expression BOOL_DEFINITION = Expression.create("bool");
    public static final Expression DBOOL_DEFINITION = Expression.create("dbool");
    public static final Expression PREDICATE_DEFINITION = Expression.create("predicate");
    public static final Expression RELATION_DEFINITION = Expression.create("relation");
    public static final Expression OBJECTIVE_DEFINITION = Expression.create("objective");
    public static final Expression MINIMIZE = Expression.create("minimize");
    public static final Expression MAXIMIZE = Expression.create("maximize");
    public static final Expression SUPPORTS = Expression.create("supports");
    public static final Expression CONFLICTS = Expression.create("conflicts");
    public static final Expression FALSE = Expression.create("false");
    public static final Expression TRUE = Expression.create("true");
    public static final Expression NOT = Expression.create("not");
    public static final Expression AND = Expression.create("and");
    public static final Expression OR = Expression.create("or");
    public static final Expression IMP = Expression.create("imp");
    public static final Expression XOR = Expression.create("xor");
    public static final Expression IFF = Expression.create("iff");
    public static final Expression EQ = Expression.create("eq");
    public static final Expression NE = Expression.create("ne");
    public static final Expression LE = Expression.create("le");
    public static final Expression LT = Expression.create("lt");
    public static final Expression GE = Expression.create("ge");
    public static final Expression GT = Expression.create("gt");
    public static final Expression NEG = Expression.create("neg");
    public static final Expression ABS = Expression.create("abs");
    public static final Expression ADD = Expression.create("add");
    public static final Expression SUB = Expression.create("sub");
    public static final Expression MUL = Expression.create("mul");
    public static final Expression DIV = Expression.create("div");
    public static final Expression MOD = Expression.create("mod");
    public static final Expression POW = Expression.create("pow");
    public static final Expression MIN = Expression.create("min");
    public static final Expression MAX = Expression.create("max");
    public static final Expression IF = Expression.create("if");
    public static final Expression ALLDIFFERENT = Expression.create("alldifferent");
    public static final Expression WEIGHTEDSUM = Expression.create("weightedsum");
    public static final Expression CUMULATIVE = Expression.create("cumulative");
    public static final Expression ELEMENT = Expression.create("element");
    public static final Expression DISJUNCTIVE = Expression.create("disjunctive");
    public static final Expression LEX_LESS = Expression.create("lex_less");
    public static final Expression LEX_LESSEQ = Expression.create("lex_lesseq");
    public static final Expression NVALUE = Expression.create("nvalue");
    public static final Expression COUNT = Expression.create("count");
    public static final Expression GLOBAL_CARDINALITY = Expression.create("global_cardinality");
    public static final Expression GLOBAL_CARDINALITY_WITH_COSTS = Expression.create("global_cardinality_with_costs");
    public static final Expression HOLD = Expression.create("hold");
    public static final Expression NIL = Expression.create("nil");
    public static final Expression ZERO = Expression.intern(new Atom(Integer.valueOf(0)));
    public static final Expression ONE = Expression.intern(new Atom(Integer.valueOf(1)));
    public static final Expression WEIGHTED = Expression.create("weighted");
    public static final Expression ANY = Expression.create("$ANY");
    public static final Expression LABEL = Expression.create("label");
    public static final Expression GROUPS_DEFINITION = Expression.create("groups");
    private String comment = null;
    private static HashSet<Expression> operators = new HashSet();

    private static Expression intern(Expression expression) {
        if (intern && !map.containsKey(expression) && map.size() < 10000) {
            map.put(expression, expression);
        }
        return expression;
    }

    public static Expression create(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return ONE;
        }
        return Expression.intern(new Atom(Integer.valueOf(n)));
    }

    public static Expression create(String string) {
        return Expression.intern(new Atom((Comparable)((Object)string)));
    }

    public static Expression create(Expression[] expressionArray) {
        return Expression.intern(new Sequence(expressionArray));
    }

    public static Expression create(List<Expression> list) {
        return Expression.intern(new Sequence(list));
    }

    public static Expression create(Expression expression) {
        return Expression.create(new Expression[]{expression});
    }

    public static Expression create(Expression expression, Expression expression2) {
        return Expression.create(new Expression[]{expression, expression2});
    }

    public static Expression create(Expression expression, Expression expression2, Expression expression3) {
        return Expression.create(new Expression[]{expression, expression2, expression3});
    }

    public static Expression create(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return Expression.create(new Expression[]{expression, expression2, expression3, expression4});
    }

    public static Expression create(Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5) {
        return Expression.create(new Expression[]{expression, expression2, expression3, expression4, expression5});
    }

    public static Expression create(Expression expression, Expression[] expressionArray) {
        Expression[] expressionArray2 = new Expression[expressionArray.length + 1];
        int n = 0;
        expressionArray2[n++] = expression;
        for (Expression expression2 : expressionArray) {
            expressionArray2[n++] = expression2;
        }
        return Expression.create(expressionArray2);
    }

    public static Expression create(Expression expression, List<Expression> list) {
        Expression[] expressionArray = new Expression[list.size() + 1];
        int n = 0;
        expressionArray[n++] = expression;
        for (Expression expression2 : list) {
            expressionArray[n++] = expression2;
        }
        return Expression.create(expressionArray);
    }

    public static void clear() {
        map.clear();
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isString(String string) {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isSequence() {
        return false;
    }

    public boolean isSequence(Expression expression) {
        return false;
    }

    public boolean isSequence(int n) {
        return false;
    }

    public String stringValue() {
        return null;
    }

    public Integer integerValue() {
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Expression not() {
        return Expression.create(NOT, this);
    }

    public Expression and(Expression expression) {
        return Expression.create(AND, this, expression);
    }

    public Expression or(Expression expression) {
        return Expression.create(OR, this, expression);
    }

    public Expression imp(Expression expression) {
        return Expression.create(IMP, this, expression);
    }

    public Expression xor(Expression expression) {
        return Expression.create(XOR, this, expression);
    }

    public Expression iff(Expression expression) {
        return Expression.create(IFF, this, expression);
    }

    public Expression eq(Expression expression) {
        return Expression.create(EQ, this, expression);
    }

    public Expression eq(int n) {
        return this.eq(Expression.create(n));
    }

    public Expression ne(Expression expression) {
        return Expression.create(NE, this, expression);
    }

    public Expression ne(int n) {
        return this.ne(Expression.create(n));
    }

    public Expression le(Expression expression) {
        return Expression.create(LE, this, expression);
    }

    public Expression le(int n) {
        return this.le(Expression.create(n));
    }

    public Expression lt(Expression expression) {
        return Expression.create(LT, this, expression);
    }

    public Expression lt(int n) {
        return this.lt(Expression.create(n));
    }

    public Expression ge(Expression expression) {
        return Expression.create(GE, this, expression);
    }

    public Expression ge(int n) {
        return this.ge(Expression.create(n));
    }

    public Expression gt(Expression expression) {
        return Expression.create(GT, this, expression);
    }

    public Expression gt(int n) {
        return this.gt(Expression.create(n));
    }

    public Expression neg() {
        return Expression.create(NEG, this);
    }

    public Expression abs() {
        return Expression.create(ABS, this);
    }

    public Expression add(Expression expression) {
        return Expression.create(ADD, this, expression);
    }

    public Expression add(int n) {
        return this.add(Expression.create(n));
    }

    public static Expression add(Expression[] expressionArray) {
        return Expression.create(ADD, expressionArray);
    }

    public static Expression add(List<Expression> list) {
        return Expression.create(ADD, list);
    }

    public Expression sub(Expression expression) {
        return Expression.create(SUB, this, expression);
    }

    public Expression sub(int n) {
        return this.sub(Expression.create(n));
    }

    public Expression mul(Expression expression) {
        return Expression.create(MUL, this, expression);
    }

    public Expression mul(int n) {
        return this.mul(Expression.create(n));
    }

    public Expression div(Expression expression) {
        return Expression.create(DIV, this, expression);
    }

    public Expression div(int n) {
        return this.div(Expression.create(n));
    }

    public Expression mod(Expression expression) {
        return Expression.create(MOD, this, expression);
    }

    public Expression mod(int n) {
        return this.mod(Expression.create(n));
    }

    public Expression min(Expression expression) {
        return Expression.create(MIN, this, expression);
    }

    public Expression min(int n) {
        return this.min(Expression.create(n));
    }

    public Expression max(Expression expression) {
        return Expression.create(MAX, this, expression);
    }

    public Expression max(int n) {
        return this.max(Expression.create(n));
    }

    public Expression ifThenElse(Expression expression, Expression expression2) {
        return Expression.create(IF, this, expression, expression2);
    }

    public Expression ifThenElse(int n, Expression expression) {
        return Expression.create(IF, this, Expression.create(n), expression);
    }

    public Expression ifThenElse(Expression expression, int n) {
        return Expression.create(IF, this, expression, Expression.create(n));
    }

    public Expression ifThenElse(int n, int n2) {
        return Expression.create(IF, this, Expression.create(n), Expression.create(n2));
    }

    public Expression hold() {
        return Expression.create(HOLD, this);
    }

    public boolean matches(Expression expression) {
        if (expression.equals(ANY)) {
            return true;
        }
        if (this.isAtom() || expression.isAtom()) {
            return this.equals(expression);
        }
        Sequence sequence = (Sequence)this;
        Sequence sequence2 = (Sequence)expression;
        if (sequence.length() != sequence2.length()) {
            return false;
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.get(i).matches(sequence2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Expression alldifferent(Expression expression) {
        return Expression.create(ALLDIFFERENT, expression);
    }

    public static Expression weightedsum(Expression expression, Expression expression2, Expression expression3) {
        return Expression.create(WEIGHTEDSUM, expression, expression2, expression3);
    }

    public static Expression weightedsum(Expression expression, Expression expression2, int n) {
        return Expression.create(WEIGHTEDSUM, expression, expression2, Expression.create(n));
    }

    public static Expression cumulative(Expression expression, Expression expression2) {
        return Expression.create(CUMULATIVE, expression, expression2);
    }

    public static Expression cumulative(Expression expression, int n) {
        return Expression.create(CUMULATIVE, expression, Expression.create(n));
    }

    public static Expression element(Expression expression, Expression expression2, Expression expression3) {
        return Expression.create(ELEMENT, expression, expression2, expression3);
    }

    public static Expression disjunctive(Expression expression) {
        return Expression.create(DISJUNCTIVE, expression);
    }

    public static Expression lex_less(Expression expression, Expression expression2) {
        return Expression.create(LEX_LESS, expression, expression2);
    }

    public static Expression lex_lesseq(Expression expression, Expression expression2) {
        return Expression.create(LEX_LESSEQ, expression, expression2);
    }

    public static Expression nvalue(Expression expression, Expression expression2) {
        return Expression.create(NVALUE, expression, expression2);
    }

    public static Expression nvalue(int n, Expression expression) {
        return Expression.create(NVALUE, Expression.create(n), expression);
    }

    public static Expression count(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return Expression.create(COUNT, expression, expression2, expression3, expression4);
    }

    public static Expression global_cardinality(Expression expression, Expression expression2) {
        return Expression.create(GLOBAL_CARDINALITY, expression, expression2);
    }

    public static Expression global_cardinality_with_costs(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return Expression.create(GLOBAL_CARDINALITY_WITH_COSTS, expression, expression2, expression3, expression4);
    }

    public static Expression global_cardinality_with_costs(Expression expression, Expression expression2, Expression expression3, int n) {
        return Expression.create(GLOBAL_CARDINALITY_WITH_COSTS, expression, expression2, expression3, Expression.create(n));
    }

    public static boolean isOperator(Expression expression) {
        return operators.contains(expression);
    }

    public static boolean isLogical(Expression expression) {
        return expression.equals(FALSE) || expression.equals(TRUE) || expression.isSequence(NOT) || expression.isSequence(AND) || expression.isSequence(OR) || expression.isSequence(IMP) || expression.isSequence(XOR) || expression.isSequence(IFF);
    }

    public static boolean isComparison(Expression expression) {
        return expression.isSequence(EQ) || expression.isSequence(NE) || expression.isSequence(LE) || expression.isSequence(LT) || expression.isSequence(GE) || expression.isSequence(GT);
    }

    public static boolean isGlobalConstraint(Expression expression) {
        return expression.isSequence(ALLDIFFERENT) || expression.isSequence(WEIGHTEDSUM) || expression.isSequence(CUMULATIVE) || expression.isSequence(ELEMENT) || expression.isSequence(DISJUNCTIVE) || expression.isSequence(LEX_LESS) || expression.isSequence(LEX_LESSEQ) || expression.isSequence(NVALUE) || expression.isSequence(COUNT) || expression.isSequence(GLOBAL_CARDINALITY) || expression.isSequence(GLOBAL_CARDINALITY_WITH_COSTS);
    }

    public static void appendString(StringBuilder stringBuilder, int[] nArray) {
        String string = "";
        for (int n : nArray) {
            stringBuilder.append(string + n);
            string = " ";
        }
    }

    public static void appendString(StringBuilder stringBuilder, IntegerVariable[] integerVariableArray) {
        String string = "";
        for (IntegerVariable integerVariable : integerVariableArray) {
            stringBuilder.append(string);
            stringBuilder.append(integerVariable.getName());
            string = " ";
        }
    }

    static {
        operators.addAll(Arrays.asList(DOMAIN_DEFINITION, INT_DEFINITION, BOOL_DEFINITION, PREDICATE_DEFINITION, RELATION_DEFINITION, OBJECTIVE_DEFINITION, SUPPORTS, CONFLICTS, NOT, AND, OR, IMP, XOR, IFF, EQ, NE, LE, LT, GE, GT, NEG, ABS, ADD, SUB, MUL, DIV, MOD, POW, MIN, MAX, IF, ALLDIFFERENT, WEIGHTEDSUM, CUMULATIVE, ELEMENT, DISJUNCTIVE, LEX_LESS, LEX_LESSEQ, NVALUE, COUNT, GLOBAL_CARDINALITY, GLOBAL_CARDINALITY_WITH_COSTS, HOLD, WEIGHTED));
    }
}

