/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.expression;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.expression.Expression;

public class Parser {
    private static Map<String, Expression> conv = new HashMap<String, Expression>();
    private BufferedReader reader;
    private boolean prolog;
    private StreamTokenizer st;

    public Parser(BufferedReader bufferedReader, boolean bl) {
        this.reader = bufferedReader;
        this.prolog = bl;
    }

    public Parser(BufferedReader bufferedReader) {
        this(bufferedReader, false);
    }

    public List<Expression> parseCSP() throws IOException {
        this.st = new StreamTokenizer(this.reader);
        this.st.resetSyntax();
        this.st.commentChar(59);
        this.st.whitespaceChars(0, 32);
        this.st.wordChars(65, 90);
        this.st.wordChars(97, 122);
        this.st.wordChars(95, 95);
        this.st.wordChars(48, 57);
        char[] cArray = new char[]{'+', '-', '*', '/', '%', '=', '<', '>', '!', '&', '|', '$'};
        for (char c : cArray) {
            this.st.wordChars(c, c);
        }
        this.st.wordChars(128, 0x10FFFF);
        this.st.parseNumbers();
        this.st.eolIsSignificant(false);
        Object object = new Stack();
        List<Expression> list = new ArrayList<Expression>();
        this.st.nextToken();
        while (this.st.ttype != -1) {
            switch (this.st.ttype) {
                case -3: {
                    String string = this.st.sval;
                    Expression expression = conv.get(string);
                    if (expression == null) {
                        expression = Expression.create(string);
                    }
                    list.add(expression);
                    break;
                }
                case -2: {
                    int n = (int)this.st.nval;
                    Expression expression = Expression.create(n);
                    list.add(expression);
                    break;
                }
                case 45: {
                    list.add(conv.get("-"));
                    break;
                }
                case 40: {
                    ((Stack)object).push(list);
                    list = new ArrayList();
                    break;
                }
                case 41: {
                    int n;
                    if (list.size() == 2 && ((Expression)list.get(0)).equals(Expression.SUB)) {
                        list.remove(0);
                        list.add(0, Expression.NEG);
                    }
                    Expression expression = Expression.create(list);
                    if (((Vector)object).isEmpty()) {
                        throw new IOException("Too many right paren at line " + this.st.lineno());
                    }
                    list = (List)((Stack)object).pop();
                    list.add(expression);
                    if (!((Vector)object).isEmpty() || (n = list.size()) % 10000 != 0) break;
                    Logger.fine("parsed " + n + " expressions");
                    break;
                }
                default: {
                    int n = this.st.ttype;
                    throw new IOException("Bad character " + (char)n + " at line " + this.st.lineno());
                }
            }
            this.st.nextToken();
        }
        if (!((Vector)object).isEmpty()) {
            throw new IOException("Missing right paren at line " + this.st.lineno());
        }
        return list;
    }

    public List<Expression> parseProlog() throws IOException {
        this.st = new StreamTokenizer(this.reader);
        this.st.resetSyntax();
        this.st.commentChar(37);
        this.st.whitespaceChars(0, 32);
        this.st.wordChars(65, 90);
        this.st.wordChars(97, 122);
        this.st.wordChars(95, 95);
        this.st.wordChars(48, 57);
        char[] cArray = new char[]{'+', '-', '*', '/', '=', '<', '>', '!', '&', '|', '$'};
        for (char c : cArray) {
            this.st.wordChars(c, c);
        }
        this.st.wordChars(128, 0x10FFFF);
        this.st.quoteChar(39);
        this.st.eolIsSignificant(false);
        Object object = new Stack();
        List<Expression> list = new ArrayList<Expression>();
        this.st.nextToken();
        while (this.st.ttype != -1) {
            switch (this.st.ttype) {
                case -3: 
                case 39: {
                    Expression expression;
                    int n;
                    String string = this.st.sval;
                    if (string.matches("-?\\d+")) {
                        n = Integer.parseInt(string);
                        expression = Expression.create(n);
                    } else {
                        expression = conv.get(string);
                        if (expression == null) {
                            expression = Expression.create(string);
                        }
                    }
                    list.add(expression);
                    break;
                }
                case -2: {
                    int n = (int)this.st.nval;
                    Expression expression = Expression.create(n);
                    list.add(expression);
                    break;
                }
                case 45: {
                    list.add(conv.get("-"));
                    break;
                }
                case 91: {
                    ((Stack)object).push(list);
                    list = new ArrayList();
                    break;
                }
                case 93: {
                    int n;
                    if (list.size() == 2 && ((Expression)list.get(0)).equals(Expression.SUB)) {
                        list.remove(0);
                        list.add(0, Expression.NEG);
                    }
                    Expression expression = Expression.create(list);
                    if (((Vector)object).isEmpty()) {
                        throw new IOException("Too many right paren at line " + this.st.lineno());
                    }
                    list = (List)((Stack)object).pop();
                    list.add(expression);
                    if (!((Vector)object).isEmpty() || (n = list.size()) % 10000 != 0) break;
                    Logger.fine("parsed " + n + " expressions");
                    break;
                }
                case 44: {
                    break;
                }
                case 46: {
                    break;
                }
                default: {
                    int n = this.st.ttype;
                    throw new IOException("Bad character " + (char)n + " at line " + this.st.lineno());
                }
            }
            this.st.nextToken();
        }
        if (!((Vector)object).isEmpty()) {
            throw new IOException("Missing right paren at line " + this.st.lineno());
        }
        return list;
    }

    public List<Expression> parse() throws IOException {
        if (this.prolog) {
            return this.parseProlog();
        }
        return this.parseCSP();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage : java Parser file");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            Parser parser = new Parser(bufferedReader);
            List<Expression> list = parser.parse();
            for (Expression expression : list) {
                System.out.println(expression);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static {
        conv.put("!", Expression.NOT);
        conv.put("&&", Expression.AND);
        conv.put("||", Expression.OR);
        conv.put("=>", Expression.IMP);
        conv.put("=", Expression.EQ);
        conv.put("!=", Expression.NE);
        conv.put("<=", Expression.LE);
        conv.put("<", Expression.LT);
        conv.put(">=", Expression.GE);
        conv.put(">", Expression.GT);
        conv.put("+", Expression.ADD);
        conv.put("-", Expression.SUB);
        conv.put("*", Expression.MUL);
        conv.put("/", Expression.DIV);
        conv.put("%", Expression.MOD);
        conv.put("wsum", Expression.WEIGHTEDSUM);
    }
}

