/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.expression.Atom;
import jp.kobe_u.sugar.expression.Expression;

public class Sequence
extends Expression {
    public static boolean flatten = true;
    private Expression[] expressions;
    private Integer hashCode = null;

    public Sequence(Expression[] expressionArray) {
        this.expressions = expressionArray;
        this.init();
    }

    public Sequence(Collection<Expression> collection) {
        this.expressions = new Expression[0];
        this.expressions = collection.toArray(this.expressions);
        this.init();
    }

    private void init() {
        if (flatten && this.expressions.length > 0) {
            Expression expression = this.expressions[0];
            boolean bl = false;
            if (expression.equals(Expression.ADD) || expression.equals(Expression.AND) || expression.equals(Expression.OR)) {
                for (int i = 1; i < this.expressions.length; ++i) {
                    if (!this.expressions[i].isSequence(expression)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                arrayList.add(expression);
                for (int i = 1; i < this.expressions.length; ++i) {
                    if (this.expressions[i].isSequence(expression)) {
                        Sequence sequence = (Sequence)this.expressions[i];
                        for (int j = 1; j < sequence.length(); ++j) {
                            arrayList.add(sequence.get(j));
                        }
                        continue;
                    }
                    arrayList.add(this.expressions[i]);
                }
                this.expressions = new Expression[0];
                this.expressions = arrayList.toArray(this.expressions);
            }
        }
        this.hashCode = this.hashCode();
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public Expression get(int n) {
        return this.expressions[n];
    }

    @Override
    public boolean isSequence() {
        return true;
    }

    @Override
    public boolean isSequence(Expression expression) {
        return this.expressions.length >= 1 && this.expressions[0].equals(expression);
    }

    @Override
    public boolean isSequence(int n) {
        return this.expressions.length == n + 1;
    }

    public int length() {
        return this.expressions.length;
    }

    public boolean matches(String string) throws SugarException {
        int n;
        block7: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '*') {
                return true;
            }
            if (n >= this.expressions.length) {
                return false;
            }
            Expression expression = this.expressions[n];
            switch (c) {
                case '.': {
                    continue block7;
                }
                case 'A': {
                    if (expression.isAtom()) continue block7;
                    return false;
                }
                case 'W': {
                    if (expression.isString()) continue block7;
                    return false;
                }
                case 'I': {
                    if (expression.isInteger()) continue block7;
                    return false;
                }
                case 'S': {
                    if (expression.isSequence()) continue block7;
                    return false;
                }
                default: {
                    throw new SugarException("Unknown pattern name " + Character.toString(c));
                }
            }
        }
        return n == this.expressions.length;
    }

    @Override
    public int compareTo(Expression expression) {
        if (expression == null) {
            return 1;
        }
        if (expression instanceof Atom) {
            return 1;
        }
        if (this.equals(expression)) {
            return 0;
        }
        Sequence sequence = (Sequence)expression;
        if (this.expressions.length < sequence.expressions.length) {
            return -1;
        }
        if (this.expressions.length > sequence.expressions.length) {
            return 1;
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            int n = this.get(i).compareTo(sequence.get(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int n = 1;
            this.hashCode = 31 * n + Arrays.hashCode(this.expressions);
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sequence sequence = (Sequence)object;
        return Arrays.equals(this.expressions, sequence.expressions);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "(";
        for (Expression expression : this.expressions) {
            stringBuilder.append(string);
            stringBuilder.append(expression.toString());
            string = " ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

