/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.hook;

import java.util.ArrayList;
import java.util.List;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.expression.Expression;
import jp.kobe_u.sugar.expression.Sequence;
import jp.kobe_u.sugar.hook.ConverterHook;

public class ExampleHook
implements ConverterHook {
    private static Expression MyConstant = Expression.create("myconstant");
    private static Expression MyPredicate = Expression.create("mypredicate");

    @Override
    public Expression convertFunction(Converter converter, Expression expression) throws SugarException {
        if (expression.equals(MyConstant)) {
            Expression expression2 = Expression.create(55);
            return expression2;
        }
        return expression;
    }

    @Override
    public Expression convertConstraint(Converter converter, Expression expression, boolean bl, List<Clause> list) throws SugarException {
        if (expression.isSequence(MyPredicate)) {
            Sequence sequence = (Sequence)expression;
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(Expression.AND);
            for (int i = 1; i < sequence.length() - 1; ++i) {
                arrayList.add(sequence.get(i).lt(sequence.get(i + 1)));
            }
            Expression expression2 = Expression.create(arrayList);
            return expression2;
        }
        if (expression.isSequence(Expression.ALLDIFFERENT)) {
            return this.convertAlldifferent(converter, (Sequence)expression, bl, list);
        }
        return expression;
    }

    private Expression convertAlldifferent(Converter converter, Sequence sequence, boolean bl, List<Clause> list) throws SugarException {
        int n;
        Expression[] expressionArray;
        Expression expression = converter.convertGlobal(sequence, bl, list);
        if (sequence.length() == 2 && sequence.get(1).isSequence()) {
            expressionArray = ((Sequence)sequence.get(1)).getExpressions();
        } else {
            expressionArray = new Expression[sequence.length() - 1];
            for (n = 1; n < sequence.length(); ++n) {
                expressionArray[n - 1] = sequence.get(n);
            }
        }
        n = expressionArray.length;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (Expression expression2 : expressionArray) {
            IntegerDomain integerDomain = converter.convertFormula(expression2).getDomain();
            n2 = Math.min(n2, integerDomain.getLowerBound());
            n3 = Math.max(n3, integerDomain.getUpperBound());
        }
        if (n == n3 - n2 + 1) {
            for (int i = n2; i <= n3; ++i) {
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                arrayList.add(Expression.OR);
                for (Expression expression3 : expressionArray) {
                    arrayList.add(expression3.eq(i));
                }
                expression = expression == null ? Expression.create(arrayList) : expression.and(Expression.create(arrayList));
            }
        }
        return expression;
    }
}

