/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.hybrid;

import jp.kobe_u.sugar.Logger;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.converter.Converter;
import jp.kobe_u.sugar.converter.Simplifier;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;

public class HybridConverter {
    public static int HYBRID_OPTION = 0;
    public static int HYBRID_PARAM = 4096;
    public static boolean USE_PMINIMAL = false;
    private CSP csp;
    private Converter converter;

    public HybridConverter(CSP cSP) {
        this.csp = cSP;
        this.converter = new Converter(cSP);
    }

    private void classifyByBoolean() {
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            if (!integerVariable.isBoolean()) continue;
            integerVariable.setEncoding(Encoding.LOG);
        }
    }

    private void classifyByPB() {
        for (Clause clause : this.csp.getClauses()) {
            for (Literal literal : clause.getLiterals()) {
                if (!(literal instanceof LinearLiteral)) continue;
                LinearSum linearSum = ((LinearLiteral)literal).getLinearExpression();
                boolean bl = true;
                for (IntegerVariable integerVariable : linearSum.getVariables()) {
                    if (integerVariable.isBoolean()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (IntegerVariable integerVariable : linearSum.getVariables()) {
                    integerVariable.setEncoding(Encoding.LOG);
                }
            }
        }
    }

    private void classifyByDomainSize() {
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            IntegerDomain integerDomain = integerVariable.getDomain();
            if (integerDomain.size() <= HYBRID_PARAM) continue;
            integerVariable.setEncoding(Encoding.LOG);
        }
    }

    private void classifyByDomainProduct() {
        for (Clause clause : this.csp.getClauses()) {
            for (Literal literal : clause.getLiterals()) {
                LinearSum linearSum;
                if (!(literal instanceof LinearLiteral) || !(linearSum = ((LinearLiteral)literal).getLinearExpression()).isDomainLargerThanExcept(HYBRID_PARAM)) continue;
                for (IntegerVariable integerVariable : linearSum.getVariables()) {
                    integerVariable.setEncoding(Encoding.LOG);
                }
            }
        }
    }

    public void classifyVariables() throws SugarException {
        block18: {
            switch (HYBRID_OPTION) {
                case 0: {
                    Logger.fine("Hybrid 0 (Order encoding)");
                    break;
                }
                case 1: {
                    Logger.fine("Hybrid 1 (Log encoding)");
                    for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
                        integerVariable.setEncoding(Encoding.LOG);
                    }
                    break;
                }
                case 2: {
                    Logger.fine("Hybrid 2 (Log encoding for 0-1 variables)");
                    this.classifyByBoolean();
                    break;
                }
                case 3: {
                    Logger.fine("Hybrid 3 (by Domain Size " + HYBRID_PARAM + ")");
                    this.classifyByDomainSize();
                    break;
                }
                case 4: {
                    Logger.fine("Hybrid 4 (by Domain Product " + HYBRID_PARAM + ")");
                    this.classifyByDomainProduct();
                    break;
                }
                case 5: {
                    Logger.fine("Hybrid 5 (by Domain Size " + HYBRID_PARAM + ")");
                    this.classifyByBoolean();
                    this.classifyByDomainSize();
                    break;
                }
                case 6: {
                    Logger.fine("Hybrid 6 (by Domain Product " + HYBRID_PARAM + ")");
                    this.classifyByBoolean();
                    this.classifyByDomainProduct();
                    break;
                }
                case 7: {
                    Logger.fine("Hybrid 7 (by Domain Size " + HYBRID_PARAM + ")");
                    this.classifyByDomainSize();
                    this.classifyByPB();
                    break;
                }
                case 8: {
                    Logger.fine("Hybrid 8 (by Domain Product " + HYBRID_PARAM + ")");
                    this.classifyByDomainProduct();
                    this.classifyByPB();
                    break;
                }
                case 9: {
                    Logger.fine("Hybrid 9 (by Domain Size " + HYBRID_PARAM + ")");
                    this.classifyByBoolean();
                    this.classifyByDomainSize();
                    this.classifyByPB();
                    break;
                }
                case 10: {
                    Logger.fine("Hybrid 10 (by Domain Product " + HYBRID_PARAM + ")");
                    this.classifyByBoolean();
                    this.classifyByDomainProduct();
                    this.classifyByPB();
                }
            }
            if (this.csp.getObjectiveVariables() == null) break block18;
            if (USE_PMINIMAL) {
                for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                    integerVariable.setEncoding(Encoding.ORDER);
                }
            } else {
                for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                    integerVariable.setEncoding(Encoding.LOG);
                }
            }
        }
    }

    public int[] count() {
        int n = 0;
        int n2 = 0;
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            Encoding encoding = integerVariable.getEncoding();
            if (SugarMain.debug >= 1) {
                Logger.fine("Encoding : " + (Object)((Object)encoding) + " " + integerVariable);
            }
            switch (encoding) {
                case ORDER: {
                    ++n;
                    break;
                }
                case LOG: {
                    ++n2;
                    break;
                }
            }
        }
        return new int[]{n, n2};
    }

    public void convert() throws SugarException {
        this.csp.propagate();
        if (this.csp.isUnsatisfiable()) {
            return;
        }
        this.classifyVariables();
        int[] nArray = this.count();
        Logger.fine("First classification of variables : Order=" + nArray[0] + " Log=" + nArray[1]);
        Converter.REDUCE_ARITY = true;
        this.converter.reduceAll();
        this.csp.propagate();
        if (this.csp.isUnsatisfiable()) {
            return;
        }
        this.classifyVariables();
        int[] nArray2 = this.count();
        Logger.fine("Second classification of variables : Order=" + nArray2[0] + " Log=" + nArray2[1]);
        Simplifier simplifier = new Simplifier(this.csp);
        simplifier.simplify();
        Logger.info("CSP : " + this.csp.summary());
        if (SugarMain.debug > 0) {
            this.csp.output(System.out, "c ");
        }
        Logger.status();
        Runtime.getRuntime().gc();
    }
}

