/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.hybrid;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearEqLiteral;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearNeLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.encoder.Encoding;
import jp.kobe_u.sugar.hybrid.HybridConverter;
import jp.kobe_u.sugar.pb.PBExpr;
import jp.kobe_u.sugar.pb.PBProblem;

public class HybridEncoder {
    public CSP csp;
    public PBProblem problem;

    public HybridEncoder(CSP cSP, PBProblem pBProblem) {
        this.csp = cSP;
        this.problem = pBProblem;
    }

    private int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i + n] = nArray[i];
        }
        return nArray2;
    }

    public int negateCode(int n) {
        n = n == 0 ? Integer.MIN_VALUE : (n == Integer.MIN_VALUE ? 0 : -n);
        return n;
    }

    private void addClause(int[] nArray) throws SugarException {
        for (int n : nArray) {
            if (n != Integer.MIN_VALUE) continue;
            return;
        }
        Object object = new PBExpr();
        int n = -1;
        for (int n2 : nArray) {
            if (n2 == 0) continue;
            if (n2 > 0) {
                ((PBExpr)object).add(1, n2);
                continue;
            }
            ((PBExpr)object).add(-1, -n2);
            ++n;
        }
        ((PBExpr)object).setCmp(">=");
        ((PBExpr)object).add(n);
        this.problem.addPB((PBExpr)object);
    }

    private int getCodeLE(IntegerVariable integerVariable, int n) {
        if (n < integerVariable.getDomain().getLowerBound()) {
            return 0;
        }
        if (n >= integerVariable.getDomain().getUpperBound()) {
            return Integer.MIN_VALUE;
        }
        return integerVariable.getCode() + integerVariable.getDomain().sizeLE(n) - 1;
    }

    private int getCodeLE(IntegerVariable integerVariable, int n, int n2) {
        int n3;
        if (n >= 0) {
            int n4 = n2 >= 0 ? n2 / n : (n2 - n + 1) / n;
            n3 = this.getCodeLE(integerVariable, n4);
        } else {
            int n5 = n2 >= 0 ? n2 / n - 1 : (n2 + n + 1) / n - 1;
            n3 = this.negateCode(this.getCodeLE(integerVariable, n5));
        }
        return n3;
    }

    private int getCode(LinearLeLiteral linearLeLiteral) throws SugarException {
        int n;
        if (!linearLeLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearLeLiteral.toString());
        }
        LinearSum linearSum = linearLeLiteral.getLinearExpression();
        int n2 = linearSum.getB();
        if (linearSum.size() == 0) {
            n = n2 <= 0 ? Integer.MIN_VALUE : 0;
        } else {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            if (integerVariable.getEncoding() != Encoding.ORDER) {
                throw new SugarException("Internal error " + linearLeLiteral.toString());
            }
            int n3 = linearSum.getA(integerVariable);
            n = this.getCodeLE(integerVariable, n3, -n2);
        }
        return n;
    }

    private int getCode(LinearGeLiteral linearGeLiteral) throws SugarException {
        int n;
        if (!linearGeLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearGeLiteral.toString());
        }
        LinearSum linearSum = linearGeLiteral.getLinearExpression();
        int n2 = linearSum.getB();
        if (linearSum.size() == 0) {
            n = n2 >= 0 ? Integer.MIN_VALUE : 0;
        } else {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            if (integerVariable.getEncoding() != Encoding.ORDER) {
                throw new SugarException("Internal error " + linearGeLiteral.toString());
            }
            int n3 = linearSum.getA(integerVariable);
            n = this.getCodeLE(integerVariable, -n3, n2);
        }
        return n;
    }

    private int getCode(LinearEqLiteral linearEqLiteral) throws SugarException {
        if (!linearEqLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearEqLiteral.toString());
        }
        LinearSum linearSum = linearEqLiteral.getLinearExpression();
        int n = linearSum.getB();
        if (linearSum.size() != 0) {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            throw new SugarException("Internal error " + linearEqLiteral.toString());
        }
        int n2 = n == 0 ? Integer.MIN_VALUE : 0;
        return n2;
    }

    private int getCode(LinearNeLiteral linearNeLiteral) throws SugarException {
        if (!linearNeLiteral.isSimple()) {
            throw new SugarException("Internal error " + linearNeLiteral.toString());
        }
        LinearSum linearSum = linearNeLiteral.getLinearExpression();
        int n = linearSum.getB();
        if (linearSum.size() != 0) {
            IntegerVariable integerVariable = linearSum.getCoef().firstKey();
            throw new SugarException("Internal error " + linearNeLiteral.toString());
        }
        int n2 = n != 0 ? Integer.MIN_VALUE : 0;
        return n2;
    }

    public void commit() throws SugarException {
        this.problem.commit();
    }

    public void cancel() throws SugarException {
        this.problem.cancel();
    }

    public void encodeDelta() throws IOException, SugarException {
        int n;
        int n2 = this.problem.variablesCount;
        for (IntegerVariable object : this.csp.getIntegerVariablesDelta()) {
            object.setCode(n2 + 1);
            n = object.getSatVariablesSize();
            n2 += n;
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariablesDelta()) {
            booleanVariable.setCode(n2 + 1);
            n = booleanVariable.getSatVariablesSize();
            n2 += n;
        }
        this.problem.addVariables(n2 - this.problem.variablesCount);
        for (IntegerVariable integerVariable : this.csp.getIntegerVariablesDelta()) {
            this.encode(integerVariable);
        }
        for (Clause clause : this.csp.getClausesDelta()) {
            if (clause.isValid()) continue;
            this.encode(clause);
        }
        this.problem.done();
    }

    private int getIntegerVariableSize(IntegerVariable integerVariable) throws SugarException {
        Encoding encoding = integerVariable.getEncoding();
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = 0;
        switch (encoding) {
            case ORDER: {
                n = integerDomain.size() - 1;
                break;
            }
            case LOG: {
                int n2 = 2;
                int n3 = integerDomain.getUpperBound() - integerDomain.getLowerBound() + 1;
                if (n3 == 1) {
                    n = 0;
                    break;
                }
                int n4 = (int)(Math.log(n3 - 1) / Math.log(n2)) + 1;
                int n5 = (n3 - 1) / (int)Math.pow(n2, n4 - 1) + 1;
                n = (n2 - 1) * (n4 - 1) + (n5 - 1);
                break;
            }
            default: {
                throw new SugarException("Unsupported encoding " + (Object)((Object)encoding));
            }
        }
        return n;
    }

    private int getBooleanVariableCode(BooleanVariable booleanVariable) throws SugarException {
        int n = this.problem.addVariables(1);
        return n;
    }

    private PBExpr getPbLog(IntegerVariable integerVariable) throws SugarException {
        int n = 2;
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n2 = integerVariable.getCode();
        PBExpr pBExpr = new PBExpr();
        int n3 = integerDomain.getUpperBound() - integerDomain.getLowerBound() + 1;
        pBExpr.add(integerDomain.getLowerBound());
        if (n3 > 1) {
            int n4 = (int)(Math.log(n3 - 1) / Math.log(n)) + 1;
            int n5 = (n3 - 1) / (int)Math.pow(n, n4 - 1) + 1;
            int n6 = 1;
            for (int i = 0; i < n4; ++i) {
                for (int j = 1; j < (i < n4 - 1 ? n : n5); ++j) {
                    pBExpr.add(n6, n2);
                    ++n2;
                }
                n6 *= n;
            }
        }
        return pBExpr;
    }

    private void encode(IntegerVariable integerVariable) throws SugarException {
        Encoding encoding = integerVariable.getEncoding();
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = integerVariable.getCode();
        switch (encoding) {
            case ORDER: {
                int n2 = integerDomain.size();
                for (int i = 2; i < n2; ++i) {
                    PBExpr pBExpr = new PBExpr();
                    pBExpr.add(-1, n);
                    pBExpr.add(1, n + 1);
                    pBExpr.setCmp(">=");
                    this.problem.addPB(pBExpr);
                    ++n;
                }
                break;
            }
            case LOG: {
                PBExpr pBExpr = this.getPbLog(integerVariable);
                if (pBExpr.getUB() > integerDomain.getUpperBound()) {
                    PBExpr pBExpr2 = new PBExpr();
                    pBExpr2.add(pBExpr);
                    pBExpr2.add(-integerDomain.getUpperBound());
                    pBExpr2.setCmp("<=");
                    this.problem.addPB(pBExpr2);
                }
                int n3 = 0;
                Iterator<int[]> iterator = integerDomain.intervals();
                while (iterator.hasNext()) {
                    int[] nArray = iterator.next();
                    if (integerDomain.getLowerBound() < nArray[0]) {
                        int n4 = this.problem.addVariables(1);
                        PBExpr pBExpr3 = new PBExpr();
                        pBExpr3.add(pBExpr);
                        pBExpr3.add(-n3);
                        pBExpr3.setCmp("<=");
                        if (SugarMain.debug >= 2) {
                            this.problem.addComment("# " + n4 + " " + pBExpr3);
                        }
                        pBExpr3.relax(n4);
                        this.problem.addPB(pBExpr3);
                        PBExpr pBExpr4 = new PBExpr();
                        pBExpr4.add(pBExpr);
                        pBExpr4.add(-nArray[0]);
                        pBExpr4.setCmp(">=");
                        if (SugarMain.debug >= 2) {
                            this.problem.addComment("# " + n4 + " " + pBExpr4);
                        }
                        pBExpr4.relax(-n4);
                        this.problem.addPB(pBExpr4);
                    }
                    n3 = nArray[1];
                }
                break;
            }
            default: {
                throw new SugarException("Unsupported encoding " + (Object)((Object)encoding));
            }
        }
    }

    private void addClauseWithPb(int[] nArray, PBExpr pBExpr, int n) throws SugarException {
        Object object;
        if (SugarMain.debug >= 2) {
            object = "";
            for (int n2 : nArray) {
                object = (String)object + n2 + " | ";
            }
            object = (String)object + pBExpr + " <= " + -n;
            this.problem.addComment((String)object);
        }
        object = new PBExpr();
        ((PBExpr)object).add(pBExpr, -1);
        ((PBExpr)object).add(-n);
        ((PBExpr)object).setCmp(">=");
        int n3 = ((PBExpr)object).getLB();
        for (int n4 : nArray) {
            if (n4 == 0) continue;
            ((PBExpr)object).add(-n3, n4);
        }
        this.problem.addPB((PBExpr)object);
    }

    private void encodeLinearLe(int[] nArray, IntegerVariable[] integerVariableArray, int n, int n2, int[] nArray2, PBExpr pBExpr) throws SugarException {
        if (pBExpr.size() > 0 && n >= integerVariableArray.length) {
            this.addClauseWithPb(nArray2, pBExpr, n2);
        } else if (pBExpr.size() == 0 && n >= integerVariableArray.length - 1) {
            nArray2[n] = this.getCodeLE(integerVariableArray[n], nArray[n], -n2);
            if (nArray2[n] != Integer.MIN_VALUE) {
                this.addClause(nArray2);
            }
        } else {
            int n3;
            int n4 = n2;
            int n5 = n2;
            for (n3 = n + 1; n3 < integerVariableArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n6 > 0) {
                    n4 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
                    n5 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                    continue;
                }
                n4 += n6 * integerVariableArray[n3].getDomain().getUpperBound();
                n5 += n6 * integerVariableArray[n3].getDomain().getLowerBound();
            }
            n4 += pBExpr.getLB();
            n5 += pBExpr.getUB();
            n3 = nArray[n];
            IntegerDomain integerDomain = integerVariableArray[n].getDomain();
            int n7 = integerDomain.getLowerBound();
            int n8 = integerDomain.getUpperBound();
            if (n3 >= 0) {
                n8 = -n4 >= 0 ? Math.min(n8, -n4 / n3) : Math.min(n8, (-n4 - n3 + 1) / n3);
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n9 = iterator.next();
                    nArray2[n] = this.getCodeLE(integerVariableArray[n], n9 - 1);
                    if (nArray2[n] == Integer.MIN_VALUE) continue;
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * n9, nArray2, pBExpr);
                }
                nArray2[n] = this.getCodeLE(integerVariableArray[n], n8);
                if (nArray2[n] != Integer.MIN_VALUE) {
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * (n8 + 1), nArray2, pBExpr);
                }
            } else {
                n7 = -n4 >= 0 ? Math.max(n7, -n4 / n3) : Math.max(n7, (-n4 + n3 + 1) / n3);
                nArray2[n] = this.negateCode(this.getCodeLE(integerVariableArray[n], n7 - 1));
                if (nArray2[n] != Integer.MIN_VALUE) {
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * (n7 - 1), nArray2, pBExpr);
                }
                Iterator<Integer> iterator = integerDomain.values(n7, n8);
                while (iterator.hasNext()) {
                    int n10 = iterator.next();
                    nArray2[n] = this.negateCode(this.getCodeLE(integerVariableArray[n], n10));
                    if (nArray2[n] == Integer.MIN_VALUE) continue;
                    this.encodeLinearLe(nArray, integerVariableArray, n + 1, n2 + n3 * n10, nArray2, pBExpr);
                }
            }
        }
    }

    private void encodeLinearLeLiteral(LinearLeLiteral linearLeLiteral, int[] nArray) throws SugarException {
        if (!linearLeLiteral.isValid()) {
            if (linearLeLiteral.isUnsatisfiable()) {
                this.addClause(nArray);
            } else if (linearLeLiteral.isSimple()) {
                nArray = this.expand(nArray, 1);
                nArray[0] = this.getCode(linearLeLiteral);
                this.addClause(nArray);
            } else {
                int n;
                Object object;
                int n2;
                LinearSum linearSum = linearLeLiteral.getLinearExpression();
                IntegerVariable[] integerVariableArray = linearSum.getVariablesSorted();
                PBExpr pBExpr = new PBExpr();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                block4: for (n2 = 0; n2 < integerVariableArray.length; ++n2) {
                    object = integerVariableArray[n2];
                    n = linearSum.getA((IntegerVariable)object);
                    Encoding encoding = ((IntegerVariable)object).getEncoding();
                    switch (encoding) {
                        case ORDER: {
                            arrayList.add(n);
                            arrayList2.add(object);
                            continue block4;
                        }
                        case LOG: {
                            pBExpr.add(this.getPbLog((IntegerVariable)object), n);
                            continue block4;
                        }
                        default: {
                            throw new SugarException("Unknown encoding " + (Object)((Object)encoding) + " of " + object);
                        }
                    }
                }
                n2 = arrayList2.size();
                nArray = this.expand(nArray, n2);
                object = new int[n2];
                integerVariableArray = new IntegerVariable[n2];
                for (n = 0; n < n2; ++n) {
                    object[n] = (Integer)arrayList.get(n);
                    integerVariableArray[n] = (IntegerVariable)arrayList2.get(n);
                }
                if (pBExpr.size() == 0 && n2 == 0) {
                    if (linearSum.getB() > 0) {
                        this.addClause(nArray);
                    }
                } else {
                    this.encodeLinearLe((int[])object, integerVariableArray, 0, linearSum.getB(), nArray, pBExpr);
                }
            }
        }
    }

    private void encodeComplexLiteral(Literal literal, int[] nArray) throws SugarException {
        if (literal instanceof LinearLeLiteral) {
            this.encodeLinearLeLiteral((LinearLeLiteral)literal, nArray);
        } else if (literal instanceof LinearGeLiteral) {
            LinearSum linearSum = new LinearSum(0);
            linearSum.subtract(((LinearGeLiteral)literal).getLinearExpression());
            this.encodeLinearLeLiteral(new LinearLeLiteral(linearSum), nArray);
        } else {
            throw new SugarException("Cannot encode " + literal.toString());
        }
    }

    private void encode(Clause clause) throws SugarException {
        if (clause.isValid()) {
            return;
        }
        if (!clause.isSimple()) {
            throw new SugarException("Cannot encode non-simple clause " + clause.toString());
        }
        try {
            int[] nArray = new int[clause.simpleSize()];
            Literal literal = null;
            int n = 0;
            for (Literal literal2 : clause.getLiterals()) {
                if (literal2.isSimple()) {
                    int n2;
                    if (literal2 instanceof BooleanLiteral) {
                        n2 = ((BooleanLiteral)literal2).getCode();
                    } else if (literal2 instanceof LinearLeLiteral) {
                        n2 = this.getCode((LinearLeLiteral)literal2);
                    } else if (literal2 instanceof LinearGeLiteral) {
                        n2 = this.getCode((LinearGeLiteral)literal2);
                    } else if (literal2 instanceof LinearEqLiteral) {
                        n2 = this.getCode((LinearEqLiteral)literal2);
                    } else if (literal2 instanceof LinearNeLiteral) {
                        n2 = this.getCode((LinearNeLiteral)literal2);
                    } else {
                        throw new SugarException("Cannot encode literal " + literal2.toString());
                    }
                    if (n2 == Integer.MIN_VALUE) {
                        return;
                    }
                    nArray[n++] = n2;
                    continue;
                }
                literal = literal2;
            }
            if (literal == null) {
                this.addClause(nArray);
            } else {
                this.encodeComplexLiteral(literal, nArray);
            }
        }
        catch (SugarException sugarException) {
            throw new SugarException(sugarException.getMessage() + " in " + clause);
        }
    }

    private void encodeObjective() throws SugarException {
        if (HybridConverter.USE_PMINIMAL) {
            int n;
            int n2;
            if (this.csp.getObjective() != CSP.Objective.MINIMIZE) {
                throw new SugarException("Minimization is only supported in P-minimal model finding");
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (IntegerVariable object : this.csp.getObjectiveVariables()) {
                IntegerDomain integerDomain = object.getDomain();
                int n3 = object.getCode();
                n2 = integerDomain.size();
                for (n = 2; n < n2; ++n) {
                    stringBuffer.append(" -x" + n3);
                    ++n3;
                }
            }
            this.problem.addPMin(stringBuffer.toString());
            PBExpr pBExpr = new PBExpr();
            for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                IntegerDomain integerDomain = integerVariable.getDomain();
                n2 = integerVariable.getCode();
                n = integerDomain.size();
                for (int i = 2; i < n; ++i) {
                    pBExpr.add(-1, n2);
                    ++n2;
                }
            }
            this.problem.addMinExpr(pBExpr);
            return;
        }
        if (this.csp.getObjectiveVariables().size() != 1) {
            throw new SugarException("Multi objective is not supported");
        }
        IntegerVariable integerVariable = this.csp.getObjectiveVariables().get(0);
        PBExpr pBExpr = new PBExpr();
        if (this.csp.getObjective() == CSP.Objective.MINIMIZE) {
            pBExpr.add(this.getPbLog(integerVariable));
        } else {
            pBExpr.add(this.getPbLog(integerVariable), -1);
        }
        pBExpr.setB(0);
        this.problem.addMinExpr(pBExpr);
    }

    public void encode() throws SugarException {
        int n;
        this.problem.clear();
        for (IntegerVariable object : this.csp.getIntegerVariables()) {
            n = this.getIntegerVariableSize(object);
            int n2 = this.problem.addVariables(n);
            object.setCode(n2);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            n = this.getBooleanVariableCode(booleanVariable);
            booleanVariable.setCode(n);
        }
        if (this.csp.getObjective() != CSP.Objective.NONE) {
            this.encodeObjective();
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            this.problem.addComment("Variable " + integerVariable);
            this.encode(integerVariable);
        }
        for (Clause clause : this.csp.getClauses()) {
            this.problem.addComment("Constraint " + clause);
            this.encode(clause);
        }
        this.problem.done();
    }

    public void outputMap(String string) throws IOException, SugarException {
        CharSequence charSequence;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        if (this.csp.getObjectiveVariables() != null) {
            Object object = "objective ";
            if (this.csp.getObjective().equals((Object)CSP.Objective.MINIMIZE)) {
                object = (String)object + "minimize";
            } else if (this.csp.getObjective().equals((Object)CSP.Objective.MAXIMIZE)) {
                object = (String)object + "maximize";
            }
            for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                object = (String)object + " " + integerVariable.getName();
            }
            bufferedWriter.write((String)object);
            bufferedWriter.write(10);
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            if (integerVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = integerVariable.getCode();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("int " + integerVariable.getName() + " " + n + " ");
            integerVariable.getDomain().appendValues((StringBuilder)charSequence, true);
            ((StringBuilder)charSequence).append('\n');
            Encoding encoding = integerVariable.getEncoding();
            ((StringBuilder)charSequence).append("encoding " + integerVariable.getName());
            switch (encoding) {
                case ORDER: {
                    ((StringBuilder)charSequence).append(" order\n");
                    break;
                }
                case LOG: {
                    ((StringBuilder)charSequence).append(" log\n");
                    break;
                }
                default: {
                    throw new SugarException("Uknown encoding " + (Object)((Object)encoding));
                }
            }
            bufferedWriter.write(((StringBuilder)charSequence).toString());
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (booleanVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = booleanVariable.getCode();
            charSequence = "bool " + booleanVariable.getName() + " " + n;
            bufferedWriter.write((String)charSequence);
            bufferedWriter.write(10);
        }
        bufferedWriter.close();
    }

    private void decode(IntegerVariable integerVariable, BitSet bitSet) throws SugarException {
        Encoding encoding = integerVariable.getEncoding();
        switch (encoding) {
            case ORDER: {
                integerVariable.decode(bitSet);
                break;
            }
            case LOG: {
                PBExpr pBExpr = this.getPbLog(integerVariable);
                int n = pBExpr.value(bitSet);
                integerVariable.setValue(n);
                break;
            }
            default: {
                throw new SugarException("Unknown encoding " + (Object)((Object)encoding));
            }
        }
    }

    private void decode(BooleanVariable booleanVariable, BitSet bitSet) {
        int n = booleanVariable.getCode();
        booleanVariable.setValue(bitSet.get(n));
    }

    public boolean decode(String string) throws IOException, SugarException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        String string2 = null;
        boolean bl = false;
        BitSet bitSet = new BitSet();
        block4: while (true) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -1) break;
            switch (streamTokenizer.ttype) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if (streamTokenizer.sval.equals("s")) {
                        streamTokenizer.nextToken();
                        string2 = streamTokenizer.sval;
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block4;
                    }
                    if (streamTokenizer.sval.equals("c")) {
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block4;
                    }
                    if (streamTokenizer.sval.equals("v")) {
                        boolean bl2 = false;
                        streamTokenizer.nextToken();
                        while (true) {
                            if (streamTokenizer.ttype == 10) continue block4;
                            if (streamTokenizer.ttype == 45) {
                                bl2 = true;
                            } else if (streamTokenizer.ttype == -3) {
                                int n = Integer.parseInt(streamTokenizer.sval.substring(1));
                                if (!bl2) {
                                    bitSet.set(n);
                                }
                                bl2 = false;
                            }
                            streamTokenizer.nextToken();
                        }
                    }
                    do {
                        streamTokenizer.nextToken();
                    } while (streamTokenizer.ttype != 10);
                    continue block4;
                }
            }
        }
        bufferedReader.close();
        if (string2.startsWith("SAT") || string2.startsWith("OPT")) {
            bl = true;
            for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
                this.decode(integerVariable, bitSet);
            }
            for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
                this.decode(booleanVariable, bitSet);
            }
        } else if (string2.startsWith("UNSAT")) {
            bl = false;
        } else {
            throw new SugarException("Unknown output result " + string2);
        }
        return bl;
    }
}

