/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.pb;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.csp.BooleanLiteral;
import jp.kobe_u.sugar.csp.BooleanVariable;
import jp.kobe_u.sugar.csp.CSP;
import jp.kobe_u.sugar.csp.Clause;
import jp.kobe_u.sugar.csp.IntegerDomain;
import jp.kobe_u.sugar.csp.IntegerVariable;
import jp.kobe_u.sugar.csp.LinearGeLiteral;
import jp.kobe_u.sugar.csp.LinearLeLiteral;
import jp.kobe_u.sugar.csp.LinearLiteral;
import jp.kobe_u.sugar.csp.LinearSum;
import jp.kobe_u.sugar.csp.Literal;
import jp.kobe_u.sugar.pb.PBExpr;
import jp.kobe_u.sugar.pb.PBProblem;

public class PBEncoder {
    public static int MAX_VAREXPRMAP_SIZE = 10000;
    public static int BASE = 0;
    public static int ENCODING_OPTION = 1;
    public static int MIXED_BASE = 15;
    public CSP csp;
    public PBProblem problem;
    public Encoding encoding;
    private VarExprMap intMap;

    public PBEncoder(CSP cSP, PBProblem pBProblem, Encoding encoding) {
        this.csp = cSP;
        this.problem = pBProblem;
        this.encoding = encoding;
        this.intMap = new VarExprMap();
    }

    public void commit() throws SugarException {
        this.problem.commit();
    }

    public void cancel() throws SugarException {
        this.problem.cancel();
    }

    public void encodeDelta() throws IOException, SugarException {
        int n;
        int n2 = this.problem.variablesCount;
        for (IntegerVariable object : this.csp.getIntegerVariablesDelta()) {
            object.setCode(n2 + 1);
            n = object.getSatVariablesSize();
            n2 += n;
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariablesDelta()) {
            booleanVariable.setCode(n2 + 1);
            n = booleanVariable.getSatVariablesSize();
            n2 += n;
        }
        this.problem.addVariables(n2 - this.problem.variablesCount);
        for (IntegerVariable integerVariable : this.csp.getIntegerVariablesDelta()) {
            this.encode(integerVariable);
        }
        for (Clause clause : this.csp.getClausesDelta()) {
            if (clause.isValid()) continue;
            this.encode(clause);
        }
        this.problem.done();
    }

    private Encoding getEncoding(IntegerVariable integerVariable) {
        Encoding encoding = this.encoding;
        if (encoding.equals((Object)Encoding.MIXED_ENCODING)) {
            if (integerVariable.getDomain().size() <= MIXED_BASE) {
                encoding = Encoding.ORDER_ENCODING;
            } else {
                encoding = Encoding.COMPACT_ORDER_ENCODING;
                BASE = 2;
            }
        }
        return encoding;
    }

    private int getIntegerVariableSize(IntegerVariable integerVariable) throws SugarException {
        Encoding encoding = this.getEncoding(integerVariable);
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = 0;
        switch (encoding) {
            case DIRECT_ENCODING: {
                n = integerDomain.size() - 1;
                break;
            }
            case ORDER_ENCODING: {
                n = integerDomain.size() - 1;
                break;
            }
            case COMPACT_ORDER_ENCODING: {
                int n2 = integerDomain.getUpperBound() - integerDomain.getLowerBound() + 1;
                if (n2 == 1) {
                    n = 0;
                    break;
                }
                int n3 = (int)(Math.log(n2 - 1) / Math.log(BASE)) + 1;
                int n4 = (n2 - 1) / (int)Math.pow(BASE, n3 - 1) + 1;
                n = (BASE - 1) * (n3 - 1) + (n4 - 1);
                break;
            }
        }
        return n;
    }

    private PBExpr getIntegerVariableExpr(IntegerVariable integerVariable) throws SugarException {
        if (this.intMap.containsKey(integerVariable)) {
            return (PBExpr)this.intMap.get(integerVariable);
        }
        Encoding encoding = this.getEncoding(integerVariable);
        int n = integerVariable.getCode();
        IntegerDomain integerDomain = integerVariable.getDomain();
        PBExpr pBExpr = new PBExpr();
        switch (encoding) {
            case DIRECT_ENCODING: {
                int n2 = integerDomain.getLowerBound();
                pBExpr.add(n2);
                Iterator<int[]> iterator = integerDomain.intervals();
                while (iterator.hasNext()) {
                    int[] nArray = iterator.next();
                    int n3 = nArray[0];
                    while (n3 <= nArray[1]) {
                        if (n3 != n2) {
                            int n4 = n3 - integerDomain.getLowerBound();
                            pBExpr.add(n4, n);
                            ++n;
                        }
                        n2 = n3++;
                    }
                }
                break;
            }
            case ORDER_ENCODING: {
                int n5 = integerDomain.getLowerBound();
                pBExpr.add(n5);
                Iterator<int[]> iterator = integerDomain.intervals();
                while (iterator.hasNext()) {
                    int[] nArray = iterator.next();
                    int n6 = nArray[0];
                    while (n6 <= nArray[1]) {
                        if (n6 != n5) {
                            int n7 = n6 - n5;
                            pBExpr.add(n7, n);
                            ++n;
                        }
                        n5 = n6++;
                    }
                }
                break;
            }
            case COMPACT_ORDER_ENCODING: {
                int n8 = integerDomain.getUpperBound() - integerDomain.getLowerBound() + 1;
                pBExpr.add(integerDomain.getLowerBound());
                if (n8 > 1) {
                    int n9 = (int)(Math.log(n8 - 1) / Math.log(BASE)) + 1;
                    int n10 = (n8 - 1) / (int)Math.pow(BASE, n9 - 1) + 1;
                    int n11 = 1;
                    for (int i = 0; i < n9; ++i) {
                        for (int j = 1; j < (i < n9 - 1 ? BASE : n10); ++j) {
                            pBExpr.add(n11, n);
                            ++n;
                        }
                        n11 *= BASE;
                    }
                }
                if (n - integerVariable.getCode() == this.getIntegerVariableSize(integerVariable)) break;
                throw new SugarException("Internal error " + integerVariable + " " + (n - integerVariable.getCode()) + " " + this.getIntegerVariableSize(integerVariable));
            }
        }
        this.intMap.put(integerVariable, pBExpr);
        return pBExpr;
    }

    private int getBooleanVariableCode(BooleanVariable booleanVariable) throws SugarException {
        int n = this.problem.addVariables(1);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private void encode(IntegerVariable integerVariable) throws SugarException {
        Encoding encoding = this.getEncoding(integerVariable);
        IntegerDomain integerDomain = integerVariable.getDomain();
        int n = integerVariable.getCode();
        switch (encoding) {
            case DIRECT_ENCODING: {
                int n2 = integerDomain.size();
                PBExpr object2 = new PBExpr();
                for (int i = 1; i < n2; ++i) {
                    object2.add(1, n);
                    ++n;
                }
                object2.add(-1);
                object2.setCmp("<=");
                this.problem.addPB(object2);
                break;
            }
            case ORDER_ENCODING: {
                void n3;
                int n2 = integerDomain.size();
                int i = 2;
                while (n3 < n2) {
                    PBExpr pBExpr = new PBExpr();
                    pBExpr.add(1, n);
                    pBExpr.add(-1, n + 1);
                    pBExpr.setCmp(">=");
                    this.problem.addPB(pBExpr);
                    ++n;
                    ++n3;
                }
                break;
            }
            case COMPACT_ORDER_ENCODING: {
                int n2 = integerDomain.getUpperBound() - integerDomain.getLowerBound() + 1;
                if (n2 <= 1) break;
                int n3 = (int)(Math.log(n2 - 1) / Math.log(BASE)) + 1;
                int n4 = (n2 - 1) / (int)Math.pow(BASE, n3 - 1) + 1;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 2; j < (i < n3 - 1 ? BASE : n4); ++j) {
                        PBExpr pBExpr = new PBExpr();
                        pBExpr.add(1, n);
                        pBExpr.add(-1, n + 1);
                        pBExpr.setCmp(">=");
                        this.problem.addPB(pBExpr);
                        ++n;
                    }
                    ++n;
                }
                break;
            }
        }
        switch (encoding) {
            case COMPACT_ORDER_ENCODING: {
                for (Clause clause : integerVariable.getDomainClauses()) {
                    this.encode(clause);
                }
                PBExpr pBExpr = this.getIntegerVariableExpr(integerVariable);
                if (pBExpr.getUB() <= integerDomain.getUpperBound()) break;
                PBExpr pBExpr2 = new PBExpr();
                pBExpr2.add(pBExpr);
                pBExpr2.add(-integerDomain.getUpperBound());
                pBExpr2.setCmp("<=");
                this.problem.addPB(pBExpr2);
                break;
            }
        }
    }

    private int encodeSimpleLiteral(Literal literal) throws SugarException {
        int n = 0;
        if (literal instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)literal;
            n = booleanLiteral.getBooleanVariable().getCode();
            if (booleanLiteral.getNegative()) {
                n = -n;
            }
        } else {
            if (literal instanceof LinearLeLiteral && literal.isSimple()) {
                throw new SugarException("Internal error " + literal);
            }
            if (literal instanceof LinearGeLiteral && literal.isSimple()) {
                throw new SugarException("Internal error " + literal);
            }
            throw new SugarException("Internal error " + literal);
        }
        return n;
    }

    private int findGe(IntegerVariable integerVariable, int n) {
        int n2 = integerVariable.getCode() - 1;
        IntegerDomain integerDomain = integerVariable.getDomain();
        Iterator<int[]> iterator = integerDomain.intervals();
        while (iterator.hasNext()) {
            int[] nArray = iterator.next();
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                if (i >= n) {
                    return n2;
                }
                ++n2;
            }
        }
        return 0;
    }

    private List<PBExpr> encodeSimpleLinear(LinearLiteral linearLiteral) throws SugarException {
        LinearSum linearSum = linearLiteral.getLinearExpression();
        if (linearSum.size() != 1) {
            throw new SugarException("Internal error " + linearLiteral);
        }
        IntegerVariable integerVariable = linearSum.getVariablesSorted()[0];
        int n = linearSum.getA(integerVariable);
        int n2 = -linearSum.getB();
        String string = linearLiteral.getCmp();
        if (string.equals("ge") && n > 0 || string.equals("le") && n < 0) {
            n2 = linearLiteral.ceilDiv(n2, n);
            n = 1;
            string = "ge";
        } else if (string.equals("ge") && n < 0 || string.equals("le") && n > 0) {
            n2 = linearLiteral.floorDiv(n2, n);
            n = 1;
            string = "le";
        } else {
            throw new SugarException("Internal error " + linearLiteral);
        }
        ArrayList<PBExpr> arrayList = new ArrayList<PBExpr>();
        if (string.equals("ge") && integerVariable.getDomain().getLowerBound() >= n2 || string.equals("le") && integerVariable.getDomain().getUpperBound() <= n2) {
            return arrayList;
        }
        if (string.equals("ge") && integerVariable.getDomain().getUpperBound() < n2 || string.equals("le") && integerVariable.getDomain().getLowerBound() > n2) {
            PBExpr pBExpr = new PBExpr();
            pBExpr.add(-1);
            pBExpr.setCmp(">=");
            arrayList.add(pBExpr);
            return arrayList;
        }
        switch (this.encoding) {
            case ORDER_ENCODING: {
                PBExpr pBExpr = new PBExpr();
                if (string.equals("ge")) {
                    int n3 = this.findGe(integerVariable, n2);
                    if (n3 == 0) {
                        pBExpr.add(-1);
                        pBExpr.setCmp(">=");
                        arrayList.add(pBExpr);
                        return arrayList;
                    }
                    pBExpr.add(1, n3);
                    pBExpr.add(-1);
                    pBExpr.setCmp(">=");
                } else {
                    int n4 = this.findGe(integerVariable, n2 + 1);
                    if (n4 == 0) {
                        return arrayList;
                    }
                    pBExpr.add(1, n4);
                    pBExpr.add(0);
                    pBExpr.setCmp("<=");
                }
                arrayList.add(pBExpr);
                return arrayList;
            }
        }
        return null;
    }

    private List<PBExpr> encodeLinear(LinearLiteral linearLiteral) throws SugarException {
        if (linearLiteral.isValid()) {
            ArrayList<PBExpr> arrayList = new ArrayList<PBExpr>();
            return arrayList;
        }
        if (linearLiteral.isUnsatisfiable()) {
            ArrayList<PBExpr> arrayList = new ArrayList<PBExpr>();
            PBExpr pBExpr = new PBExpr();
            pBExpr.add(-1);
            pBExpr.setCmp(">=");
            arrayList.add(pBExpr);
            return arrayList;
        }
        List<Object> list = null;
        if (linearLiteral.getLinearExpression().size() == 1 && ENCODING_OPTION == 1) {
            list = this.encodeSimpleLinear(linearLiteral);
        }
        if (list == null) {
            list = new ArrayList();
            LinearSum linearSum = linearLiteral.getLinearExpression();
            String string = linearLiteral.getCmp();
            PBExpr pBExpr = new PBExpr();
            pBExpr.add(linearSum.getB());
            for (IntegerVariable integerVariable : linearSum.getVariables()) {
                int n = linearSum.getA(integerVariable);
                PBExpr pBExpr2 = this.getIntegerVariableExpr(integerVariable);
                pBExpr.add(pBExpr2, n);
            }
            pBExpr.setCmp(string);
            list.add(pBExpr);
        }
        return list;
    }

    private void encode(Clause clause) throws SugarException {
        Object object;
        if (clause.isValid()) {
            return;
        }
        int n = clause.size();
        int n2 = 0;
        for (Literal object2 : clause.getLiterals()) {
            if (!(object2 instanceof LinearLiteral)) continue;
            ++n2;
        }
        if (n2 == 0) {
            object = new PBExpr();
            for (Literal literal : clause.getLiterals()) {
                int n3 = this.encodeSimpleLiteral(literal);
                ((PBExpr)object).add(1, n3);
            }
            ((PBExpr)object).add(-1);
            ((PBExpr)object).setCmp(">=");
            this.problem.addPB((PBExpr)object);
        } else if (n2 == 1 && n == 1) {
            object = clause.getLiterals().get(0);
            if (!(object instanceof LinearLiteral)) {
                throw new SugarException("unknonw literal " + object);
            }
            for (PBExpr pBExpr : this.encodeLinear((LinearLiteral)object)) {
                this.problem.addPB(pBExpr);
            }
        } else {
            object = new PBExpr();
            for (Literal literal : clause.getLiterals()) {
                int n4;
                if (literal.isUnsatisfiable()) continue;
                if (literal instanceof BooleanLiteral) {
                    n4 = this.encodeSimpleLiteral(literal);
                    ((PBExpr)object).add(1, n4);
                    continue;
                }
                if (literal instanceof LinearLiteral) {
                    n4 = this.problem.addVariables(1);
                    ((PBExpr)object).add(1, n4);
                    for (PBExpr pBExpr : this.encodeLinear((LinearLiteral)literal)) {
                        pBExpr.relax(-n4);
                        this.problem.addPB(pBExpr);
                    }
                    continue;
                }
                throw new SugarException("not supported literal " + literal);
            }
            ((PBExpr)object).add(-1);
            ((PBExpr)object).setCmp(">=");
            this.problem.addPB((PBExpr)object);
        }
    }

    private void encodeObjective() throws SugarException {
        if (this.csp.getObjectiveVariables().size() != 1) {
            throw new SugarException("Multi objective is not supported");
        }
        IntegerVariable integerVariable = this.csp.getObjectiveVariables().get(0);
        PBExpr pBExpr = new PBExpr();
        if (this.csp.getObjective() == CSP.Objective.MINIMIZE) {
            pBExpr.add(this.getIntegerVariableExpr(integerVariable));
        } else {
            pBExpr.add(this.getIntegerVariableExpr(integerVariable), -1);
        }
        pBExpr.setB(0);
        this.problem.addMinExpr(pBExpr);
    }

    public void encode() throws SugarException {
        int n;
        this.problem.clear();
        for (IntegerVariable object : this.csp.getIntegerVariables()) {
            n = this.getIntegerVariableSize(object);
            int n2 = this.problem.addVariables(n);
            object.setCode(n2);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            n = this.getBooleanVariableCode(booleanVariable);
            booleanVariable.setCode(n);
        }
        if (this.csp.getObjective() != CSP.Objective.NONE) {
            this.encodeObjective();
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            this.problem.addComment("Variable " + integerVariable + " : " + this.getIntegerVariableExpr(integerVariable));
            this.encode(integerVariable);
        }
        for (Clause clause : this.csp.getClauses()) {
            this.problem.addComment("Constraint " + clause);
            this.encode(clause);
        }
        this.problem.done();
    }

    public void outputMap(String string) throws IOException {
        CharSequence charSequence;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        if (this.csp.getObjectiveVariables() != null) {
            Object object = "objective ";
            if (this.csp.getObjective().equals((Object)CSP.Objective.MINIMIZE)) {
                object = (String)object + "minimize";
            } else if (this.csp.getObjective().equals((Object)CSP.Objective.MAXIMIZE)) {
                object = (String)object + "maximize";
            }
            for (IntegerVariable integerVariable : this.csp.getObjectiveVariables()) {
                object = (String)object + " " + integerVariable.getName();
            }
            bufferedWriter.write((String)object);
            bufferedWriter.write(10);
        }
        for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
            if (integerVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = integerVariable.getCode();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("int " + integerVariable.getName() + " " + n + " ");
            integerVariable.getDomain().appendValues((StringBuilder)charSequence, true);
            bufferedWriter.write(((StringBuilder)charSequence).toString());
            bufferedWriter.write(10);
        }
        for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
            if (booleanVariable.isAux() && SugarMain.debug <= 0) continue;
            int n = booleanVariable.getCode();
            charSequence = "bool " + booleanVariable.getName() + " " + n;
            bufferedWriter.write((String)charSequence);
            bufferedWriter.write(10);
        }
        bufferedWriter.close();
    }

    private void decode(IntegerVariable integerVariable, BitSet bitSet) throws SugarException {
        PBExpr pBExpr = this.getIntegerVariableExpr(integerVariable);
        int n = pBExpr.value(bitSet);
        integerVariable.setValue(n);
    }

    private void decode(BooleanVariable booleanVariable, BitSet bitSet) {
        int n = booleanVariable.getCode();
        booleanVariable.setValue(bitSet.get(n));
    }

    public boolean decode(String string) throws IOException, SugarException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        String string2 = null;
        boolean bl = false;
        BitSet bitSet = new BitSet();
        block4: while (true) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -1) break;
            switch (streamTokenizer.ttype) {
                case 10: {
                    continue block4;
                }
                case -3: {
                    if (streamTokenizer.sval.equals("s")) {
                        streamTokenizer.nextToken();
                        string2 = streamTokenizer.sval;
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block4;
                    }
                    if (streamTokenizer.sval.equals("c")) {
                        do {
                            streamTokenizer.nextToken();
                        } while (streamTokenizer.ttype != 10);
                        continue block4;
                    }
                    if (streamTokenizer.sval.equals("v")) {
                        boolean bl2 = false;
                        streamTokenizer.nextToken();
                        while (true) {
                            if (streamTokenizer.ttype == 10) continue block4;
                            if (streamTokenizer.ttype == 45) {
                                bl2 = true;
                            } else if (streamTokenizer.ttype == -3) {
                                int n = Integer.parseInt(streamTokenizer.sval.substring(1));
                                if (!bl2) {
                                    bitSet.set(n);
                                }
                                bl2 = false;
                            }
                            streamTokenizer.nextToken();
                        }
                    }
                    do {
                        streamTokenizer.nextToken();
                    } while (streamTokenizer.ttype != 10);
                    continue block4;
                }
            }
        }
        bufferedReader.close();
        if (string2.startsWith("SAT") || string2.startsWith("OPT")) {
            bl = true;
            for (IntegerVariable integerVariable : this.csp.getIntegerVariables()) {
                this.decode(integerVariable, bitSet);
            }
            for (BooleanVariable booleanVariable : this.csp.getBooleanVariables()) {
                this.decode(booleanVariable, bitSet);
            }
        } else if (string2.startsWith("UNSAT")) {
            bl = false;
        } else {
            throw new SugarException("Unknown output result " + string2);
        }
        return bl;
    }

    private class VarExprMap
    extends LinkedHashMap<IntegerVariable, PBExpr> {
        VarExprMap() {
            super(100, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<IntegerVariable, PBExpr> entry) {
            return this.size() > MAX_VAREXPRMAP_SIZE;
        }
    }

    public static enum Encoding {
        DIRECT_ENCODING,
        ORDER_ENCODING,
        COMPACT_ORDER_ENCODING,
        MIXED_ENCODING;

    }
}

