/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.pb;

import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.kobe_u.sugar.SugarException;

public class PBExpr {
    private Map<Integer, Integer> coef = new TreeMap<Integer, Integer>();
    private int b = 0;
    private String cmp = null;

    public int size() {
        return this.coef.size();
    }

    public Set<Integer> getXs() {
        return this.coef.keySet();
    }

    public int getA(int n) {
        return this.coef.containsKey(n) ? this.coef.get(n) : 0;
    }

    public int getB() {
        return this.b;
    }

    public void setB(int n) {
        this.b = n;
    }

    public String getCmp() {
        return this.cmp;
    }

    public void setCmp(String string) throws SugarException {
        if (string != null) {
            if (string.equals("le") || string.equals("<=")) {
                string = "<=";
            } else if (string.equals("ge") || string.equals(">=")) {
                string = ">=";
            } else {
                throw new SugarException("unsupported comparison " + string);
            }
        }
        this.cmp = string;
    }

    public int getLB() {
        int n = this.b;
        for (int n2 : this.coef.keySet()) {
            int n3 = this.coef.get(n2);
            if (n3 >= 0) continue;
            n += n3;
        }
        return n;
    }

    public int getUB() {
        int n = this.b;
        for (int n2 : this.coef.keySet()) {
            int n3 = this.coef.get(n2);
            if (n3 <= 0) continue;
            n += n3;
        }
        return n;
    }

    public void add(int n) {
        this.b += n;
    }

    public void add(int n, int n2) {
        if (n2 < 0) {
            n2 = -n2;
            this.b += n;
            n = -n;
        }
        if (this.coef.containsKey(n2)) {
            n += this.coef.get(n2).intValue();
        }
        if (n == 0 && this.coef.containsKey(n2)) {
            this.coef.remove(n2);
        } else if (n != 0) {
            this.coef.put(n2, n);
        }
    }

    public void add(PBExpr pBExpr, int n) {
        this.add(pBExpr.b * n);
        for (int n2 : pBExpr.coef.keySet()) {
            int n3 = pBExpr.coef.get(n2);
            this.add(n3 * n, n2);
        }
    }

    public void add(PBExpr pBExpr) {
        this.add(pBExpr, 1);
    }

    public void relax(int n) {
        if (this.cmp.equals("<=")) {
            this.add(-this.getUB(), n);
        } else if (this.cmp.equals(">=")) {
            this.add(-this.getLB(), n);
        }
    }

    public boolean isValid() {
        if (this.cmp != null && this.cmp.equals("<=")) {
            return this.getUB() <= 0;
        }
        if (this.cmp != null && this.cmp.equals(">=")) {
            return this.getLB() >= 0;
        }
        return false;
    }

    public boolean isUnsatisfiable() {
        if (this.cmp != null && this.cmp.equals("<=")) {
            return this.getLB() > 0;
        }
        if (this.cmp != null && this.cmp.equals(">=")) {
            return this.getUB() < 0;
        }
        return false;
    }

    public int value(BitSet bitSet) {
        int n = this.b;
        for (int n2 : this.coef.keySet()) {
            int n3 = bitSet.get(n2) ? this.coef.get(n2) : 0;
            n += n3;
        }
        return n;
    }

    public String toString() {
        String string = this.cmp;
        int n = 1;
        if (string != null && string.equals("<=")) {
            n = -1;
            string = ">=";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (int n2 : this.coef.keySet()) {
            int n3 = n * this.coef.get(n2);
            stringBuilder.append(string2);
            stringBuilder.append(n3 < 0 ? "" + n3 : "+" + n3);
            stringBuilder.append(" x" + n2);
            string2 = " ";
        }
        int n4 = n * this.b;
        if (string == null) {
            if (n4 != 0) {
                stringBuilder.append(n4 < 0 ? " " + n4 : " +" + n4);
            }
        } else {
            stringBuilder.append(" " + string + " ");
            if (n4 == 0) {
                stringBuilder.append("0");
            } else {
                stringBuilder.append(n4 < 0 ? "+" + -n4 : "" + -n4);
            }
        }
        return stringBuilder.toString();
    }
}

