/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.pb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.SugarMain;
import jp.kobe_u.sugar.pb.PBExpr;
import jp.kobe_u.sugar.pb.PBProblem;

public class PBFileProblem
extends PBProblem {
    public static int PB_BUFFER_SIZE = 4096;
    public static long MAX_PB_SIZE = 0xC0000000L;
    private String pbFileName;
    private FileChannel pbFileChannel = null;
    private ByteBuffer pbByteBuffer = null;

    public PBFileProblem(String string) throws SugarException {
        this.pbFileName = string;
        this.clear();
    }

    public void open() throws SugarException {
        if (this.pbFileChannel != null) {
            throw new SugarException("Internal error: re-opening file " + this.pbFileName);
        }
        try {
            if (this.fileSize == 0L) {
                this.pbFileChannel = new FileOutputStream(this.pbFileName).getChannel();
            } else {
                this.pbFileChannel = new RandomAccessFile(this.pbFileName, "rw").getChannel();
                this.pbFileChannel.position(this.fileSize);
            }
            this.pbByteBuffer = ByteBuffer.allocateDirect(PB_BUFFER_SIZE);
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    public void write(byte[] byArray) throws SugarException {
        if (this.pbFileChannel == null) {
            this.open();
        }
        int n = byArray.length;
        if (this.pbByteBuffer.position() + n > PB_BUFFER_SIZE) {
            this.flush();
        }
        int n2 = 0;
        while (n > PB_BUFFER_SIZE) {
            this.pbByteBuffer.put(byArray, n2, PB_BUFFER_SIZE);
            this.flush();
            n2 += PB_BUFFER_SIZE;
            n -= PB_BUFFER_SIZE;
        }
        this.pbByteBuffer.put(byArray, n2, n);
        this.fileSize += (long)byArray.length;
        if (this.fileSize >= MAX_PB_SIZE) {
            new File(this.pbFileName).delete();
            throw new SugarException("Encoding is interrupted because file size becomes too large (" + this.fileSize + " bytes)");
        }
    }

    public void write(String string) throws SugarException {
        this.write(string.getBytes());
    }

    public void flush() throws SugarException {
        if (this.pbFileChannel == null) {
            return;
        }
        try {
            this.pbByteBuffer.flip();
            this.pbFileChannel.write(this.pbByteBuffer);
            this.pbByteBuffer.clear();
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    public void close() throws SugarException {
        if (this.pbFileChannel == null) {
            return;
        }
        try {
            this.flush();
            this.pbFileChannel.close();
            this.pbFileChannel = null;
            this.pbByteBuffer = null;
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    public void update() throws SugarException {
        int n = 64;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("* #variable= ");
        stringBuilder.append(Integer.toString(this.variablesCount));
        stringBuilder.append(" #constraint= ");
        stringBuilder.append(Integer.toString(this.constraintsCount));
        while (stringBuilder.length() < n - 1) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        String string = stringBuilder.toString();
        if (this.pbFileChannel != null) {
            throw new SugarException("Internal error: updating opening file " + this.pbFileName);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.pbFileName, "rw");
            randomAccessFile.seek(0L);
            randomAccessFile.write(string.getBytes());
            if (this.fileSize == 0L) {
                this.fileSize = string.length();
            }
            randomAccessFile.setLength(this.fileSize);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new SugarException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void clear() throws SugarException {
        super.clear();
        this.update();
    }

    @Override
    public void commit() throws SugarException {
        super.commit();
    }

    @Override
    public void cancel() throws SugarException {
        this.done();
        super.cancel();
        this.update();
    }

    @Override
    public void done() throws SugarException {
        if (this.constraintsCount == 0) {
            if (this.variablesCount == 0) {
                ++this.variablesCount;
            }
            PBExpr pBExpr = new PBExpr();
            pBExpr.add(1, 1);
            pBExpr.setCmp(">=");
            pBExpr.setB(0);
            this.addPBConstraint(pBExpr);
        }
        this.flush();
        this.close();
        this.update();
    }

    @Override
    public void addComment(String string) throws SugarException {
        if (SugarMain.debug >= 1) {
            this.write("* " + string + "\n");
        }
    }

    @Override
    public void addPBConstraint(PBExpr pBExpr) throws SugarException {
        if (pBExpr.isValid()) {
            return;
        }
        if (pBExpr.isUnsatisfiable()) {
            if (this.variablesCount == 0) {
                ++this.variablesCount;
            }
            pBExpr = new PBExpr();
            pBExpr.add(-1, 1);
            pBExpr.add(-1);
            pBExpr.setCmp(">=");
        }
        this.write(pBExpr.toString());
        this.write(" ;\n");
        ++this.constraintsCount;
    }

    @Override
    public void addMinExpr(PBExpr pBExpr) throws SugarException {
        this.write("min: ");
        this.write(pBExpr.toString());
        this.write(" ;\n");
    }

    @Override
    public void addPMin(String string) throws SugarException {
        this.write("* pmin:");
        this.write(string);
        this.write(" ;\n");
    }
}

