/*
 * Decompiled with CFR 0.152.
 */
package jp.kobe_u.sugar.pb;

import jp.kobe_u.sugar.SugarException;
import jp.kobe_u.sugar.pb.PBExpr;

public abstract class PBProblem {
    public int variablesCount = 0;
    public int constraintsCount = 0;
    public long fileSize = 0L;
    private int variablesCountSave = 0;
    private int constraintsCountSave = 0;
    private long fileSizeSave = 0L;

    public void clear() throws SugarException {
        this.variablesCount = 0;
        this.constraintsCount = 0;
        this.fileSize = 0L;
        this.commit();
    }

    public void commit() throws SugarException {
        this.variablesCountSave = this.variablesCount;
        this.constraintsCountSave = this.constraintsCount;
        this.fileSizeSave = this.fileSize;
    }

    public void cancel() throws SugarException {
        this.variablesCount = this.variablesCountSave;
        this.constraintsCount = this.constraintsCountSave;
        this.fileSize = this.fileSizeSave;
    }

    public abstract void done() throws SugarException;

    public int addVariables(int n) throws SugarException {
        int n2 = this.variablesCount + 1;
        this.variablesCount += n;
        return n2;
    }

    public void addComment(String string) throws SugarException {
    }

    public abstract void addPBConstraint(PBExpr var1) throws SugarException;

    public void addPB(PBExpr pBExpr) throws SugarException {
        if (pBExpr.isValid()) {
            return;
        }
        this.addPBConstraint(pBExpr);
    }

    public abstract void addMinExpr(PBExpr var1) throws SugarException;

    public abstract void addPMin(String var1) throws SugarException;

    public String summary() {
        return this.variablesCount + " PB variables, " + this.constraintsCount + " PB clauses, " + this.fileSize + " bytes";
    }
}

