/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.ArrayList;
import java.util.List;
import jp.ac.kobe_u.cs.cream.Condition;
import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Operation;

public class Code
implements Cloneable {
    public Condition[] conditions;

    private Code() {
    }

    public Code(Network network) {
        List<Constraint> list = network.getConstraints();
        this.conditions = new Condition[list.size()];
        for (int i = 0; i < this.conditions.length; ++i) {
            Constraint constraint = list.get(i);
            this.conditions[i] = constraint.extractCondition();
        }
    }

    public Object clone() {
        Code code = new Code();
        code.conditions = (Condition[])this.conditions.clone();
        return code;
    }

    public void setTo(Network network) {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i] == null) {
                network.getConstraint(i).clearCondition();
                continue;
            }
            this.conditions[i].setTo(network);
        }
    }

    public List<Operation> operations() {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        for (Condition condition : this.conditions) {
            if (condition == null) continue;
            arrayList.addAll(condition.operations());
        }
        return arrayList;
    }
}

