/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import jp.ac.kobe_u.cs.cream.Condition;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public abstract class Constraint {
    private Network network;
    private int index = -1;

    protected Constraint(Network network) {
        this.network = network;
        this.network.add(this);
    }

    public Network getNetwork() {
        return this.network;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public abstract Constraint copy(Network var1);

    protected void clearCondition() {
    }

    protected void setCondition(Condition condition) {
    }

    protected Condition extractCondition() {
        return null;
    }

    public abstract boolean isModified();

    public abstract boolean satisfy(Trail var1);

    public abstract String toString();

    protected static Variable copy(Variable variable, Network network) {
        int n = variable.getIndex();
        return network.getVariable(n);
    }

    protected static Variable[] copy(Variable[] variableArray, Network network) {
        Variable[] variableArray2 = new Variable[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            int n = variableArray[i].getIndex();
            variableArray2[i] = network.getVariable(n);
        }
        return variableArray2;
    }

    protected static boolean isModified(Variable[] variableArray) {
        for (Variable variable : variableArray) {
            if (!variable.isModified()) continue;
            return true;
        }
        return false;
    }

    protected static String toString(Variable[] variableArray) {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (variableArray != null) {
            String string = "";
            for (Variable variable : variableArray) {
                stringBuilder.append(string).append(variable);
                string = ",";
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected static String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (nArray != null) {
            String string = "";
            for (int n : nArray) {
                stringBuilder.append(string).append(n);
                string = ",";
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

