/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kobe_u.cs.cream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ac.kobe_u.cs.cream.Constraint;
import jp.ac.kobe_u.cs.cream.Domain;
import jp.ac.kobe_u.cs.cream.IntDomain;
import jp.ac.kobe_u.cs.cream.Network;
import jp.ac.kobe_u.cs.cream.Solution;
import jp.ac.kobe_u.cs.cream.Solver;
import jp.ac.kobe_u.cs.cream.Trail;
import jp.ac.kobe_u.cs.cream.Variable;

public class DefaultSolver
extends Solver {
    public static final int STEP = 0;
    public static final int ENUM = 1;
    public static final int BISECT = 2;
    public static final int RANDOM = 3;
    private int choice = 0;
    private Trail trail = new Trail();

    public DefaultSolver(Network network) {
        this(network, -1, null);
    }

    public DefaultSolver(Network network, int n) {
        this(network, n, null);
    }

    public DefaultSolver(Network network, String string) {
        this(network, -1, string);
    }

    public DefaultSolver(Network network, int n, String string) {
        super(network, n, string);
    }

    public int getChoice() {
        return this.choice;
    }

    public void setChoice(int n) {
        this.choice = n;
    }

    public Trail getTrail() {
        return this.trail;
    }

    private List<Constraint> modifiedConstraints() {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        for (Constraint object : this.network.getConstraints()) {
            if (!object.isModified()) continue;
            arrayList.add(object);
        }
        for (Variable variable : this.network.getVariables()) {
            variable.setModified(false);
        }
        return arrayList;
    }

    public boolean satisfy() {
        boolean bl = true;
        while (!this.isAborted() && bl) {
            Variable variable;
            for (Constraint constraint : this.modifiedConstraints()) {
                if (constraint.satisfy(this.trail)) continue;
                return false;
            }
            bl = false;
            Iterator<Object> iterator = this.network.getVariables().iterator();
            while (iterator.hasNext() && !(bl |= (variable = (Variable)iterator.next()).isModified())) {
            }
        }
        return true;
    }

    protected Variable infVariable() {
        Variable variable = null;
        int n = Integer.MAX_VALUE;
        for (Variable variable2 : this.network.getVariables()) {
            int n2;
            Domain domain = variable2.getDomain();
            if (!(domain instanceof IntDomain) || domain.size() <= 1 || (n2 = ((IntDomain)domain).min()) >= n) continue;
            variable = variable2;
            n = n2;
        }
        return variable;
    }

    protected Variable supVariable() {
        Variable variable = null;
        int n = Integer.MIN_VALUE;
        for (Variable variable2 : this.network.getVariables()) {
            int n2;
            Domain domain = variable2.getDomain();
            if (!(domain instanceof IntDomain) || domain.size() <= 1 || (n2 = ((IntDomain)domain).max()) <= n) continue;
            variable = variable2;
            n = n2;
        }
        return variable;
    }

    protected Variable minimumSizeVariable() {
        Variable variable = null;
        int n = Integer.MAX_VALUE;
        for (Variable variable2 : this.network.getVariables()) {
            int n2 = variable2.getDomain().size();
            if (1 >= n2 || n2 > n) continue;
            variable = variable2;
            n = n2;
        }
        return variable;
    }

    public Variable selectVariable() {
        Variable variable = null;
        if (this.isOption(1)) {
            variable = this.infVariable();
        } else if (this.isOption(2)) {
            variable = this.supVariable();
        }
        if (variable == null) {
            variable = this.minimumSizeVariable();
        }
        return variable;
    }

    protected void solve(int n) {
        Variable variable = this.network.getObjective();
        block6: while (!this.isAborted()) {
            int n2;
            Object object;
            if (this.isOption(1)) {
                if (this.bestValue < 0x3FFFFFFF) {
                    IntDomain intDomain = (IntDomain)variable.getDomain();
                    if ((intDomain = intDomain.delete(this.bestValue, 0x3FFFFFFF)).isEmpty()) break;
                    variable.updateDomain(intDomain, this.trail);
                }
            } else if (this.isOption(2) && this.bestValue > -1073741823) {
                IntDomain intDomain = (IntDomain)variable.getDomain();
                if ((intDomain = intDomain.delete(-1073741823, this.bestValue)).isEmpty()) break;
                variable.updateDomain(intDomain, this.trail);
            }
            boolean bl = this.satisfy();
            if (this.isAborted() || !bl) break;
            Variable variable2 = this.selectVariable();
            if (variable2 == null) {
                this.solution = new Solution(this.network);
                this.success();
                break;
            }
            if (variable2.getDomain() instanceof IntDomain) {
                object = (IntDomain)variable2.getDomain();
                switch (this.choice) {
                    case 0: {
                        n2 = ((IntDomain)object).min();
                        if (!this.isAborted()) {
                            int n3 = this.trail.size();
                            variable2.updateDomain(new IntDomain(n2), this.trail);
                            this.solve(n + 1);
                            this.trail.undo(n3);
                        }
                        if (this.isAborted()) break;
                        variable2.updateDomain(((IntDomain)object).delete(n2), this.trail);
                        continue block6;
                    }
                    case 1: {
                        Iterator<Domain> iterator = variable2.getDomain().elements();
                        while (!this.isAborted() && iterator.hasNext()) {
                            int n4 = this.trail.size();
                            variable2.updateDomain(iterator.next(), this.trail);
                            this.solve(n + 1);
                            this.trail.undo(n4);
                        }
                        break;
                    }
                    case 2: {
                        int n5;
                        int n6 = ((IntDomain)object).min() + 1 == ((IntDomain)object).max() ? ((IntDomain)object).min() : (((IntDomain)object).min() + ((IntDomain)object).max()) / 2;
                        if (!this.isAborted()) {
                            n5 = this.trail.size();
                            variable2.updateDomain(((IntDomain)object).capInterval(((IntDomain)object).min(), n6), this.trail);
                            this.solve(n + 1);
                            this.trail.undo(n5);
                        }
                        if (this.isAborted()) break;
                        n5 = this.trail.size();
                        variable2.updateDomain(((IntDomain)object).capInterval(n6 + 1, ((IntDomain)object).max()), this.trail);
                        this.solve(n + 1);
                        this.trail.undo(n5);
                        break;
                    }
                    case 3: {
                        int n5;
                        n2 = ((IntDomain)object).randomElement();
                        if (!this.isAborted()) {
                            n5 = this.trail.size();
                            variable2.updateDomain(new IntDomain(n2), this.trail);
                            this.solve(n + 1);
                            this.trail.undo(n5);
                        }
                        if (this.isAborted()) break;
                        variable2.updateDomain(((IntDomain)object).delete(n2), this.trail);
                        continue block6;
                    }
                }
                break;
            }
            object = variable2.getDomain().elements();
            while (!this.isAborted() && object.hasNext()) {
                n2 = this.trail.size();
                variable2.updateDomain((Domain)object.next(), this.trail);
                this.solve(n + 1);
                this.trail.undo(n2);
            }
            break block6;
        }
    }

    @Override
    public void run() {
        this.clearBest();
        this.trail = new Trail();
        this.solve(0);
        this.trail.undo(0);
        this.fail();
    }
}

